/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.parse.html;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.IllegalApplicationStateException;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.model.PageModel;
import ai.platon.pulsar.skeleton.common.persist.ext.WebPageExKt;
import ai.platon.pulsar.skeleton.crawl.common.GlobalCacheFactory;
import ai.platon.pulsar.skeleton.crawl.parse.ParseFilter;
import ai.platon.pulsar.skeleton.crawl.parse.ParseResult;
import ai.platon.scent.common.ScentStatusTracker;
import ai.platon.scent.parse.html.AbstractSQLExtractorParseFilter;
import ai.platon.scent.parse.html.SinkAwarePendingResult;
import ai.platon.scent.parse.html.SinkAwareResultManager;
import ai.platon.scent.skeleton.ScentSession;
import java.sql.Connection;
import java.sql.ResultSet;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 L2\u00020\u0001:\u0001LB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u000203H\u0016J\b\u00105\u001a\u000203H\u0002J\u0010\u00106\u001a\u0002032\u0006\u00107\u001a\u000208H&J\u001a\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0014J\u0010\u0010?\u001a\u0002032\u0006\u0010;\u001a\u00020<H\u0002J$\u0010@\u001a\u0004\u0018\u00010:2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010:H\u0016J \u0010F\u001a\u0002032\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010G\u001a\u00020HH\u0016J\b\u0010I\u001a\u00020!H\u0016J\b\u0010J\u001a\u00020'H\u0016J\b\u0010K\u001a\u000203H\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\n \u0011*\u0004\u0018\u00010\u00150\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\n \u0011*\u0004\u0018\u00010\u001b0\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u00020'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020'X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020,X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lai/platon/scent/parse/html/AbstractSinkAwareSQLExtractorParseFilter;", "Lai/platon/scent/parse/html/AbstractSQLExtractorParseFilter;", "session", "Lai/platon/scent/skeleton/ScentSession;", "scentStatusTracker", "Lai/platon/scent/common/ScentStatusTracker;", "globalCacheFactory", "Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/scent/skeleton/ScentSession;Lai/platon/scent/common/ScentStatusTracker;Lai/platon/pulsar/skeleton/crawl/common/GlobalCacheFactory;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClosed", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "commitExector", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getCommitExector", "()Ljava/util/concurrent/ExecutorService;", "commitLastTime", "Ljava/time/Instant;", "getCommitLastTime", "()Ljava/time/Instant;", "setCommitLastTime", "(Ljava/time/Instant;)V", "commitMinInterval", "Ljava/time/Duration;", "getCommitMinInterval", "()Ljava/time/Duration;", "setCommitMinInterval", "(Ljava/time/Duration;)V", "hasSink", "", "getHasSink", "()Z", "logger", "Lorg/slf4j/Logger;", "sinkCollection", "", "getSinkCollection", "()Ljava/lang/String;", "sms", "syncBatchSize", "", "getSyncBatchSize", "()I", "taskLogger", "totalMillis", "", "checkState", "", "close", "commitWithTimeout", "doCommit", "pendingResult", "Lai/platon/scent/parse/html/SinkAwarePendingResult;", "extractWithConnection", "Ljava/sql/ResultSet;", "task", "Lai/platon/scent/parse/html/AbstractSQLExtractorParseFilter$Task;", "conn", "Ljava/sql/Connection;", "logExtractComplete", "onAfterExtract", "page", "Lai/platon/pulsar/persist/WebPage;", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "rs", "onAfterFilter", "parseResult", "Lai/platon/pulsar/skeleton/crawl/parse/ParseResult;", "shouldCommit", "toString", "tryCommit", "Companion", "scent-parse"})
@SourceDebugExtension(value={"SMAP\nAbstractSinkAwareSQLExtractorParseFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSinkAwareSQLExtractorParseFilter.kt\nai/platon/scent/parse/html/AbstractSinkAwareSQLExtractorParseFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public abstract class AbstractSinkAwareSQLExtractorParseFilter
extends AbstractSQLExtractorParseFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Logger taskLogger;
    private final int syncBatchSize;
    private long totalMillis;
    @NotNull
    private final String sms;
    @NotNull
    private final AtomicBoolean closed;
    private final ExecutorService commitExector;
    private Duration commitMinInterval;
    private Instant commitLastTime;
    @NotNull
    private static final SinkAwareResultManager pendingResultManager = new SinkAwareResultManager();

    public AbstractSinkAwareSQLExtractorParseFilter(@NotNull ScentSession session, @NotNull ScentStatusTracker scentStatusTracker, @NotNull GlobalCacheFactory globalCacheFactory, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scentStatusTracker, (String)"scentStatusTracker");
        Intrinsics.checkNotNullParameter((Object)globalCacheFactory, (String)"globalCacheFactory");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(session, scentStatusTracker, globalCacheFactory, conf);
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(AbstractSinkAwareSQLExtractorParseFilter.class));
        this.taskLogger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(AbstractSinkAwareSQLExtractorParseFilter.class), (String)".Task");
        this.syncBatchSize = 60;
        this.sms = "._.";
        this.closed = new AtomicBoolean();
        this.commitExector = Executors.newSingleThreadExecutor();
        this.commitMinInterval = Duration.ofSeconds(30L);
        this.commitLastTime = Instant.now();
    }

    @NotNull
    public abstract String getSinkCollection();

    public boolean getHasSink() {
        return !StringsKt.isBlank((CharSequence)this.getSinkCollection());
    }

    protected int getSyncBatchSize() {
        return this.syncBatchSize;
    }

    @NotNull
    protected final AtomicBoolean getClosed() {
        return this.closed;
    }

    protected final ExecutorService getCommitExector() {
        return this.commitExector;
    }

    protected final Duration getCommitMinInterval() {
        return this.commitMinInterval;
    }

    protected final void setCommitMinInterval(Duration duration) {
        this.commitMinInterval = duration;
    }

    protected final Instant getCommitLastTime() {
        return this.commitLastTime;
    }

    protected final void setCommitLastTime(Instant instant) {
        this.commitLastTime = instant;
    }

    @Override
    public void onAfterFilter(@NotNull WebPage page, @NotNull FeaturedDocument document, @NotNull ParseResult parseResult) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)parseResult, (String)"parseResult");
            super.onAfterFilter(page, document, parseResult);
            Object object2 = this.commitExector;
            try {
                ExecutorService $this$onAfterFilter_u24lambda_u241 = object2;
                boolean bl = false;
                object = Result.constructor-impl($this$onAfterFilter_u24lambda_u241.submit(() -> AbstractSinkAwareSQLExtractorParseFilter.onAfterFilter$lambda$1$lambda$0(this)));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            LogsKt.warnInterruptible((Object)((Object)this), (Throwable)it, (String)ExceptionsKt.stringify$default((Throwable)it, null, null, (int)3, null), (Object[])new Object[0]);
        }
    }

    @Override
    @Nullable
    public ResultSet onAfterExtract(@NotNull WebPage page, @NotNull FeaturedDocument document, @Nullable ResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        ResultSet resultSet = super.onAfterExtract(page, document, rs);
        if (this.getHasSink() && resultSet != null) {
            String string = this.getSinkCollection();
            String string2 = this.getName();
            Instant instant = WebPageExKt.getOptions((WebPage)page).getDeadline();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"<get-deadline>(...)");
            pendingResultManager.add(string, string2, resultSet, instant);
        }
        return resultSet;
    }

    @Override
    @Nullable
    protected ResultSet extractWithConnection(@NotNull AbstractSQLExtractorParseFilter.Task task, @NotNull Connection conn) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        ResultSet rs = super.extractWithConnection(task, conn);
        this.totalMillis += task.getMillis();
        this.logExtractComplete(task);
        return rs;
    }

    public boolean shouldCommit() {
        if (!this.getHasSink()) {
            return false;
        }
        Instant instant = this.commitLastTime;
        Intrinsics.checkNotNull((Object)instant);
        return DateTimes.elapsedTime$default((DateTimes)DateTimes.INSTANCE, (Instant)instant, null, (int)2, null).compareTo(this.commitMinInterval) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryCommit() {
        if (!this.shouldCommit()) {
            return;
        }
        this.commitLastTime = Instant.now();
        try {
            this.commitWithTimeout();
        }
        catch (Exception e) {
            this.logger.warn("Failed to commit to jdbc sink", (Throwable)e);
            throw e;
        }
    }

    public abstract void doCommit(@NotNull SinkAwarePendingResult var1);

    private final void commitWithTimeout() {
        Duration maxWaitTime = Duration.ofSeconds(45L);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(maxWaitTime, this, null){
            int label;
            final /* synthetic */ Duration $maxWaitTime;
            final /* synthetic */ AbstractSinkAwareSQLExtractorParseFilter this$0;
            {
                this.$maxWaitTime = $maxWaitTime;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TimeoutKt.withTimeout((long)this.$maxWaitTime.toMillis(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ AbstractSinkAwareSQLExtractorParseFilter this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        CoroutineScope $this$withTimeout = (CoroutineScope)this.L$0;
                                        Deferred deferred2 = BuildersKt.async$default((CoroutineScope)$this$withTimeout, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ AbstractSinkAwareSQLExtractorParseFilter this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        AbstractSinkAwareSQLExtractorParseFilter.Companion.getPendingResultManager().takeAndCommit(this.this$0.getSinkCollection(), this.this$0.getName(), (Function1<? super SinkAwarePendingResult, Unit>)((Function1)new Function1<SinkAwarePendingResult, Unit>(this.this$0){
                                                            final /* synthetic */ AbstractSinkAwareSQLExtractorParseFilter this$0;
                                                            {
                                                                this.this$0 = $receiver;
                                                                super(1);
                                                            }

                                                            public final void invoke(@NotNull SinkAwarePendingResult it) {
                                                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                                                this.this$0.doCommit(it);
                                                            }
                                                        }));
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)3, null);
                                        this.label = 1;
                                        Object object3 = deferred2.await((Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.tryCommit();
            this.closeConnections();
        }
    }

    @NotNull
    public String toString() {
        ParseFilter parseFilter = this.getParent();
        return "id: " + this.getId() + ", pid: " + (parseFilter != null ? parseFilter.getId() : 0) + ", pattern: " + this.getUrlFilter() + ", sql: " + this.getSqlName() + ", children: " + this.getChildren().size();
    }

    private final void logExtractComplete(AbstractSQLExtractorParseFilter.Task task) {
        boolean report = this.logger.isInfoEnabled();
        if (this.getParent() != null && task.getNumFitRecords() == 0) {
            report = false;
        }
        if (report) {
            String string;
            boolean withUrl = true;
            SinkAwarePendingResult pendingResult = pendingResultManager.get(this.getSinkCollection(), this.getName());
            PageModel m = task.getPage().getPageModel();
            if (m != null) {
                String string2 = "| %d/%d/%d model fields ";
                Object[] objectArray = new Object[]{m.getNumNonBlankFields(), m.getNumNonNullFields(), m.getNumFields()};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            } else {
                string = "";
            }
            String modelReport = string;
            Object fmt = "%3d. Parsed in %,dms/%4.2fs %4.2fms/p | %d/%d/%d fields in %d/%d records %s| pending %d/%d results | %s | %s -> %s";
            fmt = (String)fmt + " | " + task.getUrl();
            Object[] objectArray = new Object[]{task.getPage().getId(), task.getMillis(), (double)this.totalMillis / 1000.0, 1.0 * (double)this.totalMillis / (double)this.getMeterRelevantTasks().getCount(), task.getNumNonBlankFields(), task.getNumNonNullFields(), task.getNumFields(), task.getNumFitRecords(), task.getNumRecords(), modelReport, pendingResult.getSize(), this.getMeterResults().getCount(), WebPageExKt.getLabel((WebPage)task.getPage()), this.getName(), this.getSinkCollection()};
            String string4 = String.format((String)fmt, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            String msg = string4;
            this.taskLogger.info(msg);
        }
    }

    private final void checkState() {
        if (!this.isActive()) {
            AppContext.INSTANCE.terminate();
            throw new IllegalApplicationStateException(this + " is closed");
        }
    }

    private static final void onAfterFilter$lambda$1$lambda$0(AbstractSinkAwareSQLExtractorParseFilter this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.tryCommit();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/parse/html/AbstractSinkAwareSQLExtractorParseFilter$Companion;", "", "()V", "pendingResultManager", "Lai/platon/scent/parse/html/SinkAwareResultManager;", "getPendingResultManager", "()Lai/platon/scent/parse/html/SinkAwareResultManager;", "scent-parse"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SinkAwareResultManager getPendingResultManager() {
            return pendingResultManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

