/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.parse.html;

import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.ql.h2.utils.JdbcUtils;
import ai.platon.pulsar.skeleton.common.metrics.MetricsSystem;
import ai.platon.pulsar.skeleton.common.metrics.MultiMetric;
import ai.platon.scent.crawl.serialize.config.v1.JdbcConfig;
import ai.platon.scent.parse.html.SinkAwarePendingResult;
import ai.platon.scent.parse.html.SinkAwareResultSet;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0016\u0018\u0000 62\u00020\u0001:\u000256B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010)\u001a\u00020*H\u0016J\u000e\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-J\u001e\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020&2\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\u00020/2\u0006\u0010,\u001a\u00020-2\u0006\u00100\u001a\u00020&J\b\u00104\u001a\u00020&H\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0019\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\n \u0017*\u0004\u0018\u00010\u001b0\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0010R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00067"}, d2={"Lai/platon/scent/parse/html/JdbcCommitter;", "Ljava/lang/AutoCloseable;", "jdbcConfig", "Lai/platon/scent/crawl/serialize/config/v1/JdbcConfig;", "tableName", "", "(Lai/platon/scent/crawl/serialize/config/v1/JdbcConfig;Ljava/lang/String;)V", "dryRunSQLs", "", "getDryRunSQLs", "()Z", "setDryRunSQLs", "(Z)V", "jdbcBatchFailure", "Lai/platon/pulsar/skeleton/common/metrics/MultiMetric;", "getJdbcBatchFailure", "()Lai/platon/pulsar/skeleton/common/metrics/MultiMetric;", "getJdbcConfig", "()Lai/platon/scent/crawl/serialize/config/v1/JdbcConfig;", "jdbcFailure", "getJdbcFailure", "lastCommitElapsed", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getLastCommitElapsed", "()Ljava/time/Duration;", "lastCommitTime", "Ljava/time/Instant;", "getLastCommitTime", "()Ljava/time/Instant;", "setLastCommitTime", "(Ljava/time/Instant;)V", "logger", "Lorg/slf4j/Logger;", "metricAffectedRows", "getMetricAffectedRows", "sinkConnectionPool", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/sql/Connection;", "getTableName", "()Ljava/lang/String;", "close", "", "commit", "pendingResult", "Lai/platon/scent/parse/html/SinkAwarePendingResult;", "commitJdbcRecords", "Lai/platon/scent/parse/html/JdbcCommitter$CommitResult;", "connection", "retry", "", "commitJdbcRecordsOneByOne", "createSinkConnection", "CommitResult", "Companion", "scent-parse"})
@SourceDebugExtension(value={"SMAP\nJdbcCommitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcCommitter.kt\nai/platon/scent/parse/html/JdbcCommitter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1#2:187\n1549#3:188\n1620#3,3:189\n1855#3,2:192\n1855#3,2:194\n*S KotlinDebug\n*F\n+ 1 JdbcCommitter.kt\nai/platon/scent/parse/html/JdbcCommitter\n*L\n114#1:188\n114#1:189,3\n152#1:192,2\n174#1:194,2\n*E\n"})
public class JdbcCommitter
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JdbcConfig jdbcConfig;
    @NotNull
    private final String tableName;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConcurrentLinkedQueue<Connection> sinkConnectionPool;
    @NotNull
    private final MultiMetric metricAffectedRows;
    @NotNull
    private final MultiMetric jdbcFailure;
    @NotNull
    private final MultiMetric jdbcBatchFailure;
    private volatile Instant lastCommitTime;
    private boolean dryRunSQLs;
    @NotNull
    private static final MultiMetric globalAffectedRows = MetricsSystem.Companion.getReg().multiMetric((Object)Companion, "affectedRows");
    @NotNull
    private static final MultiMetric globalJdbcFailure = MetricsSystem.Companion.getReg().multiMetric((Object)Companion, "jdbcFailure");
    @NotNull
    private static final MultiMetric globalJdbcBatchFailure = MetricsSystem.Companion.getReg().multiMetric((Object)Companion, "jdbcBatchFailure");
    private static volatile int commitCount;

    public JdbcCommitter(@NotNull JdbcConfig jdbcConfig, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)jdbcConfig, (String)"jdbcConfig");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        this.jdbcConfig = jdbcConfig;
        this.tableName = tableName;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(JdbcCommitter.class));
        this.sinkConnectionPool = new ConcurrentLinkedQueue();
        this.metricAffectedRows = MetricsSystem.Companion.getReg().multiMetric((Object)this, this.tableName, "affectedRows");
        this.jdbcFailure = MetricsSystem.Companion.getReg().multiMetric((Object)this, "jdbcFailure");
        this.jdbcBatchFailure = MetricsSystem.Companion.getReg().multiMetric((Object)this, "jdbcBatchFailure");
        this.lastCommitTime = Instant.EPOCH;
    }

    @NotNull
    public final JdbcConfig getJdbcConfig() {
        return this.jdbcConfig;
    }

    @NotNull
    public final String getTableName() {
        return this.tableName;
    }

    @NotNull
    public final MultiMetric getMetricAffectedRows() {
        return this.metricAffectedRows;
    }

    @NotNull
    public final MultiMetric getJdbcFailure() {
        return this.jdbcFailure;
    }

    @NotNull
    public final MultiMetric getJdbcBatchFailure() {
        return this.jdbcBatchFailure;
    }

    public final Instant getLastCommitTime() {
        return this.lastCommitTime;
    }

    public final void setLastCommitTime(Instant instant) {
        this.lastCommitTime = instant;
    }

    public final boolean getDryRunSQLs() {
        return this.dryRunSQLs;
    }

    public final void setDryRunSQLs(boolean bl) {
        this.dryRunSQLs = bl;
    }

    public final Duration getLastCommitElapsed() {
        return Duration.between(this.lastCommitTime, Instant.now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit(@NotNull SinkAwarePendingResult pendingResult) {
        Intrinsics.checkNotNullParameter((Object)pendingResult, (String)"pendingResult");
        ++commitCount;
        Connection sinkConnection = null;
        int affectedRows = 0;
        boolean success = false;
        int maxRetry = 10;
        int retry = 0;
        while (!success && retry++ < maxRetry) {
            block28: {
                boolean bl;
                boolean bl22;
                Object object;
                block27: {
                    try {
                        Connection it;
                        CommitResult result;
                        block30: {
                            Object object2;
                            block29: {
                                object2 = this.sinkConnectionPool.poll();
                                if (object2 == null) break block29;
                                object = object2;
                                Connection it2 = object;
                                boolean bl3 = false;
                                object2 = !it2.isClosed() ? object : null;
                                if (object2 != null) break block30;
                            }
                            object2 = sinkConnection = this.createSinkConnection();
                        }
                        if ((affectedRows = (result = this.dryRunSQLs ? this.commitJdbcRecordsOneByOne(pendingResult, sinkConnection) : this.commitJdbcRecords(pendingResult, sinkConnection, retry)).getAffectedRows()) > 0) {
                            this.metricAffectedRows.inc((long)affectedRows);
                            globalAffectedRows.inc((long)affectedRows);
                        }
                        if (!(success = result.getState())) break block27;
                        if (sinkConnection == null) break block28;
                        boolean bl4 = false;
                        this.sinkConnectionPool.add(it);
                    }
                    catch (SQLException e) {
                        Object $this$commit_u24lambda_u242;
                        try {
                            success = false;
                            this.logger.warn("Failed connect to {} | {}", (Object)this.jdbcConfig, (Object)e.getMessage());
                        }
                        catch (Throwable throwable) {
                            if (success) {
                                Connection connection = sinkConnection;
                                if (connection != null) {
                                    Connection it = connection;
                                    boolean bl5 = false;
                                    this.sinkConnectionPool.add(it);
                                }
                            } else {
                                Connection connection = sinkConnection;
                                if (connection != null) {
                                    Object object3;
                                    Object object4 = connection;
                                    try {
                                        Connection $this$commit_u24lambda_u2422 = object4;
                                        boolean bl6 = false;
                                        $this$commit_u24lambda_u2422.close();
                                        object3 = Result.constructor-impl((Object)Unit.INSTANCE);
                                    }
                                    catch (Throwable bl6) {
                                        object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl6));
                                    }
                                    object4 = object3;
                                    Throwable throwable2 = Result.exceptionOrNull-impl((Object)object4);
                                    if (throwable2 != null) {
                                        Object it = object3 = throwable2;
                                        boolean bl7 = false;
                                        LogsKt.warnForClose((Object)this, (Throwable)it, (String)ExceptionsKt.brief$default((Throwable)it, (String)"Failed to close sink connection - ", null, (int)2, null), (Object[])new Object[0]);
                                    }
                                    Result.box-impl((Object)object4);
                                }
                            }
                            throw throwable;
                        }
                        Connection connection = sinkConnection;
                        if (connection == null) break block28;
                        object = connection;
                        try {
                            $this$commit_u24lambda_u242 = object;
                            bl22 = false;
                            $this$commit_u24lambda_u242.close();
                            $this$commit_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable bl22) {
                            $this$commit_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl22));
                        }
                        object = $this$commit_u24lambda_u242;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                        if (throwable != null) {
                            Object it = $this$commit_u24lambda_u242 = throwable;
                            bl = false;
                            LogsKt.warnForClose((Object)this, (Throwable)it, (String)ExceptionsKt.brief$default((Throwable)it, (String)"Failed to close sink connection - ", null, (int)2, null), (Object[])new Object[0]);
                        }
                        Result.box-impl((Object)object);
                    }
                    break block28;
                }
                Connection connection = sinkConnection;
                if (connection != null) {
                    Object $this$commit_u24lambda_u242;
                    object = connection;
                    try {
                        $this$commit_u24lambda_u242 = object;
                        bl22 = false;
                        $this$commit_u24lambda_u242.close();
                        $this$commit_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable) {
                        $this$commit_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object = $this$commit_u24lambda_u242;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable != null) {
                        Object it = $this$commit_u24lambda_u242 = throwable;
                        bl = false;
                        LogsKt.warnForClose((Object)this, (Throwable)it, (String)ExceptionsKt.brief$default((Throwable)it, (String)"Failed to close sink connection - ", null, (int)2, null), (Object[])new Object[0]);
                    }
                    Result.box-impl((Object)object);
                }
            }
            this.lastCommitTime = Instant.now();
        }
        if (!success) {
            this.logger.warn("JDBC failure after {} tries, with {} affected rows", (Object)retry, (Object)affectedRows);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CommitResult commitJdbcRecords(@NotNull SinkAwarePendingResult pendingResult, @NotNull Connection connection, int retry) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)pendingResult, (String)"pendingResult");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        int count = pendingResult.getSize();
        int affectedRows = 0;
        boolean success = false;
        try {
            void $this$mapTo$iv$iv;
            Object[] $this$map$iv = (Object[])pendingResult.getResultSets();
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SinkAwareResultSet sinkAwareResultSet = (SinkAwareResultSet)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getResultSet());
            }
            List resultSets = (List)destination$iv$iv;
            affectedRows = JdbcUtils.INSTANCE.executeBatchInsert((Iterable)resultSets, connection, this.tableName, this.dryRunSQLs);
            success = true;
            $this$map$iv = new Object[5];
            $this$map$iv[0] = commitCount;
            $this$map$iv[1] = count;
            $this$map$iv[2] = this.tableName;
            $this$map$iv[3] = affectedRows;
            Duration duration = this.getLastCommitElapsed();
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"<get-lastCommitElapsed>(...)");
            $this$map$iv[4] = DateTimesKt.readable((Duration)duration);
            this.logger.info("{}. Committed {} records to {}, {} rows affected, last committed {} ago", $this$map$iv);
        }
        catch (BatchUpdateException e) {
            globalJdbcBatchFailure.mark();
            this.jdbcBatchFailure.mark();
            Object[] $this$map$iv = new Object[]{commitCount, count, ExceptionsKt.brief$default((Throwable)e, null, null, (int)3, null)};
            this.logger.warn("{}. Batch insert failed, try to insert one by one for {} records | {}", $this$map$iv);
            this.commitJdbcRecordsOneByOne(pendingResult, connection);
            success = true;
        }
        catch (SQLException e) {
            globalJdbcFailure.mark();
            this.jdbcFailure.mark();
            if (retry < 10) {
                String message = ExceptionsKt.brief$default((Throwable)e, null, null, (int)3, null);
                this.logger.warn("{}. Connection lost | {}", (Object)retry, (Object)message);
            }
            throw e;
        }
        return new CommitResult(affectedRows, success);
    }

    @NotNull
    public final CommitResult commitJdbcRecordsOneByOne(@NotNull SinkAwarePendingResult pendingResult, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)pendingResult, (String)"pendingResult");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        int recordCount = pendingResult.getSize();
        int affectedRows = 0;
        boolean success = false;
        Iterable $this$forEach$iv = pendingResult.getResultSets();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SinkAwareResultSet rs = (SinkAwareResultSet)element$iv;
            boolean bl = false;
            try {
                affectedRows += JdbcUtils.INSTANCE.executeInsert(rs.getResultSet(), connection, this.tableName, this.dryRunSQLs);
                success = true;
            }
            catch (SQLException e) {
                Object[] objectArray = new Object[]{commitCount, this.tableName, ExceptionsKt.brief$default((Throwable)e, null, null, (int)3, null)};
                this.logger.warn("{}. Failed to insert record to {}, check sql log for detail | {}", objectArray);
            }
        }
        String dryRun = this.dryRunSQLs ? " (dry run) " : "";
        String string = "{}. Committed {} records to {} one by one" + dryRun + ", {} rows affected, last committed before {}";
        Object[] objectArray = new Object[5];
        objectArray[0] = commitCount;
        objectArray[1] = recordCount;
        objectArray[2] = this.tableName;
        objectArray[3] = affectedRows;
        Duration duration = this.getLastCommitElapsed();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"<get-lastCommitElapsed>(...)");
        objectArray[4] = DateTimesKt.readable((Duration)duration);
        this.logger.info(string, objectArray);
        return new CommitResult(affectedRows, success);
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = this.sinkConnectionPool;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Connection it = (Connection)element$iv;
            boolean bl = false;
            Object object2 = it;
            try {
                Connection $this$close_u24lambda_u248_u24lambda_u246 = object2;
                boolean bl2 = false;
                it.close();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object it2 = object = throwable;
            boolean bl3 = false;
            LogsKt.warnForClose((Object)this, (Throwable)it2, (String)ExceptionsKt.brief$default((Throwable)it2, null, null, (int)3, null), (Object[])new Object[0]);
        }
        this.sinkConnectionPool.clear();
    }

    private final Connection createSinkConnection() throws SQLException {
        Class.forName(this.jdbcConfig.getDriver());
        Connection connection = DriverManager.getConnection(this.jdbcConfig.getUrl(), this.jdbcConfig.getUsername(), this.jdbcConfig.getPassword());
        this.logger.info("JDBC sink has been connected | {}", (Object)connection.getClientInfo());
        Intrinsics.checkNotNull((Object)connection);
        return connection;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lai/platon/scent/parse/html/JdbcCommitter$CommitResult;", "", "affectedRows", "", "state", "", "(IZ)V", "getAffectedRows", "()I", "getState", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "scent-parse"})
    public static final class CommitResult {
        private final int affectedRows;
        private final boolean state;

        public CommitResult(int affectedRows, boolean state) {
            this.affectedRows = affectedRows;
            this.state = state;
        }

        public final int getAffectedRows() {
            return this.affectedRows;
        }

        public final boolean getState() {
            return this.state;
        }

        public final int component1() {
            return this.affectedRows;
        }

        public final boolean component2() {
            return this.state;
        }

        @NotNull
        public final CommitResult copy(int affectedRows, boolean state) {
            return new CommitResult(affectedRows, state);
        }

        public static /* synthetic */ CommitResult copy$default(CommitResult commitResult, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = commitResult.affectedRows;
            }
            if ((n2 & 2) != 0) {
                bl = commitResult.state;
            }
            return commitResult.copy(n, bl);
        }

        @NotNull
        public String toString() {
            return "CommitResult(affectedRows=" + this.affectedRows + ", state=" + this.state + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.affectedRows);
            result = result * 31 + Boolean.hashCode(this.state);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommitResult)) {
                return false;
            }
            CommitResult commitResult = (CommitResult)other;
            if (this.affectedRows != commitResult.affectedRows) {
                return false;
            }
            return this.state == commitResult.state;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"Lai/platon/scent/parse/html/JdbcCommitter$Companion;", "", "()V", "commitCount", "", "getCommitCount", "()I", "setCommitCount", "(I)V", "globalAffectedRows", "Lai/platon/pulsar/skeleton/common/metrics/MultiMetric;", "getGlobalAffectedRows", "()Lai/platon/pulsar/skeleton/common/metrics/MultiMetric;", "globalJdbcBatchFailure", "getGlobalJdbcBatchFailure", "globalJdbcFailure", "getGlobalJdbcFailure", "scent-parse"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MultiMetric getGlobalAffectedRows() {
            return globalAffectedRows;
        }

        @NotNull
        public final MultiMetric getGlobalJdbcFailure() {
            return globalJdbcFailure;
        }

        @NotNull
        public final MultiMetric getGlobalJdbcBatchFailure() {
            return globalJdbcBatchFailure;
        }

        public final int getCommitCount() {
            return commitCount;
        }

        public final void setCommitCount(int n) {
            commitCount = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

