/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.entities;

import ai.platon.scent.entities.ConfuseMatrix;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.annotation.Id;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\"\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 ;2\u00020\u0001:\u0001;BU\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\u0005H\u00c6\u0003J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u000bH\u00c6\u0003J\t\u00104\u001a\u00020\rH\u00c6\u0003JY\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00109\u001a\u00020\u0003H\u00d6\u0001J\b\u0010:\u001a\u00020\u0014H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u0004\u0018\u00010\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001e\"\u0004\b(\u0010 R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001e\"\u0004\b*\u0010 R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001e\"\u0004\b,\u0010 \u00a8\u0006<"}, d2={"Lai/platon/scent/entities/ClusterTaskStatus;", "", "totalDocuments", "", "startTime", "Ljava/time/Instant;", "totalDocumentRecall", "totalNodes", "totalEpochs", "totalClusters", "totalDistortion", "", "confuseMatrix", "Lai/platon/scent/entities/ConfuseMatrix;", "(ILjava/time/Instant;IIIIDLai/platon/scent/entities/ConfuseMatrix;)V", "getConfuseMatrix", "()Lai/platon/scent/entities/ConfuseMatrix;", "setConfuseMatrix", "(Lai/platon/scent/entities/ConfuseMatrix;)V", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "getStartTime", "()Ljava/time/Instant;", "setStartTime", "(Ljava/time/Instant;)V", "getTotalClusters", "()I", "setTotalClusters", "(I)V", "getTotalDistortion", "()D", "setTotalDistortion", "(D)V", "getTotalDocumentRecall", "setTotalDocumentRecall", "getTotalDocuments", "setTotalDocuments", "getTotalEpochs", "setTotalEpochs", "getTotalNodes", "setTotalNodes", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "scent-persist"})
public final class ClusterTaskStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int totalDocuments;
    @NotNull
    private Instant startTime;
    private int totalDocumentRecall;
    private int totalNodes;
    private int totalEpochs;
    private int totalClusters;
    private double totalDistortion;
    @NotNull
    private ConfuseMatrix confuseMatrix;
    @Id
    @Nullable
    private String id;
    @JsonIgnore
    @NotNull
    private static final transient ClusterTaskStatus EMPTY = new ClusterTaskStatus(0, null, 0, 0, 0, 0, 0.0, null, 255, null);

    public ClusterTaskStatus(int totalDocuments, @NotNull Instant startTime, int totalDocumentRecall, int totalNodes, int totalEpochs, int totalClusters, double totalDistortion, @NotNull ConfuseMatrix confuseMatrix) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)confuseMatrix, (String)"confuseMatrix");
        this.totalDocuments = totalDocuments;
        this.startTime = startTime;
        this.totalDocumentRecall = totalDocumentRecall;
        this.totalNodes = totalNodes;
        this.totalEpochs = totalEpochs;
        this.totalClusters = totalClusters;
        this.totalDistortion = totalDistortion;
        this.confuseMatrix = confuseMatrix;
    }

    public /* synthetic */ ClusterTaskStatus(int n, Instant instant, int n2, int n3, int n4, int n5, double d, ConfuseMatrix confuseMatrix, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 1) != 0) {
            n = 0;
        }
        if ((n6 & 2) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        if ((n6 & 4) != 0) {
            n2 = 0;
        }
        if ((n6 & 8) != 0) {
            n3 = 0;
        }
        if ((n6 & 0x10) != 0) {
            n4 = 0;
        }
        if ((n6 & 0x20) != 0) {
            n5 = 0;
        }
        if ((n6 & 0x40) != 0) {
            d = 0.0;
        }
        if ((n6 & 0x80) != 0) {
            confuseMatrix = new ConfuseMatrix(0, 0, 0, 0, 15, null);
        }
        this(n, instant, n2, n3, n4, n5, d, confuseMatrix);
    }

    public final int getTotalDocuments() {
        return this.totalDocuments;
    }

    public final void setTotalDocuments(int n) {
        this.totalDocuments = n;
    }

    @NotNull
    public final Instant getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.startTime = instant;
    }

    public final int getTotalDocumentRecall() {
        return this.totalDocumentRecall;
    }

    public final void setTotalDocumentRecall(int n) {
        this.totalDocumentRecall = n;
    }

    public final int getTotalNodes() {
        return this.totalNodes;
    }

    public final void setTotalNodes(int n) {
        this.totalNodes = n;
    }

    public final int getTotalEpochs() {
        return this.totalEpochs;
    }

    public final void setTotalEpochs(int n) {
        this.totalEpochs = n;
    }

    public final int getTotalClusters() {
        return this.totalClusters;
    }

    public final void setTotalClusters(int n) {
        this.totalClusters = n;
    }

    public final double getTotalDistortion() {
        return this.totalDistortion;
    }

    public final void setTotalDistortion(double d) {
        this.totalDistortion = d;
    }

    @NotNull
    public final ConfuseMatrix getConfuseMatrix() {
        return this.confuseMatrix;
    }

    public final void setConfuseMatrix(@NotNull ConfuseMatrix confuseMatrix) {
        Intrinsics.checkNotNullParameter((Object)confuseMatrix, (String)"<set-?>");
        this.confuseMatrix = confuseMatrix;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    public final void setId(@Nullable String string) {
        this.id = string;
    }

    @NotNull
    public String toString() {
        Duration elapsed = Duration.between(this.startTime, Instant.now());
        String format = "Total %d nodes in %d/%d documents are grouped into %d clusters in %s after total %d epochs, total distortion: %10.4f";
        Object[] objectArray = new Object[]{this.totalNodes, this.totalDocumentRecall, this.totalDocuments, this.totalClusters, elapsed, this.totalEpochs, this.totalDistortion};
        String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String s = string;
        return s;
    }

    public final int component1() {
        return this.totalDocuments;
    }

    @NotNull
    public final Instant component2() {
        return this.startTime;
    }

    public final int component3() {
        return this.totalDocumentRecall;
    }

    public final int component4() {
        return this.totalNodes;
    }

    public final int component5() {
        return this.totalEpochs;
    }

    public final int component6() {
        return this.totalClusters;
    }

    public final double component7() {
        return this.totalDistortion;
    }

    @NotNull
    public final ConfuseMatrix component8() {
        return this.confuseMatrix;
    }

    @NotNull
    public final ClusterTaskStatus copy(int totalDocuments, @NotNull Instant startTime, int totalDocumentRecall, int totalNodes, int totalEpochs, int totalClusters, double totalDistortion, @NotNull ConfuseMatrix confuseMatrix) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)confuseMatrix, (String)"confuseMatrix");
        return new ClusterTaskStatus(totalDocuments, startTime, totalDocumentRecall, totalNodes, totalEpochs, totalClusters, totalDistortion, confuseMatrix);
    }

    public static /* synthetic */ ClusterTaskStatus copy$default(ClusterTaskStatus clusterTaskStatus, int n, Instant instant, int n2, int n3, int n4, int n5, double d, ConfuseMatrix confuseMatrix, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n = clusterTaskStatus.totalDocuments;
        }
        if ((n6 & 2) != 0) {
            instant = clusterTaskStatus.startTime;
        }
        if ((n6 & 4) != 0) {
            n2 = clusterTaskStatus.totalDocumentRecall;
        }
        if ((n6 & 8) != 0) {
            n3 = clusterTaskStatus.totalNodes;
        }
        if ((n6 & 0x10) != 0) {
            n4 = clusterTaskStatus.totalEpochs;
        }
        if ((n6 & 0x20) != 0) {
            n5 = clusterTaskStatus.totalClusters;
        }
        if ((n6 & 0x40) != 0) {
            d = clusterTaskStatus.totalDistortion;
        }
        if ((n6 & 0x80) != 0) {
            confuseMatrix = clusterTaskStatus.confuseMatrix;
        }
        return clusterTaskStatus.copy(n, instant, n2, n3, n4, n5, d, confuseMatrix);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.totalDocuments);
        result = result * 31 + this.startTime.hashCode();
        result = result * 31 + Integer.hashCode(this.totalDocumentRecall);
        result = result * 31 + Integer.hashCode(this.totalNodes);
        result = result * 31 + Integer.hashCode(this.totalEpochs);
        result = result * 31 + Integer.hashCode(this.totalClusters);
        result = result * 31 + Double.hashCode(this.totalDistortion);
        result = result * 31 + this.confuseMatrix.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClusterTaskStatus)) {
            return false;
        }
        ClusterTaskStatus clusterTaskStatus = (ClusterTaskStatus)other;
        if (this.totalDocuments != clusterTaskStatus.totalDocuments) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startTime, (Object)clusterTaskStatus.startTime)) {
            return false;
        }
        if (this.totalDocumentRecall != clusterTaskStatus.totalDocumentRecall) {
            return false;
        }
        if (this.totalNodes != clusterTaskStatus.totalNodes) {
            return false;
        }
        if (this.totalEpochs != clusterTaskStatus.totalEpochs) {
            return false;
        }
        if (this.totalClusters != clusterTaskStatus.totalClusters) {
            return false;
        }
        if (Double.compare(this.totalDistortion, clusterTaskStatus.totalDistortion) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.confuseMatrix, (Object)clusterTaskStatus.confuseMatrix);
    }

    public ClusterTaskStatus() {
        this(0, null, 0, 0, 0, 0, 0.0, null, 255, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/entities/ClusterTaskStatus$Companion;", "", "()V", "EMPTY", "Lai/platon/scent/entities/ClusterTaskStatus;", "getEMPTY", "()Lai/platon/scent/entities/ClusterTaskStatus;", "scent-persist"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClusterTaskStatus getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

