/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.entities;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.annotation.Id;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 32\u00020\u0001:\u00013B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0000J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J1\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010.\u001a\u00020/2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u00100\u001a\u00020\u0000J\t\u00101\u001a\u00020\u0003H\u00d6\u0001J\b\u00102\u001a\u00020\u0015H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R \u0010\u0014\u001a\u0004\u0018\u00010\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000f\"\u0004\b\u001c\u0010\u0011R\u001a\u0010\u001d\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000b\"\u0004\b\u001f\u0010\rR\u001a\u0010 \u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000b\"\u0004\b\"\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000f\"\u0004\b$\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000f\"\u0004\b&\u0010\u0011\u00a8\u00064"}, d2={"Lai/platon/scent/entities/ConfuseMatrix;", "", "tp", "", "fp", "fn", "tn", "(IIII)V", "f1", "", "getF1", "()D", "setF1", "(D)V", "getFn", "()I", "setFn", "(I)V", "getFp", "setFp", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "n", "getN", "setN", "precision", "getPrecision", "setPrecision", "recall", "getRecall", "setRecall", "getTn", "setTn", "getTp", "setTp", "accumulate", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "estimate", "hashCode", "toString", "Companion", "scent-persist"})
public final class ConfuseMatrix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int tp;
    private int fp;
    private int fn;
    private int tn;
    @Id
    @Nullable
    private String id;
    private transient int n;
    private transient double precision;
    private transient double recall;
    private transient double f1;

    public ConfuseMatrix(int tp, int fp, int fn, int tn) {
        this.tp = tp;
        this.fp = fp;
        this.fn = fn;
        this.tn = tn;
        this.n = 1;
    }

    public /* synthetic */ ConfuseMatrix(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            n = 0;
        }
        if ((n5 & 2) != 0) {
            n2 = 0;
        }
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        this(n, n2, n3, n4);
    }

    public final int getTp() {
        return this.tp;
    }

    public final void setTp(int n) {
        this.tp = n;
    }

    public final int getFp() {
        return this.fp;
    }

    public final void setFp(int n) {
        this.fp = n;
    }

    public final int getFn() {
        return this.fn;
    }

    public final void setFn(int n) {
        this.fn = n;
    }

    public final int getTn() {
        return this.tn;
    }

    public final void setTn(int n) {
        this.tn = n;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    public final void setId(@Nullable String string) {
        this.id = string;
    }

    public final int getN() {
        return this.n;
    }

    public final void setN(int n) {
        this.n = n;
    }

    public final double getPrecision() {
        return this.precision;
    }

    public final void setPrecision(double d) {
        this.precision = d;
    }

    public final double getRecall() {
        return this.recall;
    }

    public final void setRecall(double d) {
        this.recall = d;
    }

    public final double getF1() {
        return this.f1;
    }

    public final void setF1(double d) {
        this.f1 = d;
    }

    @NotNull
    public final ConfuseMatrix accumulate(@NotNull ConfuseMatrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ++this.n;
        this.tp += other.tp;
        this.fp += other.fp;
        this.fn += other.fn;
        this.tn += other.tn;
        return this;
    }

    @NotNull
    public final ConfuseMatrix estimate() {
        double smooth = 0.001;
        this.precision = (double)this.tp / (smooth + (double)this.tp + (double)this.fp);
        this.recall = (double)this.tp / (smooth + (double)this.tp + (double)this.fn);
        this.f1 = (double)2 * this.precision * this.recall / (smooth + this.precision + this.recall);
        return this;
    }

    @NotNull
    public String toString() {
        String string = "tp: %d fp: %d fn: %d tn: %d microR: %4.4f, accuracy: %4.4f, microF1: %4.2f";
        Object[] objectArray = new Object[]{this.tp, this.fp, this.fn, this.tn, this.recall, this.precision, this.f1};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    public final int component1() {
        return this.tp;
    }

    public final int component2() {
        return this.fp;
    }

    public final int component3() {
        return this.fn;
    }

    public final int component4() {
        return this.tn;
    }

    @NotNull
    public final ConfuseMatrix copy(int tp, int fp, int fn, int tn) {
        return new ConfuseMatrix(tp, fp, fn, tn);
    }

    public static /* synthetic */ ConfuseMatrix copy$default(ConfuseMatrix confuseMatrix, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = confuseMatrix.tp;
        }
        if ((n5 & 2) != 0) {
            n2 = confuseMatrix.fp;
        }
        if ((n5 & 4) != 0) {
            n3 = confuseMatrix.fn;
        }
        if ((n5 & 8) != 0) {
            n4 = confuseMatrix.tn;
        }
        return confuseMatrix.copy(n, n2, n3, n4);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.tp);
        result = result * 31 + Integer.hashCode(this.fp);
        result = result * 31 + Integer.hashCode(this.fn);
        result = result * 31 + Integer.hashCode(this.tn);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConfuseMatrix)) {
            return false;
        }
        ConfuseMatrix confuseMatrix = (ConfuseMatrix)other;
        if (this.tp != confuseMatrix.tp) {
            return false;
        }
        if (this.fp != confuseMatrix.fp) {
            return false;
        }
        if (this.fn != confuseMatrix.fn) {
            return false;
        }
        return this.tn == confuseMatrix.tn;
    }

    public ConfuseMatrix() {
        this(0, 0, 0, 0, 15, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lai/platon/scent/entities/ConfuseMatrix$Companion;", "", "()V", "estimate", "Lai/platon/scent/entities/ConfuseMatrix;", "tp", "", "fp", "fn", "tn", "scent-persist"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConfuseMatrix estimate(int tp, int fp, int fn, int tn) {
            return new ConfuseMatrix(tp, fp, fn, tn).estimate();
        }

        public static /* synthetic */ ConfuseMatrix estimate$default(Companion companion, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = 0;
            }
            if ((n5 & 2) != 0) {
                n2 = 0;
            }
            if ((n5 & 4) != 0) {
                n3 = 0;
            }
            if ((n5 & 8) != 0) {
                n4 = 0;
            }
            return companion.estimate(n, n2, n3, n4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

