/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.entities;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.OpenMapTable;
import ai.platon.scent.common.MLPaths;
import ai.platon.scent.dom.HNormUrl;
import ai.platon.scent.entities.PageTableKt;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\u0018\u0000 72\u00020\u0001:\u00017B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u00105\u001a\u00020\u000eH\u0002J\b\u00106\u001a\u00020\u0005H\u0016R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\f\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u001a\u0010\u0019\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0017\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\u001e\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0011R\u0011\u0010 \u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\fR#\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050#0\u00078F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)R\u0011\u0010,\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\fR\u0019\u0010.\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010%R\u001a\u00101\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0011\"\u0004\b3\u00104\u00a8\u00068"}, d2={"Lai/platon/scent/entities/PageTableGroup;", "", "portalUrl", "Lai/platon/scent/dom/HNormUrl;", "groupName", "", "tables", "", "Lai/platon/pulsar/common/OpenMapTable;", "(Lai/platon/scent/dom/HNormUrl;Ljava/lang/String;Ljava/util/List;)V", "command", "getCommand", "()Ljava/lang/String;", "flowViewPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getFlowViewPath", "()Ljava/nio/file/Path;", "getGroupName", "setGroupName", "(Ljava/lang/String;)V", "isEmpty", "", "()Z", "isNotEmpty", "isSorted", "setSorted", "(Z)V", "getPortalUrl", "()Lai/platon/scent/dom/HNormUrl;", "projectBaseDir", "getProjectBaseDir", "projectId", "getProjectId", "recognizedComponents", "Lkotlin/Pair;", "getRecognizedComponents", "()Ljava/util/List;", "sequence", "", "getSequence", "()I", "size", "getSize", "spec", "getSpec", "tableViewPath", "getTableViewPath", "getTables", "viewBaseDir", "getViewBaseDir", "setViewBaseDir", "(Ljava/nio/file/Path;)V", "getBaseViewDir", "toString", "Companion", "scent-persist"})
@SourceDebugExtension(value={"SMAP\nPageTableGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PageTableGroup.kt\nai/platon/scent/entities/PageTableGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Lang.kt\nai/platon/scent/common/LangKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1774#2,4:66\n13#3,4:70\n1#4:74\n*S KotlinDebug\n*F\n+ 1 PageTableGroup.kt\nai/platon/scent/entities/PageTableGroup\n*L\n54#1:66,4\n56#1:70,4\n56#1:74\n*E\n"})
public final class PageTableGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HNormUrl portalUrl;
    @NotNull
    private String groupName;
    @NotNull
    private final List<OpenMapTable> tables;
    private final int sequence;
    private boolean isSorted;
    private final Path projectBaseDir;
    @NotNull
    private Path viewBaseDir;
    private final boolean isEmpty;
    private final boolean isNotEmpty;
    private final int size;
    @NotNull
    private static final AtomicInteger SEQUENCER = new AtomicInteger();
    @NotNull
    private static final PageTableGroup EMPTY = new PageTableGroup(HNormUrl.Companion.getNIL(), null, null, 6, null);

    public PageTableGroup(@NotNull HNormUrl portalUrl, @NotNull String groupName, @NotNull List<OpenMapTable> tables) {
        Intrinsics.checkNotNullParameter((Object)portalUrl, (String)"portalUrl");
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        this.portalUrl = portalUrl;
        this.groupName = groupName;
        this.tables = tables;
        this.sequence = SEQUENCER.incrementAndGet();
        this.projectBaseDir = MLPaths.INSTANCE.getHarvestResultBaseDir().resolve(this.getProjectId());
        this.viewBaseDir = this.getBaseViewDir();
        this.isEmpty = this.tables.isEmpty();
        this.isNotEmpty = !((Collection)this.tables).isEmpty();
        this.size = this.tables.size();
    }

    public /* synthetic */ PageTableGroup(HNormUrl hNormUrl, String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = Companion.generateName(hNormUrl);
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(hNormUrl, string, list);
    }

    @NotNull
    public final HNormUrl getPortalUrl() {
        return this.portalUrl;
    }

    @NotNull
    public final String getGroupName() {
        return this.groupName;
    }

    public final void setGroupName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.groupName = string;
    }

    @NotNull
    public final List<OpenMapTable> getTables() {
        return this.tables;
    }

    public final int getSequence() {
        return this.sequence;
    }

    @NotNull
    public final String getSpec() {
        return this.portalUrl.getSpec();
    }

    @NotNull
    public final String getCommand() {
        return this.portalUrl.getConfiguredUrl();
    }

    public final boolean isSorted() {
        return this.isSorted;
    }

    public final void setSorted(boolean bl) {
        this.isSorted = bl;
    }

    @NotNull
    public final String getProjectId() {
        return this.portalUrl.getHOptions().getProjectId();
    }

    public final Path getProjectBaseDir() {
        return this.projectBaseDir;
    }

    @NotNull
    public final Path getViewBaseDir() {
        return this.viewBaseDir;
    }

    public final void setViewBaseDir(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.viewBaseDir = path;
    }

    public final Path getFlowViewPath() {
        return this.viewBaseDir.resolve(this.groupName + ".flow.html");
    }

    public final Path getTableViewPath() {
        return this.viewBaseDir.resolve(this.groupName + ".html");
    }

    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public final boolean isNotEmpty() {
        return this.isNotEmpty;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final List<Pair<String, String>> getRecognizedComponents() {
        return this.tables.isEmpty() ? CollectionsKt.emptyList() : PageTableKt.getData((OpenMapTable)CollectionsKt.first(this.tables)).getRecognizedComponents();
    }

    @NotNull
    public String toString() {
        return "PageTableGroup(projectId: " + this.getProjectId() + ", groupName: " + this.groupName + ", projectBaseDir: " + this.projectBaseDir + ")";
    }

    private final Path getBaseViewDir() {
        int count;
        Path viewDir = this.projectBaseDir.resolve("views");
        Path path = this.projectBaseDir;
        Intrinsics.checkNotNull((Object)path);
        Iterable $this$count$iv = PathsKt.listDirectoryEntries((Path)path, (String)"views*");
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v0 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v0 = count = count$iv;
        }
        if (count > 0) {
            Intrinsics.checkNotNull((Object)viewDir);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(viewDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                PageTableGroup $this$runCatchingWarnUnexpected$iv = this;
                boolean $i$f$runCatchingWarnUnexpected = false;
                if ($this$runCatchingWarnUnexpected$iv == null) {
                    PageTableGroup pageTableGroup = $this$runCatchingWarnUnexpected$iv;
                    try {
                        $this$getBaseViewDir_u24lambda_u241 = pageTableGroup;
                        boolean bl = false;
                        var8_11 = Result.constructor-impl((Object)Files.move(viewDir, viewDir.resolveSibling("views." + count), new CopyOption[0]));
                    }
                    catch (Throwable bl) {
                        var8_11 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                } else {
                    Object object = $this$runCatchingWarnUnexpected$iv;
                    try {
                        $this$getBaseViewDir_u24lambda_u241 = object;
                        boolean bl = false;
                        var8_11 = Result.constructor-impl((Object)Files.move(viewDir, viewDir.resolveSibling("views." + count), new CopyOption[0]));
                    }
                    catch (Throwable bl) {
                        var8_11 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object = var8_11;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                    if (throwable != null) {
                        Throwable it$iv = throwable;
                        boolean bl = false;
                        LogsKt.warnUnexpected((Object)$this$runCatchingWarnUnexpected$iv, (Throwable)it$iv);
                    }
                }
            }
        }
        Path finalDir = this.projectBaseDir.resolve("views");
        Files.createDirectories(finalDir, new FileAttribute[0]);
        Intrinsics.checkNotNull((Object)finalDir);
        return finalDir;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/platon/scent/entities/PageTableGroup$Companion;", "", "()V", "EMPTY", "Lai/platon/scent/entities/PageTableGroup;", "getEMPTY", "()Lai/platon/scent/entities/PageTableGroup;", "SEQUENCER", "Ljava/util/concurrent/atomic/AtomicInteger;", "generateName", "", "url", "Lai/platon/scent/dom/HNormUrl;", "scent-persist"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PageTableGroup getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final String generateName(@NotNull HNormUrl url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return url.getHOptions().getProjectId();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

