/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.proxy.client;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.NetUtil;
import ai.platon.pulsar.common.Sockets;
import ai.platon.pulsar.common.concurrent.ConcurrencyKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.scent.proxy.manager.CustomHandlers;
import ai.platon.scent.proxy.server.ProxyServer;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.netty.util.ResourceLeakDetector;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 <2\u00020\u0001:\u0001<B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010/\u001a\u000200H\u0016J\u000e\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020%J\u0018\u00103\u001a\u00020+2\u0006\u00102\u001a\u00020%2\u0006\u00104\u001a\u00020\u0006H\u0002J\b\u00105\u001a\u0004\u0018\u00010%J\b\u00106\u001a\u000200H\u0002J\u0010\u00107\u001a\u0002002\u0006\u00104\u001a\u00020\u0006H\u0002J\u000e\u00108\u001a\u0002002\u0006\u00109\u001a\u00020%J\u0018\u00108\u001a\u0002002\u0006\u0010:\u001a\u00020%2\u0006\u00104\u001a\u00020\u0006H\u0002J\u0006\u0010;\u001a\u00020\u0011J\u0010\u0010;\u001a\u0002002\u0006\u00104\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u000e*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u000e*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n \u000e*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \u000e*\u0004\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lai/platon/scent/proxy/client/ProxyServerConnector;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "bossGroupThreads", "", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connected", "Ljava/util/concurrent/locks/Condition;", "disconnected", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "frontendGroupThreads", "isActive", "", "()Z", "isDisconnected", "isOnline", "localPort", "Ljava/util/concurrent/atomic/AtomicInteger;", "getLocalPort", "()Ljava/util/concurrent/atomic/AtomicInteger;", "lock", "Ljava/util/concurrent/locks/Lock;", "log", "Lorg/slf4j/Logger;", "meterConnects", "Lcom/codahale/metrics/Meter;", "meterDisconnects", "metricRegistry", "Lcom/codahale/metrics/MetricRegistry;", "numWaiting", "proxyEntry", "Ljava/util/concurrent/atomic/AtomicReference;", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "getProxyEntry", "()Ljava/util/concurrent/atomic/AtomicReference;", "proxyFuture", "Ljava/util/concurrent/Future;", "proxyServer", "Lai/platon/scent/proxy/server/ProxyServer;", "testScript", "Ljava/nio/file/Path;", "workerGroupThreads", "close", "", "connect", "proxy", "createProxyServer", "port", "disconnect", "disconnectIfNecessary", "generateTestCommand", "waitUntilOffline", "retiredProxy", "expiredProxy", "waitUntilOnline", "Companion", "scent-proxy"})
public final class ProxyServerConnector
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableConfig conf;
    private final Logger log;
    private final int bossGroupThreads;
    private final int workerGroupThreads;
    private final int frontendGroupThreads;
    @Nullable
    private ProxyServer proxyServer;
    @Nullable
    private Future<?> proxyFuture;
    private final ExecutorService executor;
    @NotNull
    private final AtomicInteger numWaiting;
    private final MetricRegistry metricRegistry;
    private final Meter meterConnects;
    private final Meter meterDisconnects;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final Lock lock;
    @NotNull
    private final Condition connected;
    @NotNull
    private final Condition disconnected;
    private Path testScript;
    @NotNull
    private final AtomicInteger localPort;
    @NotNull
    private final AtomicReference<ProxyEntry> proxyEntry;
    public static final int PROXY_SERVER_PORT_BASE = 3000;
    @NotNull
    public static final String PRIMARY_WEB_SITE = "https://www.amazon.com/";
    @NotNull
    public static final String TEST_SCRIPT_TEMPLATE = "wget --tries=3 {url} -e use_proxy=yes -e http_proxy=127.0.0.1:{port}";

    public ProxyServerConnector(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.log = LoggerFactory.getLogger(ProxyServerConnector.class);
        this.bossGroupThreads = this.conf.getInt("proxy.forward.server.boss.threads", 1);
        this.workerGroupThreads = this.conf.getInt("proxy.forward.server.worker.threads", 2);
        this.frontendGroupThreads = this.conf.getInt("proxy.forward.server.worker.threads", 2);
        this.executor = Executors.newSingleThreadExecutor();
        this.numWaiting = new AtomicInteger();
        this.metricRegistry = SharedMetricRegistries.getOrCreate((String)"pulsar");
        this.meterConnects = this.metricRegistry.meter(ai.platon.pulsar.common.StringsKt.prependReadableClassName$default((Object)this, (String)"connects", null, (int)4, null));
        this.meterDisconnects = this.metricRegistry.meter(ai.platon.pulsar.common.StringsKt.prependReadableClassName$default((Object)this, (String)"disconnects", null, (int)4, null));
        this.closed = new AtomicBoolean();
        this.lock = new ReentrantLock();
        Condition condition = this.lock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"lock.newCondition()");
        this.connected = condition;
        condition = this.lock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"lock.newCondition()");
        this.disconnected = condition;
        this.localPort = new AtomicInteger();
        this.proxyEntry = new AtomicReference();
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.ADVANCED);
        this.metricRegistry.register(ai.platon.pulsar.common.StringsKt.prependReadableClassName$default((Object)this, (String)"waiting", null, (int)4, null), (Metric)new Gauge<Integer>(){

            @NotNull
            public Integer getValue() {
                return numWaiting.get();
            }
        });
    }

    @NotNull
    public final AtomicInteger getLocalPort() {
        return this.localPort;
    }

    @NotNull
    public final AtomicReference<ProxyEntry> getProxyEntry() {
        return this.proxyEntry;
    }

    public final boolean isOnline() {
        return this.proxyEntry.get() != null && this.localPort.get() > 0;
    }

    public final boolean isDisconnected() {
        boolean bl;
        ProxyServer proxyServer = this.proxyServer;
        return proxyServer == null ? false : (bl = proxyServer.isDisconnected());
    }

    public final boolean isActive() {
        return !this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized boolean connect(@NotNull ProxyEntry proxy) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        int nextPort = Sockets.findAvailableTcpPort$default((Sockets)Sockets.INSTANCE, (int)3000, (int)0, (int)2, null);
        this.disconnectIfNecessary();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Starting forward server on {} with {}", (Object)nextPort, (Object)proxy.getDisplay());
        }
        if (!this.isActive()) {
            return false;
        }
        try {
            Object[] objectArray;
            Object[] objectArray2 = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            objectArray2.lock();
            try {
                boolean bl3 = false;
                this.proxyServer = this.createProxyServer(proxy, nextPort);
                this.waitUntilOnline(nextPort);
                this.getLocalPort().set(nextPort);
                proxy.startWork();
                this.getProxyEntry().set(proxy);
                this.connected.signalAll();
                this.meterConnects.mark();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                objectArray2.unlock();
            }
            if (this.log.isInfoEnabled()) {
                objectArray2 = new Object[]{nextPort, this.proxyEntry.get().getDisplay(), this.proxyEntry.get().getStatus()};
                this.log.info("Forward server is started on port {} with {} {}", objectArray2);
            }
            objectArray2 = new String[]{"test-proxy-ip-" + proxy.getHost() + ".sh"};
            this.testScript = AppPaths.INSTANCE.getTmp("scripts", (String[])objectArray2);
            this.generateTestCommand(nextPort);
            objectArray2 = this.testScript;
            if (objectArray2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testScript");
                objectArray = null;
            } else {
                objectArray = objectArray2;
            }
            this.log.info("Proxy test script: \n" + (Path)objectArray);
        }
        catch (TimeoutException e) {
            this.log.error("Timeout to wait for forward server on port {}", (Object)nextPort);
        }
        catch (Exception e) {
            this.log.error("Failed to start forward server", (Throwable)e);
        }
        return this.isOnline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitUntilOnline() {
        if (!this.isActive()) {
            return false;
        }
        if (this.isOnline()) {
            return true;
        }
        this.log.info("No proxy is online, waiting ...");
        this.numWaiting.incrementAndGet();
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            int i = 0;
            try {
                while (this.isActive() && !this.isOnline() && ++i < 30) {
                    this.connected.await(1L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.numWaiting.decrementAndGet();
        return this.isActive() && this.isOnline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final synchronized ProxyEntry disconnect() {
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            ProxyEntry proxy = this.getProxyEntry().getAndSet(null);
            if (proxy != null && this.proxyServer != null) {
                this.log.info("Disconnecting proxy {} {} ...", (Object)proxy.getDisplay(), (Object)proxy.getMetadata());
                Object object = this.proxyServer;
                if (object != null) {
                    ((ProxyServer)object).close();
                }
                object = this.executor;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executor");
                ConcurrencyKt.stopExecution((String)"ProxyServer", (ExecutorService)object, this.proxyFuture, (boolean)false);
                this.proxyServer = null;
                this.proxyFuture = null;
                Object object2 = this.getLocalPort().get();
                boolean bl4 = false;
                boolean bl5 = false;
                int it = ((Number)object2).intValue();
                boolean bl6 = false;
                Object object3 = object = it > 0 ? object2 : null;
                if (object != null) {
                    object2 = object;
                    bl4 = false;
                    bl5 = false;
                    it = ((Number)object2).intValue();
                    boolean bl7 = false;
                    this.waitUntilOffline(proxy, it);
                }
                this.getLocalPort().set(0);
                this.disconnected.signalAll();
                this.meterDisconnects.mark();
            }
            ProxyEntry proxyEntry = proxy;
            return proxyEntry;
        }
        finally {
            lock.unlock();
        }
    }

    public final void waitUntilOffline(@NotNull ProxyEntry retiredProxy) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)retiredProxy, (String)"retiredProxy");
        Integer n2 = this.localPort.get();
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n2).intValue();
        boolean bl3 = false;
        Integer n3 = n = it > 0 ? n2 : null;
        if (n != null) {
            n2 = n;
            bl = false;
            bl2 = false;
            it = ((Number)n2).intValue();
            boolean bl4 = false;
            this.waitUntilOffline(retiredProxy, it);
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.disconnect();
            ExecutorService executorService = this.executor;
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"executor");
            ConcurrencyKt.stopExecution((String)"ProxyServer", (ExecutorService)executorService, this.proxyFuture, (boolean)true);
        }
    }

    private final ProxyServer createProxyServer(ProxyEntry proxy, int port) {
        ProxyServer proxyServer = new ProxyServer(this.bossGroupThreads, this.workerGroupThreads, this.frontendGroupThreads, proxy, 0, false, 48, null);
        boolean bl = false;
        boolean bl2 = false;
        ProxyServer $this$createProxyServer_u24lambda_u2d7 = proxyServer;
        boolean bl3 = false;
        CustomHandlers handlers = new CustomHandlers($this$createProxyServer_u24lambda_u2d7);
        $this$createProxyServer_u24lambda_u2d7.setInterceptInitializer(handlers.getInterceptInitializer());
        $this$createProxyServer_u24lambda_u2d7.setExceptionHandle(handlers.getExceptionHandle());
        bl = false;
        bl2 = false;
        ProxyServer it = proxyServer;
        boolean bl4 = false;
        this.proxyFuture = this.executor.submit(() -> ProxyServerConnector.createProxyServer$lambda-9$lambda-8(it, port));
        return proxyServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void disconnectIfNecessary() {
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            if (this.isOnline()) {
                ProxyEntry proxy = this.getProxyEntry().get();
                ExecutorService executor = Executors.newSingleThreadExecutor();
                Future<?> future = executor.submit(() -> ProxyServerConnector.disconnectIfNecessary$lambda-11$lambda-10(this));
                this.log.info("Waiting for proxy to disconnect | {}", (Object)proxy);
                try {
                    boolean signaled = this.disconnected.await(20L, TimeUnit.SECONDS);
                    if (!signaled) {
                        this.log.warn("Timeout to wait for proxy to disconnect | {}", (Object)proxy);
                    }
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"executor");
                ConcurrencyKt.stopExecution$default((String)"ProxyServer", (ExecutorService)executor, future, (boolean)false, (int)8, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void waitUntilOnline(int port) throws TimeoutException {
        int i = 0;
        ProxyEntry proxy = this.proxyEntry.get();
        while (this.isActive() && proxy != null && !NetUtil.testNetwork((String)"127.0.0.1", (int)port) && !Thread.currentThread().isInterrupted()) {
            Object object;
            Object object2 = this.log;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            int n = i;
            i = n + 1;
            Object object3 = object = n > 5 ? object2 : null;
            if (object != null) {
                object.warn("Waited {}s for proxy to be online | {}", (Object)i, (Object)proxy.getDisplay());
            }
            object2 = this;
            bl = false;
            bl2 = false;
            it = (ProxyServerConnector)object2;
            boolean bl4 = false;
            object = (ProxyServerConnector)(i > 20 ? object2 : null);
            if (object != null) {
                object2 = object;
                bl = false;
                bl2 = false;
                it = object2;
                boolean bl5 = false;
                this.disconnect();
                throw new TimeoutException("Timeout to wait for proxy to connect");
            }
            LangKt.sleepSeconds((long)2L);
        }
    }

    private final void waitUntilOffline(ProxyEntry expiredProxy, int port) {
        int i = 0;
        ProxyEntry currentProxy = this.proxyEntry.get();
        while (this.isActive() && Intrinsics.areEqual((Object)currentProxy, (Object)expiredProxy) && NetUtil.testNetwork((String)"127.0.0.1", (int)port) && !Thread.currentThread().isInterrupted()) {
            Logger logger;
            Logger logger2 = this.log;
            boolean bl = false;
            boolean bl2 = false;
            Logger it = logger2;
            boolean bl3 = false;
            int n = i;
            i = n + 1;
            Object object = logger = n > 5 ? logger2 : null;
            if (logger != null) {
                logger.warn("Waited {}s for proxy to be offline | {}", (Object)i, (Object)currentProxy.getDisplay());
            }
            LangKt.sleepSeconds((long)1L);
            currentProxy = this.proxyEntry.get();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTestCommand(int port) {
        StringBuilder sb;
        StringBuilder stringBuilder = sb = new StringBuilder();
        String string = "#!/bin/bash";
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Object object = stringBuilder2;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object).append('\n'), (String)"append('\\n')");
        boolean bl3 = false;
        Set testUrls = new LinkedHashSet();
        testUrls.add(PRIMARY_WEB_SITE);
        String string2 = ProxyEntry.Companion.getDEFAULT_TEST_URL().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ProxyEntry.DEFAULT_TEST_URL.toString()");
        testUrls.add(string2);
        Object $this$mapTo$iv = ProxyEntry.Companion.getTEST_URLS();
        boolean $i$f$mapTo232 = false;
        object = $this$mapTo$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object e = object.next();
            URL uRL = (URL)e;
            Collection collection = testUrls;
            boolean bl4 = false;
            String string3 = it.toString();
            collection.add(string3);
        }
        $this$mapTo$iv = sb;
        Object $i$f$mapTo232 = "echo \"Total " + testUrls.size() + " urls to test\"";
        boolean bl5 = false;
        StringBuilder stringBuilder3 = ((StringBuilder)$this$mapTo$iv).append((String)$i$f$mapTo232);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringBuilder stringBuilder15 = stringBuilder3;
        boolean it = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15.append('\n'), (String)"append('\\n')");
        $this$mapTo$iv = sb;
        $i$f$mapTo232 = "mkdir /tmp/proxy.tests";
        bl5 = false;
        StringBuilder stringBuilder4 = ((StringBuilder)$this$mapTo$iv).append((String)$i$f$mapTo232);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringBuilder stringBuilder5 = stringBuilder4;
        it = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        $this$mapTo$iv = sb;
        $i$f$mapTo232 = "cd /tmp/proxy.tests";
        bl5 = false;
        StringBuilder stringBuilder6 = ((StringBuilder)$this$mapTo$iv).append((String)$i$f$mapTo232);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        StringBuilder stringBuilder7 = stringBuilder6;
        it = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
        Object $this$forEach$iv = testUrls;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            StringBuilder stringBuilder8;
            String it2 = (String)t;
            boolean bl6 = false;
            String script = StringsKt.replace$default((String)TEST_SCRIPT_TEMPLATE, (String)"{url}", (String)it2, (boolean)false, (int)4, null);
            script = StringsKt.replace$default((String)script, (String)"{port}", (String)String.valueOf(port), (boolean)false, (int)4, null);
            StringBuilder stringBuilder9 = sb;
            Object object2 = "echo";
            boolean bl4 = false;
            StringBuilder stringBuilder10 = stringBuilder9.append((String)object2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
            StringBuilder stringBuilder11 = stringBuilder10;
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
            stringBuilder9 = sb;
            object2 = "echo -----";
            bl4 = false;
            StringBuilder stringBuilder12 = stringBuilder9.append((String)object2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(value)");
            stringBuilder11 = stringBuilder12;
            bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
            stringBuilder9 = sb;
            object2 = "echo \"" + it2 + "\"";
            bl4 = false;
            StringBuilder stringBuilder13 = stringBuilder9.append((String)object2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(value)");
            stringBuilder11 = stringBuilder13;
            bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
            stringBuilder9 = sb;
            object2 = "echo \"Press any key\"";
            bl4 = false;
            StringBuilder stringBuilder14 = stringBuilder9.append((String)object2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(value)");
            stringBuilder11 = stringBuilder14;
            bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
            stringBuilder9 = sb;
            object2 = "read";
            bl4 = false;
            StringBuilder stringBuilder16 = stringBuilder9.append((String)object2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(value)");
            stringBuilder11 = stringBuilder16;
            bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
            stringBuilder9 = sb;
            boolean bl8 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append(script), (String)"append(value)");
            boolean bl9 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append('\\n')");
        }
        $this$forEach$iv = sb;
        Object object3 = "cd -";
        boolean bl11 = false;
        StringBuilder stringBuilder17 = $this$forEach$iv.append((String)object3);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append(value)");
        StringBuilder stringBuilder18 = stringBuilder17;
        boolean bl10 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18.append('\n'), (String)"append('\\n')");
        try {
            Object object4;
            OpenOption[] openOptionArray;
            $this$forEach$iv = this.testScript;
            if ($this$forEach$iv == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testScript");
                openOptionArray = null;
            } else {
                openOptionArray = $this$forEach$iv;
            }
            $this$forEach$iv = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"sb.toString()");
            object3 = Charsets.UTF_8;
            bl11 = false;
            byte[] byArray = $this$forEach$iv.getBytes((Charset)object3);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            $this$forEach$iv = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            Files.write((Path)openOptionArray, byArray, $this$forEach$iv);
            $this$forEach$iv = this.testScript;
            if ($this$forEach$iv == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testScript");
                object4 = null;
            } else {
                object4 = $this$forEach$iv;
            }
            Files.setPosixFilePermissions((Path)object4, PosixFilePermissions.fromString("rwxrw-r--"));
        }
        catch (IOException e) {
            this.log.error(e.toString());
        }
    }

    private static final void createProxyServer$lambda-9$lambda-8(ProxyServer $it, int $port) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        $it.start($port);
    }

    private static final void disconnectIfNecessary$lambda-11$lambda-10(ProxyServerConnector this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.disconnect();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lai/platon/scent/proxy/client/ProxyServerConnector$Companion;", "", "()V", "PRIMARY_WEB_SITE", "", "PROXY_SERVER_PORT_BASE", "", "TEST_SCRIPT_TEMPLATE", "scent-proxy"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

