/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.proxy.common;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fJQ\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0017\"\u00020\n\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010!\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010\"\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$J\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\nJ\u000e\u0010%\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010%\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010%\u001a\u00020\u00152\b\u0010#\u001a\u0004\u0018\u00010$J\u000e\u0010%\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\nR\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006&"}, d2={"Lai/platon/scent/proxy/common/CertUtil;", "", "()V", "keyFactory", "Ljava/security/KeyFactory;", "getKeyFactory", "()Ljava/security/KeyFactory;", "genCACert", "Ljava/security/cert/X509Certificate;", "subject", "", "caNotBefore", "Ljava/util/Date;", "caNotAfter", "keyPair", "Ljava/security/KeyPair;", "genCert", "issuer", "caPriKey", "Ljava/security/PrivateKey;", "serverPubKey", "Ljava/security/PublicKey;", "hosts", "", "(Ljava/lang/String;Ljava/security/PrivateKey;Ljava/util/Date;Ljava/util/Date;Ljava/security/PublicKey;[Ljava/lang/String;)Ljava/security/cert/X509Certificate;", "genKeyPair", "getSubject", "inputStream", "Ljava/io/InputStream;", "certificate", "loadCert", "uri", "Ljava/net/URI;", "path", "loadPriKey", "bts", "", "loadPubKey", "scent-proxy"})
public final class CertUtil {
    @NotNull
    public static final CertUtil INSTANCE = new CertUtil();
    @Nullable
    private static KeyFactory keyFactory;

    private CertUtil() {
    }

    private final KeyFactory getKeyFactory() {
        if (keyFactory == null) {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        return keyFactory;
    }

    @NotNull
    public final KeyPair genKeyPair() throws Exception {
        KeyPairGenerator caKeyPairGen = KeyPairGenerator.getInstance("RSA", "BC");
        caKeyPairGen.initialize(2048, new SecureRandom());
        KeyPair keyPair = caKeyPairGen.genKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"caKeyPairGen.genKeyPair()");
        return keyPair;
    }

    @NotNull
    public final PrivateKey loadPriKey(@Nullable byte[] bts) throws NoSuchAlgorithmException, InvalidKeySpecException {
        EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(bts);
        KeyFactory keyFactory = this.getKeyFactory();
        Intrinsics.checkNotNull((Object)keyFactory);
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"keyFactory!!.generatePrivate(privateKeySpec)");
        return privateKey;
    }

    @NotNull
    public final PrivateKey loadPriKey(@NotNull String path) throws Exception {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.loadPriKey(Files.readAllBytes(Paths.get(path, new String[0])));
    }

    @NotNull
    public final PrivateKey loadPriKey(@NotNull URI uri) throws Exception {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.loadPriKey(((Object)Paths.get(uri)).toString());
    }

    @NotNull
    public final PrivateKey loadPriKey(@NotNull InputStream inputStream) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] bts = new byte[1024];
        int len = 0;
        while (true) {
            int n = inputStream.read(bts);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            len = it;
            if (n == -1) break;
            outputStream.write(bts, 0, len);
        }
        inputStream.close();
        outputStream.close();
        return this.loadPriKey(outputStream.toByteArray());
    }

    @NotNull
    public final PublicKey loadPubKey(@Nullable byte[] bts) throws Exception {
        EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(bts);
        KeyFactory keyFactory = this.getKeyFactory();
        Intrinsics.checkNotNull((Object)keyFactory);
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyFactory!!.generatePublic(publicKeySpec)");
        return publicKey;
    }

    @NotNull
    public final PublicKey loadPubKey(@NotNull String path) throws Exception {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Files.readAllBytes(Paths.get(path, new String[0])));
        KeyFactory keyFactory = this.getKeyFactory();
        Intrinsics.checkNotNull((Object)keyFactory);
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyFactory!!.generatePublic(publicKeySpec)");
        return publicKey;
    }

    @NotNull
    public final PublicKey loadPubKey(@NotNull URI uri) throws Exception {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.loadPubKey(((Object)Paths.get(uri)).toString());
    }

    @NotNull
    public final PublicKey loadPubKey(@NotNull InputStream inputStream) throws Exception {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] bts = new byte[1024];
        int len = 0;
        while (true) {
            int n = inputStream.read(bts);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            len = it;
            if (n == -1) break;
            outputStream.write(bts, 0, len);
        }
        inputStream.close();
        outputStream.close();
        return this.loadPubKey(outputStream.toByteArray());
    }

    @NotNull
    public final X509Certificate loadCert(@NotNull InputStream inputStream) throws CertificateException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate certificate = cf.generateCertificate(inputStream);
        if (certificate == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
        }
        return (X509Certificate)certificate;
    }

    @NotNull
    public final X509Certificate loadCert(@NotNull String path) throws Exception {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.loadCert(new FileInputStream(path));
    }

    @NotNull
    public final X509Certificate loadCert(@NotNull URI uri) throws Exception {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.loadCert(((Object)Paths.get(uri)).toString());
    }

    @NotNull
    public final String getSubject(@NotNull InputStream inputStream) throws Exception {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        X509Certificate certificate = this.loadCert(inputStream);
        String[] stringArray = new String[]{", "};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((Object)certificate.getIssuerDN()).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object object = stringArray2;
        List<String> tempList = Arrays.asList(Arrays.copyOf(object, ((String[])object).length));
        object = IntStream.rangeClosed(0, tempList.size() - 1).mapToObj(arg_0 -> CertUtil.getSubject$lambda-2(tempList, arg_0)).collect(Collectors.joining(", "));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rangeClosed(0, tempList.\u2026Collectors.joining(\", \"))");
        return (String)object;
    }

    @NotNull
    public final String getSubject(@NotNull X509Certificate certificate) throws Exception {
        Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
        String[] stringArray = new String[]{", "};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((Object)certificate.getIssuerDN()).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object object = stringArray2;
        List<String> tempList = Arrays.asList(Arrays.copyOf(object, ((String[])object).length));
        object = IntStream.rangeClosed(0, tempList.size() - 1).mapToObj(arg_0 -> CertUtil.getSubject$lambda-3(tempList, arg_0)).collect(Collectors.joining(", "));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rangeClosed(0, tempList.\u2026Collectors.joining(\", \"))");
        return (String)object;
    }

    @NotNull
    public final X509Certificate genCert(@Nullable String issuer, @Nullable PrivateKey caPriKey, @Nullable Date caNotBefore, @Nullable Date caNotAfter, @Nullable PublicKey serverPubKey, String ... hosts) throws Exception {
        Intrinsics.checkNotNullParameter((Object)hosts, (String)"hosts");
        String subject = "C=CN, ST=GD, L=SZ, O=lee, OU=study, CN=" + hosts[0];
        JcaX509v3CertificateBuilder jv3Builder = new JcaX509v3CertificateBuilder(new X500Name(issuer), BigInteger.valueOf(System.currentTimeMillis() + (long)(Math.random() * (double)10000) + (long)1000), caNotBefore, caNotAfter, new X500Name(subject), serverPubKey);
        GeneralName[] generalNames = new GeneralName[hosts.length];
        int n = 0;
        int n2 = hosts.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                generalNames[i] = new GeneralName(2, hosts[i]);
            } while (n <= n2);
        }
        GeneralNames subjectAltName = new GeneralNames(generalNames);
        jv3Builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltName);
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(caPriKey);
        X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(jv3Builder.build(signer));
        Intrinsics.checkNotNullExpressionValue((Object)x509Certificate, (String)"JcaX509CertificateConver\u2026jv3Builder.build(signer))");
        return x509Certificate;
    }

    @NotNull
    public final X509Certificate genCACert(@Nullable String subject, @Nullable Date caNotBefore, @Nullable Date caNotAfter, @NotNull KeyPair keyPair) throws Exception {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        JcaX509v3CertificateBuilder jv3Builder = new JcaX509v3CertificateBuilder(new X500Name(subject), BigInteger.valueOf(System.currentTimeMillis() + (long)(Math.random() * (double)10000) + (long)1000), caNotBefore, caNotAfter, new X500Name(subject), keyPair.getPublic());
        jv3Builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(keyPair.getPrivate());
        X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(jv3Builder.build(signer));
        Intrinsics.checkNotNullExpressionValue((Object)x509Certificate, (String)"JcaX509CertificateConver\u2026jv3Builder.build(signer))");
        return x509Certificate;
    }

    private static final String getSubject$lambda-2(List $tempList, int i) {
        return (String)$tempList.get($tempList.size() - i - 1);
    }

    private static final String getSubject$lambda-3(List $tempList, int i) {
        return (String)$tempList.get($tempList.size() - i - 1);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

