/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.proxy.common;

import ai.platon.scent.proxy.server.RequestProto;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/proxy/common/ProtoUtil;", "", "()V", "getRequestProto", "Lai/platon/scent/proxy/server/RequestProto;", "httpRequest", "Lio/netty/handler/codec/http/HttpRequest;", "scent-proxy"})
public final class ProtoUtil {
    @NotNull
    public static final ProtoUtil INSTANCE = new ProtoUtil();

    private ProtoUtil() {
    }

    @Nullable
    public final RequestProto getRequestProto(@NotNull HttpRequest httpRequest) {
        String string;
        boolean isSsl;
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        String host = "";
        int port = -1;
        String hostStr = httpRequest.headers().get((CharSequence)HttpHeaderNames.HOST);
        if (hostStr == null) {
            Pattern pattern = Pattern.compile("^(?:https?://)?(?<host>[^/]*)/?.*$");
            Matcher matcher = pattern.matcher(httpRequest.uri());
            if (matcher.find()) {
                hostStr = matcher.group("host");
            } else {
                return null;
            }
        }
        String uriStr = httpRequest.uri();
        Pattern pattern = Pattern.compile("^(?:https?://)?(?<host>[^:]*)(?::(?<port>\\d+))?(/.*)?$");
        String string2 = hostStr;
        Intrinsics.checkNotNull((Object)string2);
        Matcher matcher = pattern.matcher(string2);
        String portTemp = null;
        if (matcher.find()) {
            String string3 = matcher.group("host");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"matcher.group(\"host\")");
            host = string3;
            portTemp = matcher.group("port");
            if (portTemp == null && (matcher = pattern.matcher(uriStr)).find()) {
                portTemp = matcher.group("port");
            }
        }
        if (portTemp != null) {
            port = Integer.parseInt(portTemp);
        }
        Intrinsics.checkNotNullExpressionValue((Object)uriStr, (String)"uriStr");
        boolean bl = isSsl = StringsKt.indexOf$default((CharSequence)uriStr, (String)"https", (int)0, (boolean)false, (int)6, null) == 0 || StringsKt.indexOf$default((CharSequence)(string = hostStr), (String)"https", (int)0, (boolean)false, (int)6, null) == 0;
        if (port == -1) {
            port = isSsl ? 443 : 80;
        }
        return new RequestProto(host, port, isSsl);
    }
}

