/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.proxy.manager;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.scent.proxy.client.ProxyServerConnector;
import ai.platon.scent.proxy.manager.CustomHandlers;
import ai.platon.scent.proxy.server.ExceptionHandler;
import ai.platon.scent.proxy.server.FullRequestIntercept;
import ai.platon.scent.proxy.server.FullResponseIntercept;
import ai.platon.scent.proxy.server.HttpProxyInterceptInitializer;
import ai.platon.scent.proxy.server.HttpProxyInterceptPipeline;
import ai.platon.scent.proxy.server.ProxyServer;
import ai.platon.scent.proxy.server.ResourceCacheKey;
import ai.platon.scent.proxy.server.ResourceItem;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.proxy.ProxyConnectException;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lai/platon/scent/proxy/manager/CustomHandlers;", "", "server", "Lai/platon/scent/proxy/server/ProxyServer;", "(Lai/platon/scent/proxy/server/ProxyServer;)V", "exceptionHandle", "Lai/platon/scent/proxy/server/ExceptionHandler;", "getExceptionHandle", "()Lai/platon/scent/proxy/server/ExceptionHandler;", "interceptInitializer", "Lai/platon/scent/proxy/server/HttpProxyInterceptInitializer;", "getInterceptInitializer", "()Lai/platon/scent/proxy/server/HttpProxyInterceptInitializer;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "numRequests", "Ljava/util/concurrent/atomic/AtomicInteger;", "getServer", "()Lai/platon/scent/proxy/server/ProxyServer;", "scent-proxy"})
public final class CustomHandlers {
    @NotNull
    private final ProxyServer server;
    private final Logger log;
    @NotNull
    private final AtomicInteger numRequests;
    @NotNull
    private final HttpProxyInterceptInitializer interceptInitializer;
    @NotNull
    private final ExceptionHandler exceptionHandle;

    public CustomHandlers(@NotNull ProxyServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
        this.log = LoggerFactory.getLogger(ProxyServerConnector.class);
        this.numRequests = new AtomicInteger();
        this.interceptInitializer = new HttpProxyInterceptInitializer(this){
            final /* synthetic */ CustomHandlers this$0;
            {
                this.this$0 = $receiver;
            }

            public void init(@NotNull HttpProxyInterceptPipeline pipeline) {
                Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
                pipeline.addLast(new FullRequestIntercept(this.this$0){
                    final /* synthetic */ CustomHandlers this$0;
                    {
                        this.this$0 = $receiver;
                        super(0, 1, null);
                    }

                    public boolean match(@NotNull HttpRequest httpRequest, @NotNull HttpProxyInterceptPipeline pipeline) {
                        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
                        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
                        return this.this$0.getServer().getCacheLevel() > 0;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void handelRequest(@NotNull FullHttpRequest httpRequest, @NotNull HttpProxyInterceptPipeline pipeline) {
                        void $this$filterNotTo$iv$iv;
                        void $this$filterNot$iv;
                        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
                        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
                        CustomHandlers.access$getNumRequests$p(this.this$0).incrementAndGet();
                        Logger logger = CustomHandlers.access$getLog$p(this.this$0);
                        Object[] objectArray = new Object[4];
                        objectArray[0] = CustomHandlers.access$getNumRequests$p(this.this$0);
                        objectArray[1] = httpRequest.method();
                        Iterable<E> iterable = httpRequest.headers().entries();
                        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"httpRequest.headers().entries()");
                        iterable = iterable;
                        int n = 2;
                        Object[] objectArray2 = objectArray;
                        String string = "Send request #{} - {}\n{}\n{}";
                        Logger logger2 = logger;
                        boolean $i$f$filterNot = false;
                        void var6_10 = $this$filterNot$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterNotTo = false;
                        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                            Map.Entry it = (Map.Entry)element$iv$iv;
                            boolean bl = false;
                            Object[] objectArray3 = new String[]{"referrer", "User-Agent", "Origin"};
                            if (ArraysKt.contains((Object[])objectArray3, it.getKey())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List list = (List)destination$iv$iv;
                        objectArray2[n] = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)interceptInitializer.init.handelRequest.2.INSTANCE, (int)31, null);
                        objectArray[3] = httpRequest.getUri();
                        logger2.debug(string, objectArray);
                    }
                });
                pipeline.addLast(new FullResponseIntercept(this.this$0){
                    final /* synthetic */ CustomHandlers this$0;
                    {
                        this.this$0 = $receiver;
                        super(0, 1, null);
                    }

                    public boolean match(@NotNull HttpRequest httpRequest, @NotNull HttpResponse httpResponse, @NotNull HttpProxyInterceptPipeline pipeline) {
                        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
                        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
                        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
                        return this.this$0.getServer().getCacheLevel() > 0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handelResponse(@NotNull HttpRequest httpRequest, @NotNull FullHttpResponse httpResponse, @NotNull HttpProxyInterceptPipeline pipeline) {
                        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
                        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
                        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
                        Logger logger = CustomHandlers.access$getLog$p(this.this$0);
                        AtomicInteger atomicInteger = CustomHandlers.access$getNumRequests$p(this.this$0);
                        HttpHeaders httpHeaders = httpResponse.headers();
                        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"httpResponse.headers()");
                        logger.debug("Response for request #{} - {}\n\n", (Object)atomicInteger, (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)httpHeaders), (CharSequence)", ", null, null, (int)0, null, (Function1)interceptInitializer.init.handelResponse.1.INSTANCE, (int)30, null));
                        String uri = httpRequest.uri();
                        int length = httpResponse.content().readableBytes();
                        if (length > 0) {
                            ResourceItem resource;
                            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                            ResourceCacheKey key = new ResourceCacheKey(uri, length);
                            ResourceItem resourceItem = resource = this.this$0.getServer().getResourceCache().computeIfAbsent(key, interceptInitializer.init.2::handelResponse$lambda-0);
                            resourceItem.setCheckCount(resourceItem.getCheckCount() + 1);
                            resourceItem.getCheckCount();
                            ByteBuf content = httpResponse.content();
                            try {
                                content.markReaderIndex();
                                content.retain();
                                if (resource.getCheckCount() == 2) {
                                    resource.setContent(ByteBufUtil.getBytes((ByteBuf)content));
                                } else if (resource.getCheckCount() > 2) {
                                    byte[] bytes = ByteBufUtil.getBytes((ByteBuf)content);
                                    if (Arrays.equals(resource.getContent(), bytes)) {
                                        Object object = resource;
                                        ((ResourceItem)object).setNotModifiedCount(((ResourceItem)object).getNotModifiedCount() + 1);
                                        ((ResourceItem)object).getNotModifiedCount();
                                        CustomHandlers.access$getLog$p(this.this$0).debug("Resource is not modified | {}", (Object)uri);
                                        if (resource.getNotModifiedCount() > 2) {
                                            object = this.this$0.getServer().getNotModifiedResources();
                                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"server.notModifiedResources");
                                            boolean bl = false;
                                            object.put(uri, key);
                                        }
                                    }
                                }
                            }
                            finally {
                                content.resetReaderIndex();
                                if (content.refCnt() > 1) {
                                    ReferenceCountUtil.release((Object)content);
                                }
                            }
                        }
                    }

                    private static final ResourceItem handelResponse$lambda-0(ResourceCacheKey it) {
                        return new ResourceItem(null, 0, 0, 7, null);
                    }
                });
            }
        };
        this.exceptionHandle = new ExceptionHandler(this){
            final /* synthetic */ CustomHandlers this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeCatch(@NotNull Channel backendChannel, @NotNull Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)backendChannel, (String)"backendChannel");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            }

            public void afterCatch(@NotNull Channel backendChannel, @NotNull Channel frontendChannel, @NotNull Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)backendChannel, (String)"backendChannel");
                Intrinsics.checkNotNullParameter((Object)frontendChannel, (String)"frontendChannel");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                String message = cause.getMessage();
                Throwable throwable = cause;
                if (throwable instanceof IOException) {
                    message = ExceptionsKt.simplify$default((Throwable)cause, null, null, (int)3, null);
                } else if (throwable instanceof ProxyConnectException) {
                    boolean bl = !frontendChannel.isActive();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    bl3 = false;
                    boolean bl4 = false;
                    if (!bl) {
                        boolean bl5 = false;
                        String string = "Failed requirement.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    this.this$0.getServer().getState().set(ProxyServer.State.DISCONNECTED);
                    message = ExceptionsKt.simplify$default((Throwable)cause, null, null, (int)3, null);
                }
                if (message == null) {
                    CustomHandlers.access$getLog$p(this.this$0).warn(ExceptionsKt.stringify$default((Throwable)cause, null, null, (int)3, null));
                } else {
                    CustomHandlers.access$getLog$p(this.this$0).warn(cause.getMessage());
                }
            }
        };
    }

    @NotNull
    public final ProxyServer getServer() {
        return this.server;
    }

    @NotNull
    public final HttpProxyInterceptInitializer getInterceptInitializer() {
        return this.interceptInitializer;
    }

    @NotNull
    public final ExceptionHandler getExceptionHandle() {
        return this.exceptionHandle;
    }

    public static final /* synthetic */ AtomicInteger access$getNumRequests$p(CustomHandlers $this) {
        return $this.numRequests;
    }

    public static final /* synthetic */ Logger access$getLog$p(CustomHandlers $this) {
        return $this.log;
    }
}

