/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.proxy.manager;

import ai.platon.pulsar.common.FileCommand;
import ai.platon.pulsar.common.concurrent.ConcurrentPassiveExpiringSet;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.proxy.NoProxyException;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.common.proxy.ProxyException;
import ai.platon.pulsar.common.proxy.ProxyPool;
import ai.platon.pulsar.common.proxy.ProxyPoolManager;
import ai.platon.scent.proxy.client.ProxyServerConnector;
import ai.platon.scent.proxy.pool.ProxyVendorLoader;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001:\u00019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010!\u001a\u00020\"J\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010$\u001a\u00020%H\u0016J\u001a\u0010&\u001a\u00020%2\b\u0010'\u001a\u0004\u0018\u00010\u000f2\u0006\u0010(\u001a\u00020\"H\u0002J\u001a\u0010)\u001a\u00020%2\b\u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010(\u001a\u00020\"H\u0002J$\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010(\u001a\u00020\"2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010/\u001a\u00020%2\b\u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010(\u001a\u00020\"H\u0002J\"\u00100\u001a\u00020%2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\"2\b\b\u0002\u00101\u001a\u00020-H\u0002J\u0018\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020-H\u0016J\b\u00105\u001a\u00020+H\u0016J\u0006\u00106\u001a\u00020-J\u0006\u00107\u001a\u00020%J\b\u00108\u001a\u00020-H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n \r*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \r*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \r*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \r*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lai/platon/scent/proxy/manager/InterceptiveProxyPoolManager;", "Lai/platon/pulsar/common/proxy/ProxyPoolManager;", "proxyPool", "Lai/platon/pulsar/common/proxy/ProxyPool;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/proxy/ProxyPool;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connector", "Lai/platon/scent/proxy/client/ProxyServerConnector;", "counterWatches", "Lcom/codahale/metrics/Counter;", "kotlin.jvm.PlatformType", "currentInterceptProxyEntry", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "getCurrentInterceptProxyEntry", "()Lai/platon/pulsar/common/proxy/ProxyEntry;", "localPort", "", "getLocalPort", "()I", "log", "Lorg/slf4j/Logger;", "meterRetires", "Lcom/codahale/metrics/Meter;", "meterWaits", "metricRegistry", "Lcom/codahale/metrics/MetricRegistry;", "numFailedPages", "numLostConnections", "proxyLoader", "Lai/platon/scent/proxy/pool/ProxyVendorLoader;", "checkAvailability", "Lai/platon/scent/proxy/manager/InterceptiveProxyPoolManager$Availability;", "testProxy", "close", "", "connectNext", "proxy", "avail", "disconnectIfNecessary", "formatStatus", "", "isIdle", "", "lastProxy", "handleProxyAvailability", "reportIfNecessary", "forceReport", "takeOff", "excludedProxy", "ban", "toString", "waitUntilOnline", "watch", "willDisconnectOnCommand", "Availability", "scent-proxy"})
public final class InterceptiveProxyPoolManager
extends ProxyPoolManager {
    @NotNull
    private final ImmutableConfig conf;
    private final Logger log;
    @Nullable
    private final ProxyVendorLoader proxyLoader;
    @NotNull
    private final ProxyServerConnector connector;
    private int numFailedPages;
    private int numLostConnections;
    private final MetricRegistry metricRegistry;
    private final Counter counterWatches;
    private final Meter meterWaits;
    private final Meter meterRetires;
    @NotNull
    private final AtomicBoolean closed;

    public InterceptiveProxyPoolManager(@NotNull ProxyPool proxyPool, @NotNull ImmutableConfig conf) {
        ProxyVendorLoader proxyVendorLoader;
        InterceptiveProxyPoolManager interceptiveProxyPoolManager;
        Intrinsics.checkNotNullParameter((Object)proxyPool, (String)"proxyPool");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(proxyPool, conf);
        this.conf = conf;
        this.log = LoggerFactory.getLogger(InterceptiveProxyPoolManager.class);
        InterceptiveProxyPoolManager interceptiveProxyPoolManager2 = this;
        boolean bl = false;
        boolean bl2 = false;
        InterceptiveProxyPoolManager interceptiveProxyPoolManager3 = interceptiveProxyPoolManager2;
        InterceptiveProxyPoolManager interceptiveProxyPoolManager4 = this;
        boolean bl3 = false;
        boolean bl4 = this.isEnabled();
        InterceptiveProxyPoolManager interceptiveProxyPoolManager5 = interceptiveProxyPoolManager4;
        InterceptiveProxyPoolManager interceptiveProxyPoolManager6 = interceptiveProxyPoolManager = bl4 ? interceptiveProxyPoolManager2 : null;
        if (interceptiveProxyPoolManager == null) {
            proxyVendorLoader = null;
        } else {
            interceptiveProxyPoolManager2 = interceptiveProxyPoolManager;
            bl = false;
            bl2 = false;
            InterceptiveProxyPoolManager it = interceptiveProxyPoolManager2;
            interceptiveProxyPoolManager4 = interceptiveProxyPoolManager5;
            boolean bl5 = false;
            ProxyVendorLoader proxyVendorLoader2 = new ProxyVendorLoader(this.conf);
            interceptiveProxyPoolManager5 = interceptiveProxyPoolManager4;
            proxyVendorLoader = proxyVendorLoader2;
        }
        interceptiveProxyPoolManager5.proxyLoader = proxyVendorLoader;
        this.connector = new ProxyServerConnector(this.conf);
        this.metricRegistry = SharedMetricRegistries.getOrCreate((String)"pulsar");
        this.counterWatches = this.metricRegistry.counter(ai.platon.pulsar.common.StringsKt.prependReadableClassName$default((Object)((Object)this), (String)"watches", null, (int)4, null));
        this.meterWaits = this.metricRegistry.meter(ai.platon.pulsar.common.StringsKt.prependReadableClassName$default((Object)((Object)this), (String)"waits", null, (int)4, null));
        this.meterRetires = this.metricRegistry.meter(ai.platon.pulsar.common.StringsKt.prependReadableClassName$default((Object)((Object)this), (String)"retires", null, (int)4, null));
        this.closed = new AtomicBoolean();
    }

    @Nullable
    public final ProxyEntry getCurrentInterceptProxyEntry() {
        return this.connector.getProxyEntry().get();
    }

    public final int getLocalPort() {
        return this.connector.getLocalPort().get();
    }

    public final boolean waitUntilOnline() throws NoProxyException {
        Boolean bl;
        if (!this.isActive()) {
            return false;
        }
        Boolean bl2 = this.connector.waitUntilOnline();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean it = bl2;
        boolean bl5 = false;
        this.meterWaits.mark();
        bl3 = false;
        bl4 = false;
        it = bl2;
        boolean bl6 = false;
        Boolean bl7 = bl = it ? bl2 : null;
        if (bl == null) {
            throw new NoProxyException("Failed to wait for an online proxy, pool status: " + this.getProxyPool());
        }
        return bl;
    }

    public void takeOff(@NotNull ProxyEntry excludedProxy, boolean ban) {
        Intrinsics.checkNotNullParameter((Object)excludedProxy, (String)"excludedProxy");
        if (!this.isActive()) {
            return;
        }
        this.getProxyPool().retire(excludedProxy);
        this.meterRetires.mark();
        this.connector.waitUntilOffline(excludedProxy);
    }

    public final void watch() {
        if (!this.isActive()) {
            return;
        }
        try {
            this.counterWatches.inc();
            ProxyEntry testProxy = this.getCurrentInterceptProxyEntry();
            Availability avail = this.checkAvailability(testProxy);
            this.handleProxyAvailability(testProxy, avail);
            ProxyEntry proxyEntry = testProxy;
            if (proxyEntry != null) {
                ProxyEntry proxyEntry2 = proxyEntry;
                boolean bl = false;
                boolean bl2 = false;
                ProxyEntry it = proxyEntry2;
                boolean bl3 = false;
                InterceptiveProxyPoolManager.reportIfNecessary$default(this, it, avail, false, 4, null);
            }
        }
        catch (ProxyException e) {
            throw e;
        }
        catch (Throwable t) {
            this.log.warn("Unexpected exception", t);
        }
    }

    @NotNull
    public final Availability checkAvailability() {
        return this.checkAvailability(this.getCurrentInterceptProxyEntry());
    }

    public void close() {
        if (this.isEnabled() && this.closed.compareAndSet(false, true)) {
            String string;
            this.log.info("Closing proxy pool monitor ...");
            String string2 = this.getStatusString();
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            String string3 = string = !StringsKt.isBlank((CharSequence)charSequence) ? string2 : null;
            if (string != null) {
                string2 = string;
                bl = false;
                bl2 = false;
                it = string2;
                boolean bl5 = false;
                this.log.info(it);
            }
            super.close();
            this.connector.close();
            this.getProxyPool().close();
        }
    }

    @NotNull
    public String toString() {
        return this.getProxyPool().toString();
    }

    private final Availability checkAvailability(ProxyEntry testProxy) {
        return this.isIdle() ? Availability.IDLE : (testProxy == null ? Availability.NO_PROXY : (!testProxy.isWorking() ? Availability.GONE : Availability.OK));
    }

    private final void handleProxyAvailability(ProxyEntry testProxy, Availability avail) {
        Availability availability = avail;
        int n = WhenMappings.$EnumSwitchMapping$0[availability.ordinal()];
        switch (n) {
            case 1: {
                this.disconnectIfNecessary(testProxy, avail);
                break;
            }
            case 2: {
                this.connectNext(testProxy, avail);
                break;
            }
            case 3: {
                this.disconnectIfNecessary(testProxy, avail);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void connectNext(ProxyEntry proxy, Availability avail) {
        if (!this.isActive()) {
            return;
        }
        ProxyServerConnector proxyServerConnector = this.connector;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (proxyServerConnector) {
            ProxyEntry it;
            boolean bl3;
            boolean bl4;
            ProxyEntry proxyEntry;
            boolean bl5 = false;
            ProxyEntry proxyEntry2 = proxy;
            if (proxyEntry2 != null) {
                proxyEntry = proxyEntry2;
                bl4 = false;
                bl3 = false;
                it = proxyEntry;
                boolean bl6 = false;
                this.disconnectIfNecessary(it, avail);
            }
            proxyEntry = this.getProxyPool().take();
            if (proxyEntry == null) {
                throw new NoProxyException("No proxy found in the pool");
            }
            ProxyEntry nextProxy = proxyEntry;
            if (this.isActive()) {
                boolean bl7;
                proxyEntry = nextProxy;
                bl4 = false;
                bl3 = false;
                it = proxyEntry;
                boolean bl8 = false;
                this.connector.connect(it);
                boolean bl9 = Intrinsics.areEqual((Object)this.getCurrentInterceptProxyEntry(), (Object)nextProxy);
                bl4 = false;
                bl3 = false;
                bl3 = false;
                boolean bl10 = false;
                if (!bl9) {
                    bl7 = false;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                ProxyEntry proxyEntry3 = this.getCurrentInterceptProxyEntry();
                boolean bl11 = proxyEntry3 == null ? false : proxyEntry3.isWorking();
                bl4 = false;
                bl3 = false;
                bl3 = false;
                bl10 = false;
                if (!bl11) {
                    bl7 = false;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void disconnectIfNecessary(ProxyEntry testProxy, Availability avail) {
        if (!this.isActive()) {
            return;
        }
        ProxyServerConnector proxyServerConnector = this.connector;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (proxyServerConnector) {
            ProxyEntry proxyEntry;
            boolean bl3 = false;
            ProxyEntry latestProxy = this.getCurrentInterceptProxyEntry();
            ProxyEntry proxyEntry2 = this.log;
            boolean bl4 = false;
            boolean bl5 = false;
            ProxyEntry it = proxyEntry2;
            boolean bl6 = false;
            Object object = proxyEntry = !Intrinsics.areEqual((Object)testProxy, (Object)latestProxy) ? proxyEntry2 : null;
            if (proxyEntry != null) {
                proxyEntry2 = new Object[4];
                ProxyEntry proxyEntry3 = testProxy;
                proxyEntry2[0] = proxyEntry3 == null ? null : proxyEntry3.getOutIp();
                proxyEntry3 = latestProxy;
                proxyEntry2[1] = proxyEntry3 == null ? null : proxyEntry3.getOutIp();
                proxyEntry2[2] = testProxy;
                proxyEntry2[3] = latestProxy;
                proxyEntry.warn("Proxy has been changed | {} -> {} | {} -> {}", (Object[])proxyEntry2);
            }
            if (latestProxy != null) {
                this.log.info("Proxy available {}, disconnect the online proxy | {}", (Object)avail, (Object)latestProxy);
                proxyEntry = this.connector.disconnect();
                if (proxyEntry != null) {
                    proxyEntry2 = proxyEntry;
                    bl4 = false;
                    bl5 = false;
                    it = proxyEntry2;
                    boolean bl7 = false;
                    this.getProxyPool().retire(it);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final boolean willDisconnectOnCommand() {
        boolean bl = FileCommand.INSTANCE.check("IPS-disconnect", 30L);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean it = bl;
        boolean bl4 = false;
        if (it) {
            this.log.info("Find command IPS-disconnect, disconnect the online proxy");
        }
        return bl;
    }

    private final void reportIfNecessary(ProxyEntry proxy, Availability avail, boolean forceReport) {
        boolean proxyUpdated;
        Object object = this.getStatusString();
        boolean bl = false;
        boolean bl2 = object.length() == 0 ? true : (this.numFailedPages != proxy.getNumFailedPages().get() ? true : (proxyUpdated = this.numLostConnections != proxy.getNumConnectionLosses().get()));
        if (forceReport || proxyUpdated) {
            this.numFailedPages = proxy.getNumFailedPages().get();
            this.numLostConnections = proxy.getNumConnectionLosses().get();
            this.setStatusString(this.formatStatus(avail.isIdle(), avail, proxy));
            if (this.getVerbose()) {
                String string;
                ConcurrentPassiveExpiringSet concurrentPassiveExpiringSet;
                this.log.info(this.getStatusString());
                object = this.proxyLoader;
                if (object != null && (concurrentPassiveExpiringSet = object.getBannedSegments()) != null && (string = CollectionsKt.joinToString$default((Iterable)((Iterable)concurrentPassiveExpiringSet), null, null, null, (int)0, null, null, (int)63, null)) != null) {
                    String string2;
                    String string3 = string;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String it = string3;
                    boolean bl5 = false;
                    CharSequence charSequence = it;
                    boolean bl6 = false;
                    String string4 = string2 = charSequence.length() > 0 ? string3 : null;
                    if (string2 != null) {
                        string3 = string2;
                        bl3 = false;
                        bl4 = false;
                        it = string3;
                        boolean bl7 = false;
                        this.log.info("Banned segments: " + it);
                    }
                }
            }
        }
    }

    static /* synthetic */ void reportIfNecessary$default(InterceptiveProxyPoolManager interceptiveProxyPoolManager, ProxyEntry proxyEntry, Availability availability, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        interceptiveProxyPoolManager.reportIfNecessary(proxyEntry, availability, bl);
    }

    private final String formatStatus(boolean isIdle, Availability avail, ProxyEntry lastProxy) {
        return isIdle ? "Proxy is idle for " + this.getIdleTime() + " | " + this.getProxyPool() : (lastProxy == null ? "Proxy <none> is serving " + this.getNumRunningTasks() + " tasks | " + this.getProxyPool() : "Proxy <" + lastProxy.getDisplay() + "> is serving " + this.getNumRunningTasks() + " tasks (" + avail + ") | " + lastProxy.getMetadata() + " | " + this.getProxyPool());
    }

    static /* synthetic */ String formatStatus$default(InterceptiveProxyPoolManager interceptiveProxyPoolManager, boolean bl, Availability availability, ProxyEntry proxyEntry, int n, Object object) {
        if ((n & 4) != 0) {
            proxyEntry = null;
        }
        return interceptiveProxyPoolManager.formatStatus(bl, availability, proxyEntry);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lai/platon/scent/proxy/manager/InterceptiveProxyPoolManager$Availability;", "", "(Ljava/lang/String;I)V", "isIdle", "", "()Z", "isNotOK", "isOK", "OK", "IDLE", "NO_PROXY", "TEST_IP", "SERVER_DISCONNECTED", "WILL_DISCONNECT", "WILL_EXPIRE", "TEMPORARY_LOST", "GONE", "scent-proxy"})
    public static final class Availability
    extends Enum<Availability> {
        public static final /* enum */ Availability OK = new Availability();
        public static final /* enum */ Availability IDLE = new Availability();
        public static final /* enum */ Availability NO_PROXY = new Availability();
        public static final /* enum */ Availability TEST_IP = new Availability();
        public static final /* enum */ Availability SERVER_DISCONNECTED = new Availability();
        public static final /* enum */ Availability WILL_DISCONNECT = new Availability();
        public static final /* enum */ Availability WILL_EXPIRE = new Availability();
        public static final /* enum */ Availability TEMPORARY_LOST = new Availability();
        public static final /* enum */ Availability GONE = new Availability();
        private static final /* synthetic */ Availability[] $VALUES;

        public final boolean isOK() {
            return this == OK;
        }

        public final boolean isNotOK() {
            return !this.isOK();
        }

        public final boolean isIdle() {
            return this == IDLE;
        }

        public static Availability[] values() {
            return (Availability[])$VALUES.clone();
        }

        public static Availability valueOf(String value) {
            return Enum.valueOf(Availability.class, value);
        }

        static {
            $VALUES = availabilityArray = new Availability[]{Availability.OK, Availability.IDLE, Availability.NO_PROXY, Availability.TEST_IP, Availability.SERVER_DISCONNECTED, Availability.WILL_DISCONNECT, Availability.WILL_EXPIRE, Availability.TEMPORARY_LOST, Availability.GONE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Availability.values().length];
            nArray[Availability.IDLE.ordinal()] = 1;
            nArray[Availability.NO_PROXY.ordinal()] = 2;
            nArray[Availability.GONE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

