/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.proxy.pool.vendor;

import ai.platon.scent.proxy.pool.vendor.DefaultProxyParser;
import ai.platon.scent.proxy.pool.vendor.ProxyParser;
import ai.platon.scent.proxy.pool.vendor.apeyun.APEYunProxyParser;
import ai.platon.scent.proxy.pool.vendor.dailiyun.DaiLiYunProxyParser;
import ai.platon.scent.proxy.pool.vendor.mock.MockProxyParser;
import ai.platon.scent.proxy.pool.vendor.zm.ZMProxyParser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/proxy/pool/vendor/ProxyVendorFactory;", "", "()V", "getProxyParser", "Lai/platon/scent/proxy/pool/vendor/ProxyParser;", "vendor", "", "scent-proxy"})
public final class ProxyVendorFactory {
    @NotNull
    public static final ProxyVendorFactory INSTANCE = new ProxyVendorFactory();

    private ProxyVendorFactory() {
    }

    @NotNull
    public final ProxyParser getProxyParser(@NotNull String vendor) {
        ProxyParser proxyParser;
        Intrinsics.checkNotNullParameter((Object)vendor, (String)"vendor");
        switch (vendor) {
            case "zm": {
                proxyParser = new ZMProxyParser();
                break;
            }
            case "apeyun": {
                proxyParser = new APEYunProxyParser();
                break;
            }
            case "dailiyun": {
                proxyParser = new DaiLiYunProxyParser();
                break;
            }
            case "mock": {
                proxyParser = new MockProxyParser();
                break;
            }
            default: {
                proxyParser = new DefaultProxyParser();
            }
        }
        return proxyParser;
    }
}

