/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.proxy.pool.vendor.zm;

import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimeDetector;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.common.proxy.ProxyInsufficientBalanceException;
import ai.platon.pulsar.common.proxy.ProxyRetryException;
import ai.platon.pulsar.common.proxy.ProxyType;
import ai.platon.pulsar.common.proxy.ProxyVendorException;
import ai.platon.scent.proxy.pool.vendor.ProxyParser;
import ai.platon.scent.proxy.pool.vendor.zm.ProxyItem;
import ai.platon.scent.proxy.pool.vendor.zm.ProxyResult;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/platon/scent/proxy/pool/vendor/zm/ZMProxyParser;", "Lai/platon/scent/proxy/pool/vendor/ProxyParser;", "()V", "dateTimeDetector", "Lai/platon/pulsar/common/DateTimeDetector;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "doParse", "", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "text", "", "format", "extractIp", "ipString", "getApiKey", "getApiKey0", "parse", "parseInstant", "Ljava/time/Instant;", "str", "Companion", "scent-proxy"})
public final class ZMProxyParser
extends ProxyParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Gson gson = new GsonBuilder().create();
    @NotNull
    private final DateTimeDetector dateTimeDetector = new DateTimeDetector();
    @NotNull
    public static final String PARAM_PROXY_ZM_API_KEY = "proxy.zm.api.key";

    @Override
    @NotNull
    public List<ProxyEntry> parse(@NotNull String text, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return this.doParse(text, format);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProxyEntry> doParse(String text, String format) {
        String apiKey;
        String string = this.getApiKey();
        String string2 = apiKey = string == null ? "{YOUR-API-KEY}" : string;
        if (Intrinsics.areEqual((Object)format, (Object)"json")) {
            ProxyResult result = (ProxyResult)this.gson.fromJson(text, ProxyResult.class);
            if (result.getSuccess()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = result.getData();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    void it2;
                    ProxyItem proxyItem = (ProxyItem)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string3 = it2.getOutip();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String string4 = string3;
                    int n = it2.getPort();
                    String string5 = it2.getIp();
                    boolean bl4 = false;
                    CharSequence charSequence = (CharSequence)it;
                    boolean bl5 = false;
                    boolean bl6 = !StringsKt.isBlank((CharSequence)charSequence);
                    String string6 = bl6 ? string3 : null;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n2 = 4072;
                    String string7 = null;
                    String string8 = null;
                    ProxyType proxyType = null;
                    boolean bl7 = false;
                    URL uRL = null;
                    List list = null;
                    String string9 = null;
                    Instant instant = this.parseInstant(it2.getExpire_time());
                    int n3 = 0;
                    String string10 = string6 == null ? it2.getIp() : string6;
                    int n4 = n;
                    String string11 = string5;
                    ProxyEntry proxyEntry = new ProxyEntry(string11, n4, string10, n3, instant, string9, list, uRL, bl7, proxyType, string8, string7, n2, defaultConstructorMarker);
                    collection.add(proxyEntry);
                }
                return (List)destination$iv$iv;
            }
            if (result.getCode() != 0) {
                int n = result.getCode();
                switch (n) {
                    case 113: 
                    case 117: {
                        String ip = this.extractIp(result.getMsg());
                        String link = "https://wapi.http.linkudp.com/index/index/save_white?neek=76534&appkey=" + apiKey + "&white=" + ip;
                        this.getLogger().warn(result.getMsg() + " using one of the following link:\n" + link + "\n" + text);
                        throw new ProxyVendorException("Proxy vendor exception, please add " + ip + " to the vendor's while list");
                    }
                    case 115: {
                        throw new ProxyRetryException("Retry fetching proxy - " + text);
                    }
                    case 121: {
                        throw new ProxyInsufficientBalanceException("Insufficient balance - " + text);
                    }
                }
                throw new ProxyVendorException("Proxy vendor exception - " + text);
            }
        }
        boolean bl = false;
        return CollectionsKt.emptyList();
    }

    private final String getApiKey() {
        boolean bl;
        boolean bl2;
        Object object;
        boolean bl3 = false;
        try {
            object = Result.Companion;
            boolean bl4 = false;
            String string = this.getApiKey0();
            bl2 = false;
            object = Result.constructor-impl((Object)string);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Result.Companion companion = object;
        boolean bl5 = false;
        boolean bl6 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)companion);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl7 = false;
            Throwable it = throwable3;
            boolean bl8 = false;
            this.getLogger().warn(it.getMessage());
        }
        bl5 = false;
        return (String)(Result.isFailure-impl((Object)companion) ? null : companion);
    }

    private final String getApiKey0() throws IOException {
        Path path;
        String apiKey = System.getProperty(PARAM_PROXY_ZM_API_KEY);
        CharSequence charSequence = apiKey;
        boolean bl = false;
        boolean bl2 = false;
        if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && Files.exists(path = AppPaths.INSTANCE.getPROXY_BASE_DIR().resolve("proxy.zm.api.key.txt"), new LinkOption[0])) {
            List<String> list = Files.readAllLines(path);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(path)");
            apiKey = (String)CollectionsKt.firstOrNull(list);
        }
        return apiKey;
    }

    private final String extractIp(String ipString) {
        String string;
        Pattern pattern = Pattern.compile("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");
        Matcher matcher = pattern.matcher(ipString);
        if (matcher.find()) {
            String string2 = matcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            matcher.group()\n        }");
            string = string2;
        } else {
            string = "0.0.0.0";
        }
        return string;
    }

    private final Instant parseInstant(String str) {
        Instant instant = this.dateTimeDetector.parseDateTimeStrictly(str).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"dateTimeDetector.parseDa\u2026Strictly(str).toInstant()");
        return instant;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/scent/proxy/pool/vendor/zm/ZMProxyParser$Companion;", "", "()V", "PARAM_PROXY_ZM_API_KEY", "", "scent-proxy"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

