/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.proxy.server;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.scent.proxy.server.HttpProxyInterceptPipeline;
import ai.platon.scent.proxy.server.ProxyServer;
import ai.platon.scent.proxy.server.ProxyServerHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.proxy.ProxyConnectException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0016\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010)\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\n \u001a*\u0004\u0018\u00010\u001e0\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006-"}, d2={"Lai/platon/scent/proxy/server/FrontendChannelHandler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "server", "Lai/platon/scent/proxy/server/ProxyServer;", "backendChannel", "Lio/netty/channel/Channel;", "(Lai/platon/scent/proxy/server/ProxyServer;Lio/netty/channel/Channel;)V", "display", "", "getDisplay", "()Ljava/lang/String;", "frontChannel", "getFrontChannel", "()Lio/netty/channel/Channel;", "setFrontChannel", "(Lio/netty/channel/Channel;)V", "id", "", "getId", "()I", "interceptPipeline", "Lai/platon/scent/proxy/server/HttpProxyInterceptPipeline;", "getInterceptPipeline", "()Lai/platon/scent/proxy/server/HttpProxyInterceptPipeline;", "log", "Lio/netty/util/internal/logging/InternalLogger;", "kotlin.jvm.PlatformType", "name", "getName", "serverHandle", "Lai/platon/scent/proxy/server/ProxyServerHandler;", "getServerHandle", "()Lai/platon/scent/proxy/server/ProxyServerHandler;", "channelRead", "", "cx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "", "channelRegistered", "channelUnregistered", "exceptionCaught", "cause", "", "Companion", "scent-proxy"})
public class FrontendChannelHandler
extends ChannelInboundHandlerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProxyServer server;
    @NotNull
    private final Channel backendChannel;
    private final InternalLogger log;
    private final int id;
    @NotNull
    private final String name;
    @Nullable
    private Channel frontChannel;
    @NotNull
    private static final AtomicInteger sequencer = new AtomicInteger();

    public FrontendChannelHandler(@NotNull ProxyServer server, @NotNull Channel backendChannel) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)backendChannel, (String)"backendChannel");
        this.server = server;
        this.backendChannel = backendChannel;
        this.log = InternalLoggerFactory.getInstance(FrontendChannelHandler.class);
        this.id = sequencer.incrementAndGet();
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%02d";
        Object[] objectArray = new Object[]{this.id};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        this.name = string2;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Channel getFrontChannel() {
        return this.frontChannel;
    }

    public final void setFrontChannel(@Nullable Channel channel) {
        this.frontChannel = channel;
    }

    @NotNull
    public final String getDisplay() {
        Channel channel;
        return this.name + "-" + this.backendChannel.id() + "-" + ((channel = this.frontChannel) == null ? null : channel.id());
    }

    private final ProxyServerHandler getServerHandle() {
        return (ProxyServerHandler)this.backendChannel.pipeline().get(ProxyServerHandler.class);
    }

    private final HttpProxyInterceptPipeline getInterceptPipeline() {
        return this.getServerHandle().getInterceptPipeline();
    }

    public void channelRead(@NotNull ChannelHandlerContext cx, @NotNull Object msg) {
        Intrinsics.checkNotNullParameter((Object)cx, (String)"cx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (!this.backendChannel.isOpen()) {
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        Object object = msg;
        if (object instanceof HttpResponse) {
            HttpProxyInterceptPipeline httpProxyInterceptPipeline = this.getInterceptPipeline();
            Channel channel = cx.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"cx.channel()");
            httpProxyInterceptPipeline.afterResponse(this.backendChannel, channel, (HttpResponse)msg);
        } else if (object instanceof HttpContent) {
            HttpProxyInterceptPipeline httpProxyInterceptPipeline = this.getInterceptPipeline();
            Channel channel = cx.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"cx.channel()");
            httpProxyInterceptPipeline.afterResponse(this.backendChannel, channel, (HttpContent)msg);
        } else {
            this.backendChannel.writeAndFlush(msg);
        }
    }

    public void channelRegistered(@NotNull ChannelHandlerContext cx) {
        Intrinsics.checkNotNullParameter((Object)cx, (String)"cx");
        this.frontChannel = cx.channel();
        super.channelRegistered(cx);
    }

    public void channelUnregistered(@NotNull ChannelHandlerContext cx) {
        Intrinsics.checkNotNullParameter((Object)cx, (String)"cx");
        this.log.debug("Closing the client channel {}", (Object)this.getDisplay());
        cx.channel().close();
        this.backendChannel.close();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext cx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)cx, (String)"cx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        if (cause instanceof ProxyConnectException) {
            this.log.debug("Proxy disconnected, close channels - {} - {}", (Object)this.getDisplay(), (Object)cause.getMessage());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Exception caught, close channels - {} - {}", (Object)this.getDisplay(), (Object)ExceptionsKt.stringify$default((Throwable)cause, null, null, (int)3, null));
        }
        cx.channel().close();
        this.backendChannel.close();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/proxy/server/FrontendChannelHandler$Companion;", "", "()V", "sequencer", "Ljava/util/concurrent/atomic/AtomicInteger;", "getSequencer", "()Ljava/util/concurrent/atomic/AtomicInteger;", "scent-proxy"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicInteger getSequencer() {
            return sequencer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

