/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.proxy.server;

import ai.platon.scent.proxy.server.FrontendChannelHandler;
import ai.platon.scent.proxy.server.ProxyServer;
import ai.platon.scent.proxy.server.RequestProto;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lai/platon/scent/proxy/server/FrontendHttpChannelInitializer;", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/Channel;", "server", "Lai/platon/scent/proxy/server/ProxyServer;", "backendChannel", "requestProto", "Lai/platon/scent/proxy/server/RequestProto;", "throughputCounter", "Lio/netty/handler/traffic/GlobalTrafficShapingHandler;", "proxyHandler", "Lio/netty/handler/proxy/ProxyHandler;", "(Lai/platon/scent/proxy/server/ProxyServer;Lio/netty/channel/Channel;Lai/platon/scent/proxy/server/RequestProto;Lio/netty/handler/traffic/GlobalTrafficShapingHandler;Lio/netty/handler/proxy/ProxyHandler;)V", "initChannel", "", "channel", "scent-proxy"})
public class FrontendHttpChannelInitializer
extends ChannelInitializer<Channel> {
    @NotNull
    private final ProxyServer server;
    @NotNull
    private final Channel backendChannel;
    @NotNull
    private final RequestProto requestProto;
    @NotNull
    private final GlobalTrafficShapingHandler throughputCounter;
    @Nullable
    private final ProxyHandler proxyHandler;

    public FrontendHttpChannelInitializer(@NotNull ProxyServer server, @NotNull Channel backendChannel, @NotNull RequestProto requestProto, @NotNull GlobalTrafficShapingHandler throughputCounter, @Nullable ProxyHandler proxyHandler) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)backendChannel, (String)"backendChannel");
        Intrinsics.checkNotNullParameter((Object)requestProto, (String)"requestProto");
        Intrinsics.checkNotNullParameter((Object)throughputCounter, (String)"throughputCounter");
        this.server = server;
        this.backendChannel = backendChannel;
        this.requestProto = requestProto;
        this.throughputCounter = throughputCounter;
        this.proxyHandler = proxyHandler;
    }

    protected void initChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("traffic", (ChannelHandler)this.throughputCounter);
        if (this.proxyHandler != null) {
            pipeline.addLast("proxyServerHandle", (ChannelHandler)this.proxyHandler);
        }
        if (this.requestProto.getSsl()) {
            SslContext clientSslCtx = this.server.getClientSslCtx();
            SslContext sslContext = clientSslCtx;
            ChannelHandler[] channelHandlerArray = new ChannelHandler[]{(ChannelHandler)(sslContext == null ? null : sslContext.newHandler(channel.alloc(), this.requestProto.getHost(), this.requestProto.getPort()))};
            pipeline.addLast(channelHandlerArray);
        }
        pipeline.addLast("httpCodec", (ChannelHandler)new HttpClientCodec());
        pipeline.addLast("proxyClientHandle", (ChannelHandler)new FrontendChannelHandler(this.server, this.backendChannel));
    }
}

