/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.proxy.server;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.scent.proxy.common.CertPool;
import ai.platon.scent.proxy.common.CertUtil;
import ai.platon.scent.proxy.common.DefaultProxyCACertFactory;
import ai.platon.scent.proxy.server.ExceptionHandler;
import ai.platon.scent.proxy.server.HttpProxyInterceptInitializer;
import ai.platon.scent.proxy.server.HttpTunnelIntercept;
import ai.platon.scent.proxy.server.ProxyServerHandler;
import ai.platon.scent.proxy.server.ResourceCacheKey;
import ai.platon.scent.proxy.server.ResourceItem;
import ai.platon.scent.proxy.server.TrafficCounter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u0090\u00012\u00020\u0001:\u0004\u0090\u0001\u0091\u0001BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\u0085\u0001\u001a\u00030\u0086\u0001H\u0016J\u0011\u0010\u0087\u0001\u001a\n\u0012\u0005\u0012\u00030\u0089\u00010\u0088\u0001H\u0002J\n\u0010\u008a\u0001\u001a\u00030\u0086\u0001H\u0002J\u0010\u0010\u008b\u0001\u001a\u00020\n2\u0007\u0010\u008c\u0001\u001a\u00020\u000eJ\u0010\u0010\u008d\u0001\u001a\u00020\n2\u0007\u0010\u008c\u0001\u001a\u00020\u000eJ\u0011\u0010\u008e\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u008f\u0001\u001a\u00020\u0003R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0016\"\u0004\b/\u0010\u0018R\u001c\u00100\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00108\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u0016\"\u0004\bA\u0010\u0018R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u001a\u0010F\u001a\u00020GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u0011\u0010L\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010CR\u0011\u0010M\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010CR\u001c\u0010N\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u0016\u0010S\u001a\n U*\u0004\u0018\u00010T0TX\u0082\u0004\u00a2\u0006\u0002\n\u0000RQ\u0010V\u001aB\u0012\f\u0012\n U*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n U*\u0004\u0018\u00010X0X U* \u0012\f\u0012\n U*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n U*\u0004\u0018\u00010X0X\u0018\u00010Y0W\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010[R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_RQ\u0010`\u001aB\u0012\f\u0012\n U*\u0004\u0018\u00010X0X\u0012\f\u0012\n U*\u0004\u0018\u00010a0a U* \u0012\f\u0012\n U*\u0004\u0018\u00010X0X\u0012\f\u0012\n U*\u0004\u0018\u00010a0a\u0018\u00010Y0W\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010[R\u0019\u0010c\u001a\n U*\u0004\u0018\u00010d0d\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010fR\u001c\u0010g\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010+\"\u0004\bi\u0010-R\u001c\u0010j\u001a\u0004\u0018\u00010kX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010m\"\u0004\bn\u0010oR\u0017\u0010p\u001a\b\u0012\u0004\u0012\u00020r0q\u00a2\u0006\b\n\u0000\u001a\u0004\bs\u0010tR\u001a\u0010u\u001a\u00020vX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bw\u0010x\"\u0004\by\u0010zR\u001d\u0010{\u001a\u0004\u0018\u00010|X\u0086\u000e\u00a2\u0006\u000f\n\u0000\u001a\u0004\b}\u0010~\"\u0005\b\u007f\u0010\u0080\u0001R\u0013\u0010\u0081\u0001\u001a\u00020\u0012\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0082\u0001\u0010\u0014R\u001c\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0083\u0001\u0010\u0016\"\u0005\b\u0084\u0001\u0010\u0018\u00a8\u0006\u0092\u0001"}, d2={"Lai/platon/scent/proxy/server/ProxyServer;", "Ljava/lang/AutoCloseable;", "bossGroupThreads", "", "workerGroupThreads", "frontendGroupThreads", "proxyEntry", "Lai/platon/pulsar/common/proxy/ProxyEntry;", "cacheLevel", "handleSsl", "", "(IIILai/platon/pulsar/common/proxy/ProxyEntry;IZ)V", "bannedHosts", "", "", "getBannedHosts", "()Ljava/util/Set;", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "getBossGroup", "()Lio/netty/channel/nio/NioEventLoopGroup;", "getBossGroupThreads", "()I", "setBossGroupThreads", "(I)V", "caCertFactory", "Lai/platon/scent/proxy/common/DefaultProxyCACertFactory;", "getCaCertFactory", "()Lai/platon/scent/proxy/common/DefaultProxyCACertFactory;", "setCaCertFactory", "(Lai/platon/scent/proxy/common/DefaultProxyCACertFactory;)V", "caNotAfter", "Ljava/util/Date;", "getCaNotAfter", "()Ljava/util/Date;", "setCaNotAfter", "(Ljava/util/Date;)V", "caNotBefore", "getCaNotBefore", "setCaNotBefore", "caPriKey", "Ljava/security/PrivateKey;", "getCaPriKey", "()Ljava/security/PrivateKey;", "setCaPriKey", "(Ljava/security/PrivateKey;)V", "getCacheLevel", "setCacheLevel", "clientSslCtx", "Lio/netty/handler/ssl/SslContext;", "getClientSslCtx", "()Lio/netty/handler/ssl/SslContext;", "setClientSslCtx", "(Lio/netty/handler/ssl/SslContext;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "exceptionHandle", "Lai/platon/scent/proxy/server/ExceptionHandler;", "getExceptionHandle", "()Lai/platon/scent/proxy/server/ExceptionHandler;", "setExceptionHandle", "(Lai/platon/scent/proxy/server/ExceptionHandler;)V", "frontendGroup", "getFrontendGroup", "getFrontendGroupThreads", "setFrontendGroupThreads", "getHandleSsl", "()Z", "setHandleSsl", "(Z)V", "interceptInitializer", "Lai/platon/scent/proxy/server/HttpProxyInterceptInitializer;", "getInterceptInitializer", "()Lai/platon/scent/proxy/server/HttpProxyInterceptInitializer;", "setInterceptInitializer", "(Lai/platon/scent/proxy/server/HttpProxyInterceptInitializer;)V", "isDisconnected", "isOnline", "issuer", "getIssuer", "()Ljava/lang/String;", "setIssuer", "(Ljava/lang/String;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "notModifiedResources", "", "Lai/platon/scent/proxy/server/ResourceCacheKey;", "", "getNotModifiedResources", "()Ljava/util/Map;", "getProxyEntry", "()Lai/platon/pulsar/common/proxy/ProxyEntry;", "setProxyEntry", "(Lai/platon/pulsar/common/proxy/ProxyEntry;)V", "resourceCache", "Lai/platon/scent/proxy/server/ResourceItem;", "getResourceCache", "resourceExpireTime", "Ljava/time/Duration;", "getResourceExpireTime", "()Ljava/time/Duration;", "serverPriKey", "getServerPriKey", "setServerPriKey", "serverPubKey", "Ljava/security/PublicKey;", "getServerPubKey", "()Ljava/security/PublicKey;", "setServerPubKey", "(Ljava/security/PublicKey;)V", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lai/platon/scent/proxy/server/ProxyServer$State;", "getState", "()Ljava/util/concurrent/atomic/AtomicReference;", "trafficCounter", "Lai/platon/scent/proxy/server/TrafficCounter;", "getTrafficCounter", "()Lai/platon/scent/proxy/server/TrafficCounter;", "setTrafficCounter", "(Lai/platon/scent/proxy/server/TrafficCounter;)V", "tunnelIntercept", "Lai/platon/scent/proxy/server/HttpTunnelIntercept;", "getTunnelIntercept", "()Lai/platon/scent/proxy/server/HttpTunnelIntercept;", "setTunnelIntercept", "(Lai/platon/scent/proxy/server/HttpTunnelIntercept;)V", "workerGroup", "getWorkerGroup", "getWorkerGroupThreads", "setWorkerGroupThreads", "close", "", "createChildHandler", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/Channel;", "initSSL", "isBanned", "uri", "isNotModified", "start", "localPort", "Companion", "State", "scent-proxy"})
public final class ProxyServer
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int bossGroupThreads;
    private int workerGroupThreads;
    private int frontendGroupThreads;
    @Nullable
    private ProxyEntry proxyEntry;
    private int cacheLevel;
    private boolean handleSsl;
    private final Logger logger;
    @NotNull
    private final NioEventLoopGroup bossGroup;
    @NotNull
    private final NioEventLoopGroup workerGroup;
    @NotNull
    private final NioEventLoopGroup frontendGroup;
    @NotNull
    private HttpProxyInterceptInitializer interceptInitializer;
    @Nullable
    private HttpTunnelIntercept tunnelIntercept;
    @NotNull
    private ExceptionHandler exceptionHandle;
    @NotNull
    private TrafficCounter trafficCounter;
    @NotNull
    private DefaultProxyCACertFactory caCertFactory;
    @Nullable
    private SslContext clientSslCtx;
    @Nullable
    private String issuer;
    @Nullable
    private Date caNotBefore;
    @Nullable
    private Date caNotAfter;
    @Nullable
    private PrivateKey caPriKey;
    @Nullable
    private PrivateKey serverPriKey;
    @Nullable
    private PublicKey serverPubKey;
    @NotNull
    private final AtomicReference<State> state;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final Set<String> bannedHosts;
    private final Duration resourceExpireTime;
    private final Map<ResourceCacheKey, ResourceItem> resourceCache;
    private final Map<String, ResourceCacheKey> notModifiedResources;
    @NotNull
    private static final HttpResponseStatus SUCCESS = new HttpResponseStatus(200, "Connection established");
    public static final long messageSize = 1024L;
    public static final int bandwidthFactor = 12;

    public ProxyServer(int bossGroupThreads, int workerGroupThreads, int frontendGroupThreads, @Nullable ProxyEntry proxyEntry, int cacheLevel, boolean handleSsl) {
        this.bossGroupThreads = bossGroupThreads;
        this.workerGroupThreads = workerGroupThreads;
        this.frontendGroupThreads = frontendGroupThreads;
        this.proxyEntry = proxyEntry;
        this.cacheLevel = cacheLevel;
        this.handleSsl = handleSsl;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(ProxyServer.class));
        this.bossGroup = new NioEventLoopGroup(this.bossGroupThreads);
        this.workerGroup = new NioEventLoopGroup(this.workerGroupThreads, new ThreadFactoryBuilder().setNameFormat("pwg-%d").build());
        this.frontendGroup = new NioEventLoopGroup(this.frontendGroupThreads, new ThreadFactoryBuilder().setNameFormat("pfg-%d").build());
        this.interceptInitializer = new HttpProxyInterceptInitializer();
        this.exceptionHandle = new ExceptionHandler();
        this.trafficCounter = new TrafficCounter((EventExecutorGroup)this.frontendGroup, 0L, 0L, 6, null);
        this.caCertFactory = new DefaultProxyCACertFactory();
        this.state = new AtomicReference<State>(State.INITIALIZING);
        this.closed = new AtomicBoolean();
        Object[] objectArray = new String[]{"google.com", "gstatic.com"};
        this.bannedHosts = SetsKt.mutableSetOf((Object[])objectArray);
        this.resourceExpireTime = Duration.ofMinutes(10L);
        this.resourceCache = Collections.synchronizedMap((Map)new PassiveExpiringMap(this.resourceExpireTime.toMillis()));
        this.notModifiedResources = Collections.synchronizedMap((Map)new PassiveExpiringMap(this.resourceExpireTime.toMillis()));
        if (this.handleSsl) {
            this.initSSL();
        }
    }

    public /* synthetic */ ProxyServer(int n, int n2, int n3, ProxyEntry proxyEntry, int n4, boolean bl, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 1) != 0) {
            n = 1;
        }
        if ((n5 & 2) != 0) {
            n2 = 5;
        }
        if ((n5 & 4) != 0) {
            n3 = 5;
        }
        if ((n5 & 8) != 0) {
            proxyEntry = null;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        if ((n5 & 0x20) != 0) {
            bl = true;
        }
        this(n, n2, n3, proxyEntry, n4, bl);
    }

    public final int getBossGroupThreads() {
        return this.bossGroupThreads;
    }

    public final void setBossGroupThreads(int n) {
        this.bossGroupThreads = n;
    }

    public final int getWorkerGroupThreads() {
        return this.workerGroupThreads;
    }

    public final void setWorkerGroupThreads(int n) {
        this.workerGroupThreads = n;
    }

    public final int getFrontendGroupThreads() {
        return this.frontendGroupThreads;
    }

    public final void setFrontendGroupThreads(int n) {
        this.frontendGroupThreads = n;
    }

    @Nullable
    public final ProxyEntry getProxyEntry() {
        return this.proxyEntry;
    }

    public final void setProxyEntry(@Nullable ProxyEntry proxyEntry) {
        this.proxyEntry = proxyEntry;
    }

    public final int getCacheLevel() {
        return this.cacheLevel;
    }

    public final void setCacheLevel(int n) {
        this.cacheLevel = n;
    }

    public final boolean getHandleSsl() {
        return this.handleSsl;
    }

    public final void setHandleSsl(boolean bl) {
        this.handleSsl = bl;
    }

    @NotNull
    public final NioEventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    @NotNull
    public final NioEventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    @NotNull
    public final NioEventLoopGroup getFrontendGroup() {
        return this.frontendGroup;
    }

    @NotNull
    public final HttpProxyInterceptInitializer getInterceptInitializer() {
        return this.interceptInitializer;
    }

    public final void setInterceptInitializer(@NotNull HttpProxyInterceptInitializer httpProxyInterceptInitializer) {
        Intrinsics.checkNotNullParameter((Object)httpProxyInterceptInitializer, (String)"<set-?>");
        this.interceptInitializer = httpProxyInterceptInitializer;
    }

    @Nullable
    public final HttpTunnelIntercept getTunnelIntercept() {
        return this.tunnelIntercept;
    }

    public final void setTunnelIntercept(@Nullable HttpTunnelIntercept httpTunnelIntercept) {
        this.tunnelIntercept = httpTunnelIntercept;
    }

    @NotNull
    public final ExceptionHandler getExceptionHandle() {
        return this.exceptionHandle;
    }

    public final void setExceptionHandle(@NotNull ExceptionHandler exceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"<set-?>");
        this.exceptionHandle = exceptionHandler;
    }

    @NotNull
    public final TrafficCounter getTrafficCounter() {
        return this.trafficCounter;
    }

    public final void setTrafficCounter(@NotNull TrafficCounter trafficCounter) {
        Intrinsics.checkNotNullParameter((Object)((Object)trafficCounter), (String)"<set-?>");
        this.trafficCounter = trafficCounter;
    }

    @NotNull
    public final DefaultProxyCACertFactory getCaCertFactory() {
        return this.caCertFactory;
    }

    public final void setCaCertFactory(@NotNull DefaultProxyCACertFactory defaultProxyCACertFactory) {
        Intrinsics.checkNotNullParameter((Object)defaultProxyCACertFactory, (String)"<set-?>");
        this.caCertFactory = defaultProxyCACertFactory;
    }

    @Nullable
    public final SslContext getClientSslCtx() {
        return this.clientSslCtx;
    }

    public final void setClientSslCtx(@Nullable SslContext sslContext) {
        this.clientSslCtx = sslContext;
    }

    @Nullable
    public final String getIssuer() {
        return this.issuer;
    }

    public final void setIssuer(@Nullable String string) {
        this.issuer = string;
    }

    @Nullable
    public final Date getCaNotBefore() {
        return this.caNotBefore;
    }

    public final void setCaNotBefore(@Nullable Date date) {
        this.caNotBefore = date;
    }

    @Nullable
    public final Date getCaNotAfter() {
        return this.caNotAfter;
    }

    public final void setCaNotAfter(@Nullable Date date) {
        this.caNotAfter = date;
    }

    @Nullable
    public final PrivateKey getCaPriKey() {
        return this.caPriKey;
    }

    public final void setCaPriKey(@Nullable PrivateKey privateKey) {
        this.caPriKey = privateKey;
    }

    @Nullable
    public final PrivateKey getServerPriKey() {
        return this.serverPriKey;
    }

    public final void setServerPriKey(@Nullable PrivateKey privateKey) {
        this.serverPriKey = privateKey;
    }

    @Nullable
    public final PublicKey getServerPubKey() {
        return this.serverPubKey;
    }

    public final void setServerPubKey(@Nullable PublicKey publicKey) {
        this.serverPubKey = publicKey;
    }

    @NotNull
    public final AtomicReference<State> getState() {
        return this.state;
    }

    public final boolean isOnline() {
        return this.state.get() == State.ONLINE;
    }

    public final boolean isDisconnected() {
        return this.state.get() == State.DISCONNECTED;
    }

    @NotNull
    public final Set<String> getBannedHosts() {
        return this.bannedHosts;
    }

    public final Duration getResourceExpireTime() {
        return this.resourceExpireTime;
    }

    public final Map<ResourceCacheKey, ResourceItem> getResourceCache() {
        return this.resourceCache;
    }

    public final Map<String, ResourceCacheKey> getNotModifiedResources() {
        return this.notModifiedResources;
    }

    public final boolean isBanned(@NotNull String uri) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Iterable $this$any$iv = this.bannedHosts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)uri, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isNotModified(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.notModifiedResources.keySet().contains(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void start(int localPort) {
        try {
            Object b = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.TRACE))).childHandler((ChannelHandler)this.createChildHandler());
            ChannelFuture f = b.bind(localPort).sync();
            f.channel().closeFuture().sync();
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            AutoCloseable autoCloseable = this;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ProxyServer it = (ProxyServer)autoCloseable;
                boolean bl3 = false;
                this.close();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.frontendGroup.shutdownGracefully();
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
            CertPool.INSTANCE.clear();
        }
    }

    private final void initSSL() {
        try {
            this.clientSslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            X509Certificate caCert = this.caCertFactory.getCaCert();
            this.caPriKey = this.caCertFactory.getCaPriKey();
            this.issuer = CertUtil.INSTANCE.getSubject(caCert);
            this.caNotBefore = caCert.getNotBefore();
            this.caNotAfter = caCert.getNotAfter();
            KeyPair keyPair = CertUtil.INSTANCE.genKeyPair();
            this.serverPriKey = keyPair.getPrivate();
            this.serverPubKey = keyPair.getPublic();
        }
        catch (Exception e) {
            this.handleSsl = false;
        }
    }

    private final ChannelInitializer<Channel> createChildHandler() {
        ProxyServer server = this;
        return (ChannelInitializer)new ChannelInitializer<Channel>(server){
            final /* synthetic */ ProxyServer $server;
            {
                this.$server = $server;
            }

            protected void initChannel(@NotNull Channel ch) {
                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                ch.pipeline().addLast("httpCodec", (ChannelHandler)new HttpServerCodec());
                ch.pipeline().addLast("serverHandle", (ChannelHandler)new ProxyServerHandler(this.$server));
            }
        };
    }

    public ProxyServer() {
        this(0, 0, 0, null, 0, false, 63, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lai/platon/scent/proxy/server/ProxyServer$Companion;", "", "()V", "SUCCESS", "Lio/netty/handler/codec/http/HttpResponseStatus;", "getSUCCESS", "()Lio/netty/handler/codec/http/HttpResponseStatus;", "bandwidthFactor", "", "messageSize", "", "scent-proxy"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpResponseStatus getSUCCESS() {
            return SUCCESS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lai/platon/scent/proxy/server/ProxyServer$State;", "", "(Ljava/lang/String;I)V", "INITIALIZING", "ONLINE", "DISCONNECTED", "scent-proxy"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State INITIALIZING = new State();
        public static final /* enum */ State ONLINE = new State();
        public static final /* enum */ State DISCONNECTED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.INITIALIZING, State.ONLINE, State.DISCONNECTED};
        }
    }
}

