/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.proxy.server;

import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.scent.proxy.common.CertPool;
import ai.platon.scent.proxy.common.ProtoUtil;
import ai.platon.scent.proxy.server.ExceptionHandler;
import ai.platon.scent.proxy.server.FrontendHttpChannelInitializer;
import ai.platon.scent.proxy.server.FrontendTunnelInitializer;
import ai.platon.scent.proxy.server.HttpProxyIntercept;
import ai.platon.scent.proxy.server.HttpProxyInterceptPipeline;
import ai.platon.scent.proxy.server.ProxyHandlerFactory;
import ai.platon.scent.proxy.server.ProxyServer;
import ai.platon.scent.proxy.server.RequestProto;
import ai.platon.scent.proxy.server.ResourceCacheKey;
import ai.platon.scent.proxy.server.ResourceItem;
import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0016\u0018\u0000 <2\u00020\u0001:\u0001<B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010-\u001a\u00020\u0017H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020(H\u0016J\u0010\u00103\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00104\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J \u00105\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00102\u001a\u00020(2\u0006\u00106\u001a\u00020\u001dH\u0002J\u0018\u00107\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00108\u001a\u000209H\u0016J \u0010:\u001a\u00020/2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00102\u001a\u00020(2\u0006\u00106\u001a\u00020\u001dH\u0002J\u0018\u0010;\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020(H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n \t*\u0004\u0018\u00010 0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n \t*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000eR\u000e\u0010%\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lai/platon/scent/proxy/server/ProxyServerHandler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "server", "Lai/platon/scent/proxy/server/ProxyServer;", "(Lai/platon/scent/proxy/server/ProxyServer;)V", "backendChannel", "Lio/netty/channel/Channel;", "counterMessageRecv", "Lcom/codahale/metrics/Counter;", "kotlin.jvm.PlatformType", "counterMessageSent", "display", "", "getDisplay", "()Ljava/lang/String;", "frontendChannel", "Lio/netty/channel/ChannelFuture;", "host", "id", "", "getId", "()I", "interceptPipeline", "Lai/platon/scent/proxy/server/HttpProxyInterceptPipeline;", "getInterceptPipeline", "()Lai/platon/scent/proxy/server/HttpProxyInterceptPipeline;", "setInterceptPipeline", "(Lai/platon/scent/proxy/server/HttpProxyInterceptPipeline;)V", "isConnected", "", "isSsl", "log", "Lio/netty/util/internal/logging/InternalLogger;", "metrics", "Lcom/codahale/metrics/MetricRegistry;", "name", "getName", "port", "requestBuffer", "Ljava/util/LinkedList;", "", "getServer", "()Lai/platon/scent/proxy/server/ProxyServer;", "status", "tracer", "buildInterceptPipeline", "channelRead", "", "cx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "channelRegistered", "channelUnregistered", "createFrontendBootstrap", "isHttp", "exceptionCaught", "cause", "", "forwardData", "handleSslHandshake", "Companion", "scent-proxy"})
public class ProxyServerHandler
extends ChannelInboundHandlerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProxyServer server;
    private final InternalLogger log;
    @Nullable
    private final InternalLogger tracer;
    @NotNull
    private final LinkedList<Object> requestBuffer;
    @Nullable
    private Channel backendChannel;
    @Nullable
    private ChannelFuture frontendChannel;
    private final MetricRegistry metrics;
    private final Counter counterMessageSent;
    private final Counter counterMessageRecv;
    private String host;
    private int port;
    private boolean isSsl;
    private int status;
    private boolean isConnected;
    private final int id;
    @NotNull
    private final String name;
    public HttpProxyInterceptPipeline interceptPipeline;
    @NotNull
    private static final AtomicInteger sequencer = new AtomicInteger();
    @NotNull
    private static final AtomicInteger numMessageRecv = new AtomicInteger();
    @NotNull
    private static final AtomicInteger numMessageSent = new AtomicInteger();

    /*
     * WARNING - void declaration
     */
    public ProxyServerHandler(@NotNull ProxyServer server) {
        void it;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        this.server = server;
        InternalLogger internalLogger = this.log = InternalLoggerFactory.getInstance(ProxyServerHandler.class);
        boolean bl = false;
        boolean bl2 = false;
        InternalLogger internalLogger2 = internalLogger;
        ProxyServerHandler proxyServerHandler = this;
        boolean bl3 = false;
        boolean bl4 = it.isTraceEnabled();
        proxyServerHandler.tracer = bl4 ? internalLogger : null;
        this.requestBuffer = new LinkedList();
        this.metrics = SharedMetricRegistries.getOrCreate((String)"pulsar");
        this.counterMessageSent = this.metrics.counter(ai.platon.pulsar.common.StringsKt.prependReadableClassName$default((Object)((Object)this), (String)"messageSent", null, (int)4, null));
        this.counterMessageRecv = this.metrics.counter(ai.platon.pulsar.common.StringsKt.prependReadableClassName$default((Object)((Object)this), (String)"messageRecv", null, (int)4, null));
        this.id = sequencer.incrementAndGet();
        internalLogger = StringCompanionObject.INSTANCE;
        String string = "BS%02d";
        Object[] objectArray = new Object[]{this.id};
        boolean bl5 = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        this.name = string2;
    }

    @NotNull
    public final ProxyServer getServer() {
        return this.server;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDisplay() {
        Channel channel;
        Channel channel2;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%02d-%s-%s";
        Object[] objectArray = new Object[]{this.id, (channel2 = this.backendChannel) == null ? null : channel2.id(), (channel2 = this.frontendChannel) == null ? null : ((channel = channel2.channel()) == null ? null : channel.id())};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @NotNull
    public final HttpProxyInterceptPipeline getInterceptPipeline() {
        HttpProxyInterceptPipeline httpProxyInterceptPipeline = this.interceptPipeline;
        if (httpProxyInterceptPipeline != null) {
            return httpProxyInterceptPipeline;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"interceptPipeline");
        return null;
    }

    public final void setInterceptPipeline(@NotNull HttpProxyInterceptPipeline httpProxyInterceptPipeline) {
        Intrinsics.checkNotNullParameter((Object)httpProxyInterceptPipeline, (String)"<set-?>");
        this.interceptPipeline = httpProxyInterceptPipeline;
    }

    public void channelRead(@NotNull ChannelHandlerContext cx, @NotNull Object msg) {
        ResourceCacheKey key;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)cx, (String)"cx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        numMessageRecv.incrementAndGet();
        this.counterMessageRecv.inc();
        InternalLogger internalLogger = this.tracer;
        if (internalLogger != null) {
            objectArray = new Object[]{numMessageRecv, msg.getClass(), this.getDisplay()};
            internalLogger.trace("Channel read #{} {} - {}", objectArray);
        }
        if (msg instanceof HttpRequest) {
            Object object;
            ResourceItem resource;
            if (this.status == 0) {
                RequestProto requestProto = ProtoUtil.INSTANCE.getRequestProto((HttpRequest)msg);
                if (requestProto == null) {
                    cx.channel().close();
                    return;
                }
                this.status = 1;
                this.host = requestProto.getHost();
                this.port = requestProto.getPort();
                if (StringsKt.equals((String)"CONNECT", (String)((HttpRequest)msg).method().name(), (boolean)true)) {
                    DefaultFullHttpResponse defaultFullHttpResponse;
                    String string;
                    this.status = 2;
                    String string2 = this.host;
                    if (string2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                        string = null;
                    } else {
                        string = string2;
                    }
                    if (this.server.isBanned(string)) {
                        String string3;
                        string2 = this.host;
                        if (string2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                            string3 = null;
                        } else {
                            string3 = string2;
                        }
                        this.log.debug("Host is banned | {}", (Object)string3);
                        defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.GONE);
                    } else {
                        defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, ProxyServer.Companion.getSUCCESS());
                    }
                    DefaultFullHttpResponse response = defaultFullHttpResponse;
                    cx.writeAndFlush((Object)response);
                    cx.channel().pipeline().remove("httpCodec");
                    ReferenceCountUtil.release((Object)msg);
                    return;
                }
            }
            if ((key = this.server.getNotModifiedResources().get(((HttpRequest)msg).getUri())) != null && (resource = this.server.getResourceCache().get(key)) != null) {
                String string;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = Strings.readableBytes((long)key.getLength());
                objectArray2[1] = resource.getNotModifiedCount();
                String string4 = this.host;
                if (string4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                    string = null;
                } else {
                    string = string4;
                }
                objectArray2[2] = "https://" + string + ":" + this.port + key.getUri();
                this.log.info("Resource is not modified {} {} | {}", objectArray2);
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
                cx.writeAndFlush((Object)response);
                cx.channel().pipeline().remove("httpCodec");
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            this.setInterceptPipeline(this.buildInterceptPipeline());
            HttpProxyInterceptPipeline httpProxyInterceptPipeline = this.getInterceptPipeline();
            objectArray = this.host;
            if (objectArray == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                object = null;
            } else {
                object = objectArray;
            }
            httpProxyInterceptPipeline.setRequestProto(new RequestProto((String)object, this.port, this.isSsl));
            objectArray = ((HttpRequest)msg).getUri();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"msg.uri");
            if (!StringsKt.startsWith$default((String)objectArray, (String)"/", (boolean)false, (int)2, null)) {
                ((HttpRequest)msg).setUri(new URL(((HttpRequest)msg).getUri()).getFile());
            }
            HttpProxyInterceptPipeline httpProxyInterceptPipeline2 = this.getInterceptPipeline();
            objectArray = cx.channel();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"cx.channel()");
            httpProxyInterceptPipeline2.beforeRequest((Channel)objectArray, (HttpRequest)msg);
        } else if (msg instanceof HttpContent) {
            if (this.status != 2) {
                HttpProxyInterceptPipeline httpProxyInterceptPipeline = this.getInterceptPipeline();
                key = cx.channel();
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"cx.channel()");
                httpProxyInterceptPipeline.beforeRequest((Channel)key, (HttpContent)msg);
            } else {
                ReferenceCountUtil.release((Object)msg);
                this.status = 1;
            }
        } else {
            ByteBuf byteBuf;
            if (this.server.getHandleSsl() && (byteBuf = (ByteBuf)msg).getByte(0) == 22) {
                this.handleSslHandshake(cx, msg);
                return;
            }
            if (!(msg instanceof ByteBuf)) {
                this.log.warn("Unexpected msg type: " + msg.getClass());
            }
            internalLogger = cx.channel();
            Intrinsics.checkNotNullExpressionValue((Object)internalLogger, (String)"cx.channel()");
            this.forwardData((Channel)internalLogger, msg, false);
        }
    }

    public void channelRegistered(@NotNull ChannelHandlerContext cx) {
        Intrinsics.checkNotNullParameter((Object)cx, (String)"cx");
        super.channelRegistered(cx);
        this.backendChannel = cx.channel();
    }

    public void channelUnregistered(@NotNull ChannelHandlerContext cx) {
        Channel channel;
        Intrinsics.checkNotNullParameter((Object)cx, (String)"cx");
        ChannelFuture channelFuture = this.frontendChannel;
        if (channelFuture != null && (channel = channelFuture.channel()) != null) {
            channel.close();
        }
        cx.channel().close();
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext cx, @NotNull Throwable cause) {
        Channel channel;
        Intrinsics.checkNotNullParameter((Object)cx, (String)"cx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        ExceptionHandler exceptionHandler = this.server.getExceptionHandle();
        Channel channel2 = cx.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel2, (String)"cx.channel()");
        exceptionHandler.beforeCatch(channel2, cause);
        channel2 = this.frontendChannel;
        if (channel2 != null && (channel = channel2.channel()) != null) {
            channel.close();
        }
        cx.channel().close();
    }

    private final void handleSslHandshake(ChannelHandlerContext cx, Object msg) {
        String string;
        this.isSsl = true;
        SocketAddress socketAddress = cx.channel().localAddress();
        if (socketAddress == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        int port = ((InetSocketAddress)socketAddress).getPort();
        PrivateKey privateKey = this.server.getServerPriKey();
        X509Certificate[] x509CertificateArray = new X509Certificate[1];
        String string2 = this.host;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"host");
            string = null;
        } else {
            string = string2;
        }
        x509CertificateArray[0] = CertPool.INSTANCE.getCert(port, string, this.server);
        SslContext sslContext = SslContextBuilder.forServer((PrivateKey)privateKey, (X509Certificate[])x509CertificateArray).build();
        cx.pipeline().addFirst("httpCodec", (ChannelHandler)new HttpServerCodec());
        cx.pipeline().addFirst("sslHandle", (ChannelHandler)sslContext.newHandler(cx.alloc()));
        cx.pipeline().fireChannelRead(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void forwardData(Channel backendChannel, Object msg, boolean isHttp) {
        this.backendChannel = backendChannel;
        numMessageSent.incrementAndGet();
        this.counterMessageSent.inc();
        if (this.frontendChannel != null) {
            LinkedList<Object> linkedList = this.requestBuffer;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (linkedList) {
                boolean bl3 = false;
                ChannelFuture fc = this.frontendChannel;
                if (fc != null) {
                    if (this.isConnected) {
                        InternalLogger internalLogger = this.tracer;
                        if (internalLogger != null) {
                            String string;
                            String string2 = this.host;
                            if (string2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                                string = null;
                            } else {
                                string = string2;
                            }
                            internalLogger.trace("Send message #" + numMessageSent + " to " + string + ":" + this.port + " - " + this.getDisplay());
                        }
                        fc.channel().writeAndFlush(msg);
                    } else {
                        this.requestBuffer.add(msg);
                        this.log.debug("Channel is not ready, request cached ({}) - {}", (Object)this.requestBuffer.size(), (Object)this.getDisplay());
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            return;
        }
        if (isHttp && !(msg instanceof HttpRequest)) {
            this.log.warn("Unexpected HttpRequest message");
            return;
        }
        this.createFrontendBootstrap(backendChannel, msg, isHttp);
    }

    private final ChannelFuture createFrontendBootstrap(Channel backendChannel, Object msg, boolean isHttp) {
        ChannelFuture channel;
        ProxyEntry proxyEntry;
        RequestProto proto = null;
        if (!isHttp) {
            String string;
            Object object = this.host;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                string = null;
            } else {
                string = object;
            }
            proto = new RequestProto(string, this.port, this.isSsl);
            if (this.server.getTunnelIntercept() != null && (object = this.server.getTunnelIntercept()) != null) {
                object.handle(proto);
            }
        } else {
            proto = this.getInterceptPipeline().getRequestProto();
            HttpRequest httpRequest = (HttpRequest)msg;
            RequestProto newRP = ProtoUtil.INSTANCE.getRequestProto(httpRequest);
            if (newRP != null && !Intrinsics.areEqual((Object)newRP, (Object)proto)) {
                boolean defaultPort = proto.getSsl() && proto.getPort() == 443 || !proto.getSsl() && proto.getPort() == 80;
                String hostPort = defaultPort ? proto.getHost() : proto.getHost() + ":" + proto.getPort();
                httpRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)hostPort);
            }
        }
        ProxyHandler proxyHandler = (proxyEntry = this.server.getProxyEntry()) == null ? null : ProxyHandlerFactory.INSTANCE.build(proxyEntry);
        ChannelInitializer frontendChannelInitializer = isHttp ? (ChannelInitializer)new FrontendHttpChannelInitializer(this.server, backendChannel, proto, this.server.getTrafficCounter(), proxyHandler) : (ChannelInitializer)new FrontendTunnelInitializer(backendChannel, this.server.getTrafficCounter(), proxyHandler);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.server.getFrontendGroup())).channel(NioSocketChannel.class)).handler((ChannelHandler)frontendChannelInitializer);
        if (proxyEntry != null) {
            bootstrap.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
        }
        this.frontendChannel = channel = bootstrap.connect(proto.getHost(), proto.getPort());
        channel.addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> ProxyServerHandler.createFrontendBootstrap$lambda-6(this, msg, backendChannel, isHttp, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel");
        return channel;
    }

    private final HttpProxyInterceptPipeline buildInterceptPipeline() {
        HttpProxyIntercept proxyIntercept2 = new HttpProxyIntercept(this){
            final /* synthetic */ ProxyServerHandler this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeRequest(@NotNull Channel backendChannel, @NotNull HttpRequest httpRequest, @NotNull HttpProxyInterceptPipeline pipeline) {
                Intrinsics.checkNotNullParameter((Object)backendChannel, (String)"backendChannel");
                Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
                Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
                ProxyServerHandler.access$forwardData(this.this$0, backendChannel, httpRequest, true);
            }

            public void beforeRequest(@NotNull Channel backendChannel, @NotNull HttpContent httpContent, @NotNull HttpProxyInterceptPipeline pipeline) {
                Intrinsics.checkNotNullParameter((Object)backendChannel, (String)"backendChannel");
                Intrinsics.checkNotNullParameter((Object)httpContent, (String)"httpContent");
                Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
                ProxyServerHandler.access$forwardData(this.this$0, backendChannel, httpContent, true);
            }

            public void afterResponse(@NotNull Channel backendChannel, @NotNull Channel frontendChannel, @NotNull HttpResponse httpResponse, @NotNull HttpProxyInterceptPipeline pipeline) {
                Intrinsics.checkNotNullParameter((Object)backendChannel, (String)"backendChannel");
                Intrinsics.checkNotNullParameter((Object)frontendChannel, (String)"frontendChannel");
                Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
                Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
                backendChannel.writeAndFlush((Object)httpResponse);
                if (Intrinsics.areEqual((Object)HttpHeaderValues.WEBSOCKET.toString(), (Object)httpResponse.headers().get((CharSequence)HttpHeaderNames.UPGRADE))) {
                    frontendChannel.pipeline().remove("httpCodec");
                    backendChannel.pipeline().remove("httpCodec");
                }
            }

            public void afterResponse(@NotNull Channel backendChannel, @NotNull Channel frontendChannel, @NotNull HttpContent httpContent, @NotNull HttpProxyInterceptPipeline pipeline) {
                Intrinsics.checkNotNullParameter((Object)backendChannel, (String)"backendChannel");
                Intrinsics.checkNotNullParameter((Object)frontendChannel, (String)"frontendChannel");
                Intrinsics.checkNotNullParameter((Object)httpContent, (String)"httpContent");
                Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
                backendChannel.writeAndFlush((Object)httpContent);
            }
        };
        HttpProxyInterceptPipeline httpProxyInterceptPipeline = new HttpProxyInterceptPipeline(proxyIntercept2);
        boolean bl = false;
        boolean bl2 = false;
        HttpProxyInterceptPipeline it = httpProxyInterceptPipeline;
        boolean bl3 = false;
        this.getServer().getInterceptInitializer().init(it);
        return httpProxyInterceptPipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createFrontendBootstrap$lambda-6(ProxyServerHandler this$0, Object $msg, Channel $backendChannel, boolean $isHttp, ChannelFuture fcFuture) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
        Intrinsics.checkNotNullParameter((Object)$backendChannel, (String)"$backendChannel");
        Intrinsics.checkNotNullParameter((Object)fcFuture, (String)"fcFuture");
        boolean bl = Intrinsics.areEqual((Object)this$0.frontendChannel, (Object)fcFuture);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (fcFuture.isSuccess()) {
            Object object = this$0.tracer;
            if (object != null) {
                String string;
                String string2 = this$0.host;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                    string = null;
                } else {
                    string = string2;
                }
                String string3 = "http";
                bl4 = false;
                boolean bl6 = false;
                String string4 = string3;
                String string5 = "Frontend bootstrap is connected to <" + string + ":" + this$0.port + "> ({}) - " + this$0.getDisplay();
                InternalLogger internalLogger = object;
                boolean bl7 = false;
                boolean bl8 = $isHttp;
                string2 = bl8 ? string3 : null;
                internalLogger.trace(string5, (Object)(string2 == null ? "not http" : string2));
            }
            if ((object = this$0.tracer) != null) {
                Object[] objectArray;
                Object[] objectArray2 = this$0.host;
                if (objectArray2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"host");
                    objectArray = null;
                } else {
                    objectArray = objectArray2;
                }
                objectArray2 = new Object[]{numMessageSent.incrementAndGet(), this$0.requestBuffer.size(), $msg.getClass().getSimpleName()};
                object.trace("Sending message #{} plus {} cached to " + (String)objectArray + ":" + this$0.port + " ({}) - " + this$0.getDisplay(), objectArray2);
            }
            fcFuture.channel().writeAndFlush($msg);
            object = this$0.requestBuffer;
            bl2 = false;
            boolean bl9 = false;
            synchronized (object) {
                boolean bl10 = false;
                Collection collection = this$0.requestBuffer;
                boolean it = false;
                if (!collection.isEmpty()) {
                    Iterable $this$forEach$iv = this$0.requestBuffer;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv;
                        Object it2 = element$iv = iterator.next();
                        boolean bl11 = false;
                        fcFuture.channel().writeAndFlush(it2);
                    }
                    this$0.requestBuffer.clear();
                }
                this$0.isConnected = true;
                this$0.getServer().getState().set(ProxyServer.State.ONLINE);
                Unit unit = Unit.INSTANCE;
            }
        } else {
            Iterable $this$forEach$iv = this$0.requestBuffer;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl12 = false;
                ReferenceCountUtil.release(it);
            }
            this$0.requestBuffer.clear();
            fcFuture.channel().close();
            $backendChannel.close();
        }
    }

    public static final /* synthetic */ void access$forwardData(ProxyServerHandler $this, Channel backendChannel, Object msg, boolean isHttp) {
        $this.forwardData(backendChannel, msg, isHttp);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/proxy/server/ProxyServerHandler$Companion;", "", "()V", "numMessageRecv", "Ljava/util/concurrent/atomic/AtomicInteger;", "numMessageSent", "sequencer", "scent-proxy"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

