
// delete, annotate and confirm cells as a labeled sample for ML

let scentServer = 'http://localhost:8182/api/annotate/batch'
let authToken = 'b06test42c13cb000f74539b20be9550b8a1a90b9'
let exampleData = {
    "authToken": authToken,
    "annotations": [
        {
            "vi": "461 400 400 500", "label": "Title", "url": "https://www.amazon.com/HUAWEI-P60-Pro-MNA-LX9-Unlocked/dp/B0C1GZL24G/"
        },
        {
            "vi": "561 500 500 1000", "label": "Title", "url": "https://www.amazon.com/dp/B0C1H26C46"
        }
    ]
}

let heldKey;
let ctrlKey;

/**
 * @param annotation Object
 * */
function submitAnnotation(annotation) {
    submitAnnotations([annotation])
}

/**
 * @param annotations Array
 * */
function submitAnnotations(annotations) {
    fetch(scentServer, {
        method: "POST",
        body: JSON.stringify({ authToken: authToken, annotations: annotations }),
        headers: {
            "Content-type": "application/json; charset=UTF-8"
        }
    });
}

/**
 * @param ele Element The root element
 * @param name String The field name
 * @return Element|null
 * */
function queryHiddenInputElement(ele, name) {
    let hidden = ele.querySelector(`hidden[name=${name}]`)
    if (!hidden) {
        hidden = ele.querySelector(`input[name=${name}]`)
    }
    return hidden
}

/**
 * @param ele Element The element
 * @param newColor String The new color to set
 * */
function setColor(ele, newColor) {
    ele.classList.remove('darkred')
    ele.classList.remove('green')
    ele.classList.remove('lightgrey')

    ele.classList.add(newColor)
}

/**
 * @param td Element The table data
 * */
function initializeTableData(td) {
    let tr = td.parentElement
    let tbody = tr.parentElement
    let table = tbody.parentElement
    // can be null if the column is ID
    let j = td.getAttribute("j")
    let column = table.querySelector(`thead tr th[j="${j}"] span.label`)
    if (!column) {
        return
    }

    let columnLabel = column.textContent
    let label = td.getAttribute("label")

    if (columnLabel && !label) {
        td.classList.add("disabled")
    } else if (label) {
        if (label === columnLabel) {
            td.classList.add("green")
        } else {
            td.classList.add("disabled")
            td.classList.add("darkgray")
        }
    }

    td.addEventListener("dblclick", function(ev) {
        let lastDisabled = td.classList.contains('disabled')
        td.classList.toggle("disabled")

        let label = td.getAttribute("label")
        let labelDeleted = td.getAttribute("label_deleted")
        let vi = td.getAttribute('vi')
        let url = queryHiddenInputElement(tr, "url").value
        if (url && vi) {
            if (ev.ctrlKey && columnLabel) {
                submitAnnotation({'url': url, 'vi': vi, 'label': columnLabel})
                setColor(td, 'green')
            } else if (!lastDisabled) {
                // TODO: consider new field in json - 'action': 'delete'
                submitAnnotation({'url': url, 'vi': vi, 'label': 'delete_' + label})
                if (label) {
                    td.setAttribute("label_deleted", label)
                }
                td.removeAttribute("label")
                td.classList.remove('green')
            }
        }
    });
}

/**
 * @param input Element
 * @param table Element
 * @param j number
 * @param ev Event
 * */
function handleLabelTextInputBlur(input, table, j, ev) {
    let annotations = []

    let columnElements = table.querySelectorAll(`tbody tr td[j="${j}"]`)
    columnElements.forEach(function (td) {
        if (!td.classList.contains('disabled')) {
            td.classList.remove('green')
            td.classList.add('darkred')
        }
    })

    columnElements.forEach(function (td) {
        let vi = td.getAttribute('vi')
        let tr = td.parentElement
        let url = queryHiddenInputElement(tr, "url").value
        if (!vi || !url) {
            return
        }

        let label
        if (ctrlKey || !td.classList.contains('disabled')) {
            label = input.value
        } else {
            label = "delete_" + input.value
        }

        annotations.push({'vi': vi, 'url': url, 'label': label})
    })

    submitAnnotations(annotations)

    columnElements.forEach(function (td) {
        if (ctrlKey) {
            td.classList.remove('disabled')
        }

        if (!td.classList.contains('disabled')) {
            setColor(td, 'green')
        }
    })
}

window.addEventListener("DOMContentLoaded", function() {
    // on document loaded
    document.addEventListener("keydown", function (ev) {
        heldKey = ev.key
        ctrlKey = ev.ctrlKey
    })
    document.addEventListener("keyup", function (ev) {
        heldKey = undefined
        ctrlKey = undefined
    })

    let ths = document.querySelectorAll("table.table thead tr.label th, table.table thead tr.label td")
    ths.forEach(function(th, key, list) {
        th.addEventListener("dblclick", function(ev) {
            let table = th.parentElement.parentElement.parentElement
            let j = th.getAttribute("j")

            let text = th.querySelector(".label").textContent
            let input = queryHiddenInputElement(th, "name")
            if (!input) {
                th.setAttribute("name", text)
                th.innerHTML = `<input name="name" value='${text}' />`
                input = queryHiddenInputElement(th, "name")

                input.addEventListener("blur", function (ev) {
                    handleLabelTextInputBlur(input, table, j, ev)
                })
            }

            input = queryHiddenInputElement(th, "name")
            input.classList.add("green")
        });
    });

    let tds = document.querySelectorAll("table.table tbody td");
    tds.forEach(function(td) {
        initializeTableData(td)
    });
});
