/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.skeleton.crawl.ai;

import ai.platon.pulsar.common.ai.api.ModelResponse;
import ai.platon.pulsar.common.ai.api.ResponseState;
import ai.platon.pulsar.common.ai.api.TokenUsage;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.dom.FeaturedDocument;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.zhipu.ZhipuAiChatModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/platon/pulsar/skeleton/crawl/ai/ChatModel;", "", "apiKey", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Ljava/lang/String;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "chatModel", "Ldev/langchain4j/model/zhipu/ZhipuAiChatModel;", "call", "Lai/platon/pulsar/common/ai/api/ModelResponse;", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "prompt", "context", "ele", "Lorg/jsoup/nodes/Element;", "scent-rest"})
public final class ChatModel {
    @NotNull
    private final String apiKey;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final ZhipuAiChatModel chatModel;

    public ChatModel(@NotNull String apiKey, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.apiKey = apiKey;
        this.conf = conf;
        ZhipuAiChatModel zhipuAiChatModel = ZhipuAiChatModel.builder().apiKey(this.apiKey).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).maxRetries(Integer.valueOf(1)).build();
        Intrinsics.checkNotNullExpressionValue((Object)zhipuAiChatModel, (String)"build(...)");
        this.chatModel = zhipuAiChatModel;
    }

    @NotNull
    public final ModelResponse call(@NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return this.call("", prompt);
    }

    @NotNull
    public final ModelResponse call(@NotNull String context, @NotNull String prompt) {
        ResponseState responseState;
        FinishReason r;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        String prompt1 = !StringsKt.isBlank((CharSequence)context) ? prompt + "\n\n" + context : prompt;
        UserMessage message = UserMessage.userMessage((String)prompt1);
        ChatMessage[] chatMessageArray = new ChatMessage[]{message};
        Response response = this.chatModel.generate(chatMessageArray);
        dev.langchain4j.model.output.TokenUsage u = response.tokenUsage();
        Integer n = u.inputTokenCount();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"inputTokenCount(...)");
        int n2 = ((Number)n).intValue();
        Integer n3 = u.outputTokenCount();
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"outputTokenCount(...)");
        int n4 = ((Number)n3).intValue();
        Integer n5 = u.totalTokenCount();
        Intrinsics.checkNotNullExpressionValue((Object)n5, (String)"totalTokenCount(...)");
        TokenUsage tokenUsage = new TokenUsage(n2, n4, ((Number)n5).intValue());
        FinishReason finishReason = r = response.finishReason();
        switch (finishReason == null ? -1 : WhenMappings.$EnumSwitchMapping$0[finishReason.ordinal()]) {
            case 1: {
                responseState = ResponseState.STOP;
                break;
            }
            case 2: {
                responseState = ResponseState.LENGTH;
                break;
            }
            case 3: {
                responseState = ResponseState.TOOL_EXECUTION;
                break;
            }
            case 4: {
                responseState = ResponseState.CONTENT_FILTER;
                break;
            }
            default: {
                responseState = ResponseState.OTHER;
            }
        }
        ResponseState state = responseState;
        String string = ((AiMessage)response.content()).text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        return new ModelResponse(string, state, tokenUsage);
    }

    @NotNull
    public final ModelResponse call(@NotNull FeaturedDocument document2, @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return this.call((Element)document2.getDocument(), prompt);
    }

    @NotNull
    public final ModelResponse call(@NotNull Element ele, @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        String string = ele.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
        String text = string;
        return this.call(text, prompt);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FinishReason.values().length];
            try {
                nArray[FinishReason.STOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FinishReason.LENGTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FinishReason.TOOL_EXECUTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FinishReason.CONTENT_FILTER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

