/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api;

import ai.platon.commons.distributed.lock.mongo.configuration.EnableMongoDistributedLock;
import ai.platon.pulsar.common.collect.ExternalUrlLoader;
import ai.platon.pulsar.common.collect.UrlFeederHelper;
import ai.platon.pulsar.common.collect.collector.UrlCacheCollector;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.skeleton.common.metrics.MetricFilters;
import ai.platon.pulsar.skeleton.crawl.ai.ChatModel;
import ai.platon.scent.boot.autoconfigure.common.ScrapeTaskHandler;
import ai.platon.scent.boot.autoconfigure.component.CrawlSeedV3Loader;
import ai.platon.scent.boot.autoconfigure.component.ScentCrawlLoop;
import ai.platon.scent.boot.autoconfigure.component.ScrapeTaskV1Handler;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableMongoDistributedLock
@ComponentScan(value={"ai.platon.scent.boot.autoconfigure", "ai.platon.scent.boot.autoconfigure.component"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\b\u0010\u0017\u001a\u00020\u0018H\u0017J\b\u0010\u0019\u001a\u00020\u001aH\u0017J\b\u0010\u001b\u001a\u00020\u001aH\u0017J\b\u0010\u001c\u001a\u00020\u001dH\u0017R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lai/platon/scent/rest/api/ScentApiConfiguration;", "", "urlLoader", "Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "crawlLoop", "Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "taskV1Handler", "Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/collect/ExternalUrlLoader;Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getCrawlLoop", "()Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "getTaskV1Handler", "()Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;", "getUrlLoader", "()Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "chatModel", "Lai/platon/pulsar/skeleton/crawl/ai/ChatModel;", "apiKey", "", "getRestTemplate", "Lorg/springframework/web/client/RestTemplate;", "initCrawlSeedLoader", "", "initializeDataCollectors", "metricsModule", "Lcom/fasterxml/jackson/databind/Module;", "scent-rest"})
public class ScentApiConfiguration {
    @NotNull
    private final ExternalUrlLoader urlLoader;
    @NotNull
    private final ScentCrawlLoop crawlLoop;
    @NotNull
    private final ScrapeTaskV1Handler taskV1Handler;
    @NotNull
    private final ImmutableConfig conf;

    public ScentApiConfiguration(@NotNull ExternalUrlLoader urlLoader, @NotNull ScentCrawlLoop crawlLoop, @NotNull ScrapeTaskV1Handler taskV1Handler, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)urlLoader, (String)"urlLoader");
        Intrinsics.checkNotNullParameter((Object)crawlLoop, (String)"crawlLoop");
        Intrinsics.checkNotNullParameter((Object)taskV1Handler, (String)"taskV1Handler");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.urlLoader = urlLoader;
        this.crawlLoop = crawlLoop;
        this.taskV1Handler = taskV1Handler;
        this.conf = conf;
    }

    @NotNull
    public ExternalUrlLoader getUrlLoader() {
        return this.urlLoader;
    }

    @NotNull
    public ScentCrawlLoop getCrawlLoop() {
        return this.crawlLoop;
    }

    @NotNull
    public ScrapeTaskV1Handler getTaskV1Handler() {
        return this.taskV1Handler;
    }

    @NotNull
    public ImmutableConfig getConf() {
        return this.conf;
    }

    @Bean
    public void initCrawlSeedLoader() {
        ExternalUrlLoader externalUrlLoader = this.getUrlLoader();
        CrawlSeedV3Loader crawlSeedV3Loader = externalUrlLoader instanceof CrawlSeedV3Loader ? (CrawlSeedV3Loader)externalUrlLoader : null;
        if (crawlSeedV3Loader != null) {
            crawlSeedV3Loader.setTaskV1Handler(this.getTaskV1Handler());
        }
    }

    @Bean
    @NotNull
    public Module metricsModule() {
        MetricFilter filter = MetricFilters.INSTANCE.notContains("._.");
        return (Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false, filter);
    }

    @Bean
    @NotNull
    public RestTemplate getRestTemplate() {
        return new RestTemplate();
    }

    @Bean
    public void initializeDataCollectors() {
        UrlCacheCollector urlCacheCollector;
        UrlFeederHelper urlFeederHelper = new UrlFeederHelper(this.getCrawlLoop().getUrlFeeder());
        UrlCacheCollector it = urlCacheCollector = urlFeederHelper.create("SCRAPE", ScrapeTaskHandler.Companion.getDEFAULT_TASK_PRIORITY().getValue(), this.getUrlLoader());
        boolean bl = false;
        it.getLabels().add("SCRAPE");
    }

    @Bean
    @ConditionalOnProperty(value={"EXTERNAL_AI_API_KEY"})
    @NotNull
    public ChatModel chatModel(@Value(value="$EXTERNAL_AI_API_KEY") @NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return new ChatModel(apiKey, this.getConf());
    }
}

