/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller;

import ai.platon.scent.boot.autoconfigure.persist.HarvestTaskStatusRepository;
import ai.platon.scent.rest.api.common.Requests;
import ai.platon.scent.rest.api.controller.ControllerBase;
import ai.platon.scent.rest.api.serialize.HarvestRequest;
import ai.platon.scent.rest.api.serialize.HarvestResponse;
import ai.platon.scent.rest.api.serialize.HarvestStatusRequest;
import ai.platon.scent.rest.api.service.HarvestService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"xx/a"}, consumes={"application/json"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u001c\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u00122\b\b\u0001\u0010\u001a\u001a\u00020\u0012H\u0017R\u001e\u0010\u0007\u001a\u00020\b8\u0016@\u0016X\u0097.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lai/platon/scent/rest/api/controller/AsyncHarvestController;", "Lai/platon/scent/rest/api/controller/ControllerBase;", "httpSession", "Ljavax/servlet/http/HttpSession;", "taskRepository", "Lai/platon/scent/boot/autoconfigure/persist/HarvestTaskStatusRepository;", "(Ljavax/servlet/http/HttpSession;Lai/platon/scent/boot/autoconfigure/persist/HarvestTaskStatusRepository;)V", "harvestService", "Lai/platon/scent/rest/api/service/HarvestService;", "getHarvestService", "()Lai/platon/scent/rest/api/service/HarvestService;", "setHarvestService", "(Lai/platon/scent/rest/api/service/HarvestService;)V", "log", "Lorg/slf4j/Logger;", "getTaskRepository", "()Lai/platon/scent/boot/autoconfigure/persist/HarvestTaskStatusRepository;", "harvest", "", "request", "Lai/platon/scent/rest/api/serialize/HarvestRequest;", "httpRequest", "Ljavax/servlet/http/HttpServletRequest;", "status", "Lai/platon/scent/rest/api/serialize/HarvestResponse;", "id", "authToken", "scent-rest"})
public class AsyncHarvestController
extends ControllerBase {
    @NotNull
    private final HarvestTaskStatusRepository taskRepository;
    @NotNull
    private final Logger log;
    @Autowired
    public HarvestService harvestService;

    public AsyncHarvestController(@NotNull HttpSession httpSession, @NotNull HarvestTaskStatusRepository taskRepository) {
        Intrinsics.checkNotNullParameter((Object)httpSession, (String)"httpSession");
        Intrinsics.checkNotNullParameter((Object)taskRepository, (String)"taskRepository");
        super(httpSession);
        this.taskRepository = taskRepository;
        Logger logger = LoggerFactory.getLogger(AsyncHarvestController.class);
        Intrinsics.checkNotNull((Object)logger);
        this.log = logger;
    }

    @NotNull
    public HarvestTaskStatusRepository getTaskRepository() {
        return this.taskRepository;
    }

    @NotNull
    public HarvestService getHarvestService() {
        HarvestService harvestService = this.harvestService;
        if (harvestService != null) {
            return harvestService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"harvestService");
        return null;
    }

    public void setHarvestService(@NotNull HarvestService harvestService) {
        Intrinsics.checkNotNullParameter((Object)harvestService, (String)"<set-?>");
        this.harvestService = harvestService;
    }

    @PostMapping(value={"q"})
    @NotNull
    public String harvest(@RequestBody @NotNull HarvestRequest request, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        request.setRemoteAddr(Requests.INSTANCE.getRemoteIP(httpRequest));
        return this.getHarvestService().submit(request);
    }

    @GetMapping(value={"status"}, consumes={"*/*"})
    @NotNull
    public HarvestResponse status(@RequestParam(value="id") @NotNull String id, @RequestParam @NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        HarvestStatusRequest request = new HarvestStatusRequest(authToken, id);
        return this.getHarvestService().getStatus(request);
    }
}

