/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller;

import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.model.FieldGroup;
import ai.platon.pulsar.persist.model.PageModel;
import ai.platon.scent.mongo.v1.ScrapeTaskHistory;
import ai.platon.scent.rest.api.serialize.W3DocumentRequest;
import ai.platon.scent.rest.api.service.LoadService;
import ai.platon.scent.rest.api.service.scrape.TaskHistoryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"w3doc"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J2\u0010\u000f\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011\u0018\u00010\u00102\b\b\u0001\u0010\u0012\u001a\u00020\f2\b\b\u0001\u0010\u0013\u001a\u00020\fH\u0017J&\u0010\u0014\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00110\u00102\b\b\u0001\u0010\u0013\u001a\u00020\fH\u0017J\u0012\u0010\u0015\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lai/platon/scent/rest/api/controller/W3DocController;", "", "loadService", "Lai/platon/scent/rest/api/service/LoadService;", "taskHistoryService", "Lai/platon/scent/rest/api/service/scrape/TaskHistoryService;", "(Lai/platon/scent/rest/api/service/LoadService;Lai/platon/scent/rest/api/service/scrape/TaskHistoryService;)V", "getLoadService", "()Lai/platon/scent/rest/api/service/LoadService;", "getTaskHistoryService", "()Lai/platon/scent/rest/api/service/scrape/TaskHistoryService;", "get", "", "request", "Lai/platon/scent/rest/api/serialize/W3DocumentRequest;", "getModel", "", "", "authToken", "url", "getModels", "query", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nW3DocController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 W3DocController.kt\nai/platon/scent/rest/api/controller/W3DocController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1#2:59\n1549#3:60\n1620#3,3:61\n1549#3:64\n1620#3,3:65\n*S KotlinDebug\n*F\n+ 1 W3DocController.kt\nai/platon/scent/rest/api/controller/W3DocController\n*L\n45#1:60\n45#1:61,3\n55#1:64\n55#1:65,3\n*E\n"})
public class W3DocController {
    @NotNull
    private final LoadService loadService;
    @NotNull
    private final TaskHistoryService taskHistoryService;

    public W3DocController(@NotNull LoadService loadService, @NotNull TaskHistoryService taskHistoryService) {
        Intrinsics.checkNotNullParameter((Object)loadService, (String)"loadService");
        Intrinsics.checkNotNullParameter((Object)taskHistoryService, (String)"taskHistoryService");
        this.loadService = loadService;
        this.taskHistoryService = taskHistoryService;
    }

    @NotNull
    public LoadService getLoadService() {
        return this.loadService;
    }

    @NotNull
    public TaskHistoryService getTaskHistoryService() {
        return this.taskHistoryService;
    }

    @GetMapping
    @NotNull
    public String get(@NotNull W3DocumentRequest request) {
        String string;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        FeaturedDocument document2 = this.getLoadService().loadDocument(request);
        String it = string3 = request.getFragmentCss();
        boolean bl = false;
        CharSequence charSequence = it;
        String string4 = string2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string3 : null;
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            string = document2.selectFirstOrNull(it);
            if (string == null || (string = string.outerHtml()) == null) {
                string = "";
            }
        } else {
            string = null;
        }
        String string5 = string;
        return string5 == null ? document2.getPrettyHtml() : string5;
    }

    @PostMapping(value={"query"})
    @NotNull
    public String query(@RequestBody @NotNull W3DocumentRequest request) {
        String string;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        FeaturedDocument document2 = this.getLoadService().loadDocument(request);
        String it = string3 = request.getFragmentCss();
        boolean bl = false;
        CharSequence charSequence = it;
        String string4 = string2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string3 : null;
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            string = document2.selectFirstOrNull(it);
            if (string == null || (string = string.outerHtml()) == null) {
                string = "";
            }
        } else {
            string = null;
        }
        String string5 = string;
        return string5 == null ? document2.getPrettyHtml() : string5;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"model"})
    @Nullable
    public List<Map<String, Object>> getModel(@RequestParam @NotNull String authToken, @RequestParam @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        PageModel model = this.getLoadService().load(url).getPageModel();
        if (model != null && model.isNotEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = model.getBoxedFieldGroups();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FieldGroup fieldGroup = (FieldGroup)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFieldsCopy());
            }
            return (List)destination$iv$iv;
        }
        ScrapeTaskHistory history = this.getTaskHistoryService().findTopByUrl(authToken, url);
        ScrapeTaskHistory scrapeTaskHistory = history;
        return scrapeTaskHistory != null && (scrapeTaskHistory = scrapeTaskHistory.getIdentifiedTask()) != null && (scrapeTaskHistory = scrapeTaskHistory.getDetail()) != null ? scrapeTaskHistory.getResultSet() : null;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"models"})
    @NotNull
    public List<Map<String, String>> getModels(@RequestParam @NotNull String url) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        PageModel pageModel = this.getLoadService().load(url).getPageModel();
        if (pageModel == null) {
            return CollectionsKt.emptyList();
        }
        PageModel model = pageModel;
        Iterable $this$map$iv = model.getBoxedFieldGroups();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FieldGroup fieldGroup = (FieldGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFieldsCopy());
        }
        return (List)destination$iv$iv;
    }
}

