/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.admin;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.entities.User;
import ai.platon.scent.entities.UserDashboard;
import ai.platon.scent.entities.UserDashboardHistory;
import ai.platon.scent.rest.api.common.AuthGuard;
import ai.platon.scent.rest.api.service.DashboardService;
import ai.platon.scent.rest.api.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"admin/users"}, consumes={"application/json"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J$\u0010\u0018\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lai/platon/scent/rest/api/controller/admin/AdminUserController;", "", "userService", "Lai/platon/scent/rest/api/service/UserService;", "dashboardService", "Lai/platon/scent/rest/api/service/DashboardService;", "(Lai/platon/scent/rest/api/service/UserService;Lai/platon/scent/rest/api/service/DashboardService;)V", "getDashboardService", "()Lai/platon/scent/rest/api/service/DashboardService;", "logger", "Lorg/slf4j/Logger;", "getUserService", "()Lai/platon/scent/rest/api/service/UserService;", "edit", "Lai/platon/scent/entities/User;", "authToken", "", "user", "httpRequest", "Ljavax/servlet/http/HttpServletRequest;", "list", "", "Lai/platon/scent/entities/UserDashboard;", "listDashboards", "update", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nAdminUserController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdminUserController.kt\nai/platon/scent/rest/api/controller/admin/AdminUserController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1549#2:77\n1620#2,3:78\n1549#2:81\n1620#2,3:82\n*S KotlinDebug\n*F\n+ 1 AdminUserController.kt\nai/platon/scent/rest/api/controller/admin/AdminUserController\n*L\n36#1:77\n36#1:78,3\n73#1:81\n73#1:82,3\n*E\n"})
public class AdminUserController {
    @NotNull
    private final UserService userService;
    @NotNull
    private final DashboardService dashboardService;
    @NotNull
    private final Logger logger;

    public AdminUserController(@NotNull UserService userService, @NotNull DashboardService dashboardService) {
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)dashboardService, (String)"dashboardService");
        this.userService = userService;
        this.dashboardService = dashboardService;
        this.logger = LogsKt.getLogger(AdminUserController.class);
    }

    @NotNull
    public UserService getUserService() {
        return this.userService;
    }

    @NotNull
    public DashboardService getDashboardService() {
        return this.dashboardService;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(consumes={"*/*"})
    @NotNull
    public List<UserDashboard> list(@RequestParam @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, httpRequest.getRemoteAddr(), true);
        List list = this.getDashboardService().findAll(authToken, 0, 100).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserDashboardHistory userDashboardHistory = (UserDashboardHistory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new UserDashboard((UserDashboardHistory)it));
        }
        return (List)destination$iv$iv;
    }

    @GetMapping(value={"edit/{id}"})
    @NotNull
    public User edit(@RequestParam @NotNull String authToken, @RequestBody @NotNull User user, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, httpRequest.getRemoteAddr(), true);
        return this.getUserService().save(user);
    }

    @PutMapping(value={"update"})
    @NotNull
    public User update(@RequestParam @NotNull String authToken, @RequestBody @NotNull User user, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, httpRequest.getRemoteAddr(), true);
        return this.getUserService().save(user);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"dashboards"}, consumes={"*/*"})
    @ExperimentalTime
    @NotNull
    public List<UserDashboard> listDashboards(@RequestParam @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, httpRequest.getRemoteAddr(), true);
        List list = this.getDashboardService().findAll(0, 100).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserDashboardHistory userDashboardHistory = (UserDashboardHistory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new UserDashboard((UserDashboardHistory)it));
        }
        return (List)destination$iv$iv;
    }
}

