/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service;

import ai.platon.pulsar.common.concurrent.ConcurrentExpiringLRUCache;
import ai.platon.scent.boot.autoconfigure.persist.UserDashboardHistoryRepository;
import ai.platon.scent.boot.autoconfigure.persist.UserRepository;
import ai.platon.scent.entities.ScrapeSummaryHistory;
import ai.platon.scent.entities.User;
import ai.platon.scent.entities.UserDashboardHistory;
import ai.platon.scent.mongo.v1.ScrapeTaskMonthlyHistory;
import ai.platon.scent.rest.api.service.scrape.ScrapeTaskServiceBase;
import ai.platon.scent.rest.api.service.scrape.SummaryQuery;
import ai.platon.scent.rest.api.service.scrape.Task48HourHistoryService;
import ai.platon.scent.rest.api.service.scrape.TaskMonthlyHistoryService;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.DateOperators;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaExtensionsKt;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0017J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u000fH\u0017J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lai/platon/scent/rest/api/service/DashboardService;", "", "userRepository", "Lai/platon/scent/boot/autoconfigure/persist/UserRepository;", "dashboardHistoryRepository", "Lai/platon/scent/boot/autoconfigure/persist/UserDashboardHistoryRepository;", "a48HourHistoryService", "Lai/platon/scent/rest/api/service/scrape/Task48HourHistoryService;", "monthlyHistoryService", "Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "(Lai/platon/scent/boot/autoconfigure/persist/UserRepository;Lai/platon/scent/boot/autoconfigure/persist/UserDashboardHistoryRepository;Lai/platon/scent/rest/api/service/scrape/Task48HourHistoryService;Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;Lorg/springframework/data/mongodb/core/MongoTemplate;)V", "dashboardCache", "Lai/platon/pulsar/common/concurrent/ConcurrentExpiringLRUCache;", "", "Lai/platon/scent/entities/UserDashboardHistory;", "aggregateExperimental", "Lorg/springframework/data/mongodb/core/aggregation/AggregationResults;", "Lai/platon/scent/mongo/v1/ScrapeTaskMonthlyHistory;", "authToken", "createdAt", "Ljava/time/Instant;", "create", "summaryExpires", "Ljava/time/Duration;", "createIfAbsent", "findAll", "Lorg/springframework/data/domain/Page;", "page", "", "limit", "findLatest", "Companion", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nDashboardService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DashboardService.kt\nai/platon/scent/rest/api/service/DashboardService\n+ 2 ScrapeTaskServiceBase.kt\nai/platon/scent/rest/api/service/scrape/ScrapeTaskServiceBase\n*L\n1#1,101:1\n254#2,17:102\n*S KotlinDebug\n*F\n+ 1 DashboardService.kt\nai/platon/scent/rest/api/service/DashboardService\n*L\n98#1:102,17\n*E\n"})
public class DashboardService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserRepository userRepository;
    @NotNull
    private final UserDashboardHistoryRepository dashboardHistoryRepository;
    @NotNull
    private final Task48HourHistoryService a48HourHistoryService;
    @NotNull
    private final TaskMonthlyHistoryService monthlyHistoryService;
    @NotNull
    private final MongoTemplate mongoTemplate;
    @NotNull
    private final ConcurrentExpiringLRUCache<String, UserDashboardHistory> dashboardCache;
    private static final Duration dashboardCacheTTL = Duration.ofMinutes(1L);
    private static final Duration dashboardTTL = Duration.ofMinutes(10L);

    public DashboardService(@NotNull UserRepository userRepository, @NotNull UserDashboardHistoryRepository dashboardHistoryRepository, @NotNull Task48HourHistoryService a48HourHistoryService, @NotNull TaskMonthlyHistoryService monthlyHistoryService, @NotNull MongoTemplate mongoTemplate) {
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        Intrinsics.checkNotNullParameter((Object)dashboardHistoryRepository, (String)"dashboardHistoryRepository");
        Intrinsics.checkNotNullParameter((Object)a48HourHistoryService, (String)"a48HourHistoryService");
        Intrinsics.checkNotNullParameter((Object)monthlyHistoryService, (String)"monthlyHistoryService");
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        this.userRepository = userRepository;
        this.dashboardHistoryRepository = dashboardHistoryRepository;
        this.a48HourHistoryService = a48HourHistoryService;
        this.monthlyHistoryService = monthlyHistoryService;
        this.mongoTemplate = mongoTemplate;
        Duration duration = dashboardCacheTTL;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"dashboardCacheTTL");
        this.dashboardCache = new ConcurrentExpiringLRUCache(duration, 10000);
    }

    @ExperimentalTime
    @Nullable
    public UserDashboardHistory createIfAbsent(@NotNull String authToken) {
        UserDashboardHistory dashboard;
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        UserDashboardHistory userDashboardHistory = (UserDashboardHistory)this.dashboardCache.getDatum((Object)authToken);
        if (userDashboardHistory == null) {
            userDashboardHistory = this.findLatest(authToken);
        }
        if ((dashboard = userDashboardHistory) == null || dashboard.getCreatedAt().plus(dashboardTTL).compareTo(Instant.now()) < 0) {
            dashboard = DashboardService.create$default(this, authToken, null, 2, null);
        }
        ConcurrentExpiringLRUCache.putDatum$default(this.dashboardCache, (Object)authToken, (Object)dashboard, (long)0L, (int)4, null);
        return dashboard;
    }

    @Nullable
    public UserDashboardHistory findLatest(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.dashboardHistoryRepository.findTopByAuthTokenOrderByCreatedAtDesc(authToken).orElse(null);
    }

    @NotNull
    public Page<UserDashboardHistory> findAll(@NotNull String authToken, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        String[] stringArray = new String[]{"createdAt"};
        Sort sort = Sort.by((String[])stringArray).descending();
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"descending(...)");
        Sort order = sort;
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)order);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageRequest2 = pageRequest;
        return this.dashboardHistoryRepository.findAllByAuthToken(authToken, pageRequest2);
    }

    @NotNull
    public Page<UserDashboardHistory> findAll(int page, int limit) {
        String[] stringArray = new String[]{"createdAt"};
        Sort sort = Sort.by((String[])stringArray).descending();
        Intrinsics.checkNotNullExpressionValue((Object)sort, (String)"descending(...)");
        Sort order = sort;
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)order);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageRequest2 = pageRequest;
        Page page2 = this.dashboardHistoryRepository.findAll((Pageable)pageRequest2);
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"findAll(...)");
        return page2;
    }

    @ExperimentalTime
    @NotNull
    public UserDashboardHistory create(@NotNull String authToken, @NotNull Duration summaryExpires) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)summaryExpires, (String)"summaryExpires");
        LocalDateTime now = LocalDateTime.now();
        User user = (User)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.userRepository), (Object)authToken);
        LocalDateTime localDateTime = now.minusMonths(2L);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"minusMonths(...)");
        Intrinsics.checkNotNull((Object)now);
        SummaryQuery query = new SummaryQuery(authToken, localDateTime, now, summaryExpires, null, 16, null);
        List<ScrapeSummaryHistory> monthlySummary = this.monthlyHistoryService.monthlySummaries(query);
        LocalDateTime localDateTime2 = now.minusDays(2L);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"minusDays(...)");
        query = new SummaryQuery(authToken, localDateTime2, now, summaryExpires, null, 16, null);
        List<ScrapeSummaryHistory> dailySummary = this.a48HourHistoryService.dailySummaries(query);
        LocalDateTime localDateTime3 = now.minusHours(12L);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"minusHours(...)");
        query = new SummaryQuery(authToken, localDateTime3, now, summaryExpires, null, 16, null);
        List<ScrapeSummaryHistory> hourlySummary = this.a48HourHistoryService.hourlySummaries(query);
        UserDashboardHistory dashboard = new UserDashboardHistory(authToken, user, monthlySummary, dailySummary, hourlySummary, null, null, null, 224, null);
        this.dashboardHistoryRepository.save((Object)dashboard);
        ConcurrentExpiringLRUCache.putDatum$default(this.dashboardCache, (Object)authToken, (Object)dashboard, (long)0L, (int)4, null);
        return dashboard;
    }

    public static /* synthetic */ UserDashboardHistory create$default(DashboardService dashboardService, String string, Duration duration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 2) != 0) {
            Duration duration2 = ScrapeTaskServiceBase.Companion.getSummaryCacheTTL();
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"<get-summaryCacheTTL>(...)");
            duration = duration2;
        }
        return dashboardService.create(string, duration);
    }

    @NotNull
    public AggregationResults<ScrapeTaskMonthlyHistory> aggregateExperimental(@NotNull String authToken, @NotNull Instant createdAt) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        ScrapeTaskServiceBase this_$iv = this.monthlyHistoryService;
        boolean $i$f$hourlySummary = false;
        Criteria criteria = CriteriaExtensionsKt.isEqualTo((Criteria)new Criteria("authToken"), (Object)authToken).and("createdAt").gte((Object)createdAt);
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"gte(...)");
        Criteria criteria$iv = criteria;
        MatchOperation matchOperation = Aggregation.match((Criteria)criteria$iv);
        Intrinsics.checkNotNullExpressionValue((Object)matchOperation, (String)"match(...)");
        MatchOperation matchStage$iv = matchOperation;
        ProjectionOperation projectionOperation = Aggregation.project((String[])new String[0]).and((AggregationExpression)DateOperators.Year.year((Object)"$createdAt")).as("year").and((AggregationExpression)DateOperators.DayOfMonth.dayOfMonth((String)"$createdAt")).as("dayOfMonth").and((AggregationExpression)DateOperators.Hour.hour((Object)"$createdAt")).as("hour");
        Intrinsics.checkNotNullExpressionValue((Object)projectionOperation, (String)"as(...)");
        ProjectionOperation projectStage$iv = projectionOperation;
        String[] stringArray = new String[]{"year", "dayOfMonth", "hour"};
        GroupOperation groupOperation = Aggregation.group((String[])stringArray).addToSet("year").as("year").addToSet("dayOfMonth").as("dayOfMonth").addToSet("hour").as("hour").count().as("count");
        Intrinsics.checkNotNullExpressionValue((Object)groupOperation, (String)"as(...)");
        GroupOperation countStage$iv = groupOperation;
        AggregationOperation[] aggregationOperationArray = new AggregationOperation[]{matchStage$iv, projectStage$iv, countStage$iv};
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])aggregationOperationArray);
        Intrinsics.checkNotNullExpressionValue((Object)aggregation, (String)"newAggregation(...)");
        Aggregation aggregation$iv = aggregation;
        AggregationResults aggregationResults = this_$iv.getMongoTemplate().aggregate(aggregation$iv, this_$iv.getCollectionName(), ScrapeTaskMonthlyHistory.class);
        Intrinsics.checkNotNullExpressionValue((Object)aggregationResults, (String)"aggregate(...)");
        return aggregationResults;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lai/platon/scent/rest/api/service/DashboardService$Companion;", "", "()V", "dashboardCacheTTL", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getDashboardCacheTTL", "()Ljava/time/Duration;", "dashboardTTL", "getDashboardTTL", "scent-rest"})
    public static final class Companion {
        private Companion() {
        }

        public final Duration getDashboardCacheTTL() {
            return dashboardCacheTTL;
        }

        public final Duration getDashboardTTL() {
            return dashboardTTL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

