/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service.scrape;

import ai.platon.pulsar.common.JvmTimedValue;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.boot.autoconfigure.persist.ScrapeSummaryHistoryRepository;
import ai.platon.scent.boot.autoconfigure.persist.ScrapeTaskMonthlyHistoryRepository;
import ai.platon.scent.common.ClusterTools;
import ai.platon.scent.mongo.v1.ScrapeTaskMonthlyHistory;
import ai.platon.scent.rest.api.service.scrape.ScrapeTaskServiceBase;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.CriteriaExtensionsKt;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J \u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J \u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J \u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0011H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0013H\u0016J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020%2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u001aH\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u000bH\u0016J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020 2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"H\u0016J&\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020 2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0016J.\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020 2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010.\u001a\u00020\u0011H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;", "Lai/platon/scent/rest/api/service/scrape/ScrapeTaskServiceBase;", "Lai/platon/scent/mongo/v1/ScrapeTaskMonthlyHistory;", "repository", "Lai/platon/scent/boot/autoconfigure/persist/ScrapeTaskMonthlyHistoryRepository;", "summaryRepository", "Lai/platon/scent/boot/autoconfigure/persist/ScrapeSummaryHistoryRepository;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "(Lai/platon/scent/boot/autoconfigure/persist/ScrapeTaskMonthlyHistoryRepository;Lai/platon/scent/boot/autoconfigure/persist/ScrapeSummaryHistoryRepository;Lorg/springframework/data/mongodb/core/MongoTemplate;)V", "collectionName", "", "getCollectionName", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "aggregateHourly", "", "count", "", "authToken", "startTime", "Ljava/time/Instant;", "endTime", "countByStatusCode", "statusCode", "", "countFinished", "countPending", "countSuccess", "deleteAllOld", "download", "Lorg/springframework/data/domain/Page;", "pageable", "Lorg/springframework/data/domain/Pageable;", "estimatedCount", "fetch", "", "offset", "limit", "find", "id", "findAll", "findAllByStatusCode", "findAllByStatusCodeAndCreatedAtAfter", "createdAt", "maintainDb", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nTaskMonthlyHistoryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskMonthlyHistoryService.kt\nai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 DateTimes.kt\nai/platon/pulsar/common/DateTimesKt\n*L\n1#1,155:1\n1855#2,2:156\n15#3,4:158\n*S KotlinDebug\n*F\n+ 1 TaskMonthlyHistoryService.kt\nai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService\n*L\n71#1:156,2\n138#1:158,4\n*E\n"})
public class TaskMonthlyHistoryService
extends ScrapeTaskServiceBase<ScrapeTaskMonthlyHistory> {
    @NotNull
    private final ScrapeTaskMonthlyHistoryRepository repository;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String collectionName;

    public TaskMonthlyHistoryService(@NotNull ScrapeTaskMonthlyHistoryRepository repository, @NotNull ScrapeSummaryHistoryRepository summaryRepository, @NotNull MongoTemplate mongoTemplate) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)summaryRepository, (String)"summaryRepository");
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        super(summaryRepository, mongoTemplate);
        this.repository = repository;
        this.logger = LogsKt.getLogger((Object)this);
        String string = mongoTemplate.getCollectionName(ScrapeTaskMonthlyHistory.class);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCollectionName(...)");
        this.collectionName = string;
    }

    @Override
    @NotNull
    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    @Nullable
    public ScrapeTaskMonthlyHistory find(@NotNull String authToken, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.repository.findById((Object)id).filter(arg_0 -> TaskMonthlyHistoryService.find$lambda$0((Function1)new Function1<ScrapeTaskMonthlyHistory, Boolean>(authToken){
            final /* synthetic */ String $authToken;
            {
                this.$authToken = $authToken;
                super(1);
            }

            @NotNull
            public final Boolean invoke(ScrapeTaskMonthlyHistory it) {
                return Intrinsics.areEqual((Object)it.getAuthToken(), (Object)this.$authToken);
            }
        }, arg_0)).orElse(null);
    }

    @Override
    @NotNull
    public Page<ScrapeTaskMonthlyHistory> findAll(@NotNull String authToken, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.repository.findAllByAuthToken(authToken, pageable);
    }

    @Override
    @NotNull
    public Page<ScrapeTaskMonthlyHistory> findAllByStatusCode(@NotNull String authToken, int statusCode, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.repository.findAllByAuthTokenAndTaskStatusCode(authToken, statusCode, pageable);
    }

    @Override
    @NotNull
    public Page<ScrapeTaskMonthlyHistory> findAllByStatusCodeAndCreatedAtAfter(@NotNull String authToken, int statusCode, @NotNull Instant createdAt, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)createdAt, (String)"createdAt");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        return this.repository.findAllByAuthTokenAndTaskStatusCodeAndCreatedAtAfter(authToken, statusCode, createdAt, pageable);
    }

    @NotNull
    public List<ScrapeTaskMonthlyHistory> fetch(@NotNull String authToken, long offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Criteria criteria = Criteria.where((String)"authToken");
        Intrinsics.checkNotNullExpressionValue((Object)criteria, (String)"where(...)");
        Criteria criteria2 = CriteriaExtensionsKt.isEqualTo((Criteria)criteria, (Object)authToken);
        Query query = new Query().addCriteria((CriteriaDefinition)criteria2).skip(offset).limit(limit);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"limit(...)");
        Query query2 = query;
        List list = this.getMongoTemplate().find(query2, ScrapeTaskMonthlyHistory.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"find(...)");
        return list;
    }

    @NotNull
    public Page<ScrapeTaskMonthlyHistory> download(@NotNull String authToken, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Object[] objectArray = new Integer[]{201, 102};
        List excludeStatusCodes = CollectionsKt.listOf((Object[])objectArray);
        Page result = this.repository.findAllByAuthTokenAndTaskStatusCodeNotIn(authToken, excludeStatusCodes, pageable);
        Iterable $this$forEach$iv = (Iterable)result;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScrapeTaskMonthlyHistory it = (ScrapeTaskMonthlyHistory)element$iv;
            boolean bl = false;
            it.setDownloadCount(it.getDownloadCount() + 1);
            it.getDownloadCount();
        }
        this.repository.saveAll((Iterable)result.getContent());
        return result;
    }

    @Override
    public long estimatedCount() {
        return this.getMongoTemplate().estimatedCount(ScrapeTaskMonthlyHistory.class);
    }

    @Override
    public long count(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.repository.countByAuthToken(authToken);
    }

    @Override
    public long count(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return this.repository.countByAuthTokenAndCreatedAtBetween(authToken, startTime, endTime);
    }

    @Override
    public long countPending(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.repository.countByAuthTokenAndTaskIsDone(authToken, false);
    }

    @Override
    public long countPending(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return this.repository.countByAuthTokenAndTaskIsDoneAndCreatedAtBetween(authToken, false, startTime, endTime);
    }

    @Override
    public long countFinished(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.repository.countByAuthTokenAndTaskIsDone(authToken, true);
    }

    @Override
    public long countFinished(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return this.repository.countByAuthTokenAndTaskIsDoneAndCreatedAtBetween(authToken, true, startTime, endTime);
    }

    @Override
    public long countSuccess(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.countByStatusCode(authToken, 200);
    }

    @Override
    public long countSuccess(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return this.repository.countByAuthTokenAndTaskStatusCodeAndCreatedAtBetween(authToken, 200, startTime, endTime);
    }

    @Override
    public long countByStatusCode(@NotNull String authToken, int statusCode) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        return this.repository.countByAuthTokenAndTaskStatusCode(authToken, statusCode);
    }

    public void aggregateHourly() {
        String sql = "select count(*) from ScrapeTaskMonthlyHistory group by truncatedTime, statusCode where createdAt > 2021-08-19T10:13:46.109Z";
    }

    @Override
    public void deleteAllOld() {
        Instant daysBefore = Instant.now().minus(Duration.ofDays(31L));
        boolean $i$f$measureTimedValueJvm = false;
        Instant startTime$iv = Instant.now();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)daysBefore);
        Long value$iv = this.repository.deleteAllByCreatedAtBefore(daysBefore);
        Duration elapsedTime$iv = Duration.between(startTime$iv, Instant.now());
        Intrinsics.checkNotNull((Object)elapsedTime$iv);
        JvmTimedValue timedCount = new JvmTimedValue((Object)value$iv, elapsedTime$iv);
        Object[] objectArray = new Object[]{timedCount.getValue(), daysBefore, timedCount.getDuration()};
        this.logger.info("Deleted {} records before {} from monthly history in {}", objectArray);
    }

    @Override
    public void maintainDb() {
        int dayOfMonth = LocalDate.now().getDayOfMonth();
        int mod = dayOfMonth % ClusterTools.INSTANCE.getCrawlerCount();
        if (ClusterTools.INSTANCE.getInstancePartition() == mod) {
            this.deleteAllOld();
        }
    }

    private static final boolean find$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

