/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service.scrape;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.boot.autoconfigure.persist.ScrapeTask48HourHistoryRepository;
import ai.platon.scent.boot.autoconfigure.persist.ScrapeTaskHistoryRepository;
import ai.platon.scent.boot.autoconfigure.persist.ScrapeTaskMonthlyHistoryRepository;
import ai.platon.scent.common.Saved;
import ai.platon.scent.mongo.v1.ScrapeTask;
import ai.platon.scent.mongo.v1.ScrapeTask48HourHistory;
import ai.platon.scent.mongo.v1.ScrapeTaskDetail;
import ai.platon.scent.mongo.v1.ScrapeTaskHistoriesKt;
import ai.platon.scent.mongo.v1.ScrapeTaskHistory;
import ai.platon.scent.mongo.v1.ScrapeTaskMonthlyHistory;
import ai.platon.scent.mongo.v1.ScrapeTaskMultiHistory;
import ai.platon.scent.rest.api.service.scrape.PriorityTaskQueueService;
import ai.platon.scent.rest.api.service.scrape.TaskMultiHistoryService;
import ai.platon.scent.rest.api.service.v1.ScrapeServiceV1;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001b\u001a\u00020\u001cH\u0017J \u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020\u001cH\u0016J&\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0017J\b\u0010'\u001a\u00020\u001cH\u0016J\u001c\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020&0)2\u0006\u0010*\u001a\u00020&H\u0016J\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020&0)2\u0006\u0010*\u001a\u00020&H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u000e\u0010\u0019\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService;", "", "a48HourHistoryRepository", "Lai/platon/scent/boot/autoconfigure/persist/ScrapeTask48HourHistoryRepository;", "monthlyTaskHistoryRepository", "Lai/platon/scent/boot/autoconfigure/persist/ScrapeTaskMonthlyHistoryRepository;", "taskHistoryRepository", "Lai/platon/scent/boot/autoconfigure/persist/ScrapeTaskHistoryRepository;", "queueService", "Lai/platon/scent/rest/api/service/scrape/PriorityTaskQueueService;", "mongoTemplate", "Lorg/springframework/data/mongodb/core/MongoTemplate;", "(Lai/platon/scent/boot/autoconfigure/persist/ScrapeTask48HourHistoryRepository;Lai/platon/scent/boot/autoconfigure/persist/ScrapeTaskMonthlyHistoryRepository;Lai/platon/scent/boot/autoconfigure/persist/ScrapeTaskHistoryRepository;Lai/platon/scent/rest/api/service/scrape/PriorityTaskQueueService;Lorg/springframework/data/mongodb/core/MongoTemplate;)V", "last48HourEstCount", "", "getLast48HourEstCount", "()J", "setLast48HourEstCount", "(J)V", "lastHistoryEstCount", "getLastHistoryEstCount", "setLastHistoryEstCount", "lastMonthlyEstCount", "getLastMonthlyEstCount", "setLastMonthlyEstCount", "logger", "Lorg/slf4j/Logger;", "collectDbStats", "", "countTasks", "authToken", "", "startTime", "Ljava/time/Instant;", "endTime", "deleteAll", "listTasks", "Lorg/springframework/data/domain/Page;", "Lai/platon/scent/mongo/v1/ScrapeTask;", "restoreUnfinishedTasks", "saveCascaded", "Lai/platon/scent/common/Saved;", "task", "saveCascaded0", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nTaskMultiHistoryService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskMultiHistoryService.kt\nai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1855#2,2:157\n1549#2:159\n1620#2,3:160\n*S KotlinDebug\n*F\n+ 1 TaskMultiHistoryService.kt\nai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService\n*L\n134#1:157,2\n137#1:159\n137#1:160,3\n*E\n"})
public class TaskMultiHistoryService {
    @NotNull
    private final ScrapeTask48HourHistoryRepository a48HourHistoryRepository;
    @NotNull
    private final ScrapeTaskMonthlyHistoryRepository monthlyTaskHistoryRepository;
    @NotNull
    private final ScrapeTaskHistoryRepository taskHistoryRepository;
    @NotNull
    private final PriorityTaskQueueService queueService;
    @NotNull
    private final MongoTemplate mongoTemplate;
    @NotNull
    private final Logger logger;
    private long last48HourEstCount;
    private long lastMonthlyEstCount;
    private long lastHistoryEstCount;

    public TaskMultiHistoryService(@NotNull ScrapeTask48HourHistoryRepository a48HourHistoryRepository, @NotNull ScrapeTaskMonthlyHistoryRepository monthlyTaskHistoryRepository, @NotNull ScrapeTaskHistoryRepository taskHistoryRepository, @NotNull PriorityTaskQueueService queueService, @NotNull MongoTemplate mongoTemplate) {
        Intrinsics.checkNotNullParameter((Object)a48HourHistoryRepository, (String)"a48HourHistoryRepository");
        Intrinsics.checkNotNullParameter((Object)monthlyTaskHistoryRepository, (String)"monthlyTaskHistoryRepository");
        Intrinsics.checkNotNullParameter((Object)taskHistoryRepository, (String)"taskHistoryRepository");
        Intrinsics.checkNotNullParameter((Object)queueService, (String)"queueService");
        Intrinsics.checkNotNullParameter((Object)mongoTemplate, (String)"mongoTemplate");
        this.a48HourHistoryRepository = a48HourHistoryRepository;
        this.monthlyTaskHistoryRepository = monthlyTaskHistoryRepository;
        this.taskHistoryRepository = taskHistoryRepository;
        this.queueService = queueService;
        this.mongoTemplate = mongoTemplate;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(ScrapeServiceV1.class));
    }

    public long getLast48HourEstCount() {
        return this.last48HourEstCount;
    }

    public void setLast48HourEstCount(long l) {
        this.last48HourEstCount = l;
    }

    public long getLastMonthlyEstCount() {
        return this.lastMonthlyEstCount;
    }

    public void setLastMonthlyEstCount(long l) {
        this.lastMonthlyEstCount = l;
    }

    public long getLastHistoryEstCount() {
        return this.lastHistoryEstCount;
    }

    public void setLastHistoryEstCount(long l) {
        this.lastHistoryEstCount = l;
    }

    public long countTasks(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Instant now = Instant.now();
        Duration duration = Duration.between(startTime, now);
        return duration.toHours() <= 48L ? this.a48HourHistoryRepository.countByAuthTokenAndCreatedAtBetween(authToken, startTime, endTime) : this.monthlyTaskHistoryRepository.countByAuthTokenAndCreatedAtBetween(authToken, startTime, endTime);
    }

    @ExperimentalTime
    @NotNull
    public Page<ScrapeTask> listTasks(@NotNull String authToken, @NotNull Instant startTime, @NotNull Instant endTime) {
        Page page;
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        PageRequest pageRequest = PageRequest.of((int)0, (int)500);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        PageRequest pageable = pageRequest;
        Instant now = Instant.now();
        Duration duration = Duration.between(startTime, now);
        if (duration.toHours() <= 48L) {
            Page page2 = this.a48HourHistoryRepository.findAllByAuthTokenAndCreatedAtBetween(authToken, startTime, endTime, (Pageable)pageable).map(arg_0 -> TaskMultiHistoryService.listTasks$lambda$0(listTasks.1.INSTANCE, arg_0));
            Intrinsics.checkNotNull((Object)page2);
            page = page2;
        } else {
            Page page3 = this.monthlyTaskHistoryRepository.findAllByAuthTokenAndCreatedAtBetween(authToken, startTime, endTime, (Pageable)pageable).map(arg_0 -> TaskMultiHistoryService.listTasks$lambda$1(listTasks.2.INSTANCE, arg_0));
            Intrinsics.checkNotNull((Object)page3);
            page = page3;
        }
        return page;
    }

    @NotNull
    public Saved<String, ScrapeTask> saveCascaded(@NotNull ScrapeTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        try {
            return this.saveCascaded0(task);
        }
        catch (MappingException e) {
            ScrapeTaskDetail scrapeTaskDetail = task.getDetail();
            if (scrapeTaskDetail != null) {
                scrapeTaskDetail.setResultSet(null);
            }
            return this.saveCascaded0(task);
        }
    }

    private Saved<String, ScrapeTask> saveCascaded0(ScrapeTask task) {
        ScrapeTaskMultiHistory history = ScrapeTaskHistoriesKt.createScrapeTaskHistory((ScrapeTask)task);
        this.a48HourHistoryRepository.save((Object)history.getA48HourHistory());
        if (history.getA48HourHistory().getId() == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (task.getId() != null && !Intrinsics.areEqual((Object)task.getId(), (Object)history.getA48HourHistory().getId())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String id = history.getA48HourHistory().getId();
        task.setId(id);
        history.getMonthlyHistory().setId(id);
        history.getHistory().setId(id);
        this.monthlyTaskHistoryRepository.save((Object)history.getMonthlyHistory());
        this.taskHistoryRepository.save((Object)history.getHistory());
        if (!Intrinsics.areEqual((Object)task.getId(), (Object)history.getMonthlyHistory().getId())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!Intrinsics.areEqual((Object)task.getId(), (Object)history.getHistory().getId())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = task.getId();
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return new Saved((Object)string, (Object)task);
    }

    @ExperimentalTime
    public void collectDbStats() {
        this.setLast48HourEstCount(this.mongoTemplate.estimatedCount(ScrapeTask48HourHistory.class));
        this.setLastMonthlyEstCount(this.mongoTemplate.estimatedCount(ScrapeTaskMonthlyHistory.class));
        this.setLastHistoryEstCount(this.mongoTemplate.estimatedCount(ScrapeTaskHistory.class));
    }

    /*
     * WARNING - void declaration
     */
    public void restoreUnfinishedTasks() {
        Page pageResult;
        Instant startTime = Instant.now();
        PageRequest pageRequest = PageRequest.of((int)0, (int)2000);
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        Pageable page = (Pageable)pageRequest;
        int recoveredCount = 0;
        do {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List historyTasks;
            if (!(pageResult = this.a48HourHistoryRepository.findAllByTaskIsDoneAndTaskStatusCodeNot(false, 201, page)).hasContent()) continue;
            Object[] objectArray = new Object[]{pageResult.getContent().size(), recoveredCount, pageResult.getTotalElements()};
            this.logger.info("Recovering {}/{}/{} unfinished tasks", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)pageResult.getContent(), (String)"getContent(...)");
            Iterable $this$forEach$iv = historyTasks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ScrapeTask48HourHistory it = (ScrapeTask48HourHistory)element$iv;
                boolean bl = false;
                it.getTask().setStatusCode(201);
            }
            this.a48HourHistoryRepository.saveAll((Iterable)historyTasks);
            $this$forEach$iv = historyTasks;
            PriorityTaskQueueService priorityTaskQueueService = this.queueService;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ScrapeTask48HourHistory scrapeTask48HourHistory = (ScrapeTask48HourHistory)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getIdentifiedTask());
            }
            priorityTaskQueueService.addAll((List)destination$iv$iv);
            recoveredCount += historyTasks.size();
            Intrinsics.checkNotNullExpressionValue((Object)page.next(), (String)"next(...)");
        } while (pageResult.hasContent());
        Intrinsics.checkNotNull((Object)startTime);
        Duration elapsedTime = DateTimes.elapsedTime$default((DateTimes)DateTimes.INSTANCE, (Instant)startTime, null, (int)2, null);
        this.logger.info("Recovered {} unfinished tasks in {}", (Object)recoveredCount, (Object)elapsedTime);
    }

    public void deleteAll() {
        this.a48HourHistoryRepository.deleteAll();
        this.monthlyTaskHistoryRepository.deleteAll();
        this.taskHistoryRepository.deleteAll();
    }

    private static final ScrapeTask listTasks$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ScrapeTask)$tmp0.invoke(p0);
    }

    private static final ScrapeTask listTasks$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ScrapeTask)$tmp0.invoke(p0);
    }
}

