/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.serialize.json.JacksonKt;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.scent.ScentSession;
import ai.platon.scent.common.ScentWebPageExtKt;
import ai.platon.scent.rest.api.serialize.AnnotateRequest;
import ai.platon.scent.rest.api.serialize.BatchAnnotateRequest;
import ai.platon.scent.rest.api.serialize.DOMAnnotation;
import ai.platon.scent.rest.api.service.AnnotationService;
import ai.platon.scent.rest.api.service.LoadService;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"annotate"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\u0012\u0010\u0012\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0013H\u0017J*\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\b\b\u0001\u0010\u0015\u001a\u00020\u000f2\b\b\u0001\u0010\u0016\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/platon/scent/rest/api/controller/DataAnnotationController;", "", "annotationService", "Lai/platon/scent/rest/api/service/AnnotationService;", "loadService", "Lai/platon/scent/rest/api/service/LoadService;", "environment", "Lorg/springframework/core/env/Environment;", "session", "Lai/platon/scent/ScentSession;", "(Lai/platon/scent/rest/api/service/AnnotationService;Lai/platon/scent/rest/api/service/LoadService;Lorg/springframework/core/env/Environment;Lai/platon/scent/ScentSession;)V", "logger", "Lorg/slf4j/Logger;", "annotate", "", "", "request", "Lai/platon/scent/rest/api/serialize/AnnotateRequest;", "annotateBatch", "Lai/platon/scent/rest/api/serialize/BatchAnnotateRequest;", "query", "authToken", "url", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nDataAnnotationController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataAnnotationController.kt\nai/platon/scent/rest/api/controller/DataAnnotationController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1179#2,2:51\n1253#2,4:53\n*S KotlinDebug\n*F\n+ 1 DataAnnotationController.kt\nai/platon/scent/rest/api/controller/DataAnnotationController\n*L\n40#1:51,2\n40#1:53,4\n*E\n"})
public class DataAnnotationController {
    @NotNull
    private final AnnotationService annotationService;
    @NotNull
    private final LoadService loadService;
    @NotNull
    private final Environment environment;
    @NotNull
    private final ScentSession session;
    @NotNull
    private final Logger logger;

    public DataAnnotationController(@NotNull AnnotationService annotationService, @NotNull LoadService loadService, @NotNull Environment environment, @NotNull ScentSession session) {
        Intrinsics.checkNotNullParameter((Object)annotationService, (String)"annotationService");
        Intrinsics.checkNotNullParameter((Object)loadService, (String)"loadService");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.annotationService = annotationService;
        this.loadService = loadService;
        this.environment = environment;
        this.session = session;
        this.logger = LogsKt.getLogger((Object)this);
    }

    @GetMapping(value={"query"})
    @NotNull
    public Map<String, String> query(@RequestParam @NotNull String authToken, @RequestParam @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String url0 = URLDecoder.decode(url, "UTF-8");
        Intrinsics.checkNotNull((Object)url0);
        Map map = ScentWebPageExtKt.getMlLabels((WebPage)this.session.get(url0));
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping
    @NotNull
    public Map<String, String> annotate(@RequestBody @NotNull AnnotateRequest request) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Iterable $this$associate$iv = request.getAnnotations();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            DOMAnnotation it = (DOMAnnotation)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getVi(), (Object)it.getLabel());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map annotations = destination$iv$iv;
        return this.annotationService.annotate(request.getUrl(), annotations);
    }

    @PostMapping(value={"batch"})
    @NotNull
    public String annotateBatch(@RequestBody @NotNull BatchAnnotateRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        AnnotationService.AnnotateStatus result = this.annotationService.annotateAll(request.getAnnotations());
        String string = JacksonKt.prettyPulsarObjectMapper().writeValueAsString((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }
}

