/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service;

import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.skeleton.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.skeleton.common.metrics.MetricsSystem;
import ai.platon.scent.boot.autoconfigure.persist.UserRepository;
import ai.platon.scent.common.jackson.ExtensionsKt;
import ai.platon.scent.crawl.serialize.ScrapeRequest;
import ai.platon.scent.crawl.serialize.ScrapeRequestV2;
import ai.platon.scent.entities.User;
import ai.platon.scent.entities.VisitCounter;
import ai.platon.scent.rest.api.common.NotAuthorizedException;
import ai.platon.scent.rest.api.common.VisitLimitException;
import com.codahale.metrics.Counter;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.CrudRepositoryExtensionsKt;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0012J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0012J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lai/platon/scent/rest/api/service/UserService;", "", "userRepository", "Lai/platon/scent/boot/autoconfigure/persist/UserRepository;", "(Lai/platon/scent/boot/autoconfigure/persist/UserRepository;)V", "metrics", "Lai/platon/scent/rest/api/service/UserService$Companion$Metrics;", "unlimitedTokens", "Ljava/util/SortedSet;", "", "unlimitedTokensV1", "", "unlimitedTokensV2", "checkAuth", "", "request", "Lai/platon/scent/crawl/serialize/ScrapeRequest;", "Lai/platon/scent/crawl/serialize/ScrapeRequestV2;", "user", "Lai/platon/scent/entities/User;", "authToken", "remoteAddr", "getUser", "id", "loadOrCreate", "resetVisitCountersIfNecessary", "save", "updateUserVisits", "Companion", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nUserService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserService.kt\nai/platon/scent/rest/api/service/UserService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n819#2:199\n847#2,2:200\n819#2:202\n847#2,2:203\n1#3:205\n*S KotlinDebug\n*F\n+ 1 UserService.kt\nai/platon/scent/rest/api/service/UserService\n*L\n39#1:199\n39#1:200,2\n42#1:202\n42#1:203,2\n*E\n"})
public class UserService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserRepository userRepository;
    @NotNull
    private final Companion.Metrics metrics;
    @NotNull
    private final List<String> unlimitedTokensV1;
    @NotNull
    private final List<String> unlimitedTokensV2;
    @NotNull
    private final SortedSet<String> unlimitedTokens;
    @NotNull
    public static final String USER_LOCK_ID = "vDkSr37rM7fvAPRJ";
    @NotNull
    public static final String STORE_ID = "distributeLock";

    public UserService(@NotNull UserRepository userRepository) {
        String it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        this.userRepository = userRepository;
        this.metrics = new Companion.Metrics();
        Iterable iterable = ResourceLoader.INSTANCE.readAllLines("auth/v1/unlimited-tokens.txt");
        UserService userService = this;
        boolean $i$f$filterNot = false;
        void var4_5 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)it) || StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        userService.unlimitedTokensV1 = (List)destination$iv$iv;
        $this$filterNot$iv = ResourceLoader.INSTANCE.readAllLines("auth/v2/unlimited-tokens.txt");
        userService = this;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)it) || StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        userService.unlimitedTokensV2 = (List)destination$iv$iv;
        this.unlimitedTokens = CollectionsKt.toSortedSet((Iterable)CollectionsKt.plus((Collection)this.unlimitedTokensV1, (Iterable)this.unlimitedTokensV2));
    }

    @NotNull
    public User getUser(@NotNull String id, @NotNull String remoteAddr) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)remoteAddr, (String)"remoteAddr");
        return this.loadOrCreate(id, remoteAddr);
    }

    public void checkAuth(@NotNull ScrapeRequest request) throws NotAuthorizedException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.checkAuth(request.getAuthToken(), request.getAuthToken());
    }

    public void checkAuth(@NotNull ScrapeRequestV2 request) throws NotAuthorizedException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.checkAuth(request.getAuthToken(), request.getAuthToken());
    }

    public void checkAuth(@Nullable String authToken, @Nullable String remoteAddr) throws VisitLimitException {
        if (authToken == null) {
            throw new IllegalArgumentException("Auth token is required");
        }
        if (remoteAddr == null) {
            return;
        }
        if (StringsKt.startsWith$default((String)remoteAddr, (String)"127", (boolean)false, (int)2, null)) {
            return;
        }
        String id = authToken;
        User user = this.loadOrCreate(id, remoteAddr);
        if (this.unlimitedTokens.contains(authToken)) {
            return;
        }
        this.checkAuth(user);
    }

    private User loadOrCreate(String id, String remoteAddr) {
        User user = (User)CrudRepositoryExtensionsKt.findByIdOrNull((CrudRepository)((CrudRepository)this.userRepository), (Object)id);
        if (user == null) {
            user = new User(id, remoteAddr, 0, null, null, null, 60, null);
            this.userRepository.save((Object)user);
        }
        return user;
    }

    public void checkAuth(@NotNull User user) throws VisitLimitException {
        boolean denied;
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        VisitCounter counter = user.getProfile().getVisitCounter();
        this.resetVisitCountersIfNecessary(user);
        int maxVisitsPMinutes = counter.getMaxVisitsPMinute();
        int maxVisitsPTenMinutes = counter.getMaxVisitsPTenMinutes();
        int maxVisitsPHour = counter.getMaxVisitsPHour();
        int maxVisitsPDay = counter.getMaxVisitsPDay();
        if (this.unlimitedTokens.contains(user.getId())) {
            maxVisitsPMinutes = Integer.MAX_VALUE;
            maxVisitsPTenMinutes = Integer.MAX_VALUE;
            maxVisitsPHour = Integer.MAX_VALUE;
            maxVisitsPDay = Integer.MAX_VALUE;
        }
        this.updateUserVisits(user);
        if (counter.getVisitsLastMinute() > maxVisitsPMinutes) {
            it = var8_7 = true;
            boolean bl = false;
            this.metrics.getBanned1Minute().inc();
            v0 = var8_7;
        } else if (counter.getVisitsLastTenMinutes() > maxVisitsPTenMinutes) {
            it = var8_7 = true;
            boolean bl = false;
            this.metrics.getBanned10Minute().inc();
            v0 = var8_7;
        } else if (counter.getVisitsLastHour() > maxVisitsPHour) {
            it = var8_7 = true;
            boolean bl = false;
            this.metrics.getBanned1Hour().inc();
            v0 = var8_7;
        } else if (counter.getVisitsLastDay() > maxVisitsPDay) {
            it = var8_7 = true;
            boolean bl = false;
            this.metrics.getBanned1Day().inc();
            v0 = var8_7;
        } else {
            v0 = denied = false;
        }
        if (denied) {
            this.metrics.getBanned().inc();
            String json = ExtensionsKt.prettyScentObjectWritter().writeValueAsString((Object)counter);
            throw new VisitLimitException("Blocked temporary, block rules: \n" + json, null, 2, null);
        }
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        counter.setModifiedAt(instant);
        this.userRepository.save((Object)user);
    }

    private void resetVisitCountersIfNecessary(User user) {
        VisitCounter counter = user.getProfile().getVisitCounter();
        Instant modifiedAt = counter.getModifiedAt();
        Duration idleTime = Duration.between(modifiedAt, Instant.now());
        boolean unblocked = false;
        if (idleTime.compareTo(Duration.ofDays(1L)) > 0) {
            counter.setVisitsLastDay(0);
            counter.setVisitsLastHour(0);
            counter.setVisitsLastTenMinutes(0);
            counter.setVisitsLastMinute(0);
            unblocked = true;
        } else if (idleTime.compareTo(Duration.ofHours(1L)) > 0) {
            counter.setVisitsLastHour(0);
            counter.setVisitsLastTenMinutes(0);
            counter.setVisitsLastMinute(0);
            unblocked = true;
        } else if (idleTime.compareTo(Duration.ofMinutes(10L)) > 0) {
            counter.setVisitsLastTenMinutes(0);
            counter.setVisitsLastMinute(0);
            unblocked = true;
        } else if (idleTime.compareTo(Duration.ofMinutes(1L)) > 0) {
            counter.setVisitsLastMinute(0);
            unblocked = true;
        }
        if (unblocked) {
            user.getProfile().setDeniedAt(null);
        }
    }

    private void updateUserVisits(User user) {
        VisitCounter counter = user.getProfile().getVisitCounter();
        counter.setVisitsLastMinute(counter.getVisitsLastMinute() + 1);
        counter.getVisitsLastMinute();
        counter.setVisitsLastTenMinutes(counter.getVisitsLastTenMinutes() + 1);
        counter.getVisitsLastTenMinutes();
        counter.setVisitsLastHour(counter.getVisitsLastHour() + 1);
        counter.getVisitsLastHour();
        counter.setVisitsLastDay(counter.getVisitsLastDay() + 1);
        counter.getVisitsLastDay();
    }

    @NotNull
    public User save(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Object object = this.userRepository.save((Object)user);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        return (User)object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/rest/api/service/UserService$Companion;", "", "()V", "STORE_ID", "", "USER_LOCK_ID", "Metrics", "scent-rest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/platon/scent/rest/api/service/UserService$Companion$Metrics;", "", "()V", "banned", "Lcom/codahale/metrics/Counter;", "getBanned", "()Lcom/codahale/metrics/Counter;", "banned10Minute", "getBanned10Minute", "banned1Day", "getBanned1Day", "banned1Hour", "getBanned1Hour", "banned1Minute", "getBanned1Minute", "registry", "Lai/platon/pulsar/skeleton/common/metrics/AppMetricRegistry;", "scent-rest"})
        public static final class Metrics {
            @NotNull
            private final AppMetricRegistry registry = MetricsSystem.Companion.getDefaultMetricRegistry();
            @NotNull
            private final Counter banned = this.registry.counter((Object)this, "banned");
            @NotNull
            private final Counter banned1Minute = this.registry.counter((Object)this, "banned1Minute");
            @NotNull
            private final Counter banned10Minute = this.registry.counter((Object)this, "banned10Minute");
            @NotNull
            private final Counter banned1Hour = this.registry.counter((Object)this, "banned1Hour");
            @NotNull
            private final Counter banned1Day = this.registry.counter((Object)this, "banned1Day");

            @NotNull
            public final Counter getBanned() {
                return this.banned;
            }

            @NotNull
            public final Counter getBanned1Minute() {
                return this.banned1Minute;
            }

            @NotNull
            public final Counter getBanned10Minute() {
                return this.banned10Minute;
            }

            @NotNull
            public final Counter getBanned1Hour() {
                return this.banned1Hour;
            }

            @NotNull
            public final Counter getBanned1Day() {
                return this.banned1Day;
            }
        }
    }
}

