/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller;

import ai.platon.scent.crawl.serialize.ScrapeRequestV2;
import ai.platon.scent.crawl.serialize.ScrapeResponseV2;
import ai.platon.scent.crawl.serialize.ScrapeStatusRequest;
import ai.platon.scent.rest.api.common.AuthGuard;
import ai.platon.scent.rest.api.common.Requests;
import ai.platon.scent.rest.api.service.UserService;
import ai.platon.scent.rest.api.service.v2.ScrapeServiceV2;
import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"api/x/a/v2"}, consumes={"application/json"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u001a\u0010\u0016\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lai/platon/scent/rest/api/controller/AsyncScrapeControllerVS2;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "scrapeService", "Lai/platon/scent/rest/api/service/v2/ScrapeServiceV2;", "userService", "Lai/platon/scent/rest/api/service/UserService;", "(Lorg/springframework/context/ApplicationContext;Lai/platon/scent/rest/api/service/v2/ScrapeServiceV2;Lai/platon/scent/rest/api/service/UserService;)V", "getApplicationContext", "()Lorg/springframework/context/ApplicationContext;", "getScrapeService", "()Lai/platon/scent/rest/api/service/v2/ScrapeServiceV2;", "getUserService", "()Lai/platon/scent/rest/api/service/UserService;", "getStatus", "Lai/platon/scent/crawl/serialize/ScrapeResponseV2;", "id", "", "authToken", "httpRequest", "Ljakarta/servlet/http/HttpServletRequest;", "submit", "request", "Lai/platon/scent/crawl/serialize/ScrapeRequestV2;", "scent-rest"})
public class AsyncScrapeControllerVS2 {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final ScrapeServiceV2 scrapeService;
    @NotNull
    private final UserService userService;

    public AsyncScrapeControllerVS2(@NotNull ApplicationContext applicationContext, @NotNull ScrapeServiceV2 scrapeService, @NotNull UserService userService) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)((Object)scrapeService), (String)"scrapeService");
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        this.applicationContext = applicationContext;
        this.scrapeService = scrapeService;
        this.userService = userService;
    }

    @NotNull
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @NotNull
    public ScrapeServiceV2 getScrapeService() {
        return this.scrapeService;
    }

    @NotNull
    public UserService getUserService() {
        return this.userService;
    }

    @PostMapping(value={"q"})
    @NotNull
    public String submit(@RequestBody @NotNull ScrapeRequestV2 request, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        request.setRemoteAddr(Requests.INSTANCE.getRemoteIP(httpRequest));
        new AuthGuard(request.getAuthToken(), null, false, 6, null);
        this.getUserService().checkAuth(request.getAuthToken(), request.getRemoteAddr());
        return this.getScrapeService().submit(request);
    }

    @GetMapping(value={"status"}, consumes={"*/*"})
    @NotNull
    public ScrapeResponseV2 getStatus(@RequestParam @NotNull String id, @RequestParam @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        ScrapeStatusRequest request = new ScrapeStatusRequest(authToken, id, 0, 4, null);
        new AuthGuard(request.getAuthToken(), null, false, 6, null);
        return this.getScrapeService().getStatus(request);
    }
}

