/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x;

import ai.platon.pulsar.common.LinkExtractors;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.ChatServiceV30x;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.ConversationServiceV30x;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"api/command-revisions"}, consumes={"*/*"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/CommandRevisionControllerV30x;", "", "chatService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ChatServiceV30x;", "conversationService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x;", "(Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ChatServiceV30x;Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x;)V", "create", "", "prompt", "scent-rest"})
public class CommandRevisionControllerV30x {
    @NotNull
    private final ChatServiceV30x chatService;
    @NotNull
    private final ConversationServiceV30x conversationService;

    public CommandRevisionControllerV30x(@NotNull ChatServiceV30x chatService, @NotNull ConversationServiceV30x conversationService) {
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)conversationService, (String)"conversationService");
        this.chatService = chatService;
        this.conversationService = conversationService;
    }

    @PostMapping(produces={"text/plain"})
    @NotNull
    public String create(@RequestBody @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Set urls = LinkExtractors.fromText((String)prompt);
        if (urls.isEmpty()) {
            urls = SetsKt.setOf((Object)"http://example.com");
        }
        String string = this.conversationService.convertPlainCommandToJSON(prompt, (String)CollectionsKt.first((Iterable)urls));
        if (string == null) {
            return prompt;
        }
        String json = string;
        String message = StringsKt.replace$default((String)"\n    Your task is to convert a JSON command into simple, numbered steps in plain language.\n\nThe JSON format looks like this:\n```json\n\n{\n  \"url\": \"{PLACEHOLDER_URL}\",\n  \"pageSummaryPrompt\": \"Instructions for summarizing the page...\",\n  \"dataExtractionRules\": \"Instructions for extracting specific fields...\",\n  \"linkExtractionRules\": \"https://.+\",\n  \"onPageReadyActions\": [\n    \"scroll down\",\n    \"click 'Sign In' button\"\n  ]\n}\n\n```\n\nGuidelines:\n- Start with \"Visit [url]\"\n- Convert each action in \"onPageReadyActions\" to a separate step\n- Add steps for summarizing, data extraction, and link collection if specified\n- Use clear, concise numbered instructions\n\nExample:\n1. Visit https://example.com\n2. Scroll down \n3. Click the \"Sign In\" button\n4. Summarize the page content\n5. Extract product name, price, ratings\n6. Collect all product links\n\nJSON to convert:\n```json\n{PLACEHOLDER_JSON_VALUE}\n```\n\n", (String)"{PLACEHOLDER_JSON_VALUE}", (String)json, (boolean)false, (int)4, null);
        return this.chatService.chat(message);
    }
}

