/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.AbstractWebPage;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.model.GoraWebPage;
import ai.platon.pulsar.ql.h2.utils.ResultSetUtils;
import ai.platon.pulsar.rest.api.common.NormXSQL;
import ai.platon.pulsar.rest.api.entities.ModelsKt;
import ai.platon.pulsar.rest.api.entities.ScrapeRequest;
import ai.platon.pulsar.rest.api.entities.ScrapeResponse;
import ai.platon.pulsar.skeleton.crawl.PageEventHandlers;
import ai.platon.pulsar.skeleton.crawl.event.impl.DefaultCrawlEventHandlers;
import ai.platon.pulsar.skeleton.crawl.event.impl.DefaultLoadEventHandlers;
import ai.platon.pulsar.skeleton.crawl.event.impl.PageEventHandlersFactory;
import ai.platon.pulsar.skeleton.session.PulsarSession;
import ai.platon.scent.rest.api.controller.pulsar.v30x.AbstractScrapeHyperlinkV30x;
import java.sql.ResultSet;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0002\u001f B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/XSQLScrapeHyperlinkV30x;", "Lai/platon/scent/rest/api/controller/pulsar/v30x/AbstractScrapeHyperlinkV30x;", "request", "Lai/platon/pulsar/rest/api/entities/ScrapeRequest;", "sql", "Lai/platon/pulsar/rest/api/common/NormXSQL;", "session", "Lai/platon/pulsar/skeleton/session/PulsarSession;", "uuid", "", "(Lai/platon/pulsar/rest/api/entities/ScrapeRequest;Lai/platon/pulsar/rest/api/common/NormXSQL;Lai/platon/pulsar/skeleton/session/PulsarSession;Ljava/lang/String;)V", "args", "getArgs", "()Ljava/lang/String;", "setArgs", "(Ljava/lang/String;)V", "eventHandlers", "Lai/platon/pulsar/skeleton/crawl/PageEventHandlers;", "getEventHandlers", "()Lai/platon/pulsar/skeleton/crawl/PageEventHandlers;", "setEventHandlers", "(Lai/platon/pulsar/skeleton/crawl/PageEventHandlers;)V", "logger", "Lorg/slf4j/Logger;", "doExtract", "", "page", "Lai/platon/pulsar/persist/WebPage;", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "extract", "CrawlEventHandlers", "LoadEventHandlers", "scent-rest"})
public class XSQLScrapeHyperlinkV30x
extends AbstractScrapeHyperlinkV30x {
    @NotNull
    private final Logger logger;
    @Nullable
    private String args;
    @NotNull
    private PageEventHandlers eventHandlers;

    public XSQLScrapeHyperlinkV30x(@NotNull ScrapeRequest request, @NotNull NormXSQL sql, @NotNull PulsarSession session, @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        super(request, sql, session, uuid);
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(XSQLScrapeHyperlinkV30x.class));
        this.args = "-parse " + sql.getArgs();
        this.eventHandlers = PageEventHandlersFactory.Companion.create$default((PageEventHandlersFactory.Companion)PageEventHandlersFactory.Companion, (ai.platon.pulsar.skeleton.crawl.LoadEventHandlers)((ai.platon.pulsar.skeleton.crawl.LoadEventHandlers)new LoadEventHandlers(this, this.getResponse())), null, (ai.platon.pulsar.skeleton.crawl.CrawlEventHandlers)((ai.platon.pulsar.skeleton.crawl.CrawlEventHandlers)new CrawlEventHandlers(this, this.getResponse())), (int)2, null);
    }

    public /* synthetic */ XSQLScrapeHyperlinkV30x(ScrapeRequest scrapeRequest, NormXSQL normXSQL, PulsarSession pulsarSession, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            string = string2;
        }
        this(scrapeRequest, normXSQL, pulsarSession, string);
    }

    @Nullable
    public String getArgs() {
        return this.args;
    }

    public void setArgs(@Nullable String string) {
        this.args = string;
    }

    @Override
    @NotNull
    public PageEventHandlers getEventHandlers() {
        return this.eventHandlers;
    }

    @Override
    public void setEventHandlers(@NotNull PageEventHandlers pageEventHandlers) {
        Intrinsics.checkNotNullParameter((Object)pageEventHandlers, (String)"<set-?>");
        this.eventHandlers = pageEventHandlers;
    }

    public void extract(@NotNull WebPage page, @NotNull FeaturedDocument document) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        try {
            ModelsKt.refresh((ScrapeResponse)this.getResponse(), (String)"extract");
            this.getResponse().setPageContentBytes((int)page.getContentLength());
            this.getResponse().setPageStatusCode(page.getProtocolStatus().getMinorCode());
            if (page.getProtocolStatus().isSuccess()) {
                this.doExtract(page, document);
            }
            this.getResponse();
        }
        catch (Throwable t) {
            LogsKt.warnInterruptible((Object)((Object)this), (Throwable)t, (String)("Error extracting data from page: " + page.getUrl()), (Object[])new Object[0]);
        }
    }

    protected void doExtract(@NotNull WebPage page, @NotNull FeaturedDocument document) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!page.getProtocolStatus().isSuccess() || page.getContentLength() == 0L || page.getContent() == null) {
            this.logger.info("No content | {}", (Object)page.getUrl());
            this.getResponse().setStatusCode(204);
            ModelsKt.refresh((ScrapeResponse)this.getResponse(), (int)204, (int)204, (boolean)false);
        }
        ResultSet rs = this.executeQuery(this.getRequest(), this.getResponse());
        this.getResponse().setResultSet(ResultSetUtils.INSTANCE.getTextEntitiesFromResultSet(rs));
        ModelsKt.refresh((ScrapeResponse)this.getResponse(), (int)200, (int)page.getProtocolStatus().getMinorCode(), (boolean)false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/XSQLScrapeHyperlinkV30x$CrawlEventHandlers;", "Lai/platon/pulsar/skeleton/crawl/event/impl/DefaultCrawlEventHandlers;", "hyperlink", "Lai/platon/scent/rest/api/controller/pulsar/v30x/XSQLScrapeHyperlinkV30x;", "response", "Lai/platon/pulsar/rest/api/entities/ScrapeResponse;", "(Lai/platon/scent/rest/api/controller/pulsar/v30x/XSQLScrapeHyperlinkV30x;Lai/platon/pulsar/rest/api/entities/ScrapeResponse;)V", "getHyperlink", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/XSQLScrapeHyperlinkV30x;", "getResponse", "()Lai/platon/pulsar/rest/api/entities/ScrapeResponse;", "scent-rest"})
    public static final class CrawlEventHandlers
    extends DefaultCrawlEventHandlers {
        @NotNull
        private final XSQLScrapeHyperlinkV30x hyperlink;
        @NotNull
        private final ScrapeResponse response;

        public CrawlEventHandlers(@NotNull XSQLScrapeHyperlinkV30x hyperlink, @NotNull ScrapeResponse response) {
            Intrinsics.checkNotNullParameter((Object)((Object)hyperlink), (String)"hyperlink");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.hyperlink = hyperlink;
            this.response = response;
            this.getOnWillLoad().addLast((Function1)new Function1<UrlAware, UrlAware>(){

                @NotNull
                public final UrlAware invoke(@NotNull UrlAware it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    ModelsKt.refresh((ScrapeResponse)this.getResponse(), (String)"onWillLoad");
                    return it;
                }
            });
            this.getOnLoaded().addLast((Function2)new Function2<UrlAware, WebPage, Unit>(){

                public final void invoke(@NotNull UrlAware url, @Nullable WebPage page) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    if (!this.getHyperlink().isDone()) {
                        XSQLScrapeHyperlinkV30x xSQLScrapeHyperlinkV30x = this.getHyperlink();
                        WebPage webPage = page;
                        if (webPage == null) {
                            webPage = (WebPage)GoraWebPage.Companion.getNIL();
                        }
                        xSQLScrapeHyperlinkV30x.complete(webPage);
                    }
                    ModelsKt.refresh((ScrapeResponse)this.getResponse(), (boolean)true);
                }
            });
        }

        @NotNull
        public final XSQLScrapeHyperlinkV30x getHyperlink() {
            return this.hyperlink;
        }

        @NotNull
        public final ScrapeResponse getResponse() {
            return this.response;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/XSQLScrapeHyperlinkV30x$LoadEventHandlers;", "Lai/platon/pulsar/skeleton/crawl/event/impl/DefaultLoadEventHandlers;", "hyperlink", "Lai/platon/scent/rest/api/controller/pulsar/v30x/XSQLScrapeHyperlinkV30x;", "response", "Lai/platon/pulsar/rest/api/entities/ScrapeResponse;", "(Lai/platon/scent/rest/api/controller/pulsar/v30x/XSQLScrapeHyperlinkV30x;Lai/platon/pulsar/rest/api/entities/ScrapeResponse;)V", "getHyperlink", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/XSQLScrapeHyperlinkV30x;", "getResponse", "()Lai/platon/pulsar/rest/api/entities/ScrapeResponse;", "scent-rest"})
    public static final class LoadEventHandlers
    extends DefaultLoadEventHandlers {
        @NotNull
        private final XSQLScrapeHyperlinkV30x hyperlink;
        @NotNull
        private final ScrapeResponse response;

        public LoadEventHandlers(@NotNull XSQLScrapeHyperlinkV30x hyperlink, @NotNull ScrapeResponse response) {
            Intrinsics.checkNotNullParameter((Object)((Object)hyperlink), (String)"hyperlink");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            super(null, 1, null);
            this.hyperlink = hyperlink;
            this.response = response;
            this.getOnWillLoad().addLast((Function1)1.INSTANCE);
            this.getOnWillParseHTMLDocument().addLast((Function1)2.INSTANCE);
            this.getOnWillParseHTMLDocument().addLast((Function1)3.INSTANCE);
            this.getOnHTMLDocumentParsed().addLast((Function2)new Function2<WebPage, FeaturedDocument, Unit>(){

                public final void invoke(@NotNull WebPage page, @NotNull FeaturedDocument document) {
                    Intrinsics.checkNotNullParameter((Object)page, (String)"page");
                    Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                    if (!(page instanceof AbstractWebPage)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (!((AbstractWebPage)page).hasVar("IS_SCRAPE")) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.getHyperlink().extract(page, document);
                }
            });
            this.getOnLoaded().addLast((Function1)new Function1<WebPage, Unit>(){

                public final void invoke(@NotNull WebPage page) {
                    Intrinsics.checkNotNullParameter((Object)page, (String)"page");
                    ModelsKt.refresh((ScrapeResponse)this.getResponse(), (String)"onLoaded");
                }
            });
        }

        @NotNull
        public final XSQLScrapeHyperlinkV30x getHyperlink() {
            return this.hyperlink;
        }

        @NotNull
        public final ScrapeResponse getResponse() {
            return this.response;
        }
    }
}

