/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x.service;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.dom.nodes.node.ext.NodeExtKt;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.model.ActiveDOMMetadata;
import ai.platon.pulsar.rest.api.common.DomUtils;
import ai.platon.pulsar.rest.api.common.PromptUtils;
import ai.platon.pulsar.rest.api.common.ScrapeAPIUtils;
import ai.platon.pulsar.rest.api.entities.CommandRequest;
import ai.platon.pulsar.rest.api.entities.CommandResult;
import ai.platon.pulsar.rest.api.entities.CommandStatus;
import ai.platon.pulsar.rest.api.entities.InstructResult;
import ai.platon.pulsar.rest.api.entities.ModelsKt;
import ai.platon.pulsar.rest.api.entities.ScrapeRequest;
import ai.platon.pulsar.rest.api.entities.ScrapeResponse;
import ai.platon.pulsar.skeleton.common.options.LoadOptions;
import ai.platon.pulsar.skeleton.session.PulsarSession;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.CommandServiceV30x;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.ConversationServiceV30x;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.LoadServiceV30x;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.ScrapeServiceV30x;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 92\u00020\u0001:\u00019B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001e2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u0014\u0010 \u001a\u00020\u00102\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0012J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0010H\u0016J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u000fH\u0016J(\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0010H\u0012J\u0018\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0010H\u0012J(\u0010+\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0010H\u0012J\u0018\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0010H\u0012J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0016J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u0012\u00101\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J \u00102\u001a\u00020&2\u0006\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0010H\u0012J\u001c\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001007062\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u0010\u00108\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006:"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/service/CommandServiceV30x;", "", "session", "Lai/platon/pulsar/skeleton/session/PulsarSession;", "loadService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/LoadServiceV30x;", "conversationService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x;", "scrapeService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ScrapeServiceV30x;", "(Lai/platon/pulsar/skeleton/session/PulsarSession;Lai/platon/scent/rest/api/controller/pulsar/v30x/service/LoadServiceV30x;Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x;Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ScrapeServiceV30x;)V", "commandDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "commandStatusCache", "Ljava/util/concurrent/ConcurrentSkipListMap;", "", "Lai/platon/pulsar/rest/api/entities/CommandStatus;", "commanderScope", "Lkotlinx/coroutines/CoroutineScope;", "getConversationService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x;", "getLoadService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/LoadServiceV30x;", "logger", "Lorg/slf4j/Logger;", "getScrapeService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ScrapeServiceV30x;", "getSession", "()Lai/platon/pulsar/skeleton/session/PulsarSession;", "commandStatusFlow", "Lkotlinx/coroutines/flow/Flow;", "id", "createCachedCommandStatus", "request", "Lai/platon/pulsar/rest/api/entities/CommandRequest;", "executeCommand", "status", "executeCommandStepByStep", "", "page", "Lai/platon/pulsar/persist/WebPage;", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "executeCommandStepByStep0", "executeQuery", "sql", "executeSync", "getResult", "Lai/platon/pulsar/rest/api/entities/CommandResult;", "getStatus", "performInstruct", "name", "instruct", "streamEvents", "Lreactor/core/publisher/Flux;", "Lorg/springframework/http/codec/ServerSentEvent;", "submitAsync", "Companion", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nCommandServiceV30x.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandServiceV30x.kt\nai/platon/scent/rest/api/controller/pulsar/v30x/service/CommandServiceV30x\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n1#2:289\n766#3:290\n857#3,2:291\n*S KotlinDebug\n*F\n+ 1 CommandServiceV30x.kt\nai/platon/scent/rest/api/controller/pulsar/v30x/service/CommandServiceV30x\n*L\n256#1:290\n256#1:291,2\n*E\n"})
public class CommandServiceV30x {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PulsarSession session;
    @NotNull
    private final LoadServiceV30x loadService;
    @NotNull
    private final ConversationServiceV30x conversationService;
    @NotNull
    private final ScrapeServiceV30x scrapeService;
    @NotNull
    private final ConcurrentSkipListMap<String, CommandStatus> commandStatusCache;
    @NotNull
    private final CoroutineDispatcher commandDispatcher;
    @NotNull
    private final CoroutineScope commanderScope;
    @NotNull
    private final Logger logger;
    public static final int MIN_USER_MESSAGE_LENGTH = 2;
    public static final long FLOW_POLLING_INTERVAL = 1000L;

    public CommandServiceV30x(@NotNull PulsarSession session, @NotNull LoadServiceV30x loadService, @NotNull ConversationServiceV30x conversationService, @NotNull ScrapeServiceV30x scrapeService) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)loadService, (String)"loadService");
        Intrinsics.checkNotNullParameter((Object)conversationService, (String)"conversationService");
        Intrinsics.checkNotNullParameter((Object)scrapeService, (String)"scrapeService");
        this.session = session;
        this.loadService = loadService;
        this.conversationService = conversationService;
        this.scrapeService = scrapeService;
        this.commandStatusCache = new ConcurrentSkipListMap();
        this.commandDispatcher = Dispatchers.getIO().limitedParallelism(10);
        this.commanderScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.commandDispatcher.plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)).plus((CoroutineContext)new CoroutineName("commander")));
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(CommandServiceV30x.class));
    }

    @NotNull
    public PulsarSession getSession() {
        return this.session;
    }

    @NotNull
    public LoadServiceV30x getLoadService() {
        return this.loadService;
    }

    @NotNull
    public ConversationServiceV30x getConversationService() {
        return this.conversationService;
    }

    @NotNull
    public ScrapeServiceV30x getScrapeService() {
        return this.scrapeService;
    }

    @NotNull
    public CommandStatus executeSync(@NotNull CommandRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CommandStatus status = this.createCachedCommandStatus(request);
        this.executeCommand(request, status);
        return status;
    }

    @NotNull
    public String submitAsync(@NotNull CommandRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CommandStatus status = this.createCachedCommandStatus(request);
        BuildersKt.launch$default((CoroutineScope)this.commanderScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, status, null){
            int label;
            final /* synthetic */ CommandServiceV30x this$0;
            final /* synthetic */ CommandRequest $request;
            final /* synthetic */ CommandStatus $status;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$status = $status;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.executeCommand(this.$request, this.$status);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return status.getId();
    }

    @Nullable
    public CommandStatus getStatus(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.commandStatusCache.get(id);
    }

    @Nullable
    public CommandResult getResult(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CommandStatus commandStatus = this.commandStatusCache.get(id);
        return commandStatus != null ? commandStatus.getCommandResult() : null;
    }

    @NotNull
    public Flux<ServerSentEvent<CommandStatus>> streamEvents(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Ref.IntRef doneCount = new Ref.IntRef();
        Function1 handleFluxSink2 = (Function1)new Function1<FluxSink<CommandStatus>, FluxSink<CommandStatus>>(this, id, doneCount){
            final /* synthetic */ CommandServiceV30x this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ Ref.IntRef $doneCount;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                this.$doneCount = $doneCount;
                super(1);
            }

            @NotNull
            public final FluxSink<CommandStatus> invoke(@NotNull FluxSink<CommandStatus> sink) {
                Intrinsics.checkNotNullParameter(sink, (String)"sink");
                Job job2 = FlowKt.launchIn((Flow)FlowKt.catch((Flow)FlowKt.onEach(this.this$0.commandStatusFlow(this.$id), (Function2)((Function2)new Function2<CommandStatus, Continuation<? super Unit>, Object>(sink, this.$doneCount, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ FluxSink<CommandStatus> $sink;
                    final /* synthetic */ Ref.IntRef $doneCount;
                    {
                        this.$sink = $sink;
                        this.$doneCount = $doneCount;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                CommandStatus it = (CommandStatus)this.L$0;
                                this.$sink.next((Object)it);
                                if (it.isDone()) {
                                    ++this.$doneCount.element;
                                    int cfr_ignored_0 = this.$doneCount.element;
                                }
                                if (this.$doneCount.element >= 5) {
                                    this.$sink.complete();
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CommandStatus p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                })), (Function3)((Function3)new Function3<FlowCollector<? super CommandStatus>, Throwable, Continuation<? super Unit>, Object>(this.this$0, sink, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ CommandServiceV30x this$0;
                    final /* synthetic */ FluxSink<CommandStatus> $sink;
                    {
                        this.this$0 = $receiver;
                        this.$sink = $sink;
                        super(3, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Throwable it = (Throwable)this.L$0;
                                CommandServiceV30x.access$getLogger$p(this.this$0).error("Error in command status flow", it);
                                this.$sink.error(it);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull FlowCollector<? super CommandStatus> p1, @NotNull Throwable p2, @Nullable Continuation<? super Unit> p3) {
                        var var4_4 = new /* invalid duplicate definition of identical inner class */;
                        var4_4.L$0 = p2;
                        return var4_4.invokeSuspend(Unit.INSTANCE);
                    }
                })), (CoroutineScope)CommandServiceV30x.access$getCommanderScope$p(this.this$0));
                return sink.onDispose(() -> streamEvents.handleFluxSink.1.invoke$lambda$0(job2));
            }

            private static final void invoke$lambda$0(Job $job) {
                Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
                Job.DefaultImpls.cancel$default((Job)$job, null, (int)1, null);
            }
        };
        Flux flux = Flux.create(arg_0 -> CommandServiceV30x.streamEvents$lambda$0((Function1)new Function1<FluxSink<CommandStatus>, Unit>((Function1<? super FluxSink<CommandStatus>, ? extends FluxSink<CommandStatus>>)handleFluxSink2){
            final /* synthetic */ Function1<FluxSink<CommandStatus>, FluxSink<CommandStatus>> $handleFluxSink;
            {
                this.$handleFluxSink = $handleFluxSink;
                super(1);
            }

            public final void invoke(FluxSink<CommandStatus> sink) {
                Intrinsics.checkNotNull(sink);
                this.$handleFluxSink.invoke(sink);
            }
        }, arg_0)).map(arg_0 -> CommandServiceV30x.streamEvents$lambda$1(streamEvents.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    @NotNull
    public Flow<CommandStatus> commandStatusFlow(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super CommandStatus>, Continuation<? super Unit>, Object>(this, id, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CommandServiceV30x this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$flow = (FlowCollector)this.L$0;
                        lastModifiedTime = Instant.EPOCH;
                        while (true) {
                            this.L$0 = $this$flow;
                            this.L$1 = lastModifiedTime;
                            this.L$2 = null;
                            this.label = 1;
                            v0 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl21
                            break;
                        }
                    }
                    case 1: {
                        lastModifiedTime = (Instant)this.L$1;
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl21:
                        // 2 sources

                        if ((v1 = (CommandStatus)CommandServiceV30x.access$getCommandStatusCache$p(this.this$0).get(this.$id)) == null) {
                            v1 = CommandStatus.Companion.notFound(this.$id);
                        }
                        var5_6 /* !! */  = v1;
                        Intrinsics.checkNotNull((Object)var5_6 /* !! */ );
                        status = var5_6 /* !! */ ;
                        var5_6 /* !! */  = lastModifiedTime;
                        Intrinsics.checkNotNull((Object)var5_6 /* !! */ );
                        if (!ModelsKt.refreshed((CommandStatus)status, (Instant)var5_6 /* !! */ )) ** GOTO lbl42
                        this.L$0 = $this$flow;
                        this.L$1 = status;
                        this.label = 2;
                        v2 = $this$flow.emit((Object)status, (Continuation)this);
                        if (v2 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl41
                    }
                    case 2: {
                        status = (CommandStatus)this.L$1;
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl41:
                        // 2 sources

                        lastModifiedTime = status.getLastModifiedTime();
lbl42:
                        // 2 sources

                        if (status.isDone()) {
                            this.L$0 = $this$flow;
                            this.L$1 = lastModifiedTime;
                            this.L$2 = status;
                            this.label = 3;
                            v3 = $this$flow.emit((Object)status, (Continuation)this);
                            if (v3 == var6_2) {
                                return var6_2;
                            }
                        }
                        ** GOTO lbl57
                    }
                    case 3: {
                        status = (CommandStatus)this.L$2;
                        lastModifiedTime = (Instant)this.L$1;
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl57:
                        // 2 sources

                        if (!status.isDone()) ** continue;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super CommandStatus> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public CommandStatus executeCommand(@NotNull String request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (StringsKt.isBlank((CharSequence)request)) {
            return CommandStatus.Companion.failed$default((CommandStatus.Companion)CommandStatus.Companion, (int)400, (int)0, (int)2, null);
        }
        CommandRequest request2 = this.getConversationService().normalizePlainCommand(request);
        CommandStatus status = this.createCachedCommandStatus(request2);
        if (request2 == null) {
            ModelsKt.failed((CommandStatus)status, (int)417);
            return status;
        }
        return this.executeCommand(request2, status);
    }

    @NotNull
    public CommandStatus executeCommand(@NotNull CommandRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CommandStatus status = this.createCachedCommandStatus(request);
        this.executeCommand(request, status);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CommandStatus executeCommand(@NotNull CommandRequest request, @NotNull CommandStatus status) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        try {
            ModelsKt.refresh((CommandStatus)status, (int)102);
            this.executeCommandStepByStep(request, status);
        }
        catch (Exception e) {
            ModelsKt.failed((CommandStatus)status, (int)417);
        }
        finally {
            ModelsKt.done((CommandStatus)status);
        }
        return status;
    }

    private CommandStatus createCachedCommandStatus(CommandRequest request) {
        CommandStatus status = new CommandStatus(null, 0, null, false, 0, 0, null, null, null, null, 1023, null);
        ((Map)this.commandStatusCache).put(status.getId(), status);
        ModelsKt.refresh((CommandStatus)status, (String)"created");
        return status;
    }

    static /* synthetic */ CommandStatus createCachedCommandStatus$default(CommandServiceV30x commandServiceV30x, CommandRequest commandRequest, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createCachedCommandStatus");
        }
        if ((n & 1) != 0) {
            commandRequest = null;
        }
        return commandServiceV30x.createCachedCommandStatus(commandRequest);
    }

    private void executeCommandStepByStep(CommandRequest request, CommandStatus status) {
        String[] stringArray = new String[]{request.getArgs(), "-refresh"};
        request.setArgs(LoadOptions.Companion.mergeArgs$default((LoadOptions.Companion)LoadOptions.Companion, (String[])stringArray, null, (int)2, null));
        stringArray = this.getLoadService().loadDocument(request);
        WebPage page = (WebPage)stringArray.component1();
        FeaturedDocument document = (FeaturedDocument)stringArray.component2();
        if (page.isNil()) {
            ModelsKt.failed((CommandStatus)status, (int)417);
            return;
        }
        status.setPageStatusCode(page.getProtocolStatus().getMinorCode());
        status.setPageContentBytes((int)page.getOriginalContentLength());
        if (!page.getProtocolStatus().isSuccess()) {
            return;
        }
        this.executeCommandStepByStep(page, document, request, status);
        this.logger.info("Finished executeCommandStepByStep | status: {} | {}", (Object)status.getStatus(), (Object)document.getBaseURI());
        String sql = request.getXsql();
        if (sql != null && ScrapeAPIUtils.INSTANCE.isScrapeUDF(sql)) {
            Object object;
            ModelsKt.refresh((CommandStatus)status, (int)102);
            try {
                boolean bl = false;
                this.executeQuery(sql, status);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                this.logger.warn("Failed to execute query", it);
            }
        }
        ModelsKt.refresh((CommandStatus)status, (int)200);
    }

    private void executeCommandStepByStep(WebPage page, FeaturedDocument document, CommandRequest request, CommandStatus status) {
        try {
            this.executeCommandStepByStep0(page, document, request, status);
        }
        catch (Exception e) {
            ModelsKt.failed((CommandStatus)status, (int)417);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeCommandStepByStep0(WebPage page, FeaturedDocument document, CommandRequest request, CommandStatus status) {
        Regex linkExtractionRules;
        ActiveDOMMetadata activeDOMMetadata = page.getActiveDOMMetadata();
        float screenNumber = activeDOMMetadata != null ? activeDOMMetadata.getScreenNumber() : 0.0f;
        String pageSummaryPrompt = PromptUtils.INSTANCE.normalizePageSummaryPrompt(request.getPageSummaryPrompt());
        String dataExtractionRules = PromptUtils.INSTANCE.normalizeDataExtractionRules(request.getDataExtractionRules());
        Object[] richText = null;
        String textContent = null;
        if (pageSummaryPrompt != null || dataExtractionRules != null) {
            String instruct;
            String string;
            Object[] it;
            if (Intrinsics.areEqual((Object)request.getRichText(), (Object)true)) {
                Object[] objectArray;
                it = objectArray = DomUtils.INSTANCE.selectNthScreenRichText(screenNumber, document);
                boolean bl = false;
                richText = it;
                string = objectArray;
            } else {
                string = DomUtils.INSTANCE.selectNthScreenText(screenNumber, document);
            }
            textContent = string;
            ModelsKt.refresh((CommandStatus)status, (String)"textContent");
            if (StringsKt.isBlank((CharSequence)textContent)) {
                if (NodeExtKt.getNumChars((Node)((Node)document.getBody())) > 100) {
                    Path path = document.export();
                    it = new Object[]{Float.valueOf(screenNumber), NodeExtKt.getNumChars((Node)((Node)document.getBody())), path.toUri()};
                    this.logger.warn("Not textContent found on screen: {} but there are chars in body: {}, exported to {}", it);
                }
                return;
            }
            if (pageSummaryPrompt != null) {
                instruct = StringsKt.replace$default((String)pageSummaryPrompt, (String)"{PLACEHOLDER_PAGE_CONTENT}", (String)textContent, (boolean)false, (int)4, null);
                this.performInstruct("pageSummary", instruct, status);
                CommandResult commandResult = status.getCommandResult();
                this.logger.info("pageSummary: {}", (Object)(commandResult != null ? commandResult.getPageSummary() : null));
            }
            if (dataExtractionRules != null) {
                instruct = StringsKt.replace$default((String)dataExtractionRules, (String)"{PLACEHOLDER_PAGE_CONTENT}", (String)textContent, (boolean)false, (int)4, null);
                this.performInstruct("fields", instruct, status);
                CommandResult commandResult = status.getCommandResult();
                this.logger.info("fields: {}", (Object)(commandResult != null ? commandResult.getFields() : null));
            }
        }
        if ((linkExtractionRules = PromptUtils.INSTANCE.normalizeLinkExtractionRules(request.getLinkExtractionRules())) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = DomUtils.INSTANCE.selectNthScreenLinks(document);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!linkExtractionRules.matches((CharSequence)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List links = (List)destination$iv$iv;
            if (!((Collection)links).isEmpty()) {
                InstructResult result = InstructResult.Companion.ok("links", CollectionsKt.joinToString$default((Iterable)links, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                ModelsKt.addInstructResult((CommandStatus)status, (InstructResult)result);
            }
            this.logger.info("Use regex to extract {} links: {}", (Object)links.size(), (Object)linkExtractionRules);
        }
    }

    private void performInstruct(String name, String instruct, CommandStatus status) {
        InstructResult instructResult;
        try {
            String content = this.getSession().chat(instruct).getContent();
            instructResult = InstructResult.Companion.ok(name, content);
        }
        catch (Exception e) {
            this.logger.warn("Failed to perform instruct: " + instruct, (Throwable)e);
            instructResult = InstructResult.Companion.failed$default((InstructResult.Companion)InstructResult.Companion, (String)name, (int)0, (int)2, null);
        }
        InstructResult result = instructResult;
        ModelsKt.addInstructResult((CommandStatus)status, (InstructResult)result);
    }

    private void executeQuery(String sql, CommandStatus status) {
        ScrapeRequest scrapeRequest = new ScrapeRequest(sql);
        try {
            ScrapeResponse scrapeResponse = this.getScrapeService().executeQuery(scrapeRequest);
            status.setStatusCode(scrapeResponse.getStatusCode());
            ModelsKt.ensureCommandResult((CommandStatus)status).setXsqlResultSet(scrapeResponse.getResultSet());
        }
        catch (Exception e) {
            status.setStatusCode(417);
        }
    }

    private static final void streamEvents$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final ServerSentEvent streamEvents$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ServerSentEvent)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p(CommandServiceV30x $this) {
        return $this.logger;
    }

    public static final /* synthetic */ CoroutineScope access$getCommanderScope$p(CommandServiceV30x $this) {
        return $this.commanderScope;
    }

    public static final /* synthetic */ ConcurrentSkipListMap access$getCommandStatusCache$p(CommandServiceV30x $this) {
        return $this.commandStatusCache;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/service/CommandServiceV30x$Companion;", "", "()V", "FLOW_POLLING_INTERVAL", "", "MIN_USER_MESSAGE_LENGTH", "", "scent-rest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

