/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x.service;

import ai.platon.pulsar.common.LinkExtractors;
import ai.platon.pulsar.common.serialize.json.JacksonKt;
import ai.platon.pulsar.common.serialize.json.JsonExtractor;
import ai.platon.pulsar.common.urls.URLUtils;
import ai.platon.pulsar.rest.api.entities.CommandRequest;
import ai.platon.pulsar.rest.api.entities.CommandStatus;
import ai.platon.pulsar.skeleton.session.PulsarSession;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x;", "", "session", "Lai/platon/pulsar/skeleton/session/PulsarSession;", "(Lai/platon/pulsar/skeleton/session/PulsarSession;)V", "getSession", "()Lai/platon/pulsar/skeleton/session/PulsarSession;", "convertPlainCommandToJSON", "", "plainCommand", "url", "convertResponseToMarkdown", "status", "Lai/platon/pulsar/rest/api/entities/CommandStatus;", "jsonResponse", "normalizePlainCommand", "Lai/platon/pulsar/rest/api/entities/CommandRequest;", "request", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nConversationServiceV30x.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversationServiceV30x.kt\nai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n58#2:76\n51#2:77\n1#3:78\n*S KotlinDebug\n*F\n+ 1 ConversationServiceV30x.kt\nai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x\n*L\n43#1:76\n43#1:77\n*E\n"})
public class ConversationServiceV30x {
    @NotNull
    private final PulsarSession session;

    public ConversationServiceV30x(@NotNull PulsarSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    @NotNull
    public PulsarSession getSession() {
        return this.session;
    }

    @Nullable
    public CommandRequest normalizePlainCommand(@NotNull String request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (StringsKt.isBlank((CharSequence)request)) {
            return null;
        }
        Set urls = LinkExtractors.fromText((String)request);
        if (urls.isEmpty()) {
            return null;
        }
        String url = (String)CollectionsKt.first((Iterable)urls);
        String json = this.convertPlainCommandToJSON(request, url);
        CharSequence charSequence = json;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        ObjectMapper $this$readValue$iv = JacksonKt.pulsarObjectMapper();
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        CommandRequest request2 = (CommandRequest)$this$readValue$iv.readValue(json, (TypeReference)new TypeReference<CommandRequest>(){});
        request2.setUrl(url);
        return request2;
    }

    @Nullable
    public String convertPlainCommandToJSON(@NotNull String plainCommand, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)plainCommand, (String)"plainCommand");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (!URLUtils.isStandard((String)url)) {
            boolean $i$a$-require-ConversationServiceV30x$convertPlainCommandToJSON$22 = false;
            String $i$a$-require-ConversationServiceV30x$convertPlainCommandToJSON$22 = "URL must not be blank";
            throw new IllegalArgumentException($i$a$-require-ConversationServiceV30x$convertPlainCommandToJSON$22.toString());
        }
        String processedRequest = StringsKt.replace$default((String)plainCommand, (String)url, (String)"{PLACEHOLDER_URL}", (boolean)false, (int)4, null);
        String prompt = StringsKt.replace$default((String)"\nYou're given a user request that describes how to interact with and extract information from a web page.\nYour task is to **analyze and convert** this request into a **structured JSON object** that our system can process.\n\nThe input may be conversational, contain ambiguous instructions, or be written in different languages.\n\nProduce a JSON object with these possible fields:\n\n```json\n\n{\n  \"url\": \"{PLACEHOLDER_URL}\",\n  \"pageSummaryPrompt\": \"Instructions for summarizing the page...\",\n  \"dataExtractionRules\": \"Instructions for extracting specific fields...\",\n  \"linkExtractionRules\": \"https://.+\",\n  \"onPageReadyActions\": [\n    \"scroll down\",\n    \"click 'Sign In' button\"\n  ]\n}\n\n```\n\n### \ud83d\udd27 Guidelines:\n\n* **Keep the URL placeholder** as `{PLACEHOLDER_URL}` exactly as shown.\n* Only include fields that are relevant to the user's request.\n* For `onPageReadyActions`: List any interaction steps in order of execution.\n* For `pageSummaryPrompt`: Include clear instructions for summarizing the page content.\n* For `dataExtractionRules`: Specify what fields to extract and their format.\n* For `linkExtractionRules`: Define a Kotlin-compatible regex pattern that matches exactly one valid URL.\n  * * Match the input's link extraction requirement.\n  * * Match only one full URL (not multiple in a string).\n  * * Be compatible with Kotlin's Regex class.\n  * * Support both HTTP and HTTPS schemes.\n  * * Optionally include path, query, and fragment.\n  * * Return only the pattern string (no explanation).\n  \n* Convert vague requests into specific, actionable instructions.\n\n### \ud83d\udce5 Input:\n\n```text\n{PLACEHOLDER_REQUEST}\n```\n\n", (String)"{PLACEHOLDER_REQUEST}", (String)processedRequest, (boolean)false, (int)4, null);
        String content = this.getSession().chat(prompt).getContent();
        if (StringsKt.isBlank((CharSequence)content)) {
            return null;
        }
        content = StringsKt.replace$default((String)content, (String)"{PLACEHOLDER_URL}", (String)url, (boolean)false, (int)4, null);
        return (String)CollectionsKt.firstOrNull((List)JsonExtractor.INSTANCE.extractJsonBlocks(content));
    }

    @NotNull
    public String convertResponseToMarkdown(@NotNull String jsonResponse) {
        Intrinsics.checkNotNullParameter((Object)jsonResponse, (String)"jsonResponse");
        String userMessage = StringsKt.replace$default((String)"\nConvert the following JSON string into a well-structured Markdown document.\n\n## Output requirement\n\nThe output must include:\n\n### \ud83e\uddfe Human-Readable Explanation\n\nPresent the JSON content as structured Markdown sections:\n\n1. **Page Summary** \u2014 A brief summary of the page content.\n2. **Fields** \u2014 A list of extracted key-value pairs from the page.\n3. **Links** \u2014 A list of extracted links.\n\n### \ud83d\udce6 JSON representation\n\nInclude the original JSON string as a fenced code block **at the end** of the Markdown document.\nThe JSON section name is **JSON representation**\n\n## \ud83d\udd27 JSON to Convert:\n\n```json\n{JSON_STRING}\n\n", (String)"{JSON_STRING}", (String)jsonResponse, (boolean)false, (int)4, null);
        return this.getSession().chat(userMessage).getContent();
    }

    @NotNull
    public String convertResponseToMarkdown(@NotNull CommandStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        String jsonResponse = JacksonKt.pulsarObjectMapper().writeValueAsString((Object)status);
        Intrinsics.checkNotNull((Object)jsonResponse);
        return this.convertResponseToMarkdown(jsonResponse);
    }
}

