/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x.service;

import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.rest.api.entities.PromptRequest;
import ai.platon.pulsar.skeleton.common.options.LoadOptions;
import ai.platon.pulsar.skeleton.session.PulsarSession;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.LoadServiceV30x;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ExtractServiceV30x;", "", "session", "Lai/platon/pulsar/skeleton/session/PulsarSession;", "loadService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/LoadServiceV30x;", "(Lai/platon/pulsar/skeleton/session/PulsarSession;Lai/platon/scent/rest/api/controller/pulsar/v30x/service/LoadServiceV30x;)V", "getLoadService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/LoadServiceV30x;", "getSession", "()Lai/platon/pulsar/skeleton/session/PulsarSession;", "extract", "", "request", "Lai/platon/pulsar/rest/api/entities/PromptRequest;", "scent-rest"})
public class ExtractServiceV30x {
    @NotNull
    private final PulsarSession session;
    @NotNull
    private final LoadServiceV30x loadService;

    public ExtractServiceV30x(@NotNull PulsarSession session, @NotNull LoadServiceV30x loadService) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)loadService, (String)"loadService");
        this.session = session;
        this.loadService = loadService;
    }

    @NotNull
    public PulsarSession getSession() {
        return this.session;
    }

    @NotNull
    public LoadServiceV30x getLoadService() {
        return this.loadService;
    }

    @NotNull
    public String extract(@NotNull PromptRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String prompt = request.getPrompt();
        String[] stringArray = (String[])prompt;
        if (stringArray == null || StringsKt.isBlank((CharSequence)stringArray)) {
            return "\n    I am PulsarRPA, what can I do for you?\n";
        }
        stringArray = new String[]{request.getArgs(), "-refresh"};
        request.setArgs(LoadOptions.Companion.mergeArgs$default((LoadOptions.Companion)LoadOptions.Companion, (String[])stringArray, null, (int)2, null));
        stringArray = this.getLoadService().loadDocument(request);
        WebPage page = (WebPage)stringArray.component1();
        FeaturedDocument document = (FeaturedDocument)stringArray.component2();
        String prompt2 = StringsKt.trimIndent((String)("\n            Extract the following information from the web page:\n            " + prompt + "\n            \n            " + document.getText() + "\n\n\n            "));
        return page.getProtocolStatus().isSuccess() ? this.getSession().chat(prompt2).getContent() : page.getProtocolStatus().toString();
    }
}

