/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.schedule;

import ai.platon.commons.distributed.lock.exception.DistributedLockException;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.collect.UrlFeederHelper;
import ai.platon.pulsar.common.collect.collector.DataCollector;
import ai.platon.pulsar.common.collect.collector.PriorityDataCollector;
import ai.platon.pulsar.common.collect.collector.UrlCacheCollector;
import ai.platon.pulsar.skeleton.common.collect.PriorityDataCollectorsTableFormatter;
import ai.platon.scent.boot.autoconfigure.component.ScentCrawlLoop;
import ai.platon.scent.common.Runtimes;
import ai.platon.scent.rest.api.service.CrawlSeedService;
import ai.platon.scent.rest.api.service.scrape.Task48HourHistoryService;
import ai.platon.scent.rest.api.service.scrape.TaskMonthlyHistoryService;
import ai.platon.scent.rest.api.service.scrape.TaskMultiHistoryService;
import ai.platon.scent.rest.api.service.v1.ScrapeServiceV1;
import ai.platon.scent.rest.api.service.v2.ScrapeServiceV2;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@Profile(value={"!test"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0019\u001a\u00020\u001aH\u0017J\b\u0010\u001b\u001a\u00020\u001aH\u0017J\b\u0010\u001c\u001a\u00020\u001aH\u0017J\b\u0010\u001d\u001a\u00020\u001aH\u0017J\b\u0010\u001e\u001a\u00020\u001aH\u0012R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00120\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lai/platon/scent/rest/api/schedule/ScentRestMonitor;", "", "seedService", "Lai/platon/scent/rest/api/service/CrawlSeedService;", "scrapeServiceV1", "Lai/platon/scent/rest/api/service/v1/ScrapeServiceV1;", "scrapeServiceV2", "Lai/platon/scent/rest/api/service/v2/ScrapeServiceV2;", "task48HourHistoryService", "Lai/platon/scent/rest/api/service/scrape/Task48HourHistoryService;", "taskMonthlyHistoryService", "Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;", "multiHistoryService", "Lai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService;", "crawlLoop", "Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "(Lai/platon/scent/rest/api/service/CrawlSeedService;Lai/platon/scent/rest/api/service/v1/ScrapeServiceV1;Lai/platon/scent/rest/api/service/v2/ScrapeServiceV2;Lai/platon/scent/rest/api/service/scrape/Task48HourHistoryService;Lai/platon/scent/rest/api/service/scrape/TaskMonthlyHistoryService;Lai/platon/scent/rest/api/service/scrape/TaskMultiHistoryService;Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;)V", "dcLog", "Lorg/slf4j/Logger;", "logger", "kotlin.jvm.PlatformType", "urlFeederHelper", "Lai/platon/pulsar/common/collect/UrlFeederHelper;", "getUrlFeederHelper", "()Lai/platon/pulsar/common/collect/UrlFeederHelper;", "checkAndReportDataCollectors", "", "collectDbStats", "executeTopTaskBatch", "maintainScrapeTaskDb", "removeRetiredFetchCacheCollector", "Companion", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nScentRestMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScentRestMonitor.kt\nai/platon/scent/rest/api/schedule/ScentRestMonitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n800#2,11:126\n288#2,2:137\n1#3:139\n*S KotlinDebug\n*F\n+ 1 ScentRestMonitor.kt\nai/platon/scent/rest/api/schedule/ScentRestMonitor\n*L\n76#1:126,11\n77#1:137,2\n*E\n"})
public class ScentRestMonitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CrawlSeedService seedService;
    @NotNull
    private final ScrapeServiceV1 scrapeServiceV1;
    @NotNull
    private final ScrapeServiceV2 scrapeServiceV2;
    @NotNull
    private final Task48HourHistoryService task48HourHistoryService;
    @NotNull
    private final TaskMonthlyHistoryService taskMonthlyHistoryService;
    @NotNull
    private final TaskMultiHistoryService multiHistoryService;
    @NotNull
    private final ScentCrawlLoop crawlLoop;
    private final Logger logger;
    @NotNull
    private final Logger dcLog;
    public static final long INITIAL_DELAY = 120000L;

    public ScentRestMonitor(@NotNull CrawlSeedService seedService, @NotNull ScrapeServiceV1 scrapeServiceV1, @NotNull ScrapeServiceV2 scrapeServiceV2, @NotNull Task48HourHistoryService task48HourHistoryService, @NotNull TaskMonthlyHistoryService taskMonthlyHistoryService, @NotNull TaskMultiHistoryService multiHistoryService, @NotNull ScentCrawlLoop crawlLoop) {
        Intrinsics.checkNotNullParameter((Object)seedService, (String)"seedService");
        Intrinsics.checkNotNullParameter((Object)((Object)scrapeServiceV1), (String)"scrapeServiceV1");
        Intrinsics.checkNotNullParameter((Object)((Object)scrapeServiceV2), (String)"scrapeServiceV2");
        Intrinsics.checkNotNullParameter((Object)task48HourHistoryService, (String)"task48HourHistoryService");
        Intrinsics.checkNotNullParameter((Object)taskMonthlyHistoryService, (String)"taskMonthlyHistoryService");
        Intrinsics.checkNotNullParameter((Object)multiHistoryService, (String)"multiHistoryService");
        Intrinsics.checkNotNullParameter((Object)crawlLoop, (String)"crawlLoop");
        this.seedService = seedService;
        this.scrapeServiceV1 = scrapeServiceV1;
        this.scrapeServiceV2 = scrapeServiceV2;
        this.task48HourHistoryService = task48HourHistoryService;
        this.taskMonthlyHistoryService = taskMonthlyHistoryService;
        this.multiHistoryService = multiHistoryService;
        this.crawlLoop = crawlLoop;
        this.logger = LoggerFactory.getLogger(ScentRestMonitor.class);
        this.dcLog = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(DataCollector.class));
    }

    private UrlFeederHelper getUrlFeederHelper() {
        return new UrlFeederHelper(this.crawlLoop.getUrlFeeder());
    }

    @Scheduled(fixedDelay=120000L, initialDelay=120000L)
    public void checkAndReportDataCollectors() {
        if (Runtimes.INSTANCE.isDevInstance()) {
            // empty if block
        }
        try {
            this.crawlLoop.getUrlFeeder().getUrlPool().removeDeceased();
            List collectors = this.crawlLoop.getCollectors();
            this.dcLog.info("\n{}", (Object)new PriorityDataCollectorsTableFormatter((Collection)collectors));
            this.dcLog.info(this.crawlLoop.getAbstract());
            this.logger.info(this.crawlLoop.getAbstract());
            this.removeRetiredFetchCacheCollector();
        }
        catch (Throwable t) {
            LogsKt.warnInterruptible((Object)this, (Throwable)t);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeRetiredFetchCacheCollector() {
        Object v0;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.getUrlFeederHelper().getFeeder().getCollectors();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof UrlCacheCollector)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UrlCacheCollector it = (UrlCacheCollector)element$iv;
                boolean bl = false;
                if (!(it.getDeadTime().compareTo(Instant.now()) <= 0)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        UrlCacheCollector collector = v0;
        if (collector != null) {
            this.logger.info("Removing dead collector {}, dead at {}", (Object)collector.getName(), (Object)collector.getDeadTime());
            collector.getUrlCache().deepClear();
            this.getUrlFeederHelper().remove(collector.getName());
        }
    }

    @Scheduled(fixedDelay=60000L, initialDelay=120000L)
    public void collectDbStats() {
        try {
            this.scrapeServiceV1.collectDbStats();
            this.multiHistoryService.collectDbStats();
        }
        catch (Throwable t) {
            LogsKt.warnInterruptible((Object)this, (Throwable)t);
        }
    }

    @Scheduled(fixedDelay=0x6DDD00L, initialDelay=60000L)
    public void maintainScrapeTaskDb() {
        try {
            this.task48HourHistoryService.maintainDb();
            this.taskMonthlyHistoryService.maintainDb();
        }
        catch (Throwable t) {
            LogsKt.warnInterruptible((Object)this, (Throwable)t);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Scheduled(fixedDelay=60000L, initialDelay=60000L)
    public void executeTopTaskBatch() {
        try {
            Iterable iterable = this.crawlLoop.getUrlFeeder().findByName("SCRAPE");
            int n = 0;
            for (Object t : iterable) {
                void it;
                PriorityDataCollector priorityDataCollector = (PriorityDataCollector)t;
                int n2 = n;
                boolean bl = false;
                int n3 = it.getSize();
                n = n2 + n3;
            }
            int count = n;
            if (count < 100) {
                try {
                    this.scrapeServiceV1.executeTopN();
                }
                catch (DistributedLockException e) {
                    this.logger.warn("DistributedLockException: {}", (Object)e.getMessage());
                }
                catch (Throwable t) {
                    LogsKt.warnInterruptible((Object)this, (Throwable)t);
                }
            }
        }
        catch (Exception e) {
            LogsKt.warnInterruptible((Object)this, (Throwable)e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/scent/rest/api/schedule/ScentRestMonitor$Companion;", "", "()V", "INITIAL_DELAY", "", "scent-rest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

