/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service.billing;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.scent.rest.api.common.BillingException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0012J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0004H\u0016J \u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0012J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/platon/scent/rest/api/service/billing/BillingService;", "", "redisTemplate", "Lorg/springframework/data/redis/core/RedisTemplate;", "", "(Lorg/springframework/data/redis/core/RedisTemplate;)V", "logger", "Lorg/slf4j/Logger;", "checkAndRecordUsage", "", "authToken", "getCount", "", "key", "getUsage", "Lai/platon/scent/rest/api/service/billing/BillingService$UsageStats;", "incrementAndGet", "now", "Ljava/time/Instant;", "duration", "Ljava/time/Duration;", "resetUsage", "Companion", "UsageStats", "scent-rest"})
public class BillingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RedisTemplate<String, String> redisTemplate;
    @NotNull
    private final Logger logger;
    @NotNull
    private static final String BILLING_KEY_PREFIX = "billing:";
    private static final int DAILY_LIMIT = 1000;
    private static final int HOURLY_LIMIT = 200;
    private static final int MINUTE_LIMIT = 60;

    public BillingService(@NotNull RedisTemplate<String, String> redisTemplate) {
        Intrinsics.checkNotNullParameter(redisTemplate, (String)"redisTemplate");
        this.redisTemplate = redisTemplate;
        this.logger = LogsKt.getLogger((Object)this);
    }

    public void checkAndRecordUsage(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Instant now = Instant.now();
        String dailyKey = "billing:daily:" + authToken;
        String hourlyKey = "billing:hourly:" + authToken;
        String minuteKey = "billing:minute:" + authToken;
        Intrinsics.checkNotNull((Object)now);
        Duration duration = Duration.ofDays(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(...)");
        long dailyCount = this.incrementAndGet(dailyKey, now, duration);
        if (dailyCount > 1000L) {
            throw new BillingException("Daily API limit exceeded for token: " + authToken);
        }
        Duration duration2 = Duration.ofHours(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofHours(...)");
        long hourlyCount = this.incrementAndGet(hourlyKey, now, duration2);
        if (hourlyCount > 200L) {
            throw new BillingException("Hourly API limit exceeded for token: " + authToken);
        }
        Duration duration3 = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(...)");
        long minuteCount = this.incrementAndGet(minuteKey, now, duration3);
        if (minuteCount > 60L) {
            throw new BillingException("Minute API limit exceeded for token: " + authToken);
        }
    }

    @NotNull
    public UsageStats getUsage(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Instant now = Instant.now();
        long l = this.getCount("billing:daily:" + authToken);
        long l2 = this.getCount("billing:hourly:" + authToken);
        long l3 = this.getCount("billing:minute:" + authToken);
        Intrinsics.checkNotNull((Object)now);
        return new UsageStats(l, l2, l3, 1000, 200, 60, now);
    }

    public void resetUsage(@NotNull String authToken) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Object[] objectArray = new String[]{"billing:daily:" + authToken, "billing:hourly:" + authToken, "billing:minute:" + authToken};
        this.redisTemplate.delete((Collection)CollectionsKt.listOf((Object[])objectArray));
    }

    private long incrementAndGet(String key, Instant now, Duration duration) {
        long count;
        Long l = this.redisTemplate.opsForValue().increment((Object)key);
        if (l == null) {
            l = 1L;
        }
        if ((count = ((Number)l).longValue()) == 1L) {
            this.redisTemplate.expire((Object)key, duration);
        }
        return count;
    }

    private long getCount(String key) {
        Object object = (String)this.redisTemplate.opsForValue().get((Object)key);
        return object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 0L;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/platon/scent/rest/api/service/billing/BillingService$Companion;", "", "()V", "BILLING_KEY_PREFIX", "", "DAILY_LIMIT", "", "HOURLY_LIMIT", "MINUTE_LIMIT", "scent-rest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003JO\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lai/platon/scent/rest/api/service/billing/BillingService$UsageStats;", "", "dailyCount", "", "hourlyCount", "minuteCount", "dailyLimit", "", "hourlyLimit", "minuteLimit", "timestamp", "Ljava/time/Instant;", "(JJJIIILjava/time/Instant;)V", "getDailyCount", "()J", "getDailyLimit", "()I", "getHourlyCount", "getHourlyLimit", "getMinuteCount", "getMinuteLimit", "getTimestamp", "()Ljava/time/Instant;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "", "scent-rest"})
    public static final class UsageStats {
        private final long dailyCount;
        private final long hourlyCount;
        private final long minuteCount;
        private final int dailyLimit;
        private final int hourlyLimit;
        private final int minuteLimit;
        @NotNull
        private final Instant timestamp;

        public UsageStats(long dailyCount, long hourlyCount, long minuteCount, int dailyLimit, int hourlyLimit, int minuteLimit, @NotNull Instant timestamp) {
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            this.dailyCount = dailyCount;
            this.hourlyCount = hourlyCount;
            this.minuteCount = minuteCount;
            this.dailyLimit = dailyLimit;
            this.hourlyLimit = hourlyLimit;
            this.minuteLimit = minuteLimit;
            this.timestamp = timestamp;
        }

        public final long getDailyCount() {
            return this.dailyCount;
        }

        public final long getHourlyCount() {
            return this.hourlyCount;
        }

        public final long getMinuteCount() {
            return this.minuteCount;
        }

        public final int getDailyLimit() {
            return this.dailyLimit;
        }

        public final int getHourlyLimit() {
            return this.hourlyLimit;
        }

        public final int getMinuteLimit() {
            return this.minuteLimit;
        }

        @NotNull
        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final long component1() {
            return this.dailyCount;
        }

        public final long component2() {
            return this.hourlyCount;
        }

        public final long component3() {
            return this.minuteCount;
        }

        public final int component4() {
            return this.dailyLimit;
        }

        public final int component5() {
            return this.hourlyLimit;
        }

        public final int component6() {
            return this.minuteLimit;
        }

        @NotNull
        public final Instant component7() {
            return this.timestamp;
        }

        @NotNull
        public final UsageStats copy(long dailyCount, long hourlyCount, long minuteCount, int dailyLimit, int hourlyLimit, int minuteLimit, @NotNull Instant timestamp) {
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            return new UsageStats(dailyCount, hourlyCount, minuteCount, dailyLimit, hourlyLimit, minuteLimit, timestamp);
        }

        public static /* synthetic */ UsageStats copy$default(UsageStats usageStats, long l, long l2, long l3, int n, int n2, int n3, Instant instant, int n4, Object object) {
            if ((n4 & 1) != 0) {
                l = usageStats.dailyCount;
            }
            if ((n4 & 2) != 0) {
                l2 = usageStats.hourlyCount;
            }
            if ((n4 & 4) != 0) {
                l3 = usageStats.minuteCount;
            }
            if ((n4 & 8) != 0) {
                n = usageStats.dailyLimit;
            }
            if ((n4 & 0x10) != 0) {
                n2 = usageStats.hourlyLimit;
            }
            if ((n4 & 0x20) != 0) {
                n3 = usageStats.minuteLimit;
            }
            if ((n4 & 0x40) != 0) {
                instant = usageStats.timestamp;
            }
            return usageStats.copy(l, l2, l3, n, n2, n3, instant);
        }

        @NotNull
        public String toString() {
            return "UsageStats(dailyCount=" + this.dailyCount + ", hourlyCount=" + this.hourlyCount + ", minuteCount=" + this.minuteCount + ", dailyLimit=" + this.dailyLimit + ", hourlyLimit=" + this.hourlyLimit + ", minuteLimit=" + this.minuteLimit + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.dailyCount);
            result = result * 31 + Long.hashCode(this.hourlyCount);
            result = result * 31 + Long.hashCode(this.minuteCount);
            result = result * 31 + Integer.hashCode(this.dailyLimit);
            result = result * 31 + Integer.hashCode(this.hourlyLimit);
            result = result * 31 + Integer.hashCode(this.minuteLimit);
            result = result * 31 + this.timestamp.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UsageStats)) {
                return false;
            }
            UsageStats usageStats = (UsageStats)other;
            if (this.dailyCount != usageStats.dailyCount) {
                return false;
            }
            if (this.hourlyCount != usageStats.hourlyCount) {
                return false;
            }
            if (this.minuteCount != usageStats.minuteCount) {
                return false;
            }
            if (this.dailyLimit != usageStats.dailyLimit) {
                return false;
            }
            if (this.hourlyLimit != usageStats.hourlyLimit) {
                return false;
            }
            if (this.minuteLimit != usageStats.minuteLimit) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.timestamp, (Object)usageStats.timestamp);
        }
    }
}

