;

"use strict";

const ANNOTATION_PANEL = `
<div id="PR-dataAnnotationPanel" class="layui-form" style="display: none; padding: 20px;">
    <div class="layui-item-list annotations">
    </div>
    <div class="layui-form-item">
      <div class="layui-input-block">
        <button class="layui-btn" id="PR-doAnnotate">Submit</button>
        <button class="layui-btn" id="PR-refresh">Refresh</button>
        <button class="layui-btn" id="PR-discard">Discard</button>
      </div>
    </div>
<!--    <div class="layui-form-item" pane="">-->
<!--      <div class="layui-input-block">-->
<!--        <input type="checkbox" title="Disable Annotation">-->
<!--        <div class="layui-unselect layui-form-checkbox disable-annotation" lay-skin="primary">-->
<!--           <span>Disable Annotation</span><i class="layui-icon layui-icon-ok"></i>-->
<!--        </div>-->
<!--      </div>-->
<!--    </div>-->
    <div class="layui-row">
        <div class="PR-message layui-col-lg12"></div>
        <div class="layui-col-lg12">Added: <span class="PR-added-annotations layui-bg-green"></span></div>
        <div class="layui-col-lg12">Loaded: <span class="PR-loaded-annotations"></span></div>
        <a class="PR-pageURL layui-col-lg12"></a>
    </div>
</div>
`;

// keep consistent with ai.platon.pulsar.dom.nodes.ML_LABEL
const DATA_LABEL_KEY = 'L';

const AUTH_TOKEN = 'b09kGOoAxo2hfa398944d3a97c7a4857e6cb9dc40b0d';

const ANNOTATE_QUERY_API = 'http://localhost:8182/api/annotate/query';

const ANNOTATE_POST_API = 'http://localhost:8182/api/annotate';

const DataAnnotationPropTypes = {
    id: '',
    className: '',
    vi: '',
    text: '',
    label: ''
};

class DataAnnotation {

    constructor(vi, label, id, className, text) {
        this.vi = ''
        this.label = ''
        this.id = ''
        this.className = ''
        this.text = ''
    }
}

class DataAnnotationList {
    constructor() {
        this.annotations = []
    }

    findByVI() {

    }

    findByLabel() {

    }
}

let __annotation_utils__ = function () {
};

__annotation_utils__.disableAnnotation = false;
__annotation_utils__.annotations = [];
// The title specified by the LLM, should be set by the server, and should be a json object
__annotation_utils__.llmTitle = null;
__annotation_utils__.forcedLabel = null;
__annotation_utils__.isAnnotated = false;
__annotation_utils__.isDiscarded = false;
__annotation_utils__.status = false;
// __annotation_utils__.nextTaskUrl = false

__annotation_utils__.isFinished = function () {
    return __annotation_utils__.isAnnotated || __annotation_utils__.isDiscarded
};

__annotation_utils__.findAnnotationByVI = function (targetVI) {
    return this.annotations.find(function(a) {
        return a.vi === targetVI
    });
};
__annotation_utils__.findAnnotationByLabel = function (label) {
    return this.annotations.find(function(a) {
        return a.label === label
    });
};

/**
 * @param text string
 * @param max number
 * @param suffix string
 * */
__annotation_utils__.abbreviate = function (text, max, suffix) {
    let str = text.replace(/^\s+|\s+$/g, '').replace(/[\r\n]*\s*[\r\n]+/g, ' ').replace(/[ \t]+/g, ' ')
    if (str.length <= max) {
        return text;
    }

    let abbr = ''
    str = str.split(' ')
    suffix = (typeof suffix !== 'undefined' ? suffix : ' ...')
    max = (max - suffix.length)

    for (let len = str.length, i = 0; i < len; i++) {
        if ((abbr + str[i]).length < max) {
            abbr += str[i] + ' ';
        } else {
            break;
        }
    }

    return abbr.replace(/[ ]$/g, '') + suffix;
}

/**
 * @param content string
 * */
__annotation_utils__.addStyleContent = function(content) {
    const style = document.createElement('style');
    style.appendChild(document.createTextNode(content));
    document.head.appendChild(style);
};

__annotation_utils__.addAnnotationItem = function(targetEle) {
    let vi = targetEle.getAttribute('vi')

    let found = this.findAnnotationByVI(vi)
    if (found) {
        return
    }

    let forcedLabel = this.forcedLabel
    let addedLabel = targetEle.getAttribute(DATA_LABEL_KEY) || ''
    if (!addedLabel && forcedLabel) {
        addedLabel = forcedLabel
    }

    // let generatedLabel = ele.id || ele.className || ele.tagName
    let annotation = {
        vi: vi,
        label: addedLabel,
        id: targetEle.id,
        className: targetEle.className,
        text: targetEle.textContent,
    }
    this.addAnnotation(annotation)
};

__annotation_utils__.addAnnotationKVItem = function(key, value) {
    let annotation = {
        vi: '0 0 0 0',
        label: key,
        id: null,
        className: null,
        text: value,
    }
    this.addAnnotation(annotation)
};

/**
 * @param json string
 * */
__annotation_utils__.addAnnotationJSON = function(json) {
    let annotation = JSON.parse(json)
    this.addAnnotation(annotation)
};

/**
 * @param annotation object
 * */
__annotation_utils__.addAnnotation = function(annotation) {
    // let annotation = {
    //     vi: '0 0 0 0',
    //     label: key,
    //     id: null,
    //     className: null,
    //     text: value,
    // }
    this.annotations.push(annotation)
    this.addLabel(annotation)
    this.renderAnnotationList()
};

__annotation_utils__.removeAnnotationItem = function(vi) {
    // let vi = ele.getAttribute('vi')

    let annotations = this.annotations.filter(function(a) {
        return a.vi !== vi
    });

    if (annotations.length !== this.annotations) {
        this.annotations = annotations
        this.renderAnnotationList()
    }
};

__annotation_utils__.navigateTo = function(url) {
    window.location = url
};

__annotation_utils__.renderAnnotationList = function() {
    let annotationHTML = `<div class='PR-injected PR-panel'>`;

    this.annotations.forEach(anno => {
        let forcedLabel = this.forcedLabel
        let label = forcedLabel || anno.label
        let text = this.abbreviate(anno.text, 100)

        annotationHTML += `
<div class="layui-form-item">
  <div class="layui-inline layui-input-group">
    <div class="layui-input-split layui-input-suffix vi">
      ${anno.vi}
    </div>
    <input type="text" name="arr[]" required lay-verify="required" placeholder="Input a label for the data" 
        autocomplete="on" class="label layui-input" style="min-width: 80px"
        value="${label}" targetVI="${anno.vi}" />
    <div class="layui-input-split layui-input-suffix text">${text}</div>
    <button type="button" class="layui-btn layui-btn-sm PR-close">x</button>
  </div>
</div>
`
    });
    annotationHTML += "</div>"

    document.querySelector('#PR-dataAnnotationPanel.layui-form .layui-item-list').innerHTML = annotationHTML

    this.registerAddLabelEventListeners()
};

/**
 * @param ele HTMLElement
 * @return string
 * */
__annotation_utils__.inspect = function (ele) {
    let name = ele.tagName
    let id = ele.id
    let clazz = ele.className
    if (id) {
        name = name + "#" + id
    } else if (clazz) {
        name = name + "." + clazz
    }
    let style = ele.style
    let area = ele.clientWidth + " x " + ele.clientHeight
    let vi = ele.getAttribute("vi")

    let color = __pulsar000_utils__.getPropertyValue(style, "color")
    let backgroundColor = __pulsar000_utils__.getPropertyValue(style, "background-color")
    let font = __pulsar000_utils__.getPropertyValue(style, "font")
    let margin = __pulsar000_utils__.getPropertyValue(style, "margin")
    let padding = __pulsar000_utils__.getPropertyValue(style, "padding")

    let html = `<div class="PR-inspect PR-injected PR-panel">
<h4 class="layui-row"><span class="layui-col-lg6">${name}</span><span class="layui-col-lg6">${area}</span></h4>`

    if (color) html += `<div>Color: ${color}</div>`
    if (backgroundColor) html += `<div>Background: ${backgroundColor}</div>`
    if (font) html += `<div>Font: ${font}</div>`
    if (margin) html += `<div>Margin: ${margin}</div>`
    if (padding) html += `<div>Padding: ${padding}</div>`

    html += `
<div class="layui-row">VI: ${vi}</div>
<hr/>
<div class="layui-hide">Metrics: ${__pulsar000_utils__.getFullPageMetrics()}</div>
<div class="layui-row">
    <b>Label: </b><span>${ele.getAttribute(DATA_LABEL_KEY) || 'None'}</span></div>
<div class="layui-row" style="max-width: 500px">
    <b>LLM Title: </b><span>${this.llmTitle}</span></div>
<div class="layui-row">
    <b>Message: </b><span>${this.message || 'None'}</span>
</div>
</div>`

    return html
}

__annotation_utils__.isMouseOnPanel = function (ev) {
    // let rect = document.querySelector("#PLATONAI-ML-PANEL").getBoundingClientRect();
    // if (ev.clientX >= rect.left && ev.clientX <= rect.right &&
    //     ev.clientY >= rect.top && ev.clientY <= rect.bottom) {
    //     // Mouse is inside element.
    //     return true
    // }

    let rects = document.querySelectorAll(".layui-layer, .PR-panel");
    for (let i = 0; i < rects.length; i++) {
        let rect = rects[i].getBoundingClientRect();
        if (ev.clientX >= rect.left && ev.clientX <= rect.right &&
            ev.clientY >= rect.top && ev.clientY <= rect.bottom) {
            // Mouse is inside element.
            return true
        }
    }
}

/**
 * @param ele HTMLElement
 * */
__annotation_utils__.addCustomElementEventListeners = function(ele) {
    let vi = ele.getAttribute('vi')
    if (!vi) return

    const allowAllElements = true
    if (allowAllElements || ele.childElementCount === 0) {
        // TODO: handle text block rather than element block
        ele.addEventListener('mouseover', ev => {
            if (__annotation_utils__.disableAnnotation) {
                return true
            }

            if (__annotation_utils__.isMouseOnPanel(ev)) {
                return true
            }

            ev.preventDefault()
            ev.stopPropagation()

            // let cssText = ele.style.cssText
            // if (cssText) {
            //     ele.dataset.oldStyle = cssText
            // }

            // ele.style.cssText += ` border: 1px solid #F00; padding-top: 20px; padding-left: 10px; background-color: lightgray`;
            ele.style.cssText += ` color: orangered; background-color: greenyellow`;

            let info = __annotation_utils__.inspect(ele)
            layer.msg(info, {icon: 1, offset: 'r', time: 30000, zIndex: 99999});

            return false
        })

        ele.addEventListener('mouseout', ev => {
            if (__annotation_utils__.disableAnnotation) {
                return true
            }

            ev.preventDefault()

            // let cssText = ele.dataset.oldStyle
            // ele.style.cssText = cssText
            ele.style.color = null
            ele.style.backgroundColor = null

            return false
        })

        ele.addEventListener('click', ev => {
            if (__annotation_utils__.disableAnnotation) {
                return true
            }

            if (__annotation_utils__.isMouseOnPanel(ev)) {
                return true
            }

            ev.preventDefault()
            ev.stopPropagation()

            __annotation_utils__.addAnnotationItem(ele)

            return false
        })

        // dblclick to remove
        ele.addEventListener('dblclick', ev => {
            if (__annotation_utils__.disableAnnotation) {
                return true
            }

            if (__annotation_utils__.isMouseOnPanel(ev)) {
                return true
            }

            let submitOnDbClick = true
            if (submitOnDbClick || __annotation_utils__.forcedLabel) {
                __annotation_utils__.submit(ele)
                // if (__annotation_utils__.nextTaskUrl) {
                //     window.location = __annotation_utils__.nextTaskUrl
                // }
            } else {
                ev.preventDefault()
                __annotation_utils__.removeAnnotationItem(vi)
            }

            return false
        })
    }
}

__annotation_utils__.addCustomEventListeners = function() {
    // document.head.insertAdjacentHTML("beforeend", layerStyle);
    document.querySelector('body div').insertAdjacentHTML('beforeend', ANNOTATION_PANEL);

    let layer = __annotation_utils__.layer

    document.__pulsar000_forEachElement(ele => {
        __annotation_utils__.addCustomElementEventListeners(ele)
    });
};

/**
 * @param ele HTMLElement
 * */
__annotation_utils__.removeCustomElementEventListeners = function(ele) {
    ele.removeEventListener('click')
    ele.removeEventListener('dblclick')
    ele.removeEventListener('mouseover')
    ele.removeEventListener('mouseout')
};

__annotation_utils__.removeCustomEventListeners = function() {
    document.__pulsar000_forEachElement(ele => {
        ele.removeEventListener('click')
        ele.removeEventListener('dblclick')
        ele.removeEventListener('mouseover')
        ele.removeEventListener('mouseout')
    });
};

__annotation_utils__.registerAddLabelEventListeners = function () {
    document.querySelectorAll('#PR-dataAnnotationPanel .layui-form-item').forEach(function (item) {
        let labelInput = item.querySelector('input.label')
        if (!labelInput) {
            return
        }

        let closeButton = item.querySelector('.PR-close')
        let targetVI = labelInput.getAttribute('targetVI')
        let label = labelInput.value

        labelInput.addEventListener('change', ev => {
            let annotation = __annotation_utils__.findAnnotationByVI(targetVI);
            if (annotation) {
                annotation.label = label
                __annotation_utils__.addLabel(annotation)
            }
        })

        closeButton.addEventListener('click', ev => {
            __annotation_utils__.removeAnnotationItem(targetVI)
            let annotation = __annotation_utils__.findAnnotationByVI(targetVI);
            if (annotation) {
                __annotation_utils__.removeLabel(annotation)
            }
        })
    })

    document.querySelectorAll('#PR-dataAnnotationPanel input.label').forEach(function (ele) {
        ele.addEventListener('change', ev => {
            let targetVI = ele.getAttribute('targetVI')
            let label = ele.value
            // let annotation = __annotation_utils__.annotations.find(function(a) {
            //     return a.vi === targetVI
            // });
            let annotation = __annotation_utils__.findAnnotationByVI(targetVI);
            if (annotation) {
                annotation.label = label
                __annotation_utils__.addLabel(annotation)
            }
        })
    })
};

__annotation_utils__.add = function(a, b) {
    return a + b
}

__annotation_utils__.addLabel = function(annotation) {
    let label = annotation.label
    let targetVI = annotation.vi
    document.__pulsar000_forEachElement(ele => {
        if (ele.childElementCount === 0) {
            // TODO: handle text block rather than element block
            let vi = ele.getAttribute('vi')
            if (targetVI === vi) {
                ele.setAttribute(DATA_LABEL_KEY, label)
                ele.classList.add('layui-bg-blue')
            }
        }
    });
};

__annotation_utils__.removeLabel = function(annotation) {
    let targetVI = annotation.vi
    document.__pulsar000_forEachElement(ele => {
        if (ele.childElementCount === 0) {
            // TODO: handle text block rather than element block
            let vi = ele.getAttribute('vi')
            if (targetVI === vi) {
                ele.removeAttribute(DATA_LABEL_KEY)
                ele.classList.remove('layui-bg-blue')
            }
        }
    });
};

__annotation_utils__.loadAnnotations = function() {
    let $ = __annotation_utils__.$

    let pageUrl = $('#PulsarMetaInformation').attr('normurl')

    let url = ANNOTATE_QUERY_API + "?authToken=" + AUTH_TOKEN + "&url=" + encodeURIComponent(pageUrl)
    $.get(url, function (data, status) {
        $("#PR-dataAnnotationPanel .PR-loaded-annotations").text(JSON.stringify(data))
    })

    return false
};

/**
 * @param ele HTMLElement
 * */
__annotation_utils__.submit = function(ele) {
    let $ = __annotation_utils__.$

    let submitting = $(document).data("submitting")
    if (!submitting) {
        $(document).data("submitting", true)
        setTimeout(function () {
            $(document).data("submitting", false)
        }, 3000);

        this.doSubmit(() => {
            $(".PR-message").text("Submitted")
        })
    }

    return false
}

/**
 * @param onComplete function
 * */
__annotation_utils__.doSubmit = function(onComplete) {
    let $ = __annotation_utils__.$

    let pageUrl = $('#PulsarMetaInformation').attr('normurl')
    if (!pageUrl) {
        console.log("Page url (normurl) is not set, the document feature might not be calculated")
        return false
    }

    let data = {
        authToken: AUTH_TOKEN,
        url: pageUrl,
        annotations: __annotation_utils__.annotations.map(a => {
            return { 'vi': a.vi, 'label': a.label }
        }).filter(a => a.vi.length > 0 && a.label.length > 0),
    }

    if (data.annotations.length === 0) {
        return false
    }

    $("#PR-doAnnotate").hide()
    setTimeout(function () {
        $('#PR-doAnnotate').show()
    }, 5000);

    $.ajax(ANNOTATE_POST_API, {
        data: JSON.stringify(data),
        contentType: 'application/json',
        type: 'POST',
        success: function(response) {
            __annotation_utils__.isAnnotated = true
            __annotation_utils__.status = 'OK'
            // alert(JSON.stringify(response))
            $("#PR-dataAnnotationPanel .PR-added-annotations").text(JSON.stringify(response))
        },
        error: function(jqXHR, textStatus, error) {
            __annotation_utils__.status = 'SUBMIT_FAILURE'
            $("#PR-dataAnnotationPanel .PR-message").text(textStatus)
        },
        complete: function () {
            onComplete()
            $('#PR-doAnnotate').show()
        }
    })

    return false
};

__annotation_utils__.discard = function(e) {
    e.preventDefault()

    this.isDiscarded = true
    this.status = 'DISCARDED'

    document.querySelector("#PR-dataAnnotationPanel .PR-message").textContent = "discarded"
    return false
};

__annotation_utils__.refresh = function(e) {
    e.preventDefault()

    this.isDiscarded = true
    this.status = 'DISCARDED'

    document.querySelector("#PR-dataAnnotationPanel .PR-message").textContent = "refresh"

    window.location = window.location

    return false
};

layui.use('layer', function() {
    const $ = layui.jquery
        , layer = layui.layer
        , util = layui.util;

    __annotation_utils__.$ = $
    __annotation_utils__.layer = layer
    __annotation_utils__.util = util

    if($(window).width() <= 500) {
        return;
    }

    let openPanel = function() {
        layer.open({
            type: 1
            ,title: 'ML Annotation Panel - platon.ai - 2025/1/21 14:45'
            ,id: 'PLATONAI-ML-PANEL'
            ,area: ['50%', '300px']
            ,content: $('#PR-dataAnnotationPanel')
            ,shade: false
            ,offset: 'lb'
            ,resize: true
            ,maxmin: true
            ,zIndex: 999999
            ,min: function(layero, index) {
                layer.style(index, {top: 'auto', bottom: 0});
                return false;
            }
        });

        $('*[d-label]').each(function (index) {
            __annotation_utils__.addAnnotationItem(this)
        })

        let pageUrl = $('#PulsarMetaInformation').attr('normurl')
        if (!pageUrl) {
            console.log("Page url (normurl) is not set, the document feature might not be calculated")
            return
        }

        $('.PR-pageURL').text(pageUrl).attr('href', pageUrl).attr('target', '_blank')

        __annotation_utils__.loadAnnotations()

        this.status = 'READY'
    };

    layer.ready(function() {
        __annotation_utils__.addCustomEventListeners();

        openPanel();

        $('#PR-doAnnotate').on('click', __annotation_utils__.submit)
        $('#PR-discard').on('click', __annotation_utils__.discard)
        $('#PR-refresh').on('click', __annotation_utils__.refresh)
    });
});
