/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api;

import ai.platon.commons.distributed.lock.mongo.configuration.EnableMongoDistributedLock;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.collect.ExternalUrlLoader;
import ai.platon.pulsar.common.collect.UrlFeederHelper;
import ai.platon.pulsar.common.collect.collector.UrlCacheCollector;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.skeleton.common.metrics.MetricFilters;
import ai.platon.scent.boot.autoconfigure.common.ScrapeTaskHandler;
import ai.platon.scent.boot.autoconfigure.component.CrawlSeedV3Loader;
import ai.platon.scent.boot.autoconfigure.component.ScentCrawlLoop;
import ai.platon.scent.boot.autoconfigure.component.ScentGlobalCache;
import ai.platon.scent.boot.autoconfigure.component.ScrapeTaskV1Handler;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableMongoDistributedLock
@ComponentScan(value={"ai.platon.scent.boot.autoconfigure", "ai.platon.scent.boot.autoconfigure.component"})
@DependsOn(value={"scentContextConfiguration"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0017J\b\u0010\u001b\u001a\u00020\u001cH\u0017J\b\u0010\u001d\u001a\u00020\u001cH\u0017J\b\u0010\u001e\u001a\u00020\u001fH\u0017R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lai/platon/scent/rest/api/ScentApiConfiguration;", "", "urlLoader", "Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "globalCache", "Lai/platon/scent/boot/autoconfigure/component/ScentGlobalCache;", "crawlLoop", "Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "taskV1Handler", "Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/collect/ExternalUrlLoader;Lai/platon/scent/boot/autoconfigure/component/ScentGlobalCache;Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getCrawlLoop", "()Lai/platon/scent/boot/autoconfigure/component/ScentCrawlLoop;", "getGlobalCache", "()Lai/platon/scent/boot/autoconfigure/component/ScentGlobalCache;", "logger", "Lorg/slf4j/Logger;", "getTaskV1Handler", "()Lai/platon/scent/boot/autoconfigure/component/ScrapeTaskV1Handler;", "getUrlLoader", "()Lai/platon/pulsar/common/collect/ExternalUrlLoader;", "getRestTemplate", "Lorg/springframework/web/client/RestTemplate;", "initCrawlSeedLoader", "", "initializeDataCollectors", "metricsModule", "Lcom/fasterxml/jackson/databind/Module;", "scent-rest"})
public class ScentApiConfiguration {
    @NotNull
    private final ExternalUrlLoader urlLoader;
    @NotNull
    private final ScentGlobalCache globalCache;
    @NotNull
    private final ScentCrawlLoop crawlLoop;
    @NotNull
    private final ScrapeTaskV1Handler taskV1Handler;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Logger logger;

    public ScentApiConfiguration(@NotNull ExternalUrlLoader urlLoader, @NotNull ScentGlobalCache globalCache, @NotNull ScentCrawlLoop crawlLoop, @NotNull ScrapeTaskV1Handler taskV1Handler, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)urlLoader, (String)"urlLoader");
        Intrinsics.checkNotNullParameter((Object)globalCache, (String)"globalCache");
        Intrinsics.checkNotNullParameter((Object)crawlLoop, (String)"crawlLoop");
        Intrinsics.checkNotNullParameter((Object)taskV1Handler, (String)"taskV1Handler");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.urlLoader = urlLoader;
        this.globalCache = globalCache;
        this.crawlLoop = crawlLoop;
        this.taskV1Handler = taskV1Handler;
        this.conf = conf;
        this.logger = LogsKt.getLogger((Object)this);
    }

    @NotNull
    public ExternalUrlLoader getUrlLoader() {
        return this.urlLoader;
    }

    @NotNull
    public ScentGlobalCache getGlobalCache() {
        return this.globalCache;
    }

    @NotNull
    public ScentCrawlLoop getCrawlLoop() {
        return this.crawlLoop;
    }

    @NotNull
    public ScrapeTaskV1Handler getTaskV1Handler() {
        return this.taskV1Handler;
    }

    @NotNull
    public ImmutableConfig getConf() {
        return this.conf;
    }

    @Bean
    @NotNull
    public Module metricsModule() {
        MetricFilter filter = MetricFilters.INSTANCE.notContains("._.");
        return (Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false, filter);
    }

    @Bean
    @NotNull
    public RestTemplate getRestTemplate() {
        return new RestTemplate();
    }

    @PostConstruct
    public void initCrawlSeedLoader() {
        ExternalUrlLoader externalUrlLoader = this.getUrlLoader();
        CrawlSeedV3Loader crawlSeedV3Loader = externalUrlLoader instanceof CrawlSeedV3Loader ? (CrawlSeedV3Loader)externalUrlLoader : null;
        if (crawlSeedV3Loader != null) {
            crawlSeedV3Loader.setTaskV1Handler(this.getTaskV1Handler());
        }
    }

    @PostConstruct
    public void initializeDataCollectors() {
        String taskName = "SCRAPE";
        int priority = ScrapeTaskHandler.Companion.getDEFAULT_TASK_PRIORITY().getValue();
        this.logger.info("Adding data collector for " + taskName + " with priority " + priority + " ... | crawl loop: {}", (Object)this.getCrawlLoop());
        UrlFeederHelper helper = new UrlFeederHelper(this.getCrawlLoop().getUrlFeeder());
        UrlCacheCollector collector = helper.create(taskName, priority, this.getUrlLoader());
        collector.getLabels().add(taskName);
        this.logger.info("Data collector is added | {}", (Object)collector.toString());
    }
}

