/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller;

import ai.platon.scent.crawl.serialize.ScrapeRequestV1;
import ai.platon.scent.crawl.serialize.ScrapeResponse;
import ai.platon.scent.crawl.serialize.ScrapeStatusRequest;
import ai.platon.scent.rest.api.common.AuthGuard;
import ai.platon.scent.rest.api.common.Requests;
import ai.platon.scent.rest.api.common.VisitLimitException;
import ai.platon.scent.rest.api.service.UserService;
import ai.platon.scent.rest.api.service.billing.BillingService;
import ai.platon.scent.rest.api.service.v1.ScrapeServiceV1;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"api/x/a"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ.\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00142\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J*\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J*\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001b2\b\b\u0001\u0010\u0015\u001a\u00020\u00142\b\b\u0001\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u001a\u0010\u001e\u001a\u00020\u00142\b\b\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lai/platon/scent/rest/api/controller/AsyncScrapeControllerVS1;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "scrapeService", "Lai/platon/scent/rest/api/service/v1/ScrapeServiceV1;", "userService", "Lai/platon/scent/rest/api/service/UserService;", "billingService", "Lai/platon/scent/rest/api/service/billing/BillingService;", "(Lorg/springframework/context/ApplicationContext;Lai/platon/scent/rest/api/service/v1/ScrapeServiceV1;Lai/platon/scent/rest/api/service/UserService;Lai/platon/scent/rest/api/service/billing/BillingService;)V", "getApplicationContext", "()Lorg/springframework/context/ApplicationContext;", "getScrapeService", "()Lai/platon/scent/rest/api/service/v1/ScrapeServiceV1;", "getUserService", "()Lai/platon/scent/rest/api/service/UserService;", "getStatusById", "Lai/platon/scent/crawl/serialize/ScrapeResponse;", "id", "", "authToken", "debug", "", "httpRequest", "Ljakarta/servlet/http/HttpServletRequest;", "getStatusByIds", "", "ids", "getStatusByIdsByPost", "submit", "request", "Lai/platon/scent/crawl/serialize/ScrapeRequestV1;", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nAsyncScrapeControllerVS1.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncScrapeControllerVS1.kt\nai/platon/scent/rest/api/controller/AsyncScrapeControllerVS1\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1549#2:132\n1620#2,3:133\n1549#2:136\n1620#2,3:137\n1549#2:140\n1620#2,3:141\n1549#2:144\n1620#2,3:145\n*S KotlinDebug\n*F\n+ 1 AsyncScrapeControllerVS1.kt\nai/platon/scent/rest/api/controller/AsyncScrapeControllerVS1\n*L\n102#1:132\n102#1:133,3\n103#1:136\n103#1:137,3\n125#1:140\n125#1:141,3\n126#1:144\n126#1:145,3\n*E\n"})
public class AsyncScrapeControllerVS1 {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final ScrapeServiceV1 scrapeService;
    @NotNull
    private final UserService userService;
    @NotNull
    private final BillingService billingService;

    public AsyncScrapeControllerVS1(@NotNull ApplicationContext applicationContext, @NotNull ScrapeServiceV1 scrapeService, @NotNull UserService userService, @NotNull BillingService billingService) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)((Object)scrapeService), (String)"scrapeService");
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)billingService, (String)"billingService");
        this.applicationContext = applicationContext;
        this.scrapeService = scrapeService;
        this.userService = userService;
        this.billingService = billingService;
    }

    @NotNull
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @NotNull
    public ScrapeServiceV1 getScrapeService() {
        return this.scrapeService;
    }

    @NotNull
    public UserService getUserService() {
        return this.userService;
    }

    @PostMapping(value={"q"}, consumes={"application/json"}, produces={"application/json"})
    @NotNull
    public String submit(@RequestBody @NotNull ScrapeRequestV1 request, @NotNull HttpServletRequest httpRequest) throws VisitLimitException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        request.setRemoteAddr(Requests.INSTANCE.getRemoteIP(httpRequest));
        new AuthGuard(request.getAuthToken(), null, false, 6, null);
        this.getUserService().checkAuth(request.getAuthToken(), request.getRemoteAddr());
        this.billingService.checkAndRecordUsage(request.getAuthToken());
        return this.getScrapeService().submit(request);
    }

    @GetMapping(value={"status"}, consumes={"*/*"})
    @NotNull
    public ScrapeResponse getStatusById(@RequestParam @NotNull String id, @RequestParam @NotNull String authToken, @RequestParam(defaultValue="0") int debug, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        ScrapeStatusRequest request = new ScrapeStatusRequest(authToken, id, debug);
        new AuthGuard(request.getAuthToken(), null, false, 6, null);
        this.billingService.checkAndRecordUsage(authToken);
        ScrapeResponse response = this.getScrapeService().getStatus(request);
        if (debug <= 0) {
            response.setMessage(null);
        }
        return response;
    }

    @GetMapping(value={"statuses"}, consumes={"*/*"}, produces={"application/json"})
    @NotNull
    public List<ScrapeResponse> getStatusByIds(@RequestParam @NotNull String ids, @RequestParam @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        ScrapeStatusRequest it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        this.billingService.checkAndRecordUsage(authToken);
        Object object = new String[]{"|"};
        object = StringsKt.split$default((CharSequence)ids, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ScrapeStatusRequest(authToken, (String)it, 0, 4, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ScrapeStatusRequest)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getScrapeService().getStatus(it));
        }
        List responses = (List)destination$iv$iv;
        return responses;
    }

    @PostMapping(value={"statuses"}, consumes={"*/*"}, produces={"application/json"})
    @NotNull
    public List<ScrapeResponse> getStatusByIdsByPost(@RequestParam @NotNull String authToken, @RequestBody @NotNull String ids, @NotNull HttpServletRequest httpRequest) {
        ScrapeStatusRequest it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        this.billingService.checkAndRecordUsage(authToken);
        String ids0 = ((Object)StringsKt.trim((CharSequence)ids)).toString();
        String delimiter = StringsKt.contains$default((CharSequence)ids0, (CharSequence)"|", (boolean)false, (int)2, null) ? "|" : "\n";
        Object object = new String[]{delimiter};
        object = StringsKt.split$default((CharSequence)ids0, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        void var9_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ScrapeStatusRequest(authToken, (String)it, 0, 4, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ScrapeStatusRequest)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getScrapeService().getStatus(it));
        }
        List responses = (List)destination$iv$iv;
        return responses;
    }
}

