/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller;

import ai.platon.scent.rest.api.common.AuthGuard;
import ai.platon.scent.rest.api.service.billing.BillingService;
import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"billing"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001a\u0010\u000b\u001a\u00020\b2\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/platon/scent/rest/api/controller/BillingController;", "", "billingService", "Lai/platon/scent/rest/api/service/billing/BillingService;", "(Lai/platon/scent/rest/api/service/billing/BillingService;)V", "getUsage", "Lai/platon/scent/rest/api/service/billing/BillingService$UsageStats;", "authToken", "", "httpRequest", "Ljakarta/servlet/http/HttpServletRequest;", "resetUsage", "scent-rest"})
public class BillingController {
    @NotNull
    private final BillingService billingService;

    public BillingController(@NotNull BillingService billingService) {
        Intrinsics.checkNotNullParameter((Object)billingService, (String)"billingService");
        this.billingService = billingService;
    }

    @GetMapping(value={"api/usage"}, consumes={"*/*"}, produces={"application/json"})
    @NotNull
    public BillingService.UsageStats getUsage(@RequestParam @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        return this.billingService.getUsage(authToken);
    }

    @PostMapping(value={"reset"}, consumes={"*/*"}, produces={"application/json"})
    @NotNull
    public String resetUsage(@RequestParam @NotNull String authToken, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        new AuthGuard(authToken, null, false, 6, null);
        this.billingService.resetUsage(authToken);
        return "Usage reset successfully";
    }
}

