/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.ql.common.ResultSets;
import ai.platon.pulsar.ql.h2.utils.ResultSetUtils;
import ai.platon.pulsar.rest.api.common.NormXSQL;
import ai.platon.pulsar.rest.api.entities.ScrapeRequest;
import ai.platon.pulsar.rest.api.entities.ScrapeResponse;
import ai.platon.pulsar.skeleton.context.PulsarContext;
import ai.platon.pulsar.skeleton.crawl.PageEventHandlers;
import ai.platon.pulsar.skeleton.session.PulsarSession;
import ai.platon.scent.ql.h2.context.support.ScentH2Context;
import ai.platon.scent.rest.api.controller.pulsar.v30x.ScrapeHyperlinkV30x;
import ai.platon.scent.rest.api.controller.pulsar.v30x.XSQLScrapeHyperlinkV30x;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Instant;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.h2.jdbc.JdbcSQLException;
import org.h2.tools.SimpleResultSet;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0004\u001a\u00020\tH\u0002J\u0018\u0010+\u001a\u00020,2\u0006\u0010\u0004\u001a\u00020\t2\u0006\u0010/\u001a\u00020\rH\u0002R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0011X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00060"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/AbstractScrapeHyperlinkV30x;", "Lai/platon/scent/rest/api/controller/pulsar/v30x/ScrapeHyperlinkV30x;", "request", "Lai/platon/pulsar/rest/api/entities/ScrapeRequest;", "sql", "Lai/platon/pulsar/rest/api/common/NormXSQL;", "session", "Lai/platon/pulsar/skeleton/session/PulsarSession;", "uuid", "", "(Lai/platon/pulsar/rest/api/entities/ScrapeRequest;Lai/platon/pulsar/rest/api/common/NormXSQL;Lai/platon/pulsar/skeleton/session/PulsarSession;Ljava/lang/String;)V", "connectionPool", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ljava/sql/Connection;", "getConnectionPool", "()Ljava/util/concurrent/ArrayBlockingQueue;", "eventHandlers", "Lai/platon/pulsar/skeleton/crawl/PageEventHandlers;", "getEventHandlers", "()Lai/platon/pulsar/skeleton/crawl/PageEventHandlers;", "setEventHandlers", "(Lai/platon/pulsar/skeleton/crawl/PageEventHandlers;)V", "isCompleted", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lorg/slf4j/Logger;", "randomConnection", "getRandomConnection", "()Ljava/sql/Connection;", "getRequest", "()Lai/platon/pulsar/rest/api/entities/ScrapeRequest;", "getSession", "()Lai/platon/pulsar/skeleton/session/PulsarSession;", "getSql", "()Lai/platon/pulsar/rest/api/common/NormXSQL;", "sqlContext", "Lai/platon/scent/ql/h2/context/support/ScentH2Context;", "getSqlContext", "()Lai/platon/scent/ql/h2/context/support/ScentH2Context;", "complete", "", "page", "Lai/platon/pulsar/persist/WebPage;", "executeQuery", "Ljava/sql/ResultSet;", "response", "Lai/platon/pulsar/rest/api/entities/ScrapeResponse;", "conn", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nAbstractScrapeHyperlinkV30x.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractScrapeHyperlinkV30x.kt\nai/platon/scent/rest/api/controller/pulsar/v30x/AbstractScrapeHyperlinkV30x\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,106:1\n1#2:107\n17#3,6:108\n*S KotlinDebug\n*F\n+ 1 AbstractScrapeHyperlinkV30x.kt\nai/platon/scent/rest/api/controller/pulsar/v30x/AbstractScrapeHyperlinkV30x\n*L\n83#1:108,6\n*E\n"})
public abstract class AbstractScrapeHyperlinkV30x
extends ScrapeHyperlinkV30x {
    @NotNull
    private final ScrapeRequest request;
    @NotNull
    private final NormXSQL sql;
    @NotNull
    private final PulsarSession session;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicBoolean isCompleted;

    public AbstractScrapeHyperlinkV30x(@NotNull ScrapeRequest request, @NotNull NormXSQL sql, @NotNull PulsarSession session, @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        super(sql.getUrl(), uuid);
        this.request = request;
        this.sql = sql;
        this.session = session;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(XSQLScrapeHyperlinkV30x.class));
        this.isCompleted = new AtomicBoolean();
    }

    @NotNull
    public final ScrapeRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final NormXSQL getSql() {
        return this.sql;
    }

    @NotNull
    public final PulsarSession getSession() {
        return this.session;
    }

    @NotNull
    protected final ScentH2Context getSqlContext() {
        PulsarContext pulsarContext = this.session.getContext();
        Intrinsics.checkNotNull((Object)pulsarContext, (String)"null cannot be cast to non-null type ai.platon.scent.ql.h2.context.support.ScentH2Context");
        return (ScentH2Context)pulsarContext;
    }

    @NotNull
    protected final ArrayBlockingQueue<Connection> getConnectionPool() {
        return this.getSqlContext().getConnectionPool();
    }

    @NotNull
    protected final Connection getRandomConnection() {
        return this.getSqlContext().getRandomConnection();
    }

    @NotNull
    public abstract PageEventHandlers getEventHandlers();

    public abstract void setEventHandlers(@NotNull PageEventHandlers var1);

    @NotNull
    public ResultSet executeQuery() {
        return this.executeQuery(this.request, this.getResponse());
    }

    public void complete(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.getResponse().setId(this.getUuid());
        this.getResponse().setDone(true);
        this.getResponse().setFinishTime(Instant.now());
        if (this.isCompleted.compareAndSet(false, true)) {
            super.complete((Object)this.getResponse());
        }
    }

    @NotNull
    protected ResultSet executeQuery(@NotNull ScrapeRequest request, @NotNull ScrapeResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        SimpleResultSet simpleResultSet = ResultSets.newSimpleResultSet();
        Intrinsics.checkNotNullExpressionValue((Object)simpleResultSet, (String)"newSimpleResultSet(...)");
        ResultSet rs = (ResultSet)simpleResultSet;
        try {
            response.setStatusCode(200);
            rs = this.executeQuery(this.sql.getSql());
        }
        catch (JdbcSQLException e) {
            response.setStatusCode(417);
            this.logger.warn("Failed to execute sql #" + response.getId() + "{}", (Object)ExceptionsKt.brief$default((Throwable)e, null, null, (int)3, null));
        }
        catch (Throwable e) {
            response.setStatusCode(417);
            this.logger.warn("Failed to execute sql #" + response.getId() + "\n{}", (Object)ExceptionsKt.brief$default((Throwable)e, null, null, (int)3, null));
        }
        return rs;
    }

    private final ResultSet executeQuery(String sql) {
        ResultSet resultSet;
        Connection connection = this.getConnectionPool().poll();
        if (connection == null) {
            connection = this.getRandomConnection();
        }
        Connection connection2 = connection;
        ResultSet it = resultSet = this.executeQuery(sql, connection2);
        boolean bl = false;
        this.getConnectionPool().offer(connection2);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResultSet executeQuery(String sql, Connection conn) {
        Statement statement;
        ResultSet result = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Statement statement2 = statement = conn.createStatement(1005, 1007);
        if (statement2 != null) {
            Intrinsics.checkNotNull((Object)statement2);
            AutoCloseable autoCloseable = statement;
            Throwable throwable = null;
            try {
                block15: {
                    Statement st = (Statement)autoCloseable;
                    boolean bl2 = false;
                    try {
                        ResultSet resultSet;
                        ResultSet resultSet2 = resultSet = st.executeQuery(sql);
                        if (resultSet2 == null) break block15;
                        Intrinsics.checkNotNull((Object)resultSet2);
                        AutoCloseable autoCloseable2 = resultSet;
                        Throwable throwable2 = null;
                        try {
                            ResultSet rs = (ResultSet)autoCloseable2;
                            boolean bl3 = false;
                            result = ResultSetUtils.copyResultSet$default((ResultSetUtils)ResultSetUtils.INSTANCE, (ResultSet)rs, (int)0, (int)2, null);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                        }
                    }
                    catch (JdbcSQLException e) {
                        String string = e.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        String message = string;
                        if (StringsKt.contains$default((CharSequence)message, (CharSequence)"Syntax error in SQL statement", (boolean)false, (int)2, null)) {
                            this.getResponse().setStatusCode(400);
                            this.logger.warn("Syntax error in SQL statement #" + this.getResponse().getId() + ">>>\n{}\n<<<", (Object)e.getSQL());
                        }
                        this.getResponse().setStatusCode(417);
                        if (!AppContext.INSTANCE.isActive()) break block15;
                        this.logger.warn("Failed to execute scrape task #" + this.getResponse().getId(), (Throwable)e);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        long millis = System.currentTimeMillis() - start$iv;
        ResultSet resultSet = result;
        if (resultSet == null) {
            ResultSet resultSet3 = ResultSets.newResultSet();
            resultSet = resultSet3;
            Intrinsics.checkNotNullExpressionValue((Object)resultSet3, (String)"newResultSet(...)");
        }
        return resultSet;
    }
}

