/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x;

import ai.platon.pulsar.rest.api.entities.CommandRequest;
import ai.platon.pulsar.rest.api.entities.CommandStatus;
import ai.platon.pulsar.rest.api.entities.PromptRequest;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.ChatServiceV30x;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.CommandServiceV30x;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.ConversationServiceV30x;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.ExtractServiceV30x;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Deprecated(message="AiController is deprecated for now, please use CommandController/ConversationController/ExtractionController instead.")
@RestController
@CrossOrigin
@RequestMapping(value={"api/ai"}, consumes={"*/*"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u001a\u001a\u00020\u00112\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0017J\u0012\u0010\u001d\u001a\u00020\u00122\b\b\u0001\u0010\u001e\u001a\u00020\u0011H\u0017J\u0012\u0010\u001f\u001a\u00020\u00112\b\b\u0001\u0010 \u001a\u00020\u0011H\u0017J\u0012\u0010!\u001a\u00020\u00112\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0017J\u0012\u0010\"\u001a\u00020\u00112\b\b\u0001\u0010 \u001a\u00020\u0011H\u0017J\u0012\u0010#\u001a\u00020\u00112\b\b\u0001\u0010 \u001a\u00020\u0011H\u0017J\u0012\u0010$\u001a\u00020\u00112\b\b\u0001\u0010 \u001a\u00020\u0011H\u0017J\u0012\u0010%\u001a\u00020\u00122\b\b\u0001\u0010\u001b\u001a\u00020&H\u0017J\u0012\u0010'\u001a\u00020\u00122\b\b\u0001\u0010\u001b\u001a\u00020&H\u0017J\u0012\u0010(\u001a\u00020\u00112\b\b\u0001\u0010\u001b\u001a\u00020\u0011H\u0017J\u0012\u0010)\u001a\u00020\u00112\b\b\u0001\u0010\u001b\u001a\u00020\u0011H\u0017J\u0012\u0010*\u001a\u00020\u00112\b\b\u0001\u0010\u001b\u001a\u00020\u0011H\u0017J\u0012\u0010+\u001a\u00020\u00112\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0017J\u0012\u0010,\u001a\u00020\u00112\b\b\u0001\u0010\u001b\u001a\u00020\u001cH\u0017R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/AiControllerV30x;", "", "commandService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/CommandServiceV30x;", "conversationService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x;", "chatService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ChatServiceV30x;", "extractService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ExtractServiceV30x;", "(Lai/platon/scent/rest/api/controller/pulsar/v30x/service/CommandServiceV30x;Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x;Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ChatServiceV30x;Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ExtractServiceV30x;)V", "getChatService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ChatServiceV30x;", "getCommandService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/CommandServiceV30x;", "commandStatusCache", "Ljava/util/concurrent/ConcurrentSkipListMap;", "", "Lai/platon/pulsar/rest/api/entities/CommandStatus;", "getConversationService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x;", "executor", "Ljava/util/concurrent/ExecutorService;", "getExtractService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ExtractServiceV30x;", "markdownResultCache", "chatAboutPageBackward", "request", "Lai/platon/pulsar/rest/api/entities/PromptRequest;", "commandStatus", "id", "conversations", "prompt", "conversationsAbout", "conversationsBackward", "conversationsPost", "conversationsPostBackward", "executeCommand", "Lai/platon/pulsar/rest/api/entities/CommandRequest;", "executeCommandBackward", "executeCommandWithPlainLanguage", "executeCommandWithPlainLanguageAsync", "executeCommandWithPlainLanguageBackward", "executeExtraction", "executeExtractionBackward", "scent-rest"})
public class AiControllerV30x {
    @NotNull
    private final CommandServiceV30x commandService;
    @NotNull
    private final ConversationServiceV30x conversationService;
    @NotNull
    private final ChatServiceV30x chatService;
    @NotNull
    private final ExtractServiceV30x extractService;
    @NotNull
    private final ConcurrentSkipListMap<String, CommandStatus> commandStatusCache;
    @NotNull
    private final ConcurrentSkipListMap<String, String> markdownResultCache;
    @NotNull
    private final ExecutorService executor;

    public AiControllerV30x(@NotNull CommandServiceV30x commandService, @NotNull ConversationServiceV30x conversationService, @NotNull ChatServiceV30x chatService, @NotNull ExtractServiceV30x extractService) {
        Intrinsics.checkNotNullParameter((Object)commandService, (String)"commandService");
        Intrinsics.checkNotNullParameter((Object)conversationService, (String)"conversationService");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)extractService, (String)"extractService");
        this.commandService = commandService;
        this.conversationService = conversationService;
        this.chatService = chatService;
        this.extractService = extractService;
        this.commandStatusCache = new ConcurrentSkipListMap();
        this.markdownResultCache = new ConcurrentSkipListMap();
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newCachedThreadPool(...)");
        this.executor = executorService;
    }

    @NotNull
    public CommandServiceV30x getCommandService() {
        return this.commandService;
    }

    @NotNull
    public ConversationServiceV30x getConversationService() {
        return this.conversationService;
    }

    @NotNull
    public ChatServiceV30x getChatService() {
        return this.chatService;
    }

    @NotNull
    public ExtractServiceV30x getExtractService() {
        return this.extractService;
    }

    @GetMapping(value={"/conversations"})
    @NotNull
    public String conversations(@RequestParam(value="prompt") @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return this.getChatService().chat(prompt);
    }

    @PostMapping(value={"/conversations"})
    @NotNull
    public String conversationsPost(@RequestBody @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return this.getChatService().chat(prompt);
    }

    @PostMapping(value={"/conversations/about"})
    @NotNull
    public String conversationsAbout(@RequestBody @NotNull PromptRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.getChatService().chat(request);
    }

    @PostMapping(value={"/extractions"})
    @NotNull
    public String executeExtraction(@RequestBody @NotNull PromptRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.getExtractService().extract(request);
    }

    @PostMapping(value={"/commands"})
    @NotNull
    public CommandStatus executeCommand(@RequestBody @NotNull CommandRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.getCommandService().executeCommand(request);
    }

    @PostMapping(value={"/commands"}, consumes={"text/plain"}, produces={"text/markdown"})
    @NotNull
    public String executeCommandWithPlainLanguage(@RequestBody @NotNull String request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CommandStatus response = this.getCommandService().executeCommand(request);
        return this.getConversationService().convertResponseToMarkdown(response);
    }

    @PostMapping(value={"/commands/async"}, consumes={"text/plain"}, produces={"text/markdown"})
    @NotNull
    public String executeCommandWithPlainLanguageAsync(@RequestBody @NotNull String request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        ((Map)this.commandStatusCache).put(id, new CommandStatus(id, 0, null, false, 0, 0, null, null, null, null, 1022, null));
        this.executor.submit(() -> AiControllerV30x.executeCommandWithPlainLanguageAsync$lambda$0(this, request, id));
        return id;
    }

    @GetMapping(value={"/commands/{id}/status"}, produces={"text/event-stream"})
    @NotNull
    public CommandStatus commandStatus(@PathVariable @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CommandStatus commandStatus = this.commandStatusCache.get(id);
        if (commandStatus == null) {
            commandStatus = CommandStatus.Companion.notFound(id);
        }
        return commandStatus;
    }

    @PostMapping(value={"/extract"})
    @NotNull
    public String executeExtractionBackward(@RequestBody @NotNull PromptRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.executeExtraction(request);
    }

    @PostMapping(value={"/command"})
    @NotNull
    public CommandStatus executeCommandBackward(@RequestBody @NotNull CommandRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.executeCommand(request);
    }

    @PostMapping(value={"/command"}, consumes={"text/plain"}, produces={"text/markdown"})
    @NotNull
    public String executeCommandWithPlainLanguageBackward(@RequestBody @NotNull String request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.executeCommandWithPlainLanguage(request);
    }

    @GetMapping(value={"/chat"})
    @NotNull
    public String conversationsBackward(@RequestParam(value="prompt") @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return this.conversations(prompt);
    }

    @PostMapping(value={"/chat"})
    @NotNull
    public String conversationsPostBackward(@RequestBody @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return this.conversationsPost(prompt);
    }

    @PostMapping(value={"/chat-about"})
    @NotNull
    public String chatAboutPageBackward(@RequestBody @NotNull PromptRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.conversationsAbout(request);
    }

    private static final void executeCommandWithPlainLanguageAsync$lambda$0(AiControllerV30x this$0, String $request, String $id) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        CommandStatus response = this$0.getCommandService().executeCommand($request);
        ((Map)this$0.commandStatusCache).put($id, response);
        ((Map)this$0.markdownResultCache).put($id, this$0.getConversationService().convertResponseToMarkdown(response));
    }
}

