/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x;

import ai.platon.pulsar.rest.api.entities.CommandRequest;
import ai.platon.pulsar.rest.api.entities.CommandResult;
import ai.platon.pulsar.rest.api.entities.CommandStatus;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.CommandServiceV30x;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.ConversationServiceV30x;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@CrossOrigin
@RequestMapping(value={"api/commands"}, consumes={"*/*"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J\u001e\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00140\u00132\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0017J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\b\b\u0001\u0010\u0019\u001a\u00020\u000f2\b\b\u0001\u0010\u001a\u001a\u00020\u000fH\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/CommandControllerV30x;", "", "conversationService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x;", "commandService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/CommandServiceV30x;", "(Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x;Lai/platon/scent/rest/api/controller/pulsar/v30x/service/CommandServiceV30x;)V", "getCommandService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/CommandServiceV30x;", "getConversationService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x;", "getResult", "Lorg/springframework/http/ResponseEntity;", "Lai/platon/pulsar/rest/api/entities/CommandResult;", "id", "", "getStatus", "Lai/platon/pulsar/rest/api/entities/CommandStatus;", "streamEvents", "Lreactor/core/publisher/Flux;", "Lorg/springframework/http/codec/ServerSentEvent;", "submitCommand", "request", "Lai/platon/pulsar/rest/api/entities/CommandRequest;", "submitPlainCommand", "plainCommand", "mode", "scent-rest"})
public class CommandControllerV30x {
    @NotNull
    private final ConversationServiceV30x conversationService;
    @NotNull
    private final CommandServiceV30x commandService;

    public CommandControllerV30x(@NotNull ConversationServiceV30x conversationService, @NotNull CommandServiceV30x commandService) {
        Intrinsics.checkNotNullParameter((Object)conversationService, (String)"conversationService");
        Intrinsics.checkNotNullParameter((Object)commandService, (String)"commandService");
        this.conversationService = conversationService;
        this.commandService = commandService;
    }

    @NotNull
    public ConversationServiceV30x getConversationService() {
        return this.conversationService;
    }

    @NotNull
    public CommandServiceV30x getCommandService() {
        return this.commandService;
    }

    @PostMapping
    @NotNull
    public ResponseEntity<Object> submitCommand(@RequestBody @NotNull CommandRequest request) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = request.getMode();
        if (Intrinsics.areEqual((Object)string, (Object)"sync")) {
            ResponseEntity responseEntity2 = ResponseEntity.ok((Object)this.getCommandService().executeSync(request));
            responseEntity = responseEntity2;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"ok(...)");
        } else if (Intrinsics.areEqual((Object)string, (Object)"async")) {
            ResponseEntity responseEntity3 = ResponseEntity.ok((Object)this.getCommandService().submitAsync(request));
            responseEntity = responseEntity3;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity3, (String)"ok(...)");
        } else {
            ResponseEntity responseEntity4 = ResponseEntity.badRequest().body((Object)("Invalid mode: " + request.getMode()));
            responseEntity = responseEntity4;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity4, (String)"body(...)");
        }
        return responseEntity;
    }

    @PostMapping(value={"/plain"})
    @NotNull
    public ResponseEntity<Object> submitPlainCommand(@RequestBody @NotNull String plainCommand, @RequestParam(name="mode", defaultValue="sync") @NotNull String mode) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)plainCommand, (String)"plainCommand");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        CommandRequest commandRequest = this.getConversationService().normalizePlainCommand(plainCommand);
        if (commandRequest == null) {
            ResponseEntity responseEntity2 = ResponseEntity.badRequest().body((Object)("Invalid plain command: " + plainCommand));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"body(...)");
            return responseEntity2;
        }
        CommandRequest request = commandRequest;
        String string = mode.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        request.setMode(string);
        String string2 = request.getMode();
        if (Intrinsics.areEqual((Object)string2, (Object)"sync")) {
            ResponseEntity responseEntity3 = ResponseEntity.ok((Object)this.getCommandService().executeSync(request));
            responseEntity = responseEntity3;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity3, (String)"ok(...)");
        } else if (Intrinsics.areEqual((Object)string2, (Object)"async")) {
            ResponseEntity responseEntity4 = ResponseEntity.ok((Object)this.getCommandService().submitAsync(request));
            responseEntity = responseEntity4;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity4, (String)"ok(...)");
        } else {
            ResponseEntity responseEntity5 = ResponseEntity.badRequest().body((Object)("Invalid mode: " + request.getMode()));
            responseEntity = responseEntity5;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity5, (String)"body(...)");
        }
        return responseEntity;
    }

    @GetMapping(value={"/{id}/status"})
    @NotNull
    public ResponseEntity<CommandStatus> getStatus(@PathVariable @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.getCommandService().getStatus(id));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @GetMapping(value={"/{id}/result"})
    @NotNull
    public ResponseEntity<CommandResult> getResult(@PathVariable @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.getCommandService().getResult(id));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @GetMapping(value={"/{id}/stream"}, produces={"text/event-stream"})
    @NotNull
    public Flux<ServerSentEvent<CommandStatus>> streamEvents(@PathVariable @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getCommandService().streamEvents(id);
    }
}

