/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x;

import ai.platon.pulsar.rest.api.entities.PromptRequest;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.ChatServiceV30x;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@CrossOrigin
@RequestMapping(value={"api/conversations"}, consumes={"*/*"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\f\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\tH\u0017J\u0012\u0010\u000e\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\tH\u0017J\u0012\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\r\u001a\u00020\tH\u0017J\u0012\u0010\u0011\u001a\u00020\t2\b\b\u0001\u0010\u0012\u001a\u00020\tH\u0017J\u0012\u0010\u0013\u001a\u00020\t2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u0012\u0010\u0016\u001a\u00020\t2\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0017J\u0012\u0010\u0017\u001a\u00020\t2\b\b\u0001\u0010\u0012\u001a\u00020\tH\u0017J\u0012\u0010\u0018\u001a\u00020\t2\b\b\u0001\u0010\u0012\u001a\u00020\tH\u0017J\u0012\u0010\u0019\u001a\u00020\t2\b\b\u0001\u0010\u0012\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/ConversationControllerV30x;", "", "chatService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ChatServiceV30x;", "(Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ChatServiceV30x;)V", "getChatService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ChatServiceV30x;", "conversationsCache", "Ljava/util/concurrent/ConcurrentSkipListMap;", "", "executor", "Ljava/util/concurrent/ExecutorService;", "conversationResult", "id", "conversationStatus", "conversationStream", "Lorg/springframework/web/servlet/mvc/method/annotation/SseEmitter;", "conversations", "prompt", "conversationsAbout", "request", "Lai/platon/pulsar/rest/api/entities/PromptRequest;", "conversationsAboutAsync", "conversationsAsync", "conversationsPost", "conversationsPostAsync", "scent-rest"})
public class ConversationControllerV30x {
    @NotNull
    private final ChatServiceV30x chatService;
    @NotNull
    private final ConcurrentSkipListMap<String, String> conversationsCache;
    @NotNull
    private final ExecutorService executor;

    public ConversationControllerV30x(@NotNull ChatServiceV30x chatService) {
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        this.chatService = chatService;
        this.conversationsCache = new ConcurrentSkipListMap();
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newCachedThreadPool(...)");
        this.executor = executorService;
    }

    @NotNull
    public ChatServiceV30x getChatService() {
        return this.chatService;
    }

    @GetMapping(value={""})
    @NotNull
    public String conversations(@RequestParam(value="prompt") @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return this.getChatService().chat(prompt);
    }

    @GetMapping(value={"/async"})
    @NotNull
    public String conversationsAsync(@RequestParam(value="prompt") @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        this.executor.submit(() -> ConversationControllerV30x.conversationsAsync$lambda$0(this, id, prompt));
        return id;
    }

    @PostMapping(value={""})
    @NotNull
    public String conversationsPost(@RequestBody @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return this.getChatService().chat(prompt);
    }

    @PostMapping(value={"/async"})
    @NotNull
    public String conversationsPostAsync(@RequestBody @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        this.executor.submit(() -> ConversationControllerV30x.conversationsPostAsync$lambda$1(this, id, prompt));
        return id;
    }

    @PostMapping(value={"/about"})
    @NotNull
    public String conversationsAbout(@RequestBody @NotNull PromptRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.getChatService().chat(request);
    }

    @PostMapping(value={"/about/async"})
    @NotNull
    public String conversationsAboutAsync(@RequestBody @NotNull PromptRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        this.executor.submit(() -> ConversationControllerV30x.conversationsAboutAsync$lambda$2(this, id, request));
        return id;
    }

    @GetMapping(value={"/{id}"})
    @NotNull
    public String conversationResult(@PathVariable @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.conversationsCache.get(id);
        if (object == null) {
            object = "No result found for id: " + id;
        }
        return object;
    }

    @GetMapping(value={"/{id}/status"})
    @NotNull
    public String conversationStatus(@PathVariable @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.conversationsCache.containsKey(id) ? "Processing" : "Completed";
    }

    @GetMapping(value={"/{id}/stream"})
    @NotNull
    public SseEmitter conversationStream(@PathVariable @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SseEmitter emitter = new SseEmitter();
        this.executor.submit(() -> ConversationControllerV30x.conversationStream$lambda$3(this, id, emitter));
        return emitter;
    }

    private static final void conversationsAsync$lambda$0(ConversationControllerV30x this$0, String $id, String $prompt) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        Intrinsics.checkNotNullParameter((Object)$prompt, (String)"$prompt");
        ((Map)this$0.conversationsCache).put($id, this$0.getChatService().chat($prompt));
    }

    private static final void conversationsPostAsync$lambda$1(ConversationControllerV30x this$0, String $id, String $prompt) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        Intrinsics.checkNotNullParameter((Object)$prompt, (String)"$prompt");
        ((Map)this$0.conversationsCache).put($id, this$0.getChatService().chat($prompt));
    }

    private static final void conversationsAboutAsync$lambda$2(ConversationControllerV30x this$0, String $id, PromptRequest $request) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        ((Map)this$0.conversationsCache).put($id, this$0.getChatService().chat($request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void conversationStream$lambda$3(ConversationControllerV30x this$0, String $id, SseEmitter $emitter) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        Intrinsics.checkNotNullParameter((Object)$emitter, (String)"$emitter");
        try {
            String result = this$0.conversationsCache.get($id);
            if (result != null) {
                $emitter.send((Object)result);
            } else {
                $emitter.send((Object)("No result found for id: " + $id));
            }
        }
        catch (Exception e) {
            $emitter.completeWithError((Throwable)e);
        }
        finally {
            $emitter.complete();
        }
    }
}

