/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x;

import ai.platon.pulsar.rest.api.entities.PromptRequest;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.ExtractServiceV30x;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@CrossOrigin
@RequestMapping(value={"api/extractions"}, consumes={"*/*"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\f\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0012\u0010\u000f\u001a\u00020\u000b2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0012\u0010\u0010\u001a\u00020\u000b2\b\b\u0001\u0010\u0011\u001a\u00020\u000bH\u0017J\u0012\u0010\u0012\u001a\u00020\u000b2\b\b\u0001\u0010\u0011\u001a\u00020\u000bH\u0017J\u0012\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0011\u001a\u00020\u000bH\u0017R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/ExtractionControllerV30x;", "", "extractService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ExtractServiceV30x;", "(Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ExtractServiceV30x;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "getExtractService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ExtractServiceV30x;", "extractionsCache", "Ljava/util/concurrent/ConcurrentSkipListMap;", "", "executeExtraction", "request", "Lai/platon/pulsar/rest/api/entities/PromptRequest;", "executeExtractionAsync", "extractionResult", "uuid", "extractionStatus", "extractionStream", "Lorg/springframework/web/servlet/mvc/method/annotation/SseEmitter;", "scent-rest"})
public class ExtractionControllerV30x {
    @NotNull
    private final ExtractServiceV30x extractService;
    @NotNull
    private final ConcurrentSkipListMap<String, String> extractionsCache;
    @NotNull
    private final ExecutorService executor;

    public ExtractionControllerV30x(@NotNull ExtractServiceV30x extractService) {
        Intrinsics.checkNotNullParameter((Object)extractService, (String)"extractService");
        this.extractService = extractService;
        this.extractionsCache = new ConcurrentSkipListMap();
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newCachedThreadPool(...)");
        this.executor = executorService;
    }

    @NotNull
    public ExtractServiceV30x getExtractService() {
        return this.extractService;
    }

    @PostMapping(value={""})
    @NotNull
    public String executeExtraction(@RequestBody @NotNull PromptRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.getExtractService().extract(request);
    }

    @PostMapping(value={"/async"})
    @NotNull
    public String executeExtractionAsync(@RequestBody @NotNull PromptRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String uuid = string;
        this.executor.submit(() -> ExtractionControllerV30x.executeExtractionAsync$lambda$0(this, uuid, request));
        return uuid;
    }

    @GetMapping(value={"/{uuid}"})
    @NotNull
    public String extractionResult(@PathVariable @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        String string = this.extractionsCache.get(uuid);
        if (string == null) {
            string = "Extraction not found";
        }
        return string;
    }

    @GetMapping(value={"/{uuid}/status"})
    @NotNull
    public String extractionStatus(@PathVariable @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        String string = this.extractionsCache.get(uuid);
        if (string == null) {
            string = "Extraction not found";
        }
        return string;
    }

    @GetMapping(value={"/{uuid}/stream"})
    @NotNull
    public SseEmitter extractionStream(@PathVariable @NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        SseEmitter emitter = new SseEmitter();
        this.executor.submit(() -> ExtractionControllerV30x.extractionStream$lambda$1(this, uuid, emitter));
        return emitter;
    }

    private static final void executeExtractionAsync$lambda$0(ExtractionControllerV30x this$0, String $uuid, PromptRequest $request) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$uuid, (String)"$uuid");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        ((Map)this$0.extractionsCache).put($uuid, this$0.getExtractService().extract($request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void extractionStream$lambda$1(ExtractionControllerV30x this$0, String $uuid, SseEmitter $emitter) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$uuid, (String)"$uuid");
        Intrinsics.checkNotNullParameter((Object)$emitter, (String)"$emitter");
        while (this$0.extractionsCache.containsKey($uuid)) {
            try {
                String result = this$0.extractionsCache.get($uuid);
                if (result != null) {
                    $emitter.send((Object)result);
                    continue;
                }
                $emitter.send((Object)"Extraction not found");
            }
            catch (Exception e) {
                $emitter.send((Object)("Error: " + e.getMessage()));
            }
            finally {
                $emitter.complete();
            }
        }
    }
}

