/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x;

import ai.platon.pulsar.rest.api.entities.ScrapeRequest;
import ai.platon.pulsar.rest.api.entities.ScrapeResponse;
import ai.platon.pulsar.rest.api.entities.ScrapeStatusRequest;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.ScrapeServiceV30x;
import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@CrossOrigin
@RequestMapping(value={"api/x"}, consumes={"*/*"}, produces={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\f2\b\b\u0003\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\u001a\u0010\u0014\u001a\u00020\u00112\b\b\u0001\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001a\u0010\r\u001a\u00020\u00112\b\b\u0001\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001e\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00180\u00172\b\b\u0001\u0010\u0019\u001a\u00020\u0013H\u0017J\u0012\u0010\u001a\u001a\u00020\u00132\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/ScrapeControllerV30x;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "scrapeService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ScrapeServiceV30x;", "(Lorg/springframework/context/ApplicationContext;Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ScrapeServiceV30x;)V", "getApplicationContext", "()Lorg/springframework/context/ApplicationContext;", "getScrapeService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ScrapeServiceV30x;", "count", "", "status", "httpRequest", "Ljakarta/servlet/http/HttpServletRequest;", "execute", "Lai/platon/pulsar/rest/api/entities/ScrapeResponse;", "sql", "", "getStatus", "uuid", "streamEvents", "Lreactor/core/publisher/Flux;", "Lorg/springframework/http/codec/ServerSentEvent;", "id", "submitJob", "scent-rest"})
public class ScrapeControllerV30x {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final ScrapeServiceV30x scrapeService;

    public ScrapeControllerV30x(@NotNull ApplicationContext applicationContext, @NotNull ScrapeServiceV30x scrapeService) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)scrapeService, (String)"scrapeService");
        this.applicationContext = applicationContext;
        this.scrapeService = scrapeService;
    }

    @NotNull
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @NotNull
    public ScrapeServiceV30x getScrapeService() {
        return this.scrapeService;
    }

    @PostMapping(value={"/e"})
    @NotNull
    public ScrapeResponse execute(@RequestBody @NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return this.getScrapeService().executeQuery(new ScrapeRequest(sql));
    }

    @PostMapping(value={"s"})
    @NotNull
    public String submitJob(@RequestBody @NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return this.getScrapeService().submitJob(new ScrapeRequest(sql));
    }

    @GetMapping(value={"c"}, consumes={"*/*"})
    public int count(@RequestParam(value="status", required=false) int status, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        return this.getScrapeService().count(status);
    }

    public static /* synthetic */ int count$default(ScrapeControllerV30x scrapeControllerV30x, int n, HttpServletRequest httpServletRequest, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: count");
        }
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return scrapeControllerV30x.count(n, httpServletRequest);
    }

    @GetMapping(value={"status"}, consumes={"*/*"}, produces={"application/json"})
    @NotNull
    public ScrapeResponse status(@RequestParam(value="uuid") @NotNull String uuid, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        ScrapeStatusRequest request = new ScrapeStatusRequest(uuid);
        return this.getScrapeService().getStatus(request);
    }

    @GetMapping(value={"/{id}/status"}, consumes={"*/*"}, produces={"application/json"})
    @NotNull
    public ScrapeResponse getStatus(@PathVariable(value="id") @NotNull String uuid, @NotNull HttpServletRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        ScrapeStatusRequest request = new ScrapeStatusRequest(uuid);
        return this.getScrapeService().getStatus(request);
    }

    @GetMapping(value={"/{id}/stream"}, produces={"text/event-stream"})
    @NotNull
    public Flux<ServerSentEvent<ScrapeResponse>> streamEvents(@PathVariable @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getScrapeService().streamEvents(id);
    }
}

