/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x.service;

import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.rest.api.entities.PromptRequest;
import ai.platon.pulsar.skeleton.common.options.LoadOptions;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.LoadServiceV30x;
import ai.platon.scent.skeleton.ScentSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ChatServiceV30x;", "", "session", "Lai/platon/scent/skeleton/ScentSession;", "loadService", "Lai/platon/scent/rest/api/controller/pulsar/v30x/service/LoadServiceV30x;", "(Lai/platon/scent/skeleton/ScentSession;Lai/platon/scent/rest/api/controller/pulsar/v30x/service/LoadServiceV30x;)V", "getLoadService", "()Lai/platon/scent/rest/api/controller/pulsar/v30x/service/LoadServiceV30x;", "getSession", "()Lai/platon/scent/skeleton/ScentSession;", "chat", "", "request", "Lai/platon/pulsar/rest/api/entities/PromptRequest;", "prompt", "scent-rest"})
public class ChatServiceV30x {
    @NotNull
    private final ScentSession session;
    @NotNull
    private final LoadServiceV30x loadService;

    public ChatServiceV30x(@NotNull ScentSession session, @NotNull LoadServiceV30x loadService) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)loadService, (String)"loadService");
        this.session = session;
        this.loadService = loadService;
    }

    @NotNull
    public ScentSession getSession() {
        return this.session;
    }

    @NotNull
    public LoadServiceV30x getLoadService() {
        return this.loadService;
    }

    @NotNull
    public String chat(@NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return this.getSession().chat(prompt).getContent();
    }

    @NotNull
    public String chat(@NotNull PromptRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String[] stringArray = new String[]{request.getArgs(), "-refresh"};
        request.setArgs(LoadOptions.Companion.mergeArgs$default((LoadOptions.Companion)LoadOptions.Companion, (String[])stringArray, null, (int)2, null));
        stringArray = this.getLoadService().loadDocument(request);
        WebPage page = (WebPage)stringArray.component1();
        FeaturedDocument document = (FeaturedDocument)stringArray.component2();
        String prompt = request.getPrompt();
        CharSequence charSequence = prompt;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return "\nHi, I am PulsarRPA! \n\n\ud83d\udc96 PulsarRPA: The AI-Powered, Lightning-Fast Browser Automation Solution! \ud83d\udc96\n\n\u2728 Key Capabilities:\n* \ud83e\udd16 AI Integration with LLMs \u2013 Smarter automation powered by large language models\n* \u26a1 Ultra-Fast Automation \u2013 Coroutine-safe browser automation with spider-level crawling performance\n* \ud83e\udde0 Web Understanding \u2013 Deep comprehension of dynamic web content\n* \ud83d\udcca Data Extraction APIs \u2013 Powerful tools to extract structured data effortlessly\n\nWhat can I do for you today?\n";
        }
        return page.getProtocolStatus().isSuccess() ? this.getSession().chat(prompt, document.getText()).getContent() : page.getProtocolStatus().toString();
    }
}

