/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x.service;

import ai.platon.pulsar.common.LinkExtractors;
import ai.platon.pulsar.common.ai.llm.PromptTemplate;
import ai.platon.pulsar.common.ai.llm.PromptTemplateLoader;
import ai.platon.pulsar.common.serialize.json.JSONExtractor;
import ai.platon.pulsar.common.serialize.json.JacksonKt;
import ai.platon.pulsar.common.urls.URLUtils;
import ai.platon.pulsar.rest.api.entities.CommandRequest;
import ai.platon.pulsar.rest.api.entities.CommandStatus;
import ai.platon.pulsar.skeleton.session.PulsarSession;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x;", "", "session", "Lai/platon/pulsar/skeleton/session/PulsarSession;", "(Lai/platon/pulsar/skeleton/session/PulsarSession;)V", "resource", "", "getResource", "()Ljava/lang/String;", "getSession", "()Lai/platon/pulsar/skeleton/session/PulsarSession;", "convertPlainCommandToJSON", "plainCommand", "url", "convertResponseToMarkdown", "status", "Lai/platon/pulsar/rest/api/entities/CommandStatus;", "jsonResponse", "normalizePlainCommand", "Lai/platon/pulsar/rest/api/entities/CommandRequest;", "request", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nConversationServiceV30x.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversationServiceV30x.kt\nai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n58#2:92\n51#2:93\n1#3:94\n*S KotlinDebug\n*F\n+ 1 ConversationServiceV30x.kt\nai/platon/scent/rest/api/controller/pulsar/v30x/service/ConversationServiceV30x\n*L\n45#1:92\n45#1:93\n*E\n"})
public class ConversationServiceV30x {
    @NotNull
    private final PulsarSession session;
    @NotNull
    private final String resource;

    public ConversationServiceV30x(@NotNull PulsarSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.resource = "prompts/api/request/command/convert_response_to_markdown_prompt.md";
    }

    @NotNull
    public PulsarSession getSession() {
        return this.session;
    }

    @Nullable
    public CommandRequest normalizePlainCommand(@NotNull String request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (StringsKt.isBlank((CharSequence)request)) {
            return null;
        }
        Set urls = LinkExtractors.fromText((String)request);
        if (urls.isEmpty()) {
            return null;
        }
        String url = (String)CollectionsKt.first((Iterable)urls);
        String json = this.convertPlainCommandToJSON(request, url);
        CharSequence charSequence = json;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        ObjectMapper $this$readValue$iv = JacksonKt.pulsarObjectMapper();
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        CommandRequest request2 = (CommandRequest)$this$readValue$iv.readValue(json, (TypeReference)new TypeReference<CommandRequest>(){});
        request2.setUrl(url);
        return request2;
    }

    @Nullable
    public String convertPlainCommandToJSON(@NotNull String plainCommand, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)plainCommand, (String)"plainCommand");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (!URLUtils.isStandard((String)url)) {
            boolean $i$a$-require-ConversationServiceV30x$convertPlainCommandToJSON$22 = false;
            String $i$a$-require-ConversationServiceV30x$convertPlainCommandToJSON$22 = "URL must not be blank";
            throw new IllegalArgumentException($i$a$-require-ConversationServiceV30x$convertPlainCommandToJSON$22.toString());
        }
        String processedRequest = StringsKt.replace$default((String)plainCommand, (String)url, (String)"{PLACEHOLDER_URL}", (boolean)false, (int)4, null);
        String resource = "prompts/api/request/command/api_request_plain_command_conversion_prompt.md";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"{PLACEHOLDER_REQUEST_JSON_COMMAND_TEMPLATE}", (Object)"\n{\n  \"url\": \"{PLACEHOLDER_URL}\",\n  \"onBrowserLaunchedActions\": [\n    \"clear browser cookies\",\n    \"navigate to the home page\", \n    \"click a random link\"\n  ],\n  \"onPageReadyActions\": [\n    \"scroll to the middle of the page\",\n    \"scroll to the top of the page\"\n  ],\n  \"pageSummaryPrompt\": \"Instructions for summarizing the page...\",\n  \"dataExtractionRules\": \"Instructions for extracting specific fields...\",\n  \"uriExtractionRules\": \"Instructions for extracting URIs, for example: links containing /dp/\",\n  \"xsql\": \"select dom_first_text(dom, 'title') as title from load_and_select(@url, ':root')\"\n}\n"), TuplesKt.to((Object)"{PLACEHOLDER_REQUEST_PLAIN_COMMAND_TEMPLATE}", (Object)processedRequest)};
        String prompt = new PromptTemplateLoader(resource, "\nConvert a natural language web automation request into a structured JSON configuration for automated browser interaction and data extraction.\n\n### \ud83c\udfaf Task:\nTransform the user's conversational instructions into a precise JSON object that defines browser automation workflow, page interactions, and data extraction requirements.\n\n### \ud83d\udccb JSON Structure:\nUse this template with only the fields relevant to the request:\n\n```json\n{PLACEHOLDER_REQUEST_JSON_COMMAND_TEMPLATE}\n```\n\n### \ud83d\udd27 Field Guidelines:\n\n**Required Fields:**\n* `url`: Always preserve as `{PLACEHOLDER_URL}` - do not modify this placeholder\n\n**Optional Fields (include only if relevant):**\n* `onBrowserLaunchedActions`: Pre-navigation setup actions (cookies, authentication, etc.)\n  - Execute in the specified order before loading the target page\n  - Common actions: cookie management, login, navigation setup\n  \n* `onPageReadyActions`: Page interaction steps after initial load\n  - Execute in the specified order once the page is fully loaded\n  - Common actions: clicking, scrolling, form filling, waiting\n  \n* `pageSummaryPrompt`: Natural language instructions for page content summarization\n  - Be specific about what aspects to focus on\n  - Include desired output format or structure\n  \n* `dataExtractionRules`: Structured data extraction specifications\n  - Define exact field names and expected formats\n  - Specify selectors, patterns, or identification methods\n  \n* `uriExtractionRules`: Natural language instructions to extract URIs from the page\n  - Will be converted into regex patterns automatically\n  - Example: \"extract all product links containing '/dp/'\"\n\n* `xsql`: X-SQL query to run on the page's DOM\n    - Use for advanced data extraction or processing\n    - Should be a valid X-SQL query string\n\n### \u26a1 Conversion Rules:\n* **Specificity**: Convert vague instructions into concrete, executable actions\n* **Order**: Sequence actions logically (setup \u2192 navigation \u2192 interaction \u2192 extraction)\n* **Clarity**: Use precise language that eliminates ambiguity\n* **Relevance**: Only include fields that address the user's actual requirements\n* **Actionability**: Every instruction should be directly executable by automation\n\n### \ud83c\udf10 Language Support:\nProcess requests in any language and output JSON with English field values.\n\n### \ud83d\udce5 User Request:\n\n```text\n{PLACEHOLDER_REQUEST_PLAIN_COMMAND_TEMPLATE}\n```\n\n### \ud83d\udce4 Expected Output:\nReturn only the JSON object - no explanations or additional text.\n", MapsKt.mapOf((Pair[])pairArray), CollectionsKt.listOf((Object)"{PLACEHOLDER_URL}")).load().render();
        String content = this.getSession().chat(prompt).getContent();
        if (StringsKt.isBlank((CharSequence)content)) {
            return null;
        }
        content = new PromptTemplate(content, MapsKt.mapOf((Pair)TuplesKt.to((Object)"{PLACEHOLDER_URL}", (Object)url)), null, 4, null).render();
        return (String)CollectionsKt.firstOrNull((List)JSONExtractor.Companion.extractJsonBlocks(content));
    }

    @NotNull
    public String getResource() {
        return this.resource;
    }

    @NotNull
    public String convertResponseToMarkdown(@NotNull String jsonResponse) {
        Intrinsics.checkNotNullParameter((Object)jsonResponse, (String)"jsonResponse");
        String userMessage = new PromptTemplateLoader(this.getResource(), "\nConvert the following JSON string into a well-structured Markdown document.\n\n### \ud83c\udfaf Output Requirements:\n\nThe output must include:\n\n#### \ud83e\uddfe Human-Readable Explanation\nPresent the JSON content as structured Markdown sections:\n\n1. **Page Summary** \u2014 A brief summary of the page content\n2. **Extracted Data** \u2014 Key-value pairs extracted from the page (if any)\n3. **Extracted Links** \u2014 List of URIs/links found on the page (if any)\n\n#### \ud83d\udce6 JSON Representation\nInclude the original JSON string as a fenced code block at the end of the document.\n\n### \ud83d\udd27 JSON to Convert:\n\n```json\n{PLACEHOLDER_JSON_STRING}\n```\n", MapsKt.mapOf((Pair)TuplesKt.to((Object)"{PLACEHOLDER_JSON_STRING}", (Object)jsonResponse)), null, 8, null).load().render();
        return this.getSession().chat(userMessage).getContent();
    }

    @NotNull
    public String convertResponseToMarkdown(@NotNull CommandStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        String jsonResponse = JacksonKt.pulsarObjectMapper().writeValueAsString((Object)status);
        Intrinsics.checkNotNull((Object)jsonResponse);
        return this.convertResponseToMarkdown(jsonResponse);
    }
}

