/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.controller.pulsar.v30x.service;

import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.rest.api.common.NormXSQL;
import ai.platon.pulsar.rest.api.common.ScrapeAPIUtils;
import ai.platon.pulsar.rest.api.entities.ModelsKt;
import ai.platon.pulsar.rest.api.entities.ScrapeRequest;
import ai.platon.pulsar.rest.api.entities.ScrapeResponse;
import ai.platon.pulsar.rest.api.entities.ScrapeStatusRequest;
import ai.platon.pulsar.skeleton.session.PulsarSession;
import ai.platon.scent.rest.api.controller.pulsar.v30x.AbstractScrapeHyperlinkV30x;
import ai.platon.scent.rest.api.controller.pulsar.v30x.DegenerateXSQLScrapeHyperlinkV30x;
import ai.platon.scent.rest.api.controller.pulsar.v30x.ScrapeHyperlinkV30x;
import ai.platon.scent.rest.api.controller.pulsar.v30x.XSQLScrapeHyperlinkV30x;
import ai.platon.scent.rest.api.controller.pulsar.v30x.service.ScrapeServiceV30x;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiMapUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0012J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020 H\u0016J\u001c\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0#0\"2\u0006\u0010$\u001a\u00020\nH\u0016J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\f\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n\u0018\u00010\r0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lai/platon/scent/rest/api/controller/pulsar/v30x/service/ScrapeServiceV30x;", "", "session", "Lai/platon/pulsar/skeleton/session/PulsarSession;", "(Lai/platon/pulsar/skeleton/session/PulsarSession;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "responseCache", "Ljava/util/concurrent/ConcurrentSkipListMap;", "", "Lai/platon/pulsar/rest/api/entities/ScrapeResponse;", "responseStatusIndex", "Lorg/apache/commons/collections4/ListValuedMap;", "", "scrapingDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "scrapingScope", "Lkotlinx/coroutines/CoroutineScope;", "getSession", "()Lai/platon/pulsar/skeleton/session/PulsarSession;", "commandStatusFlow", "Lkotlinx/coroutines/flow/Flow;", "uuid", "count", "statusCode", "createScrapeHyperlink", "Lai/platon/scent/rest/api/controller/pulsar/v30x/ScrapeHyperlinkV30x;", "request", "Lai/platon/pulsar/rest/api/entities/ScrapeRequest;", "executeQuery", "getStatus", "Lai/platon/pulsar/rest/api/entities/ScrapeStatusRequest;", "streamEvents", "Lreactor/core/publisher/Flux;", "Lorg/springframework/http/codec/ServerSentEvent;", "id", "submitJob", "scent-rest"})
public class ScrapeServiceV30x {
    @NotNull
    private final PulsarSession session;
    private final Logger logger;
    @NotNull
    private final ConcurrentSkipListMap<String, ScrapeResponse> responseCache;
    private final ListValuedMap<Integer, String> responseStatusIndex;
    @NotNull
    private final CoroutineDispatcher scrapingDispatcher;
    @NotNull
    private final CoroutineScope scrapingScope;

    public ScrapeServiceV30x(@NotNull PulsarSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.logger = LoggerFactory.getLogger(ScrapeServiceV30x.class);
        this.responseCache = new ConcurrentSkipListMap();
        this.responseStatusIndex = MultiMapUtils.newListValuedHashMap();
        this.scrapingDispatcher = Dispatchers.getIO().limitedParallelism(10);
        this.scrapingScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.scrapingDispatcher.plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)).plus((CoroutineContext)new CoroutineName("scraping")));
    }

    @NotNull
    public PulsarSession getSession() {
        return this.session;
    }

    @NotNull
    public ScrapeResponse executeQuery(@NotNull ScrapeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            ScrapeHyperlinkV30x hyperlink = this.createScrapeHyperlink(request);
            this.getSession().submit((UrlAware)hyperlink);
            ScrapeResponse response = (ScrapeResponse)hyperlink.get(120L, TimeUnit.SECONDS);
            Intrinsics.checkNotNull((Object)response);
            return response;
        }
        catch (TimeoutException e) {
            this.logger.warn("Timeout executing query: >>>" + request.getSql() + "<<<", (Throwable)e);
            return new ScrapeResponse("", 408, 408, 0, false, null, null, 120, null);
        }
        catch (Exception e) {
            this.logger.error("Unexpected error executing query: >>>" + request.getSql() + "<<<", (Throwable)e);
            return new ScrapeResponse("", 500, 1462, 0, false, null, null, 120, null);
        }
    }

    @NotNull
    public String submitJob(@NotNull ScrapeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ScrapeHyperlinkV30x hyperlink = this.createScrapeHyperlink(request);
        ((Map)this.responseCache).put(hyperlink.getUuid(), hyperlink.getResponse());
        hyperlink.getResponse().setId(hyperlink.getUuid());
        this.getSession().submit((UrlAware)hyperlink);
        return hyperlink.getUuid();
    }

    @NotNull
    public ScrapeResponse getStatus(@NotNull ScrapeStatusRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ScrapeResponse scrapeResponse = this.responseCache.computeIfAbsent(request.getId(), arg_0 -> ScrapeServiceV30x.getStatus$lambda$0((Function1)new Function1<String, ScrapeResponse>(request){
            final /* synthetic */ ScrapeStatusRequest $request;
            {
                this.$request = $request;
                super(1);
            }

            @NotNull
            public final ScrapeResponse invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new ScrapeResponse(this.$request.getId(), 404, 404, 0, false, null, null, 120, null);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)scrapeResponse, (String)"computeIfAbsent(...)");
        return scrapeResponse;
    }

    @NotNull
    public Flux<ServerSentEvent<ScrapeResponse>> streamEvents(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Flux flux = Flux.create(arg_0 -> ScrapeServiceV30x.streamEvents$lambda$1((Function1)new Function1<FluxSink<ScrapeResponse>, Unit>(this, id){
            final /* synthetic */ ScrapeServiceV30x this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(1);
            }

            public final void invoke(FluxSink<ScrapeResponse> sink) {
                Job job2 = FlowKt.launchIn((Flow)FlowKt.catch((Flow)FlowKt.onEach(this.this$0.commandStatusFlow(this.$id), (Function2)((Function2)new Function2<ScrapeResponse, Continuation<? super Unit>, Object>(sink, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ FluxSink<ScrapeResponse> $sink;
                    {
                        this.$sink = $sink;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ScrapeResponse it = (ScrapeResponse)this.L$0;
                                this.$sink.next((Object)it);
                                if (it.isDone()) {
                                    this.$sink.complete();
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull ScrapeResponse p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                })), (Function3)((Function3)new Function3<FlowCollector<? super ScrapeResponse>, Throwable, Continuation<? super Unit>, Object>(this.this$0, sink, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ ScrapeServiceV30x this$0;
                    final /* synthetic */ FluxSink<ScrapeResponse> $sink;
                    {
                        this.this$0 = $receiver;
                        this.$sink = $sink;
                        super(3, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Throwable it = (Throwable)this.L$0;
                                ScrapeServiceV30x.access$getLogger$p(this.this$0).error("Error in command status flow", it);
                                this.$sink.error(it);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull FlowCollector<? super ScrapeResponse> p1, @NotNull Throwable p2, @Nullable Continuation<? super Unit> p3) {
                        var var4_4 = new /* invalid duplicate definition of identical inner class */;
                        var4_4.L$0 = p2;
                        return var4_4.invokeSuspend(Unit.INSTANCE);
                    }
                })), (CoroutineScope)ScrapeServiceV30x.access$getScrapingScope$p(this.this$0));
                sink.onDispose(() -> streamEvents.1.invoke$lambda$0(job2));
            }

            private static final void invoke$lambda$0(Job $job) {
                Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
                Job.DefaultImpls.cancel$default((Job)$job, null, (int)1, null);
            }
        }, arg_0)).map(arg_0 -> ScrapeServiceV30x.streamEvents$lambda$2(streamEvents.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    @NotNull
    public Flow<ScrapeResponse> commandStatusFlow(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super ScrapeResponse>, Continuation<? super Unit>, Object>(this, uuid, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ScrapeServiceV30x this$0;
            final /* synthetic */ String $uuid;
            {
                this.this$0 = $receiver;
                this.$uuid = $uuid;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$flow = (FlowCollector)this.L$0;
                        lastModifiedTime = Instant.EPOCH;
                        while (true) {
                            this.L$0 = $this$flow;
                            this.L$1 = lastModifiedTime;
                            this.label = 1;
                            v0 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl20
                            break;
                        }
                    }
                    case 1: {
                        lastModifiedTime = (Instant)this.L$1;
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        if ((v1 = (ScrapeResponse)ScrapeServiceV30x.access$getResponseCache$p(this.this$0).get(this.$uuid)) == null) {
                            v1 = ScrapeResponse.Companion.notFound(this.$uuid);
                        }
                        var5_6 /* !! */  = v1;
                        Intrinsics.checkNotNull((Object)var5_6 /* !! */ );
                        status = var5_6 /* !! */ ;
                        if (!status.isDone()) break;
                        this.L$0 = null;
                        this.L$1 = null;
                        this.label = 2;
                        v2 = $this$flow.emit((Object)status, (Continuation)this);
                        if (v2 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl36
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl36:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                var5_6 /* !! */  = lastModifiedTime;
                Intrinsics.checkNotNull((Object)var5_6 /* !! */ );
                if (!ModelsKt.refreshed((ScrapeResponse)status, (Instant)var5_6 /* !! */ )) ** GOTO lbl53
                this.L$0 = $this$flow;
                this.L$1 = status;
                this.label = 3;
                v3 = $this$flow.emit((Object)status, (Continuation)this);
                if (v3 == var6_2) {
                    return var6_2;
                }
                ** GOTO lbl52
                {
                    case 3: {
                        status = (ScrapeResponse)this.L$1;
                        $this$flow = (FlowCollector)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl52:
                        // 2 sources

                        lastModifiedTime = status.getLastModifiedTime();
lbl53:
                        // 2 sources

                        if (!status.isDone()) ** continue;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super ScrapeResponse> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public int count(int statusCode) {
        int n;
        if (statusCode == 0) {
            n = this.responseCache.size();
        } else {
            List list = this.responseStatusIndex.get((Object)statusCode);
            n = list != null ? list.size() : 0;
        }
        return n;
    }

    private ScrapeHyperlinkV30x createScrapeHyperlink(ScrapeRequest request) {
        AbstractScrapeHyperlinkV30x abstractScrapeHyperlinkV30x;
        String sql = request.getSql();
        if (ScrapeAPIUtils.INSTANCE.isScrapeUDF(sql)) {
            NormXSQL xSQL = ScrapeAPIUtils.INSTANCE.normalize(sql);
            abstractScrapeHyperlinkV30x = new XSQLScrapeHyperlinkV30x(request, xSQL, this.getSession(), null, 8, null);
        } else {
            abstractScrapeHyperlinkV30x = new DegenerateXSQLScrapeHyperlinkV30x(request, this.getSession(), null, 4, null);
        }
        AbstractScrapeHyperlinkV30x link = abstractScrapeHyperlinkV30x;
        link.getEventHandlers().getCrawlEventHandlers().getOnLoaded().addLast((Function2)new Function2<UrlAware, WebPage, Object>(this, link){
            final /* synthetic */ ScrapeServiceV30x this$0;
            final /* synthetic */ AbstractScrapeHyperlinkV30x $link;
            {
                this.this$0 = $receiver;
                this.$link = $link;
                super(2);
            }

            @Nullable
            public final Object invoke(@NotNull UrlAware url, @Nullable WebPage page) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                ((Map)ScrapeServiceV30x.access$getResponseCache$p(this.this$0)).put(this.$link.getUuid(), this.$link.getResponse());
                ScrapeServiceV30x.access$getResponseStatusIndex$p(this.this$0).get((Object)this.$link.getResponse().getStatusCode()).add(this.$link.getUuid());
                return null;
            }
        });
        return link;
    }

    private static final ScrapeResponse getStatus$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ScrapeResponse)$tmp0.invoke(p0);
    }

    private static final void streamEvents$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final ServerSentEvent streamEvents$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ServerSentEvent)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p(ScrapeServiceV30x $this) {
        return $this.logger;
    }

    public static final /* synthetic */ CoroutineScope access$getScrapingScope$p(ScrapeServiceV30x $this) {
        return $this.scrapingScope;
    }

    public static final /* synthetic */ ConcurrentSkipListMap access$getResponseCache$p(ScrapeServiceV30x $this) {
        return $this.responseCache;
    }

    public static final /* synthetic */ ListValuedMap access$getResponseStatusIndex$p(ScrapeServiceV30x $this) {
        return $this.responseStatusIndex;
    }
}

