/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.scent.common.ScentWebPageExtKt;
import ai.platon.scent.rest.api.serialize.DOMAnnotation;
import ai.platon.scent.skeleton.ScentSession;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\t2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0016J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J0\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\t2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\u0012\u001a\u00020\rH\u0012J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lai/platon/scent/rest/api/service/AnnotationService;", "", "session", "Lai/platon/scent/skeleton/ScentSession;", "(Lai/platon/scent/skeleton/ScentSession;)V", "logger", "Lorg/slf4j/Logger;", "annotate", "", "", "url", "annotations", "annotateAll", "Lai/platon/scent/rest/api/service/AnnotationService$AnnotateStatus;", "", "Lai/platon/scent/rest/api/serialize/DOMAnnotation;", "annotateOne", "Lai/platon/pulsar/persist/WebPage;", "result", "get", "AnnotateResult", "AnnotateStatus", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nAnnotationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationService.kt\nai/platon/scent/rest/api/service/AnnotationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,124:1\n1855#2,2:125\n1#3:127\n215#4,2:128\n*S KotlinDebug\n*F\n+ 1 AnnotationService.kt\nai/platon/scent/rest/api/service/AnnotationService\n*L\n69#1:125,2\n96#1:128,2\n*E\n"})
public class AnnotationService {
    @NotNull
    private final ScentSession session;
    @NotNull
    private final Logger logger;

    public AnnotationService(@NotNull ScentSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.logger = LogsKt.getLogger((Object)this);
    }

    @NotNull
    public Map<String, String> get(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Map map = ScentWebPageExtKt.getMlLabels((WebPage)this.session.load(url));
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @NotNull
    public Map<String, String> annotate(@NotNull String url, @NotNull Map<String, String> annotations) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        AnnotateStatus result = new AnnotateStatus(0, 0, 0, 0, 0, 0, 63, null);
        WebPage webPage = this.annotateOne(url, annotations, result);
        if (webPage == null) {
            return MapsKt.emptyMap();
        }
        WebPage page = webPage;
        this.session.flush();
        Object object = this.session.getOrNull(page.getUrl());
        if (object == null || (object = ScentWebPageExtKt.getMlLabels((WebPage)object)) == null) {
            return MapsKt.emptyMap();
        }
        Object mlLabels = object;
        Object[] objectArray = new Object[]{page.getId(), mlLabels, annotations, page.getUrl()};
        this.logger.info("{}. Annotated: {} accepted: {} | {}", objectArray);
        return mlLabels;
    }

    @NotNull
    public AnnotateStatus annotateAll(@NotNull List<DOMAnnotation> annotations) {
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Set affectedPageUrls = new LinkedHashSet();
        AnnotateStatus result = new AnnotateStatus(0, 0, 0, 0, 0, 0, 63, null);
        Iterable $this$forEach$iv = annotations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DOMAnnotation anno = (DOMAnnotation)element$iv;
            boolean bl = false;
            result.setSubmitted(result.getSubmitted() + 1);
            result.getSubmitted();
            String url = anno.getUrl();
            if (url == null) continue;
            result.setValid(result.getValid() + 1);
            result.getValid();
            int lastAffectedAnnots = result.getAffectedAnnots();
            WebPage page = this.annotateOne(url, MapsKt.mapOf((Pair)TuplesKt.to((Object)anno.getVi(), (Object)anno.getLabel())), result);
            if (result.getAffectedAnnots() <= lastAffectedAnnots) continue;
            affectedPageUrls.add(url);
        }
        result.setAffectedPages(result.getAffectedPages() + affectedPageUrls.size());
        this.session.flush();
        this.logger.info("{}", (Object)result);
        return result;
    }

    private WebPage annotateOne(String url, Map<String, String> annotations, AnnotateStatus result) {
        WebPage webPage;
        WebPage it = webPage = this.session.get(url);
        boolean bl = false;
        Object object = it.isNotInternal() ? webPage : null;
        if (object == null) {
            return null;
        }
        WebPage page = object;
        int removed = 0;
        int added = 0;
        Map<String, String> $this$forEach$iv = annotations;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String oldValue;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String vi = entry.getKey();
            String label = entry.getValue();
            CharSequence charSequence = label;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                oldValue = ScentWebPageExtKt.removeMLLabel((WebPage)page, (String)vi);
                if (oldValue == null) continue;
                ++removed;
                continue;
            }
            if (StringsKt.startsWith$default((String)label, (String)"delete_", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)label, (String)"_delete", (boolean)false, (int)2, null)) {
                oldValue = ScentWebPageExtKt.removeMLLabel((WebPage)page, (String)vi);
                if (oldValue == null) continue;
                ++removed;
                continue;
            }
            ScentWebPageExtKt.addMLLabel((WebPage)page, (String)vi, (String)label);
            ++added;
        }
        result.setRemoved(result.getRemoved() + removed);
        result.setAdded(result.getAdded() + added);
        if (removed + added > 0) {
            result.setAffectedAnnots(result.getAffectedAnnots() + 1);
            result.getAffectedAnnots();
        }
        this.session.persist(page);
        return page;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0017\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J5\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001R(\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lai/platon/scent/rest/api/service/AnnotationService$AnnotateResult;", "", "url", "", "annotations", "", "", "status", "Lai/platon/scent/rest/api/service/AnnotationService$AnnotateStatus;", "(ILjava/util/Map;Lai/platon/scent/rest/api/service/AnnotationService$AnnotateStatus;)V", "getAnnotations", "()Ljava/util/Map;", "setAnnotations", "(Ljava/util/Map;)V", "getStatus", "()Lai/platon/scent/rest/api/service/AnnotationService$AnnotateStatus;", "setStatus", "(Lai/platon/scent/rest/api/service/AnnotationService$AnnotateStatus;)V", "getUrl", "()I", "setUrl", "(I)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "scent-rest"})
    public static final class AnnotateResult {
        private int url;
        @NotNull
        private Map<String, String> annotations;
        @NotNull
        private AnnotateStatus status;

        public AnnotateResult(int url, @NotNull Map<String, String> annotations, @NotNull AnnotateStatus status) {
            Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            this.url = url;
            this.annotations = annotations;
            this.status = status;
        }

        public /* synthetic */ AnnotateResult(int n, Map map, AnnotateStatus annotateStatus, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            this(n, map, annotateStatus);
        }

        public final int getUrl() {
            return this.url;
        }

        public final void setUrl(int n) {
            this.url = n;
        }

        @NotNull
        public final Map<String, String> getAnnotations() {
            return this.annotations;
        }

        public final void setAnnotations(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.annotations = map;
        }

        @NotNull
        public final AnnotateStatus getStatus() {
            return this.status;
        }

        public final void setStatus(@NotNull AnnotateStatus annotateStatus) {
            Intrinsics.checkNotNullParameter((Object)annotateStatus, (String)"<set-?>");
            this.status = annotateStatus;
        }

        public final int component1() {
            return this.url;
        }

        @NotNull
        public final Map<String, String> component2() {
            return this.annotations;
        }

        @NotNull
        public final AnnotateStatus component3() {
            return this.status;
        }

        @NotNull
        public final AnnotateResult copy(int url, @NotNull Map<String, String> annotations, @NotNull AnnotateStatus status) {
            Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            return new AnnotateResult(url, annotations, status);
        }

        public static /* synthetic */ AnnotateResult copy$default(AnnotateResult annotateResult, int n, Map map, AnnotateStatus annotateStatus, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = annotateResult.url;
            }
            if ((n2 & 2) != 0) {
                map = annotateResult.annotations;
            }
            if ((n2 & 4) != 0) {
                annotateStatus = annotateResult.status;
            }
            return annotateResult.copy(n, map, annotateStatus);
        }

        @NotNull
        public String toString() {
            return "AnnotateResult(url=" + this.url + ", annotations=" + this.annotations + ", status=" + this.status + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.url);
            result = result * 31 + ((Object)this.annotations).hashCode();
            result = result * 31 + this.status.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotateResult)) {
                return false;
            }
            AnnotateResult annotateResult = (AnnotateResult)other;
            if (this.url != annotateResult.url) {
                return false;
            }
            if (!Intrinsics.areEqual(this.annotations, annotateResult.annotations)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.status, (Object)annotateResult.status);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000b\"\u0004\b\u0015\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000b\"\u0004\b\u0017\u0010\r\u00a8\u0006%"}, d2={"Lai/platon/scent/rest/api/service/AnnotationService$AnnotateStatus;", "", "submitted", "", "valid", "removed", "added", "affectedAnnots", "affectedPages", "(IIIIII)V", "getAdded", "()I", "setAdded", "(I)V", "getAffectedAnnots", "setAffectedAnnots", "getAffectedPages", "setAffectedPages", "getRemoved", "setRemoved", "getSubmitted", "setSubmitted", "getValid", "setValid", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "scent-rest"})
    public static final class AnnotateStatus {
        private int submitted;
        private int valid;
        private int removed;
        private int added;
        private int affectedAnnots;
        private int affectedPages;

        public AnnotateStatus(int submitted, int valid, int removed, int added, int affectedAnnots, int affectedPages) {
            this.submitted = submitted;
            this.valid = valid;
            this.removed = removed;
            this.added = added;
            this.affectedAnnots = affectedAnnots;
            this.affectedPages = affectedPages;
        }

        public /* synthetic */ AnnotateStatus(int n, int n2, int n3, int n4, int n5, int n6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n7 & 1) != 0) {
                n = 0;
            }
            if ((n7 & 2) != 0) {
                n2 = 0;
            }
            if ((n7 & 4) != 0) {
                n3 = 0;
            }
            if ((n7 & 8) != 0) {
                n4 = 0;
            }
            if ((n7 & 0x10) != 0) {
                n5 = 0;
            }
            if ((n7 & 0x20) != 0) {
                n6 = 0;
            }
            this(n, n2, n3, n4, n5, n6);
        }

        public final int getSubmitted() {
            return this.submitted;
        }

        public final void setSubmitted(int n) {
            this.submitted = n;
        }

        public final int getValid() {
            return this.valid;
        }

        public final void setValid(int n) {
            this.valid = n;
        }

        public final int getRemoved() {
            return this.removed;
        }

        public final void setRemoved(int n) {
            this.removed = n;
        }

        public final int getAdded() {
            return this.added;
        }

        public final void setAdded(int n) {
            this.added = n;
        }

        public final int getAffectedAnnots() {
            return this.affectedAnnots;
        }

        public final void setAffectedAnnots(int n) {
            this.affectedAnnots = n;
        }

        public final int getAffectedPages() {
            return this.affectedPages;
        }

        public final void setAffectedPages(int n) {
            this.affectedPages = n;
        }

        public final int component1() {
            return this.submitted;
        }

        public final int component2() {
            return this.valid;
        }

        public final int component3() {
            return this.removed;
        }

        public final int component4() {
            return this.added;
        }

        public final int component5() {
            return this.affectedAnnots;
        }

        public final int component6() {
            return this.affectedPages;
        }

        @NotNull
        public final AnnotateStatus copy(int submitted, int valid, int removed, int added, int affectedAnnots, int affectedPages) {
            return new AnnotateStatus(submitted, valid, removed, added, affectedAnnots, affectedPages);
        }

        public static /* synthetic */ AnnotateStatus copy$default(AnnotateStatus annotateStatus, int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
            if ((n7 & 1) != 0) {
                n = annotateStatus.submitted;
            }
            if ((n7 & 2) != 0) {
                n2 = annotateStatus.valid;
            }
            if ((n7 & 4) != 0) {
                n3 = annotateStatus.removed;
            }
            if ((n7 & 8) != 0) {
                n4 = annotateStatus.added;
            }
            if ((n7 & 0x10) != 0) {
                n5 = annotateStatus.affectedAnnots;
            }
            if ((n7 & 0x20) != 0) {
                n6 = annotateStatus.affectedPages;
            }
            return annotateStatus.copy(n, n2, n3, n4, n5, n6);
        }

        @NotNull
        public String toString() {
            return "AnnotateStatus(submitted=" + this.submitted + ", valid=" + this.valid + ", removed=" + this.removed + ", added=" + this.added + ", affectedAnnots=" + this.affectedAnnots + ", affectedPages=" + this.affectedPages + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.submitted);
            result = result * 31 + Integer.hashCode(this.valid);
            result = result * 31 + Integer.hashCode(this.removed);
            result = result * 31 + Integer.hashCode(this.added);
            result = result * 31 + Integer.hashCode(this.affectedAnnots);
            result = result * 31 + Integer.hashCode(this.affectedPages);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotateStatus)) {
                return false;
            }
            AnnotateStatus annotateStatus = (AnnotateStatus)other;
            if (this.submitted != annotateStatus.submitted) {
                return false;
            }
            if (this.valid != annotateStatus.valid) {
                return false;
            }
            if (this.removed != annotateStatus.removed) {
                return false;
            }
            if (this.added != annotateStatus.added) {
                return false;
            }
            if (this.affectedAnnots != annotateStatus.affectedAnnots) {
                return false;
            }
            return this.affectedPages == annotateStatus.affectedPages;
        }

        public AnnotateStatus() {
            this(0, 0, 0, 0, 0, 0, 63, null);
        }
    }
}

