/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.scent.rest.api.service.scrape;

import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.Priority13;
import ai.platon.scent.persist.mongo.v1.ScrapeTask;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\b\u0017\u0018\u0000 !2\u00020\u0001:\u0002!\"B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u001cH\u0012J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0012J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lai/platon/scent/rest/api/service/scrape/RedisTaskQueueService;", "", "redisTemplate", "Lorg/springframework/data/redis/core/RedisTemplate;", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lorg/springframework/data/redis/core/RedisTemplate;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "logger", "Lorg/slf4j/Logger;", "add", "", "task", "Lai/platon/scent/persist/mongo/v1/ScrapeTask;", "addAll", "tasks", "", "count", "", "priority", "Lai/platon/pulsar/common/Priority13;", "deleteAll", "estimatedCount", "estimatedEnqueueOrder", "get", "id", "getTopN", "n", "", "parsePriority", "publishTaskStatusChange", "takeTopN", "updateTaskStatus", "Companion", "TaskStatusMessage", "scent-rest"})
@SourceDebugExtension(value={"SMAP\nRedisTaskQueueService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisTaskQueueService.kt\nai/platon/scent/rest/api/service/scrape/RedisTaskQueueService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1855#2,2:177\n766#2:182\n857#2,2:183\n1855#2,2:185\n1549#2:187\n1620#2,3:188\n1603#2,9:191\n1855#2:200\n1856#2:202\n1612#2:203\n1855#2,2:204\n1549#2:206\n1620#2,3:207\n1603#2,9:210\n1855#2:219\n1856#2:221\n1612#2:222\n37#3,2:179\n1#4:181\n1#4:201\n1#4:220\n*S KotlinDebug\n*F\n+ 1 RedisTaskQueueService.kt\nai/platon/scent/rest/api/service/scrape/RedisTaskQueueService\n*L\n68#1:177,2\n92#1:182\n92#1:183,2\n113#1:185,2\n130#1:187\n130#1:188,3\n134#1:191,9\n134#1:200\n134#1:202\n134#1:203\n143#1:204,2\n155#1:206\n155#1:207,3\n158#1:210,9\n158#1:219\n158#1:221\n158#1:222\n87#1:179,2\n134#1:201\n158#1:220\n*E\n"})
public class RedisTaskQueueService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RedisTemplate<String, String> redisTemplate;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Logger logger;
    @NotNull
    private static final String TASK_KEY_PREFIX = "scrape:task:";
    @NotNull
    private static final String QUEUE_KEY_PREFIX = "scrape:queue:";
    private static final long TASK_EXPIRE_DAYS = 7L;
    @NotNull
    private static final String TASK_STATUS_CHANNEL = "scrape:task:status";

    public RedisTaskQueueService(@NotNull RedisTemplate<String, String> redisTemplate, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter(redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.redisTemplate = redisTemplate;
        this.objectMapper = objectMapper;
        this.logger = LogsKt.getLogger((Object)this);
    }

    public void add(@NotNull ScrapeTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string = task.getId();
        if (string == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        String taskId = string;
        Priority13 priority = this.parsePriority(task.getPriority());
        String taskKey = TASK_KEY_PREFIX + task.getId();
        String queueKey = QUEUE_KEY_PREFIX + priority.name();
        String taskJson = this.objectMapper.writeValueAsString((Object)task);
        this.redisTemplate.opsForValue().set((Object)taskKey, (Object)taskJson, Duration.ofDays(7L));
        this.redisTemplate.opsForZSet().add((Object)queueKey, (Object)taskId, (double)task.getCreatedAt().toEpochMilli());
        this.publishTaskStatusChange(task);
    }

    public void updateTaskStatus(@NotNull ScrapeTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String taskKey = TASK_KEY_PREFIX + task.getId();
        String taskJson = this.objectMapper.writeValueAsString((Object)task);
        this.redisTemplate.opsForValue().set((Object)taskKey, (Object)taskJson, Duration.ofDays(7L));
        this.publishTaskStatusChange(task);
    }

    private void publishTaskStatusChange(ScrapeTask task) {
        try {
            String string = task.getId();
            Intrinsics.checkNotNull((Object)string);
            int n = task.getStatusCode();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            String message = this.objectMapper.writeValueAsString((Object)new TaskStatusMessage(string, n, instant));
            this.redisTemplate.convertAndSend(TASK_STATUS_CHANNEL, (Object)message);
        }
        catch (Exception e) {
            this.logger.error("Failed to publish task status change", (Throwable)e);
        }
    }

    public void addAll(@NotNull List<ScrapeTask> tasks) {
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScrapeTask it = (ScrapeTask)element$iv;
            boolean bl = false;
            this.add(it);
        }
    }

    @Nullable
    public ScrapeTask get(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String taskKey = TASK_KEY_PREFIX + id;
        String string = (String)this.redisTemplate.opsForValue().get((Object)taskKey);
        if (string == null) {
            return null;
        }
        String taskJson = string;
        return (ScrapeTask)this.objectMapper.readValue(taskJson, ScrapeTask.class);
    }

    public long count(@NotNull Priority13 priority) {
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        String queueKey = QUEUE_KEY_PREFIX + priority.name();
        Long l = this.redisTemplate.opsForZSet().size((Object)queueKey);
        return l == null ? 0L : l;
    }

    public long estimatedCount(@NotNull Priority13 priority) {
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        return this.count(priority);
    }

    /*
     * WARNING - void declaration
     */
    public long estimatedCount() {
        Collection $this$toTypedArray$iv = (Collection)EntriesMappings.entries$0;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Priority13[] priority13Array = thisCollection$iv.toArray(new Priority13[0]);
        long l = 0L;
        int n = priority13Array.length;
        for (int i = 0; i < n; ++i) {
            void it;
            Priority13 priority13;
            Priority13 priority132 = priority13 = priority13Array[i];
            long l2 = l;
            boolean bl = false;
            long l3 = this.count((Priority13)it);
            l = l2 + l3;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public long estimatedEnqueueOrder(@NotNull Priority13 priority) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        Iterable $this$filter$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Priority13 it = (Priority13)element$iv$iv;
            boolean bl = false;
            if (!(it.compareTo((Enum)priority) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        long l = 0L;
        for (Object t : iterable2) {
            void it;
            Priority13 priority13 = (Priority13)t;
            long l2 = l;
            boolean bl = false;
            long l3 = this.count((Priority13)it);
            l = l2 + l3;
        }
        return l;
    }

    public void deleteAll() {
        String pattern = "scrape:task:*";
        Set set = this.redisTemplate.keys((Object)pattern);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keys(...)");
        Set keys = set;
        if (!((Collection)keys).isEmpty()) {
            this.redisTemplate.delete((Collection)keys);
        }
        String queuePattern = "scrape:queue:*";
        Set set2 = this.redisTemplate.keys((Object)queuePattern);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"keys(...)");
        Set queueKeys = set2;
        if (!((Collection)queueKeys).isEmpty()) {
            this.redisTemplate.delete((Collection)queueKeys);
        }
    }

    @NotNull
    public List<ScrapeTask> takeTopN(int n) {
        List mergedTasks = new ArrayList();
        Iterable $this$forEach$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Priority13 priority = (Priority13)element$iv;
            boolean bl = false;
            List<ScrapeTask> tasks = this.takeTopN(priority, n);
            if (!(!((Collection)tasks).isEmpty())) continue;
            mergedTasks.addAll((Collection)tasks);
            if (mergedTasks.size() < n) continue;
            return CollectionsKt.take((Iterable)mergedTasks, (int)n);
        }
        return mergedTasks;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ScrapeTask> takeTopN(@NotNull Priority13 priority, int n) {
        void $this$mapNotNullTo$iv$iv;
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        String queueKey = QUEUE_KEY_PREFIX + priority.name();
        Set set = this.redisTemplate.opsForZSet().range((Object)queueKey, 0L, (long)n - 1L);
        if (set != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = set;
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
        } else {
            return CollectionsKt.emptyList();
        }
        List taskIds = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = taskIds;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$map = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ScrapeTask it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String id = (String)element$iv$iv;
            boolean bl2 = false;
            String taskKey = TASK_KEY_PREFIX + id;
            String taskJson = (String)this.redisTemplate.opsForValue().get((Object)taskKey);
            if ((taskJson != null ? (ScrapeTask)this.objectMapper.readValue(taskJson, ScrapeTask.class) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List tasks = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = taskIds;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{id};
            this.redisTemplate.opsForZSet().remove((Object)queueKey, objectArray);
            this.redisTemplate.delete((Object)(TASK_KEY_PREFIX + id));
        }
        return tasks;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ScrapeTask> getTopN(@NotNull Priority13 priority, int n) {
        void $this$mapNotNullTo$iv$iv;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        String queueKey = QUEUE_KEY_PREFIX + priority.name();
        Set set = this.redisTemplate.opsForZSet().range((Object)queueKey, 0L, (long)n - 1L);
        if (set != null) {
            void $this$mapTo$iv$iv;
            Iterable iterable = set;
            boolean $i$f$map = false;
            void var9_8 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toString());
            }
        } else {
            return CollectionsKt.emptyList();
        }
        List taskIds = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = taskIds;
        boolean $i$f$mapNotNull = false;
        $this$map$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ScrapeTask it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String id = (String)element$iv$iv;
            boolean bl2 = false;
            String taskKey = TASK_KEY_PREFIX + id;
            String taskJson = (String)this.redisTemplate.opsForValue().get((Object)taskKey);
            if ((taskJson != null ? (ScrapeTask)this.objectMapper.readValue(taskJson, ScrapeTask.class) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private Priority13 parsePriority(int priority) {
        Priority13 priority13 = Priority13.Companion.valueOfOrNull(priority);
        if (priority13 == null) {
            priority13 = Priority13.LOWEST;
        }
        return priority13;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/platon/scent/rest/api/service/scrape/RedisTaskQueueService$Companion;", "", "()V", "QUEUE_KEY_PREFIX", "", "TASK_EXPIRE_DAYS", "", "TASK_KEY_PREFIX", "TASK_STATUS_CHANNEL", "scent-rest"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Priority13> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Priority13.values()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lai/platon/scent/rest/api/service/scrape/RedisTaskQueueService$TaskStatusMessage;", "", "taskId", "", "statusCode", "", "updatedAt", "Ljava/time/Instant;", "(Ljava/lang/String;ILjava/time/Instant;)V", "getStatusCode", "()I", "getTaskId", "()Ljava/lang/String;", "getUpdatedAt", "()Ljava/time/Instant;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "scent-rest"})
    public static final class TaskStatusMessage {
        @NotNull
        private final String taskId;
        private final int statusCode;
        @NotNull
        private final Instant updatedAt;

        public TaskStatusMessage(@NotNull String taskId, int statusCode, @NotNull Instant updatedAt) {
            Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
            Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
            this.taskId = taskId;
            this.statusCode = statusCode;
            this.updatedAt = updatedAt;
        }

        @NotNull
        public final String getTaskId() {
            return this.taskId;
        }

        public final int getStatusCode() {
            return this.statusCode;
        }

        @NotNull
        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @NotNull
        public final String component1() {
            return this.taskId;
        }

        public final int component2() {
            return this.statusCode;
        }

        @NotNull
        public final Instant component3() {
            return this.updatedAt;
        }

        @NotNull
        public final TaskStatusMessage copy(@NotNull String taskId, int statusCode, @NotNull Instant updatedAt) {
            Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
            Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
            return new TaskStatusMessage(taskId, statusCode, updatedAt);
        }

        public static /* synthetic */ TaskStatusMessage copy$default(TaskStatusMessage taskStatusMessage, String string, int n, Instant instant, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = taskStatusMessage.taskId;
            }
            if ((n2 & 2) != 0) {
                n = taskStatusMessage.statusCode;
            }
            if ((n2 & 4) != 0) {
                instant = taskStatusMessage.updatedAt;
            }
            return taskStatusMessage.copy(string, n, instant);
        }

        @NotNull
        public String toString() {
            return "TaskStatusMessage(taskId=" + this.taskId + ", statusCode=" + this.statusCode + ", updatedAt=" + this.updatedAt + ")";
        }

        public int hashCode() {
            int result = this.taskId.hashCode();
            result = result * 31 + Integer.hashCode(this.statusCode);
            result = result * 31 + this.updatedAt.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TaskStatusMessage)) {
                return false;
            }
            TaskStatusMessage taskStatusMessage = (TaskStatusMessage)other;
            if (!Intrinsics.areEqual((Object)this.taskId, (Object)taskStatusMessage.taskId)) {
                return false;
            }
            if (this.statusCode != taskStatusMessage.statusCode) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.updatedAt, (Object)taskStatusMessage.updatedAt);
        }
    }
}

